﻿/*
You can use config var inEvent of Sub using this array var
$ConfVar["NameOfVar"]

To use $Host Var in your script type:
$ConfVar["Host"]

This is case sensitive

List of All variable that can be used in player events or in other event if you have username
This can be retreived with function:
GetCurrentPlayerVar( idOfVar )
GetPlayerVar( username, idOfVar )

example:
$CurrNickName = GetCurrentPlayerVar( "NickName" );
$SpecificNickName = GetPlayerVar( "gai-luron","NickName" );

Nickname		-> Nickname
Username		-> UserName
Laps			-> Total number of laps done on the current track and with the current car
SessLaps		-> Total number of laps done this session on current track and with the current car
TotalPitTime		-> Totaltime used for a pit stop
Car			-> Current car of the player
Posabs			-> Current absolute position
Posqual			-> Current qualification position
Groupqual		-> Current group qualification
SwearWordsRem		-> Remaining number of swearwords to be used before OnSwearWords2 is triggered
H_Mass			-> Current Required Handicap User mass
H_TRes			-> Current Required Handicap Restriction
P_Mass			-> Current player Mass
P_TRes			-> Current player restriction
SplitTime		-> Last Split time done by player
LapsDone		-> Laps done for the current player in current qualification/race

Split1			-> Last First Split, updated when doing new Split1
Split2			-> Last First Split, erased when doing Split1
Split3			-> Last First Split, erased when doing Split1
LapTime			-> Current Lap Time, erased when doing New LapTime
PBLapTime		-> Current PB on current Combo
diffLapTimeToPB		-> Laptime - PBLTime, Last PBLTime is new realised

SectorSplit1		-> Last First sector Split, updated when doing new Split1
SectorSplit2		-> Last second sector Split, erased when doing Split1
SectorSplit3		-> Last third sector Split, erased when doing Split1
SectorSplitLast		-> Last Last sector Split, erased when doing Split1

BestSectorSplit1	-> Best Split duration for the sector 1
BestSectorSplit2	-> Best Split duration for the sector 2
BestSectorSplit3	-> Best Split duration for the sector 3
BestSectorSplitLast	-> BestSplit duration for the last sector

DiffSectorSplit1	-> $SectorSplit1 - $BestSectorSplit1
DiffSectorSplit2	-> $SectorSplit2 - $BestSectorSplit2
DiffSectorSplit3	-> $SectorSplit3 - $BestSectorSplit3
DiffSectorSplitLast	-> $SectorSplitLast - $BestSectorSplitLast

isBestSectorSplit1	-> 1 if this sector split is best than previous Best, otherwise 0
isBestSectorSplit2	-> 1 if this sector split is best than previous Best, otherwise 0
isBestSectorSplit3	-> 1 if this sector split is best than previous Best, otherwise 0
isBestSectorSplitLast	-> 1 if this sector split is best than previous Best, otherwise 0

BestSpeed		-> Best Speed done on this combo by player
UnitSpeed		-> Speedunit of the current player
AvgSpeed		-> Avg Speed on last Lap Time
Tpb			-> Theoretical PB
DriftScore		-> Drift score
typ			-> {typ} - = "Sess" if split PB for Session "PB" if split PB for PB file;
AngleVelocity		-> Last Angle velocity in degrees
LastDriftScore		-> Last drift score
AccelerationTime	-> Acceleration time achieved from start to end speed
MaxAllowedLapTime1	-> Max Allowed Time before trigger Event OnMaxAllowedLapTime1
MaxAllowedLapTime2	-> Max Allowed Time before trigger Event OnMaxAllowedLapTime2
Dist			-> Distance done on current combo/track by player
SessDist		-> Distance done on current combo/track by player this session

pitWork			-> Work do on car on the pit
PlayerFlags		-> Flag(s) for the current player

RemainFDIP		-> Remain count for fast drive in pit

Pos			-> display the current position of the player
UNameBefore		-> the username of the player before you in race
UNameBehind		-> the username of the player behind you in race
GapBefore		-> gap between you and the player before you in race in mm.ss.hh
GapBehind		-> gap between you and of the player behind you in race in mm.ss.hh

FinishedPos		-> finish or qualify pos (1 = win / 256 = not added to table)
RaceTotalTime		-> race time (ms) the use of NumToMsh is needed
RacePBTime		-> race time (ms) the use of NumToMsh is needed

CurrNode		-> is the node on the track where the player is, -1 is player is not on track


List of all variables that can be used in all events
This can be retreived with function:
getLapperVar( idOfVar )

example:
$CurrTrack = getLapperVar( "LongTrackName" );

RotateIn		-> Races remaining before Rotation
HostName		-> Current host Name
ShortTrackName		-> Track Name in Short format : SO6
LongTrackName		-> Track Name in long format : South City Chicane
ShortTime		-> Server Time in short format
LongTime		-> Server Time in long format
ShortDate		-> Date in short format
LongDate		-> Date in long format
CurrRotateCar		-> Current rotated Car
CurrRotateTrack		-> Current rotated Track
CurrLongRotateTrack	-> Current rotated Track
NextRotateCar		-> Next rotated Car
NextRotateTrack		-> Next rotated Track
NextLongRotateTrack	-> Next rotated Track
RequiredFlags		-> Flag(s) required on this server

Additionnal variable that can be used in OnAuthReached.

$auth			-> Authorization reached
*/

/*
Command block to run when a LFS Special event is triggered
Event EventId()
...
EndEvent

Command block used by backcall command like button or scheduled action or when received a command by player
Sub SubId()
...
EndSub

RegisterScheduleAction( "0 0 0 * * * *", SA_mid );
	You can register a subfunction to call when a time is reached
	Firts arg = cron format ss mm hh dayOfWeek dd MM YYYY
	dayOfWeek start at 0 = Sunday
	Second arg = Sub to call when player type this text

Command allowed on Event and Sub

cmdLFS("Command_text");
	Send a command to Lapper, see command.txt in LFS Doc

privMsg( "Message_text");
	Send a private message to the player that has triggered the event

openPrivButton( "help",25,28,150,10,5,-1,0,"^2Commands list" );
openPrivButton( "help",25,28,150,10,5,-1,0,"^2Commands list", backcall );
	Open a button for the current player
	1 - Unique id for this button
	2 - Left coordinate for this button ( 0-200 )
		$origL = (value between 0-200); - when this value is used, every next value can be made relative to this one (example: $origL + 5;)
	3 - Top coordinate for this button ( 0-200 )
		$origT = (value between 0-200); - when this value is used, every next value can be made relative to this one (example: $origT + 5;)
	4 - Width of the button ( 0-200 )
	5 - Heigth of the button ( 0-200 )
	6 - Space between line in multiline button
	7 - Duration in seconds for the button to be displayed (use -1 if you don't want an automatic close)
	8 - Format of the button, look at insim.txt for values
	9 - Button caption, for multiline, separate each line with &
	10 - Option name of the backcalled sub
	
Backcalled Sub receive the keyboardflag to have the key pressed when click
// CFlags byte : click flags

			1		// left click
			2		// right click
			4		// ctrl + click
			8		// shift + click
			
			if left click and right click, you receive 2 + 1 = 3

closePrivButton("welc&pos&clos&ref");
	Close one or more button(s), you specify ID of the button to close, multiple ID's have to be separated by a &

openGlobalButton( "bargr1",60,1,10,6,6,30,96,"Restart:" );
	Same as openPrivButton, but open button for all players connected

closeGlobalButton("welc&pos&clos&ref");
	Same as closePrivButton, but close button for all players connected

WriteLine( "My test");
	To display message on the Lapper console with carriage return
Write( "My test");
	To display message on the Lapper console without carriage return

There are another functions, look in config file

Codes that can be used on button format:

0 - transparent button
16 - light button
32 - dark button
64 - align text to left
128 - align text to right

If you want to make a light colored button with text aligned to the left, combine the codes to one new code, for example 16+64 = 80
*/

/*
To create colored text, use the following codes in front of the text you want to color:

^0 - black
^1 - red
^2 - green
^3 - yellow
^4 - blue
^5 - violet
^6 - cyan
^7 - white
^8 - no color

Other variables that could be used on expressions
&&			-> and
||			-> or
+			-> plus
-			-> minus
/			-> devide
*			-> multiply
^			-> pow
==			-> equal to
!=			-> not equal to
>			-> bigger then
<			-> smaller then
<=			-> smaller then and equal to
>=			-> bigger then and equal to
*/

#################
#General options#
#################

$AdminFile = "./admin.txt"; # Name of the file containing admin lfsname player

$StoredValueDbs = "./../Database/storedvalue"; # Name of the database in which additional values are stored

$TrackInfoFile = "trackInfo.cfg"; # Path to the TrackInfoFile used to compare splits

$TCPmode = true; # Connection to LFS in UDP mode or TCP mode

$EnableRegisterWeb = false; # When set to "true" your LFS Server is displayed on the FRH Team website

# To receive a notification via mail when an error occur on Lapper
#$adminEmail = "";
#$smtpServer = "";
#$loginMail = "";
#$passMail = "";

$DateFormat = "dd/MM/yy";
$LongDateFormat = "dddd dd MMMM yyyy";
				# Date format used for the exported elp files
				# Look at C#-format for date/time, little help
				# HH = Hour in 0-23 format
				# hh = Hour in 0-12 format
				# mm = Minute
				# tt = PM or AM
				# dd = Day
				# MM = Month
				# yyyy = year with 4 digits

$MessageTime = 5000; # Time in milliseconds for a racecontrol message (started by: rcm_all) to be displayed on screen

$PubStatIdk = "HI35je5nzDCc5t6I9Rnn488H7H5WoYbf";	# Indentification code for a connection to PubStat.
			# To obtain a PubStatId go to www.lfsworld.net , select My LFSW Setting, tab Pubstat Access
			# Remove # before PubStatIdK to activate this option

$ShowPlayerControl = False; # Set option to "true" if you want to show the control configuration of players when leaving the pits.

##############
#FTP transfer#
##############
# Results files can also be transferred to an FTP server
# Define the following parameters to use this feature
# Remove # before line to activate it
# -------------------------------------------------------------------

#$FtpServer = "your ftp server"; # Name/IP-address of your FTP server
#$FtpLogin = "your login"; # Loginname for your FTP server
#$FtpPasswd = "your password"; # Password for your FTP server
#$FtpRemotePath = "your remote dir"; # Directorname

#############
#Default Car#
#############
# Default car to show, when no car is specified in command !top or !drf and when a player haven't used a car on this server
# You can combine several cars by using + (example: "XFG+XRG";)
# -------------------------------------------------------------------

#$DefaultTopCar = "UF1";
#$DefaultTopCar = "XFG";
#$DefaultTopCar = "XRG";
#$DefaultTopCar = "XRT";
#$DefaultTopCar = "RB4";
#$DefaultTopCar = "FXO";
#$DefaultTopCar = "LX4";
#$DefaultTopCar = "LX6";
#$DefaultTopCar = "RAC";
$DefaultTopCar = "FZ5";
#$DefaultTopCar = "MRT";
#$DefaultTopCar = "XFR";
#$DefaultTopCar = "UFR+XFR";
#$DefaultTopCar = "FOX";
#$DefaultTopCar = "FO8";
#$DefaultTopCar = "FXR+XRR+FZR";
#$DefaultTopCar = "XRR";
#$DefaultTopCar = "FZR";
#$DefaultTopCar = "BF1";
#$DefaultTopCar = "FBM";

###################################
#Event triggered when lapper start#
###################################
#Syntax: ss mm hh dayofweek dd MM YYYY

Event OnLapperStart()
	RegisterScheduleAction( "0 0 0 * * * *", Reinitialise_server_1 );
	RegisterScheduleAction( "30 0 0 * * * *", Reinitialise_server_2 );
	RegisterScheduleAction( "0 1 0 * * * * ", Track_check );
	RegisterScheduleAction( "0 2 0 * * * *", Schedule_trackcheck );

	GlobalVar $enable_pitboard;
	GlobalVar $enable_pitwindow_gui;
	GlobalVar $enable_safetycar_gui;
	GlobalVar $enable_ctrack_gui;

	initAddons();

	IF ( $enable_pitboard == "true" )
	THEN
		OnLapperStart_Pitboard();
	ENDIF

	IF ( $enable_ctrack_gui == "true" )
	THEN
	  OnLapperStart_Ctrack();
	ENDIF

	OnLapperStart_Handicap();
	OnLapperStart_Set_Schedule();
	OnLapperStart_Panic();
EndEvent

Sub Reinitialise_server_1()
	cmdLFS( "/msg ^1Server will be reinitialised in 30 seconds^8" );
EndSub

Sub Reinitialise_server_2()
	cmdLFS("/reinit");
EndSub

Sub Track_check()
	cmdLFS( "/msg ^1In 1 minute the selected Track/car(s) will be ...^8" );
	cmdLFS( "/msg ^1... checked and changed if needed^8" );
EndSub

###################################
#Authorization Options ( license )#
###################################
#Authorization Options
#
#$Auth1 $Auth2 ... $Auth10 variable
#Syntax : $AuthX = "Label,Carname:Trackname:MinimumTime&Carname:Trackname:MinimumTime&...| Carname:Trackname:MinimumTime&Carname:Trackname:MinimumTime&... | ...";
#& -> And condition
#| -> Or condition
#
#$AuthAllowPlayer="Auth1|...|AuthX|@username1,username2,...,usernameN";
#or
#$AuthAllowPlayer="All";
#-------------------------------------------------------------------

#$Auth1 = "Bronze,XFG:BL1:1.45.00 | XRT:SO4:1.20.20";
#$Auth2 = "Silver,XFG:BL1:1.40.00 | XRT:SO4:1.20.20";
#$Auth3 = "Gold,XFG:BL1:1.35.00";

$AuthAllowPlayer = "All";

$AuthMinPlayer = 0;	# Minimum number of players on the server to auto enable authorization
			# If number of players is below value, alle players are allowed
			# If number of players is above value, only AuthAllowPlayer are allowed

Event OnAuthAllowed() # Player event
	globalMsg( langEngine( "%{main_allowed}%", GetCurrentPlayerVar("Nickname") ) );
Endevent

Event OnAuthNotAllowed() # Player event
	cmdLFS("/spec "  . GetCurrentPlayerVar("Nickname") );
	globalMsg( langEngine( "%{main_notallowed}%", GetCurrentPlayerVar("Nickname") ));
Endevent

# Local viariable that can be used
# $auth -> Authorization reached

Event OnAuthReached( $level ) # Player event
	privMsg(langEngine( "%{main_gotlevel}%", $level ) );
EndEvent

##################
#Swearword filter#
##################
#Specify a list of swearwords seperated by ,
#Specify a file with swearwords, one word per line
#-------------------------------------------------------------------

#$SwearWordsList = "fuck,asholes,bastard,idiot";
$SwearWordsList = "&./../Database/swearwords.txt";
$SwearWordsMax = 3; # Maximum number of allowed swearwords per session

Event OnSwearWords1() # Player event
	privMsg( "^7Don't use swearwords on this server" );
	privMsg( "^7You will be banned after ^2" . GetCurrentPlayerVar("SwearWordsRem") . " ^7 more swearword(s)" );
EndEvent

Event OnSwearWords2()  # Player event
	privMsg( "^7Banned for using too many swearwords" );
	cmdLFS( "/ban " . GeCurrentPlayerVar("UserName") . " 14" );
EndEvent

###########
#Handicaps#
###########
#You can specify 3 levels of handicap : for car, for car and track, for user
#Priority Level low to hight : HandicapCars, HandicapCarsTracks, HandicapUser
#-------------------------------------------------------------------
#Handicap cars
#
#Syntax :
#
#$HandicapCars = "car:mass:irest,car:mass:irest,...,car:mass:irest";
#
#car : LFS short car name
#mass : mass handicap in kg
#irest : Air intake restriction in percent
#-------------------------------------------------------------------
#Handicap cars/tracks
#
#Syntax :
#
#$HandicapCarsTracks = "car/track:mass:irest,car/track:mass:irest,...,car/track:mass:irest";
#
#car : LFS short car name
#track : LFS short track name
#mass : mass handicap in kg
#irest : Air intake restriction in percent
#-------------------------------------------------------------------
#$HandicapUser		# a list of players and their handicap
#			# if you prefix with & , You can indicate a file name that contains a list of racers, one racer per line
#			# if you prefix with @, You can list username separated with ,
#
#Syntax :
#
#$HandicapUsers = "&./your_file";
#$HandicapUsers = "@userName:mass:irest,userName:mass:irest,...userName:mass:irest";
#
#$RefreshHandicapUsers	# allow Lapper to refresh HandicapUsers on each player leaving pits
			# Usefull if HandicapUsers is a file and is updated frequently by an external program
#-------------------------------------------------------------------

#$HandicapCars = "FXR:0:50,XRR:1000:0,FZR:1000:0";

#$HandicapCarsTracks = "XFG/BL1:100:10,XRT/AS1:50:10";

#$RefreshHandicapUsers = true;
#$HandicapUsers = "&./AB-Restrictions.txt";
#$HandicapUsers = "@Gai-Luron:100:20,gwendoline:100:30,_-ALUCARD-_,lagamel:50:10,lister88,c-quad,shimanofr,bruno7529,boby5,kevinb,edgar,berlioz,la tortue,neron59,eur-can,stff,2psbob,oliv76000";

Event OnToLowHandicap() # Player event
	cmdLFS("/spec " . GetCurrentPlayerVar("Nickname") );
	globalMsg( langEngine( "%{main_tolowhand1}%",GetCurrentPlayerVar("Nickname") ));
	globalMsg( langEngine( "%{main_tolowhand2}%",GetCurrentPlayerVar( "H_Mass" ), GetCurrentPlayerVar("H_Tres")) );
EndEvent

#################
#Control Allowed#
#################
# Racer flags
# "Y" = Yes
# "N" = No
# "*"" = Yes or No
# Local variable
#-------------------------------------------------------------------

$SwapSide = "*";
$AutoGears = "*";
$Shifter = "*";
$HelpBrake = "*";
$AxisClutch = "*";
$AutoClutch = "*";
$Mouse = "*";
$KbNoHelp = "*";
$KbStabilised = "*";
$CustomView = "*";

Event OnNotMatchFlags( ) # Player event
	privMsg(langEngine( "%{main_nomatchflag}%" )  );
	privMsg(langEngine( "%{main_yourflag}%" , GetCurrentPlayerVar("PlayerFlags") ) );
	privMsg(langEngine( "%{main_yourflag}%" , GetLapperVar( "RequiredFlags" ) ) );
	privMsg(langEngine( "%{main_spectated}%" ) );
	cmdLFS("/spec " . GetCurrentPlayerVar("Username") );
EndEvent

##############
#Race Control#
##############
#Voting:
#
#$InRaceLapsVoteMinMax = Laps in between where votes are allowed in race
#$InRaceLapsVoteMinMax = 0-0 Votes are never allowed
#$InRaceLapsVoteMinMax = -5 Votes are allowed between lap 1 and 5
#$InRaceLapsVoteMinMax = 2- Votes are allowed between laps 2 and the end of the race
#$InRaceLapsVoteMinMax = - Votes are always allowed
#
#$VoteRestart = percentage of players that have to vote to restart a race. To let LFS admin this function, set it to -1
#OnVoteRestartChange = Command to do when player votes to restart
#OnVoteRestartReach = Command to execute when VoteRestart is reached
#OnVoteRestartZero = Command to execute when no nb of player reach zero

#$VoteQualify = percentage of players that have to vote to start a qualification. To let LFS admin this function, set it to -1
#OnVoteQualifyChange = same as restart but for qualify
#OnVoteQualifyReach = same as restart but for qualify
#OnVoteQualifyZero = same as restart but for qualify
#
#$VoteEnd = percentage of players that have to vote to end a race. To let LFS admin this function, set it to -1
#OnVoteEndChange = same as restart but for endrace
#OnVoteEndReach = same as restart but for endrace
#OnVoteEndyZero = same as restart but for endrace
#-------------------------------------------------------------------
#Local variable:
#
#$Vote - Number of players that have voted
#$Remain - Number of players remaining to vote
#$Need - Number of players needed for an action
#$VoteLifeSec = Number of seconds to keep the vote alive after voting
#-------------------------------------------------------------------
#Auto restart:
#
#$AutoRestartRaceSec = Second between the end of a race (last player finished) and an automatic restart
#
#Rotation only work if AutoRestartRaceSec is set
#EnableRotation =	Allow or disallow rotation for track and/or car
#			Values : true or false
#$RotateTracks = "tracks to rotate"; separated by ','
#$RotateCars = "cars to rotate"; separated by ',' Use LFS definition for car, if not set, no car rotation
#$RotateEveryNbRaces = Number of races to do before rotation;
#-------------------------------------------------------------------

$InRaceLapsVoteMinMax = "-";

$VoteRestart = -1;

Event OnVoteRestartChange($PlayerOnTrack, $Vote , $Need) # Lapper Event
	openGlobalButton( "bargr1",60,1,10,6,6,30,96,langEngine( "%{main_vote_restart1}%"));
	openGlobalButton( "bargr2",70,1,20,6,6,30,96,langEngine( "%{main_vote_restart2}%",$Vote,$PlayerOnTrack,$Need ) );
EndEvent

Event OnVoteRestartReach($PlayerOnTrack, $Vote , $Need) # Lapper Event
	closeGlobalButton( "bargr1&bargr2" );
EndEvent

Event OnVoteRestartZero() # Lapper Event
	closeGlobalButton( "bargr1&bargr2" );
EndEvent

$VoteQualify = -1;

Event OnVoteQualifyChange($PlayerOnTrack, $Vote , $Need) # Lapper Event
	openGlobalButton( "bargq1",90,1,10,6,6,30,96,langEngine( "%{main_vote_qualify1}%") );
	openGlobalButton( "bargq2",100,1,20,6,6,30,96,langEngine( "%{main_vote_qualify2}%",$Vote,$PlayerOnTrack,$Need ));
EndEvent

Event OnVoteQualifyReach($PlayerOnTrack, $Vote , $Need) # Lapper Event
	closeGlobalButton("bargq1&bargq2" );
EndEvent

Event OnVoteQualifyZero() # Lapper Event
	closeGlobalButton("bargq1&bargq2" );
EndEvent

$VoteEnd = -1;

Event OnVoteEndChange($PlayerOnTrack, $Vote , $Need) # Lapper Event
	openGlobalButton( "barge1",120,1,10,6,6,30,96,langEngine( "%{main_vote_end1}%") );
	openGlobalButton( "barge2",130,1,20,6,6,30,96,langEngine( "%{main_vote_end2}%",$Vote,$PlayerOnTrack,$Need ) );
EndEvent

Event OnVoteEndReach($PlayerOnTrack, $Vote , $Need) # Lapper Event
 	closeGlobalButton( "barge1&barge2" );
EndEvent

Event OnVoteEndZero() # Lapper Event
 	closeGlobalButton( "barge1&barge2" );
EndEvent

$VoteLifeSec = 30;

$AutoRestartRaceSec = 0;

$EnableRotation = false;
$RotateTracks = "SO6R,BL1,FE3";
$RotateEveryNbRaces = 4;
$RotateCars = "XFG+UF1,TBO,XFR+UFR";

Event OnRotateCar() # Lapper Event
 	globalMsg(langEngine( "%{main_car_changed}%",getLapperVar( "CurrRotateCar" )));
EndEvent

Event OnRotateTrack() # Lapper Event
 	globalMsg(langEngine( "%{main_track_changed1}%") );
	globalMsg(langEngine( "%{main_track_changed2}%", getLapperVar( "CurrLongRotateTrack" )));
EndEvent

#################################################
#Connect messages when a player joins the server#
#################################################

Event OnConnect() # Player event
	$left_right=50;
	$top_bottom=50;
	openPrivButton( "welcome_bg",$left_right,$top_bottom,100,78,5,-1,16,"" );
	openPrivButton( "welcome_1a",$left_right+1,$top_bottom+1,98,5,5,-1,32,"^7Welcome at this ^1Absolute-beginners.net^7 server" );
	openPrivButton( "welcome_1b",$left_right+1,$top_bottom+6,98,5,5,-1,32,"^7You are on server: " . getLapperVar( "HostName" ) );
	
	openPrivButton( "rules_1a",$left_right+1,$top_bottom+11,68,5,5,-1,64,"^1The rules:" );
	openPrivButton( "rules_1b",$left_right+1,$top_bottom+16,68,5,5,-1,64,"^7- Race clean and fair" );
	openPrivButton( "rules_1c",$left_right+1,$top_bottom+21,68,5,5,-1,64,"^7- Don't cut corners" );
	openPrivButton( "rules_1d",$left_right+1,$top_bottom+26,68,5,5,-1,64,"^7- Don't use swearwords and/or an offensive nickname" );
	openPrivButton( "rules_1e",$left_right+1,$top_bottom+31,68,5,5,-1,64,"^7- Respect pitlane exit" );
	openPrivButton( "rules_1f",$left_right+1,$top_bottom+36,68,5,5,-1,64,"^7- Respect ^4BLUE^7 and ^3YELLOW^7 flags" );

	openPrivButton( "rules_1g",$left_right+1,$top_bottom+46,68,5,5,-1,64,"^2General information:" );
	openPrivButton( "rules_1h",$left_right+1,$top_bottom+51,68,5,5,-1,64,"^7- Show all Lapper commands by typing: !help" );
	#openPrivButton( "rules_1i",$left_right+1,$top_bottom+56,68,5,5,-1,64,"^7- Authorisation is set on BL1/FBM - time 1.16.00 or below" );
	#openPrivButton( "rules_1j",$left_right+1,$top_bottom+61,68,5,5,-1,64,"^7- If less then 9 players are connected,everyone is authorised" );
  	openPrivButton( "rules_1k",$left_right+1,$top_bottom+56,68,5,5,-1,64,"^7- By accepting these rules you are binded to them" );

	openPrivButton( "info_1_bg",$left_right+69,$top_bottom+11,30,10,5,-1,32,"" );
	openPrivButton( "info_1a",$left_right+69,$top_bottom+11,30,5,5,-1,0,"^7Lapper version:" );
	openPrivButton( "info_1b",$left_right+69,$top_bottom+16,30,5,5,-1,0,"^75.846 - (C) Gai-Luron" );

	openPrivButton( "info_2_bg",$left_right+69,$top_bottom+21,30,35,5,-1,32,"" );
	openPrivButton( "info_2a",$left_right+69,$top_bottom+21,30,5,5,-1,0,"^7Additional scripts:" );
	openPrivButton( "info_2b",$left_right+69,$top_bottom+31,30,5,5,-1,64,"^7-Pitboard" );
	openPrivButton( "info_2c",$left_right+69,$top_bottom+36,30,5,5,-1,64,"^7-Pitwindow GUI" );
	openPrivButton( "info_2d",$left_right+69,$top_bottom+41,30,5,5,-1,64,"^7-CTrack GUI" );
	openPrivButton( "info_2e",$left_right+69,$top_bottom+46,30,5,5,-1,64,"^7-Handicap GUI" );
	openPrivButton( "info_2f",$left_right+69,$top_bottom+51,30,5,5,-1,0,"^7(C) Yisc[NL]" );

	openPrivButton( "info_3_bg",$left_right+69,$top_bottom+56,30,20,5,-1,32,"" );
	openPrivButton( "info_3a",$left_right+69,$top_bottom+56,30,5,5,-1,0,"^7Server sponsored by:" );
	openPrivButton( "info_3b",$left_right+69,$top_bottom+66,30,5,5,-1,0,"^4NXS^7 Internet" );
	openPrivButton( "info_3c",$left_right+69,$top_bottom+71,30,5,5,-1,0,"^7http://www.nxs.nl" );

	openPrivButton( "close_welcome",$left_right+1,$top_bottom+71,34,5,5,-1,32,"^2Accept",OnConnectClose );
	openPrivButton( "refuse_welcome",$left_right+35,$top_bottom+71,34,5,5,-1,32,"^1Deny",OnConnectCloseKick );

	IF ( $enable_pitboard == "true" )
	THEN
	  OnConnect_Pitboard();
	ENDIF

	OnConnect_Handicap();
EndEvent

Sub OnConnectClose( $KeyFlags,$id )
	closePrivButton("welcome_bg&welcome_1a&welcome_1b");
	closePrivButton("rules_bg&rules_1a&rules_1b&rules_1c&rules_1d&rules_1e&rules_1f&rules_1g&rules_1h&rules_1i&rules_1j&rules_1k");
	closePrivButton("info_1_bg&info_1a&info_1b&info_2_bg&info_2a&info_2b&info_2c&info_2d&info_2e&info_2f&info_3_bg&info_3a&info_3b&info_3c");
	closePrivButton("close_welcome&refuse_welcome");

	IF ( $enable_pitboard == "true" )
	THEN
	  OnConnectClose_Pitboard();
	ENDIF
EndSub

Sub OnConnectCloseKick( $KeyFlags,$id )
	closePrivButton("welcome_bg&welcome_1a&welcome_1b");
	closePrivButton("rules_bg&rules_1a&rules_1b&rules_1c&rules_1d&rules_1e&rules_1f&rules_1g&rules_1h&rules_1i&rules_1j&rules_1k");
	closePrivButton("info_1_bg&info_1a&info_1b&info_2_bg&info_2a&info_2b&info_2c&info_2d&info_2e&info_2f&info_3_bg&info_3a&info_3b&info_3c");
	closePrivButton("close_welcome&refuse_welcome");

	cmdLFS("/kick " . GetCurrentPlayerVar("UserName") );
EndSub

##########################################
#New PLayer joining race or leaving pits)#
##########################################

Event OnNewPlayerJoin()
	IF ( $enable_pitboard == "true" )
	THEN
	  OnNewPlayerJoin_Pitboard();
	ENDIF

	OnNewPlayerJoin_Handicap();
EndEvent

#####################################################
#DisConnect messages when a player leaves the server#
#####################################################

Event OnDisConnect() # Player event
	IF ( $enable_pitboard == "true" )
	THEN
	  OnDisConnect_Pitboard();
	ENDIF

	OnDisConnect_Handicap();
EndEvent


#############################################$#
#Splitting (general action when passing split)#
###############################################

Event OnSplit1() # Player event
EndEvent

Event OnSplit2() # Player event
EndEvent

Event OnSplit3() # Player event
EndEvent

Event OnLap() # Player event
EndEvent

#############################################
#Action when a new Gapping Info is avaiaible#
#############################################

/*
openPrivButton( "help",25,28,150,10,5,-1,0,"^2Commands list", backcall );
	Open a button for the current player
	1 - Unique id for this button
	2 - Left coordinate for this button ( 0-200 )
		$origL = (value between 0-200); - when this value is used, every next value can be made relative to this one (example: $origL + 5;)
	3 - Top coordinate for this button ( 0-200 )
		$origT = (value between 0-200); - when this value is used, every next value can be made relative to this one (example: $origT + 5;)
	4 - Width of the button ( 0-200 )
	5 - Heigth of the button ( 0-200 )
	6 - Space between line in multiline button
	7 - Duration in seconds for the button to be displayed (use -1 if you don't want an automatic close)
	8 - Format of the button, look at insim.txt for values
	9 - Button caption, for multiline, separate each line with &
	10 - Option name of the backcalled sub
*/

Event OnNewGapPlayerBefore( $split )

	IF ( $enable_pitboard == "true" )
	THEN
	  OnNewGapPlayerBefore_Pitboard( $split );
	ELSE
	  $y = 187;
	  $x = 62;

	  IF( GetCurrentPlayerVar( "UNameBefore" ) != "" )
	  THEN
	    $nickName = GetPlayerVar( GetCurrentPlayerVar( "UNameBefore" ),"nickName" );
	    $larg = 15;
	    openPrivButton("Before1",$x,$y,$larg,5,10,-1,32, langEngine( "%{main_before}%" ));
	    $x = $x + $larg;
	    $larg = 30;
	    openPrivButton("Before2",$x,$y,$larg,5,10,-1,32, $nickName );
	    $x = $x + $larg;
	    $larg = 30;
	    openPrivButton("Before3",$x,$y,$larg,5,10,-1,32, GetCurrentPlayerVar( "GapBefore" ));
	  ELSE
	    closePrivButton( "Before1");
	    closePrivButton( "Before2");
	    closePrivButton( "Before3");
	  ENDIF
	ENDIF
EndEvent

Event OnNewGapPlayerBehind( $split )
	IF ( $enable_pitboard == "true" )
	THEN
	  OnNewGapPlayerBehind_Pitboard( $split );
	ELSE
	  $y = 195;
	  $x = 62;

	  IF( GetCurrentPlayerVar( "UNameBehind" ) != "" )
	  THEN
	    $nickName = GetPlayerVar( GetCurrentPlayerVar( "UNameBehind" ),"nickName" );
	    $larg = 15;
	    openPrivButton("behind1",$x,$y,$larg,5,10,-1,32, langEngine( "%{main_behind}%" ) );
	    $x = $x + $larg;
	    $larg = 30;
	    openPrivButton("behind2",$x,$y,$larg,5,10,-1,32, $nickName );
	    $x = $x + $larg;
	    $larg = 30;
	    openPrivButton("behind3",$x,$y,$larg,5,10,-1,32, GetCurrentPlayerVar( "GapBehind" ));
	  ELSE
	    closePrivButton( "behind1");
	    closePrivButton( "behind2");
	    closePrivButton( "behind3");
	  ENDIF
	ENDIF
EndEvent

#######################################################
#Splitting (compare player split to best player split)#
#######################################################

$ShowSplitPB = true; # Set to false if you don't want to see messages about splits

Event OnSpbSplit1() # Player event
	IF ( $enable_pitboard == "true" )
	THEN
	  OnSpbSplit1_Pitboard();
	ELSE
	  IF( GetCurrentPlayerVar("isBestSectorSplit1") == 1 )
	  THEN
	    $color = "^2";
	  ELSE
	    $color = "^1";
	  ENDIF
	  openPrivButton( "id_spb",50,55,100,10,10,5,0,
	  		langEngine( "%{main_split1}%"
			  		,NumToMSH( GetCurrentPlayerVar("SectorSplit1"))
			  		,$color
			  		, NumToMSH( GetCurrentPlayerVar("DiffSectorSplit1"))
			  		,NumToMSH(GetCurrentPlayerVar("Tpb"))
			)
	);
	ENDIF
EndEvent

Event OnSpbSplit2() # Player event
	IF ( $enable_pitboard == "true" )
	THEN
	  OnSpbSplit2_Pitboard();
	ELSE
	  IF( GetCurrentPlayerVar("isBestSectorSplit2")  == 1 ) # Player event
	  THEN
	    $color = "^2";
	  ELSE
	    $color = "^1";
	  ENDIF
		openPrivButton( "id_spb",50,55,100,10,10,5,0,
	  		langEngine( "%{main_split2}%"
				,NumToMSH(GetCurrentPlayerVar("SectorSplit2"))
				,$color
				,NumToMSH( GetCurrentPlayerVar("DiffSectorSplit2"))
				,NumToMSH(GetCurrentPlayerVar("Tpb"))
			)
		);
	ENDIF
EndEvent

Event OnSpbSplit3() # Player event
	IF ( $enable_pitboard == "true" )
	THEN
	  OnSpbSplit3_Pitboard();
	ELSE
	  IF( GetCurrentPlayerVar("isBestSectorSplit3")  == 1 )
	  THEN
	    $color = "^2";
	  ELSE
	    $color = "^1";
	  ENDIF
	  	openPrivButton( "id_spb",50,55,100,10,10,5,0,
  			langEngine( "%{main_split3}%"
					,NumToMSH(GetCurrentPlayerVar("SectorSplit3"))
					,$color
					,NumToMSH( GetCurrentPlayerVar("DiffSectorSplit3"))
					,NumToMSH(GetCurrentPlayerVar("Tpb"))
			)
		);
	ENDIF
EndEvent

Event OnSpbLast() # Player event
	IF ( $enable_pitboard == "true" )
	THEN
	  OnSpbLast_Pitboard();
	ELSE
	  IF( GetCurrentPlayerVar("isBestSectorSplitLast")  == 1 )
	  THEN
	    $color = "^2";
	  ELSE
	    $color = "^1";
	  ENDIF
	  	openPrivButton( "id_spb",50,55,100,10,10,5,0,
	  		langEngine( "%{main_splitlast}%"
	  		        ,NumToMSH( GetCurrentPlayerVar("SectorSplitLast"))
	  		        ,$color
				,NumToMSH(GetCurrentPlayerVar("DiffSectorSplitLast"))
				,NumToMSH(GetCurrentPlayerVar("Tpb"))
				,ToPlayerUnit( GetCurrentPlayerVar("AvgSpeed") )
				,GetCurrentPlayerVar("UnitSpeed")
			)
		);
	ENDIF

	OnSpbLast_Panic();
EndEvent

####################################################
#Actions to do on splits relative to trackinfo.cfg#
####################################################
#Local variable: {SplitTime} - Split time
#-------------------------------------------------------------------

Sub TRI_split1_0() # Player event
	globalMsg(  langEngine( "%{main_great1}%", NumToMSH(GetCurrentPlayerVar("SplitTime")),GetCurrentPlayerVar("Nickname") ) );
EndSub

Sub TRI_split1_1() # Player event
	globalMsg( langEngine( "%{main_good1}%",NumToMSH(GetCurrentPlayerVar("SplitTime")),GetCurrentPlayerVar("Nickname") ) );
EndSub

Sub TRI_split2_0() # Player event
	globalMsg(  langEngine( "%{main_great2}%", NumToMSH(GetCurrentPlayerVar("SplitTime")),GetCurrentPlayerVar("Nickname") ) );
EndSub

Sub TRI_split2_1() # Player event
	globalMsg( langEngine( "%{main_good2}%",NumToMSH(GetCurrentPlayerVar("SplitTime")),GetCurrentPlayerVar("Nickname") ) );
EndSub

Sub TRI_split3_0() # Player event
	globalMsg(  langEngine( "%{main_great3}%", NumToMSH(GetCurrentPlayerVar("SplitTime")),GetCurrentPlayerVar("Nickname") ) );
EndSub

Sub TRI_split3_1() # Player event
	globalMsg( langEngine( "%{main_good3}%",NumToMSH(GetCurrentPlayerVar("SplitTime")),GetCurrentPlayerVar("Nickname") ) );
EndSub

Sub TRI_lap_0() # Player event
	globalMsg( langEngine( "%{main_greatlap}%",NumToMSH( GetCurrentPlayerVar("LapTime") ), GetCurrentPlayerVar("Nickname" ) ) );
EndSub

Sub TRI_lap_1() # Player event
	globalMsg( langEngine( "%{main_goodlap}%", NumToMSH( GetCurrentPlayerVar("LapTime") ), GetCurrentPlayerVar("Nickname") ) );
EndSub

#########################
#List of user qualifying#
#########################
#RefreshQualUsers : allow Lapper to refresh QualUsers on each outgoing pits, Usefull if QualUsers is a file and this is changed frequently by an external program
#QualUser : is a list of racers that participed in the qualification, required for function !nearqual !topqual and !statsqual
#if you prefix with & , You can indicate a file name that contains a list of racers, one racer per line (example : QualUsers = ./userfile.txt;)
#if you prefix with @, You can list usernames separated with ',' (example : QualUsers = @Gai-Luron,gwendoline,_-ALUCARD-_,lagamel;)
#You can specify which car is used by a user adding car after username separated by ':' (example : Gai-Luron:XFR,lagamel:UFR)
#You can specify the scheme of group of this qualification using a special username called DefGroup
#Defgroup Take 3 argument separated with ':'
#1 - Is the number Max of Group for this qualification
#2 - Is the number max of user per group
#3 - Is the minimum of user in the last group, recalc previous group as possible if number is low
#If you ommit scheme of groups, the group of qualification do not appear
#-------------------------------------------------------------------

$RefreshQualUsers = true;
#$QualUsers = "&./your_file.flt";
#$QualUsers = "@DefGroup:5:5:2,Gai-Luron,MataGyula,nesrulz,gwendoline,_-ALUCARD-_,lagamel,lister88,c-quad,shimanofr,bruno7529,boby5,kevinb,edgar,berlioz,la tortue,neron59,eur-can,stff,2psbob,oliv76000";

#################
#Command actions#
#################
#If ! before a name, force nickName authentification if UseUsernameForAuthentication=true
#If ! before a name, force userName authentification if UseUsernameForAuthentication=false
#You can use regexp expression in userName pattern, type regex=your regular expression
#
#Example:	if UseUsernameForAuthentication=true
#		!regex=^\[COP\].*
#		Find all user with a nickname that begins with [COP]
#		regex=^Gai.*
#		Find all user with a username that begins with Gai
# 		See regular expression on web for more info how it work
#
#Use & sign at end of patterns
#-------------------------------------------------------------------

Event OnMSO( $text ) # Player event

#	writeline( $text );
	$idxOfFirtsSpace = indexOf( $text, " ");
	
	$userName = GetCurrentPlayerVar("UserName");

	UserGroupFromFile( "admin", "./admin.txt" );
	
	IF( $idxOfFirtsSpace == -1 ) THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirtsSpace );
	  $argv = trim( subStr( $text,$idxOfFirtsSpace ) );
	ENDIF
	
	SWITCH( $command )

		CASE "!gui":
		        IF( $enable_config_gui == "true" )
		        THEN
			        IF ( UserIsAdmin( $userName ) == 1 )
				THEN
				  config_gui(0,0);
				ELSE
				  privMsg( langEngine( "%{main_notadmin}%" ) );
				ENDIF
			ENDIF
			BREAK;
		CASE "!node":
			IF ( UserIsAdmin( $userName ) == 1 )
			THEN
			  privMsg(  langEngine( "%{main_currnode}%", GetCurrentPlayerVar( "CurrNode" ) ) );
			ENDIF
			BREAK;
		CASE "!zone":
			IF ( UserIsAdmin( $userName ) == 1 )
			THEN
			  privMsg( langEngine( "%{main_currnode}%", GetCurrentPlayerVar( "X" ) . ":" . GetCurrentPlayerVar( "Y" ) ) );
			ENDIF
			BREAK;
		CASE "!term":
			IF ( UserIsAdmin( $userName ) == 1 )
			THEN
			  globalMsg( langEngine( "%{main_lapclose}%" ) );
			  termLapper();
			ELSE
			  privMsg( langEngine( "%{main_notadmin}%" ) );
			ENDIF
			BREAK;
		CASE "!test":
		        privRcm( GetCurrentPlayerVar("Nickname") . " is testing...");
			BREAK;
		CASE "!powered":
			http("http://www.frh-team.net/reglapper/getserver2.php");
			BREAK;
		CASE "!license":
		  setLicense( $argv );
	 		BREAK;
		CASE "!groupcmdlfs":
			IF ( UserIsAdmin( $userName ) == 1 )
			THEN
			  groupCmdLfs( $argv );
			ELSE
			  privMsg( langEngine( "%{main_notadmin}%" ) );
			ENDIF
			BREAK;
		CASE "!ban":
			IF ( UserIsAdmin( $userName ) == 1 )
			THEN
			  privMsg( langEngine( "%{main_ban}%", GetCurrentPlayerVar( "Nickname" ), GetPlayerVar( $argv, "Nickname" ) ) );
			  cmdLFS( "/ban " . $argv . " 1" );
			ENDIF
			BREAK;
		CASE "!kick":
			IF ( UserIsAdmin( $userName ) == 1 )
			THEN
			  privMsg( langEngine( "%{main_kick}%", GetCurrentPlayerVar( "Nickname" ), GetPlayerVar( $argv, "Nickname" ) ));
			  cmdLFS( "/kick " . $argv . " 1" );
			ENDIF
			BREAK;
		CASE "!pos":
			privMsg( langEngine( "%{main_friendpos}%", GetCurrentPlayerVar( "Posabs" ) ) );
			BREAK;
		CASE "!groupqual":
			privMsg( langEngine( "%{main_groupqual}%", GetCurrentPlayerVar( "Groupqual" ) ) );
			BREAK;
		CASE "!ver":
			http("http://www.frh-team.net/reglapper/getserver2.php");
			lapperVersion();
			BREAK;
		CASE "!auth":
			privMsg( langEngine( "%{main_level}%", GetCurrentPlayerVar("AuthLevel") ) );
			BREAK;
		CASE "!cleanspb":
			cleanSpb();
			BREAK;
		CASE "!spb":
			showSpb();
			BREAK;
		CASE "!hand":
			showHand( $argv );
			BREAK;
		CASE "!statsqual":
			statsQual( $argv );
			BREAK;
		CASE "!dstatsqual":
			dStatsQual( $argv );
			BREAK;
		CASE "!stats":
			stats( $argv );
			BREAK;
		CASE "!dstats":
			dStats( $argv );
			BREAK;
		CASE "!nearqual":
			nearQual( $argv );
			BREAK;
		CASE "!drfnearqual":
			drfNearQual( $argv );
			BREAK;
		CASE "!near":
			near( $argv );
			BREAK;
		CASE "!drfnear":
			drfNear( $argv );
			BREAK;
		CASE "!top":
			top( $argv );
			BREAK;
		CASE "!mypb":
			CurrentPlayerlfsWorldPB( $argv );
			BREAK;
		CASE "!myconfig":
			myConfig( );
			BREAK;
		CASE "!drf":
			drf( $argv );
			BREAK;
		CASE "!topqual":
			topQual( $argv );
			BREAK;
		CASE "!drfqual":
			drfQual( $argv );
			BREAK;
		CASE "!distance":
			privMsg(langEngine( "%{main_dist}%"
							,GetCurrentPlayerVar( "Car" )
							,GetLapperVar("ShortTrackName")
							,ToPlayerUnit( GetCurrentPlayerVar("Dist") )
							,GetCurrentPlayerVar("UnitDist")
							,ToPlayerUnit( GetCurrentPlayerVar("SessDist") )
							,GetCurrentPlayerVar("UnitDist")
			));
			BREAK;
		CASE "!laps":
			privMsg( langEngine( "%{main_lapdone}%"
							,GetCurrentPlayerVar("Car")
							,GetLapperVar("ShortTrackName")
							,GetCurrentPlayerVar("Laps")
							,GetCurrentPlayerVar("SessLaps") ) );
			 BREAK;
		CASE "!pit":
			privMsg( langEngine( "%{main_timeinpit}%",NumToMSH (GetCurrentPlayerVar("TotalPitTime"))));
			BREAK;
		CASE "!track":
			privMsg( langEngine( "%{main_trackused}%",GetLapperVar("ShortTrackName"),GetLapperVar("LongTrackName") ) );
			BREAK;
		CASE "!time":
			privMsg( langEngine( "%{main_serverclock}%",GetLapperVar("LongTime") ) );
			BREAK;
		CASE "!help":
			openPrivButton( "help",25,18,150,10,5,-1,0,"^2Commands list" );
			openPrivButton( "help2",25,18,150,6,5,-1,80,"^2General commands"
			. "&^3!top ^8[table offset] [3-letter car name] ['filter' pattern]"
			. "&^3!stats ^8[playername pattern]"
			. "&^3!near ^8Gap with 14 pilots near you on the ranking"
			. "&^3!spb ^8Split times and TPB (Theoretical PB)"
			. "&^3!razspb ^8Start new spb session (eg when changing car)"
			. "&^3!track ^8Name of actual track"
			. "&^3!time ^8Server time (to leagues mettings)"
			. "&^3!ver ^8Version of LFSLapper"
			. "&"
			. "&^2AB-functions"
			. "&^3!5qual ^8Display RCM that qualify will start in 5 minutes (Admin only)"
			. "&^3!5race ^8Display RCM that race will start in 5 minutes (Admin only)"
			. "&^3!cfgsplits ^8Set number of splits (open configs) (Admin only)"
			. "&^3!closepb ^8Close Pitboard temporary"
			. "&^3!config ^8Set Pitboard settings" 
			. "&^3!connected ^8Check player status"
			. "&^3!ctrack ^8Change track"
			. "&^3!hcs ^8Set handicaps (Admin only)"
			. "&^3!msg ^8Write and send RCM-message (Admin only)"
			. "&^3!panic ^8Warn admins that grid is wrong"
			. "&^3!pitwindow ^8Show current set Pitwindow(s)"
			. "&^3!plstatus X ^8Set player status , 0 = ready , 1 = not ready , 2 = spectator"
			. "&^3!pwgui ^8Set Pitwindow(s) (Admin only)"
			. "&^3!ready ^8Display RCM to ask if everyone is ready to start (Admin only)"
			. "&^3!rqual X ^8Restart qualify over X time. If nothing is specified, qualify restarts with same length"
			. "&^3!rrace X ^8Restart race over X laps. If nothing is specified, race restarts with same length"
			. "&^3!sc ^8Set Safetycar settings (Admin only)"
			. "&^3!schedule ^8Show schedule of next races"
			. "&^3!set_schedule ^8Set schedule for upcoming races (Admin only)");
			openPrivButton( "close",90,170,20,10,8,-1,16,"^3Ok",MA_closeHelp );
	 		BREAK;
		CASE "!closepb":
			IF ( $enable_pitboard == "true" )
			THEN
			  close_pitboard( $KeyFlags );
			ENDIF
			BREAK;
		CASE "!config":
			IF ( $enable_pitboard == "true" )
			THEN
			  Config_Pitboard( $KeyFlags );
			ENDIF
			BREAK;
		CASE "!pitwindow":
			IF ( $enable_pitboard == "true" )
			THEN
			  Pitwindow( $KeyFlags ); 
			ENDIF
			BREAK;
		CASE "!pwgui":
			IF ( $enable_pitwindow_gui == "true" )
			THEN
			  IF ( UserIsAdmin( $userName ) == 1 )
			  THEN
			    MA_pwgui(0,0);
			  ELSE
			    privMsg(langEngine( "%{main_notadmin}%" ));
			  ENDIF
			ENDIF
			BREAK;
		CASE "!sc":
			IF ( $enable_safetycar_gui == "true" )
			THEN
			  IF ( UserIsAdmin( $userName ) == 1 )
			  THEN
			    Safetycar_gui( $KeyFlags );
			  ELSE
			    privMsg(langEngine( "%{main_notadmin}%" ));
			  ENDIF
			ENDIF
			BREAK;
		CASE "!ctrack":
			IF ( $enable_ctrack_gui == "true" )
			THEN
			  IF ( UserIsAdmin( $userName ) == 1 )
			  THEN
			    Ctrack(0,0);
			  ELSE
			    privMsg(langEngine( "%{main_notadmin}%" ));
			  ENDIF
			ENDIF
			BREAK;
		CASE "!5qual":
			IF( UserInGroup( "admin", $userName ) == 1 )
			THEN
			  cmdLFS ( "/rcm ^25 minutes before the qualify will start" );
			  cmdLFS ( "/rcm_all" );
			ELSE
			  privMsg( "^1You are not allowed to do that");
			ENDIF
			BREAK;
		CASE "!5race":
			IF( UserInGroup( "admin", $userName ) == 1 )
			THEN
			  cmdLFS ( "/rcm ^25 minutes before the race will start" );
			  cmdLFS ( "/rcm_all" );
			ELSE
			  privMsg( "^1You are not allowed to do that");
			ENDIF
			BREAK;
		CASE "!connected":
			connected ( 0,0 );
			BREAK;
		CASE "!ready":
			IF( UserInGroup( "admin", $userName ) == 1 )
			THEN
			  cmdLFS ( "/rcm ^2Everyone ready to start? Type: !plstatus 0" );
			  cmdLFS ( "/rcm_all" );
			ELSE
			  privMsg( "^1You are not allowed to do that");
			ENDIF
			BREAK;
		CASE "!rqual":
			restart_qualify ( $KeyFlags , $argv );
			BREAK;
		CASE "!rrace":
			restart_race ( $KeyFlags , $argv );
			BREAK;
		CASE "!plstatus":
			set_player_status ( $KeyFlags , $argv );
			BREAK;
		CASE "!msg":
			IF( UserInGroup( "admin", $userName ) == 1 )
			THEN
			  openPrivButton( "send_msg",52,0,48,5,5,-1,32,"^3Click to resend message: &" .GetCurrentPlayerVar ("message"),rcm_msg );
			  openPrivButton( "write_send_msg_bg",100,0,48,10,5,-1,32,"" );
			  openPrivTextButton( "write_send_msg",100,5,48,5,5,0,"^3Write message and click OK (max. 50 characters)","^2Click to type and send a message",50,rcm_written_msg );
			  openPrivButton( "close_msg",148,0,10,10,5,-1,32,"^1X",close_msg );
			ELSE
			  privMsg( "^1You are not allowed to open that");
			ENDIF
			BREAK;
		CASE "!hcs":
			IF( UserInGroup( "admin", $userName ) == 1 )
			THEN
			  Handicap ( 0,0 );
			ELSE
			  privMsg(langEngine( "%{main_notadmin}%" ));
			ENDIF
			BREAK;
		CASE "!set_schedule":
			IF( UserInGroup( "admin", $userName ) == 1 )
			THEN
			  Set_Schedule ( 0,0 );
			ELSE
			  privMsg(langEngine( "%{main_notadmin}%" ));
			ENDIF
			BREAK;
		CASE "!schedule":
			Schedule( $KeyFlags );
			BREAK;
		CASE "!cfgsplits":
			IF( UserInGroup( "admin", $userName ) == 1 )
			THEN
			  OpenConfig_splits( $KeyFlags );
			ELSE
			  privMsg( "^1You are not allowed to do that");
			ENDIF
			BREAK;
		CASE "!panic":
			panic_message ( 0 , 0 );
			BREAK;
	ENDSWITCH
EndEvent

Sub MA_closeHelp( $KeyFlags,$id )
	closePrivButton("help&help2&close");
EndSub

Sub restart_qualify ( $KeyFlags , $argv )
	IF ($argv != "")
	THEN
	  cmdLFS( "/qual " . $argv);
	ENDIF
	cmdLFS( "/qualify " );
EndSub

Sub restart_race ( $KeyFlags , $argv )
	IF ($argv != "")
	THEN
	  cmdLFS( "/laps " . $argv);
	ENDIF
	cmdLFS( "/restart");
EndSub

Sub rcm_written_msg ( $message )
	SetCurrentPlayerVar ("message", "^2".$message);

	cmdLFS ( "/rcm ^2" . $message );
	cmdLFS ( "/rcm_all" );
	openPrivButton( "send_msg",52,0,48,5,5,-1,32,"^3Resend message: &^8" .GetCurrentPlayerVar ("message"),rcm_msg );
EndSub

Sub rcm_msg ( $KeyFlags , $argv )
	cmdLFS ( "/rcm ^2" . GetCurrentPlayerVar ( "message" ) );
	cmdLFS ( "/rcm_all" );
EndSub

Sub close_msg ( $KeyFlags , $argv )
	closePrivButton ( "send_msg&write_send_msg_bg&write_send_msg&close_msg" );
EndSub

#####################################
#Action on teleport to pit (Shift+P)#
#####################################

/*
Event OnEnterPit()  # Player event
 	privMsg( GetCurrentPlayerVar("Nickname") . "^8 teleported to pits!" );
EndEvent
*/

# Actions to execute when player spectates or disconnects (leaves race).

/*
Event OnLeaveRace()  # Player event
	privMsg( GetCurrentPlayerVar("Nickname" ) . "^8 left the race!" );
EndEvent
*/

###############################
#Action a player flooding chat#
###############################

/*
Event OnFlood() # Player event
	privMsg( langEngine( "%{main_flood}%", GetCurrentPlayerVar("Nickname") ) );
	cmdLFS( "/kick " . GetCurrentPlayerVar("Username" ) );
EndEvent

$MaxFloodLines = 4; # Maximum number of consecutive lines allowed

$MaxFloodLinesTime = 5000; # Maximum time between two consecutive lines in milliseconds to count as flooding
*/

#########################
#Action on Qual and race#
#########################

Event OnRaceStart( $NumP ) # Lapper event
	DelayedCommand( 5, ORS );
	OnRaceStart_Panic();
EndEvent

Sub ORS()
	IF ( $enable_pitboard == "true" )
	THEN
		OnRaceStart_Pitboard();
	ELSE
	        globalRcm(  langEngine( "%{main_brake}%" ) );
	ENDIF
EndSub

Event OnQualStart( $NumP ) # Lapper event
	  DelayedCommand( 5, OQS );
EndEvent

Sub OQS()
	IF ( $enable_pitboard == "true" )
	THEN
	  OnQualStart_Pitboard();
	ENDIF
EndSub

Event OnFinish()
EndEvent

Event OnResult( $flagConfirm )
	#writeline ( langEngine( "%{main_on_result}%" ,GetCurrentPlayerVar("FinishedPos") ) );
EndEvent

#########################
#Action to do on session#
#########################

/*
$MaxSessionLaps = 2;

Event OnMaxSessionLaps() # Player event
	privMsg( "Max session laps reacheds" );
EndEvent
*/

###############################
#Options on spinning detection#
###############################

/*
$MinAngleVelocity = 250; # Minimum angle velocity to trigger action. Possible values: 0 - 720

# Action to execute when angle velocity is higher than MinAngleVelocity.

Event OnAngleVelocity() # Player event
	globalMsg( langEngine( "%{main_lost_control}%" ,GetCurrentPlayerVar("Nickname") ) );
EndEvent

$MaxNbInStunt = 20; #MaxNbInStunt is max time (in 100 ms) allowed in stunt mode before OnMaxNbInStunt is executed. If -1 No OnMaxNbInStunt are activated

Event OnMaxNbInStunt() # Player event
	cmdLFS( "/spec " . GetCurrentPlayerVar("Nickname") );
EndEvent
*/

#################################
#Actions when player is too slow#
#################################

#$MaxAllowedLapTime1 = 100; # % Max allowed time to complete a lap relative to MaxLapTime in trackInfo.cfg

/*
Event OnMaxAllowedLapTime1() # Player event
	privMsg( langEngine( "%{main_toslow1}%" ,$MaxAllowedLapTime1 ) );
	privMsg( langEngine( "%{main_toslow2}%" , GetCurrentPlayerVar("MaxAllowedLapTime2") ) );
EndEvent
*/

#$MaxAllowedLapTime2 = 150; # % Max allowed time to complete a lap relative to MaxLapTime in trackInfo.cfg

/*
Event OnMaxAllowedLapTime2() # Player event
	privMsg( langEngine( "%{main_toslowvery1}%" ) );
	globalMsg( langEngine( "%{main_toslowvery2}%", GetCurrentPlayerVar("Nickname") ) );
	cmdLFS( "/spec " . GetCurrentPlayerVar("Username") );
EndEvent
*/

##################################
#Options for idle player on track#
##################################

/*
#$IdleExclude = "Lagamel,Gai-Luron"; # Usernames excluded for idle check

$OnIdleTimeout1 = 20; # Idle timeout for OnIdleAction1 in seconds

Event OnIdle1() # Player event
	privMsg( langEngine( "%{main_idle1}%" ) );
EndEvent

$OnIdleTimeout2 = 30; # Idle timeout for OnIdleAction2 in seconds

Event OnIdle2() # Player event
	cmdLFS( "/spec " . GetCurrentPlayerVar("Nickname") );
	privMsg( langEngine( "%{main_idle2}%" ) );
EndEvent
*/

##################
#Drifting options#
##################
# This is the filepath for a file containing the collected data.
# This file will be created if it doesnt exist yet.
# You must ensure read/write access to this path.
#-------------------------------------------------------------------

$DriftDatabase = "./../Database/DriftPB";

/*
# Actions to do on new personal best drift lap.

Event OnDriftPB() # Player event
	globalRcm( langEngine( "%{main_newdriftpb}%" , GetCurrentPlayerVar("Nickname"),GetCurrentPlayerVar("DriftScore") . " ^3pts!") );
EndEvent

Event OnDriftPB()  # Player event
	globalMsg( langEngine( "%{main_newdriftpb}%" , GetCurrentPlayerVar("Nickname"),GetCurrentPlayerVar("DriftScore") . " ^3pts!") );
EndEvent

# Actions to do to when total lap drift score is higher or equal to MinimumDriftScore.

Event OnDriftLap() # Player event
	globalMsg( langEngine( "%{main_driftlap}%" , GetCurrentPlayerVar("Nickname"), GetCurrentPlayerVar("DriftScore") ) );
EndEvent

# Message to get on end of each drift.
# Possible variables to use:

Event OnDriftScore() # Player event
	privMsg( langEngine( "%{main_ondriftscore}%" , GetCurrentPlayerVar("DriftScore"), GetCurrentPlayerVar("LastDriftScore") ) );
EndEvent

$GoodDriftScore = 4000; # Value to be reached to execute action on good drift score

Event OnGoodDrift() # Player event
	privMsg( langEngine( "%{main_ongooddrift}%" ,GetCurrentPlayerVar("Nickname"),GetCurrentPlayerVar("LastDriftScore") ) );
EndEvent

$MinimumDriftScore = 10; # Minimum drift score required

# Actions to do at end of lap if MinimumDriftScore is not achieved.

Event OnDriftTooLow() # Player event
	privMsg( langEngine( "%{main_drifttolow}%" ,GetCurrentPlayerVar("Nickname") ) );
	cmdLFS( "/spec " . GetCurrentPlayerVar("Nickname") );
EndEvent


$MinimumDriftSpeed = 50; # Minimum speed in km/h to maintain. Driving below that speed will reset score
$MinimumDriftAngle = 15; # Minimum angel to maintain. When angle is below value, score is reset
$MaximumDriftAngle = 100; # Maximum angel to maintain. When angle is above value, score is reset
*/

################################
#Options for hotlapping options#
################################

$GripDatabase = "./../Database/GripPB";	# This is the filepath of a file containing the collected data
				# This file will be created if it doesnt exist yet
				# You must ensure read/write access to this path

$LapTimeUsedForPb = 1; # How many PB lap used to make average PB time, Min = 1 and Max = 10

# Action to do on new personal best lap.
# OnPBQual for the racer who make qualif ( in QualUser )
# OnPB the other racer

/*
Event OnPB() # Player event
	globalMsg( langEngine( "%{main_onnewpb}%" , GetCurrentPlayerVar("Nickname"),GetCurrentPlayerVar("Car" ),NumToMSH(GetCurrentPlayerVar("LapTime")) ) );
EndEvent
*/

Event OnPB() # Player event
	privMsg( langEngine( "%{main_onnewpb}%" , GetCurrentPlayerVar("Nickname"), GetCurrentPlayerVar("Car"),NumToMSH(GetCurrentPlayerVar("LapTime")) ) );
	privMsg( langEngine( "%{main_onnewpb_rank}%" ,GetCurrentPlayerVar("Posabs") ) );
	privMsg( langEngine( "%{main_onnewpb_sesslaps}%" , GetCurrentPlayerVar("SessLaps") ) );
	privMsg( langEngine( "%{main_onnewpb_servlaps}%" , GetCurrentPlayerVar("Laps") ) );
	privMsg( langEngine( "%{main_onnewpb_avgspeed}%" ,ToPlayerUnit( GetCurrentPlayerVar("AvgSpeed") ),GetCurrentPlayerVar("UnitSpeed") ) );
	#privRcm( langEngine( "%{main_onnewpb_rank2}%" ,GetCurrentPlayerVar("Car"),GetCurrentPlayerVar("Posabs") ) );
EndEvent

/*
Event OnPBQual()
	globalMsg( langEngine( "%{main_onnewpbqual}%" ,GetCurrentPlayerVar("Nickname"),NumToMSH( GetCurrentPlayerVar("LapTime")) ) );
	globalMsg( langEngine( "%{main_onnewpbqual_rank}%" , GetCurrentPlayerVar("Posabs") ) );
	globalMsg( langEngine( "%{main_onnewpbqual_pos}%" ,GetCurrentPlayerVar("Posqual") ) );
	globalMsg( langEngine( "%{main_onnewpbqual_pool}%" ,GetCurrentPlayerVar("Groupqual") ) );
	globalMsg( langEngine( "%{main_onnewpbqual_avgspeed}%" , ToPlayerUnit( GetCurrentPlayerVar("AvgSpeed") ), GetCurrentPlayerVar("UnitSpeed") ) );
	globalRcm( langEngine( "%{main_onnewpbqual_posqual}%" ,GetCurrentPlayerVar("Nickname"),GetCurrentPlayerVar("Posqual"),GetCurrentPlayerVar("Groupqual") ) );
EndEvent
*/

##########################
#Options for acceleration#
##########################

$AccelerationStartSpeed = 1; # At which speed to start measuring time. In km/h
$AccelerationEndSpeed = 100; # At which speed to stop measuring time. In km/h

$AccelerationStartSpeedMph = 1; # At which speed to start measuring time. In Mph
$AccelerationEndSpeedMph = 60; # At which speed to stop measuring time. In Mph

$AccelerationPrivateMaxTime = 10; # Maximum acceleration time in seconds to show message

#Message to show to players.
#Possible variables to use:
#{AccelerationStartSpeed} - Starting speed
#{AccelerationEndSpeed} - Ending speed
#{AccelerationTime} - Acceleration time achieved from start to end speed
#{UnitSpeed} Unit of the Speed of the player connected

Event OnAcceleration()  # Player event
	privMsg( langEngine( "%{main_accel}%" ,GetCurrentPlayerVar("AccelerationTime"),GetCurrentPlayerVar("AccelerationEndSpeed"),GetCurrentPlayerVar("UnitSpeed") ) );
EndEvent
############################
#Actions to do on Car Reset#
############################

/*
$MaxCarResets = 5;        # Set to a positive number to limit number of race resets

Event OnMaxCarResets() # Spectate if player has used car reset more than the max
    globalMsg( langEngine( "%{main_maxreset}%" , GetCurrentPlayerVar( "NickName" ) ) );
    cmdLFS( "/spec " . GetCurrentPlayerVar( "Username" ) );
EndEvent

Event OnCarReset() # Do something when the car resets
    globalMsg( langEngine( "%{main_oncarreset}%", GetCurrentPlayerVar( "NickName" ),GetCurrentPlayerVar( "LapsDone" )+1 ));
    IF( $ConfVar["MaxCarResets"] > 0 )
    THEN
        openPrivButton( "carres_warn",50,60,100,15,5,4,16, langEngine( "%{main_specwarn}%" ) );
        openPrivButton( "carres_msg1",50,75,100,10,5,4,16,langEngine( "%{main_resetrest}%",$ConfVar["MaxCarResets"] - GetCurrentPlayerVar( "NumCarResets" )));
        privdelayedcommand( 4, ApplyCarResetPenalty);
    ELSE
        privdelayedcommand( 1, ApplyCarResetPenalty);
    ENDIF
EndEvent

Sub ApplyCarResetPenalty()
    IF( GetCurrentPlayerVar( "LapsDone" ) > 0 )
    THEN
        IF( getLapperVar( "RaceLapsLeft" ) <= 1 )
        THEN
            cmdLFS( "/p_30 " . GetCurrentPlayerVar( "Username" ) );
        ELSE
            cmdLFS( "/p_dt " . GetCurrentPlayerVar( "Username" ) );
        ENDIF
    ELSE
        IF( getLapperVar( "RaceLapsLeft" ) > 1 )
        THEN
            cmdLFS( "/p_dt " . GetCurrentPlayerVar( "Username" ) );
        ENDIF
    ENDIF
EndSub
*/

######################
#Actions for pit stop#
######################
#Local variable tou can use
#-------------------------------------------------------------------
# no pit windows if two var set to 0

$PitWindowStart=0;
$PitWindowStop=0;

Event OnNotPitWindow()  # Player event
	privMsg( langEngine( "%{main_notpitwindow}%" ,GetCurrentPlayerVar("Nickname"),$ConfVar["PitWindowStart"],$ConfVar["PitWindowStop"] ) );
EndEvent

Event OnBeginPitWindow() # Player event
	privMsg( langEngine( "%{main_inpitwindows}%" ,GetCurrentPlayerVar("Nickname") ) );
EndEvent

Event OnEndPitWindow()  # Player event
	privMsg( langEngine( "%{main_outpitwindows}%", GetCurrentPlayerVar("Nickname"] ) );
EndEvent

Event OnBeginPit( )  # Player event
	globalMsg( langEngine( "%{main_beginpit}%", GetCurrentPlayerVar("Nickname") ) );
	privMsg( langEngine( "%{main_pitwork}%", GetCurrentPlayerVar("pitWork") ) );
EndEvent

Event OnEndPit()  # Player event
	IF ( $enable_pitboard == "true" )
	THEN
	  OnEndPit_Pitboard();
	ELSE
	  globalMsg( langEngine( "%{main_endpit}%",GetCurrentPlayerVar("Nickname"),numToMSH(GetCurrentPlayerVar("PitTime") ) ) );
	  privMsg(  langEngine( "%{main_endpitpriv}%", numToMSH(GetCurrentPlayerVar("PitTime")), numToMSH( GetCurrentPlayerVar("TotalPitTime") ) ) );
	ENDIF
EndEvent

Event OnPit()  # Player teleported to pit

EndEvent

#$FL_Changed -> Front Left Changed  : 1 Changed 0 No
#$FR_Changed -> Front Right Changed : 1 Changed 0 No
#$RL_Changed -> Rear Left Changed : 1 Changed 0 No
#$RR_Changed -> Rear Right Changed : 1 Changed 0 No

Event OnChangeTyres( $FL_Changed, $FR_Changed, $RL_Changed, $RR_Changed )
EndEvent

######################
#Actions on penalties#
######################
#Possible variables to use:
#
#OnFastDriveOnPitL1 = Actions on 30 Sec Penalty or drive-through
#OnFastDriveOnPitL2 = Actions on 45 Sec Penalty or Stop&Go
#MaxFastDriveOnPit = Max Fast Drive on Pit allowed per race
#OnMaxFastDriveOnPit = Actions on Max Fast Drive on Pit allowed
#OnFalseStartL1 = 30 Sec Penalty or drive-through
#OnFalseStartL2 = 45 Sec Penalty or Stop&Go
#
#Local Variable can be used:
#
#-------------------------------------------------------------------

/*
Event OnFastDriveOnPitL1() # Player event
	globalMsg( langEngine( "%{main_fastdrivepitl1_1}%",GetCurrentPlayerVar("Nickname") ) );
	privMsg( langEngine( "%{main_fastdrivepitl1_2}%" ) );
EndEvent

Event OnFastDriveOnPitL2() # Player event
	globalMsg( langEngine( "%{main_fastdrivepitl2_1}%",GetCurrentPlayerVar("Nickname") ) );
	privMsg( langEngine( "%{main_fastdrivepitl2_1}%", GetCurrentPlayerVar("RemainFDIP" ) ) );
	cmdLFS( "/spec " . GetCurrentPlayerVar( "Username" ) );
EndEvent

Event OnMaxFastDriveOnPit() # Player event
	globalMsg( langEngine( "%{main_maxfastdrivepit1}%",GetCurrentPlayerVar("Nickname") ) );
	privRcm( langEngine( "%{main_maxfastdrivepit2}%"  ) );
	cmdLFS( "/kick " . GetCurrentPlayerVar("Username") );
EndEvent
$MaxFastDriveOnPit = 2;

Event OnFalseStartL1()
EndEvent

Event OnFalseStartL2()
EndEvent
*/

####################
#Overriding options#
####################
include( "./../includes/addonsused.lpr");
include( "./../includes/pitboard.lpr");
include( "./../includes/pitwindow_gui.lpr");
include( "./../includes/safetycar.lpr");
include( "./../includes/connected.lpr");
include( "./../includes/ctrack.lpr");
include( "./../includes/handicap.lpr");
include( "./../includes/schedule_set.lpr");
include( "./../includes/schedule_2.lpr");
include( "./../includes/panic.lpr");

Lang "EN"
	main_welc1 = "^7Welcome {0} ^7to ^1LFSLapper ^7powered server !&^2Type ^7!help ^2after leaving garage to see commands.";
	main_welc2 = "^7Your actual friendly Position (all visitors) : ^7{0}&^2Your actual League prequalify Position : {1}^6Estimate Pool : {2}&Don't use swearwords on this server&respect other player&otherwise you can be banned";
	main_accept = "Accept";
	main_deny = "Deny";
	main_speedtrap = "SpeedTrap = {0} {1}";
	main_gotlevel =  "^3You have got level: {0}";
	main_swear11 = "^1Don't use this words on this server";
	main_swear12 = "You will be spectated in ^2{0} ^1 more attempt(s)";
	main_swear21 = "Too many swearwords, spectated";
	main_nomatchflag = "Flags not match required flags";
	main_yourflag =  "Yours flags -> {0}";
	main_requiredflag = "Required flags -> {0}" ;
	main_spectated = "Spectated";
	main_notadmin = "You are not an Admin!";
	main_currnode = "The Current Node is : {0}";
	main_currzone = "The Current Zone is : {0}";
	main_lapclose = "Lapper Closed By Administrator!";
	main_ban = "{0} Ban {1}";
	main_kick = "{0} kick {1}";
	main_friendpos = "Your friendly position is {0}";
	main_groupqual = "Your groupqual is {0}";
	main_level = "^3You have level(s): {0}";
	main_dist = "Distance done on {0}/{1} = {2} {3}, session = {4} {5}";
	main_lapdone = "Laps done on {0}/{1} = {2}, session = {3}";
	main_timeinpit = "Time in pitting {0}";
	main_trackused = "Track in use : {0} = {1}";
	main_serverclock = "Server time clock reference : {0}";
	main_midnight = "Midnight warning to all working men!";
	main_newyear = "Happy New Year!";
	main_allowed = "{0}^3 allowed on this server";
	main_notallowed = "{0}^3 not allowed on this server";
	main_tolowhand1 = "{0}^3 spectated for to low handicap";
	main_tolowhand2 = "^3need {0}kg and {1}% of intake restriction!";
	main_vote_restart1 = "Restart:";
	main_vote_restart2 = "({0}/{1}) Need {2}";
	main_vote_qualify1 = "Qualify";
	main_vote_qualify2 = "({0}/{1}) Need {2}";
	main_vote_end1 = "End:";
	main_vote_end2 = "({0}/{1}) Need {2}";
	main_car_changed = "Car changed, go to pit! Current car = {0}";
	main_track_changed1 = "Track changed, please wait!";
	main_track_changed2 = "Current Track = {0}";
	main_left_server = "{0} left the server";
	main_before = "Before: ";
	main_behind = "Behind: ";
	main_split1 = "^7SP1: {0} {1}({2})&^7TPB:{3}";
	main_split2 = "^7SP2: {0} {1}({2})&^7TPB:{3}";
	main_split3 = "^7SP3: {0} {1}({2})&^7TPB:{3}";
	main_splitlast = "^7SPL: {0} {1}({2})&^7TPB:{3} Avg:{4}{5}";
	main_great1 = "Great 1st split ({0}) by {1}^8!";
	main_good1 = "Good 1st split ({0}) by {1}^8!";
	main_great2 = "Great 2nd split ({0}) by {1}^8!";
	main_good2 = "Good 2nd split ({0}) by {1}^8!";
	main_great3 = "Great 3rd split ({0}) by {1}^8!";
	main_good3 = "Good 3rd split ({0}) by {1}^8!";
	main_greatlap = "Great lap ({0}) by {1}^8!";
	main_goodlap = "Good lap ({0}) by {1}^8!";
	main_help1 = "^2Commands list";
	main_help = "^2General commands"
			. "&^3!myconfig ^8Configure lapper for you"
			. "&^3!top ^8[table offset] [3-letter car name] ['filter' pattern]"
			. "&^3!drf ^8[table offset] [3-letter car name] ['filter' pattern]"
			. "&^3!stats ^8[playername pattern]"
			. "&^3!dstats ^8[playername pattern]"
			. "&^3!near ^8Gap with 14 pilots near you on the ranking"
			. "&^3!spb ^8Split times and TPB (Theoretical PB)"
			. "&^3!razspb ^8Start new spb session (eg when changing car)"
			. "&^3!track ^8Name of actual track"
			. "&^3!time ^8Server time (to leagues mettings)"
			. "&^3!ver ^8Version of LFSLapper"
			. "&"
			. "&^2Special league commands"
			. "&^3!topqual ^8Rank to pilots specified on *.flt file"
			. "&^3!statsqual ^8Actual Position on prequalify session"
			. "&"
			. "&^2New functions"
			. "&^3!laps ^8Total laps number + session laps number"
			. "&^3!hand ^8Handicap by pilot ordered by league-host admin"
			. "&^3!pit ^8Total pit stop time"
			. "&^3Shift+i ^8Configure your display messages"
			. "&^3!closepb ^8Close Pitboard temporary"
			. "&^3!config ^8Configure Pitboard"
			. "&^3!ctrack ^8Open track change GUI (Admin only)"
			. "&^3!pitwindow ^8Show currently set pitwindow(s)"
			. "&^3!pwgui ^8Open Pitwindow GUI (Admin only)"
			. "&^3!sc ^8Open safetycar GUI (Admin only)";
	main_flood = "{0}^3 kicked for flooding";
	main_brake = "^3Please, brake in time!";
	main_on_result = "Finished Pos = {0}";
	main_lost_control = "^1Danger! ^8{0} ^2lost control!";
	main_toslow1 = "you are too slow! Max : {0}";
	main_toslow2 = "kick on {0}";
	main_toslowvery1 = "You are very slow, spectated!";
	main_toslowvery2 = "{0} is too slow, spectated!";
	main_idle1 = "^3You are idle and will be spectated in 10 seconds" ;
	main_idle2 = "^3You are spectated for non-activity";
	main_newdriftpb = "{0}^3 made new PB: ^7{1} ^3pts!";
	main_driftlap = "{0} ^3drifted to ^7{1} ^3pts";
	main_ondriftscore = "Score: ^7{0} ^3{1}";
	main_ongooddrift = "{0} ^3made excellent drift: ^7{1} ^3pts";
	main_drifttolow = "{0}^3 disqualified";
	main_onnewpb = "New PB by {0}^8 ({1}): {2}";
	main_onnewpb_rank = "Friendly rank : {0}";
	main_onnewpb_sesslaps = "Session laps done = {0}";
	main_onnewpb_servlaps = "Total laps done (server) = {0}";
	main_onnewpb_avgspeed = "Average speed: {0}{1}";
	main_onnewpb_rank2 = "Friendly {0} rank: ^7{1}";
	main_onnewpbqual = "League - New QT by {0}^8:{1}";
	main_onnewpbqual_rank = "Friendly rank (all visitors): ^7{0}";
	main_onnewpbqual_pos = "^2Qualify pos.: {0}";
	main_onnewpbqual_pool = "^6Actual Pool: {0}";
	main_onnewpbqual_avgspeed = "Average speed: {0}{1}";
	main_onnewpbqual_posqual = "{0} ^2Pos:{1} - Pool:{2}";
	main_accel = "^8Accelerated in ^3{0}^8 seconds to {1} {2}!";
	main_notpitwindow = "{0} ^1You are not on pit Windows, allowed in {1}-{2}";
	main_inpitwindows = "{0} ^1You are allowed to pit";
	main_outpitwindows = "{0}  ^1You are not allowed to pit";
	main_beginpit = "{0}^8 makes a pit stop";
	main_pitwork = "Pit begin! Work:{0}";
	main_endpit = "{0}^8 left pits in {1}";
	main_endpitpriv = "Pit stop finished in {0} - Total Pit: {1}";
	main_fastdrivepitl1_1 = "{0}^1 Warning for fast driving in pit";
	main_fastdrivepitl1_2 = "^1WARNING-KICK POSSIBLE" ;
	main_fastdrivepitl2_1 = "{0}^1 Spectated for fast driving in pit";
	main_fastdrivepitl2_2 = "^1KICK IN {0} TRY" ;
	main_maxfastdrivepit1 = "{0}^1 kicked for fast driving in pit";
	main_maxfastdrivepit2 = "^1YOU ARE KICKED";
	main_maxreset = "{0} spectated for exceeding max car resets";
	main_oncarreset = "Car Reset by {0} on lap {1}";
	main_specwarn = "^1Spectate Warning";
	main_resetrest = "^2You have^3 {0} ^2car resets left";

	built_pos = "Pos";
	built_grp = "Grp";
	built_car = "Car";
	built_track = "Track";
	built_nick = "NickName";
	built_pb = "Pb";
	built_split = "Split";
	built_splits = "Splits";
	built_points = "Points";
	built_nolfspb = "LFS World PB not yet retreived";
	built_nolfspbcrit = "No LFS World PB for this criteria";
	built_lapsdone = " Laps Done";
	built_hand_nick = "^3{0}^9 handicap:";
	built_hand_curr = "  - Current {0}Kg - Intake Restr.: {1}%";
	built_hand_req =  "  - Required {0}^9 {1}Kg - Intake Rest.: {2}%";




EndLang
Lang "FR"
	main_welc1 = "^7Bienvenue {0} ^7sur ce serveur Géré par ^1LFSLapper^7!&^2Tapez ^7!help ^2 pour voir les commandes après avoir quitté le garage";
	main_welc2 = "^7Votre position absolue (Tous les visiteurs) : ^7{0}&^2Votre position de préqualification : {1}^6Estimation de poule : {2}&Ne pas employer de mots grossiers sur ce serveur&Respecter les autres joueurs&sinon vous risquez d'être banni";
	main_accept = "Accepter";
	main_deny = "Refuser";
	main_speedtrap = "Radar = {0} {1}";
	main_gotlevel =  "^3Vous avez atteind le niveau: {0}";
	main_swear11 = "^1Ne pas utiliser de gros mots ici";
	main_swear12 = "Encore {0} gros mot(s) et vous passerez spectateur";
	main_swear21 = "Trop de gros mots, spectateur";
	main_nomatchflag = "Flags ne correspondent pas aux flags requis";
	main_yourflag =  "Vos flags -> {0}";
	main_requiredflag = "Flags requis -> {0}" ;
	main_spectated = "Spectateur";
	main_notadmin = "Vous n'êtes pas admin!";
	main_currnode = "Le noeud courant est: {0}";
	main_currzone = "La zone courante est: {0}";
	main_lapclose = "Lapper fermé par un administrateur!";
	main_ban = "{0} a banni {1}";
	main_kick = "{0} a kické {1}";
	main_friendpos = "Votre position absolue est {0}";
	main_groupqual = "Votre poule est {0}";
	main_level = "^3Vous avez le(s) niveau(x): {0}";
	main_dist = "Distance réalisée avec {0}/{1} = {2} {3}, session = {4} {5}";
	main_lapdone = "Tours réalisés avec {0}/{1} = {2}, session = {3}";
	main_timeinpit = "Temps passé aux stands {0}";
	main_trackused = "Circuit actuel: {0} = {1}";
	main_serverclock = "Heure du serveur: {0}";
	main_midnight = "Minuit, attention aux travailleurs!";
	main_newyear = "Bonne année!";
	main_allowed = "{0}^3 autorisé sur ce serveur";
	main_notallowed = "{0}^3 non autorisé sur ce serveur";
	main_tolowhand1 = "{0}^3 spectateur car handicap trop faible";
	main_tolowhand2 = "^3Requis {0}kg et {1}% de limitation à l'admission!";
	main_vote_restart1 = "Redémarrer:";
	main_vote_restart2 = "({0}/{1}) Requis {2}";
	main_vote_qualify1 = "Qualify";
	main_vote_qualify2 = "({0}/{1}) Requis {2}";
	main_vote_end1 = "Finir:";
	main_vote_end2 = "({0}/{1}) Requis {2}";
	main_car_changed = "La voiture a changé, Allez aux pits! Voiture = {0}";
	main_track_changed1 = "Changement de circuit, patientez!";
	main_track_changed2 = "Circuit actuel = {0}";
	main_left_server = "{0} part du serveur";
	main_before = "Précédent: ";
	main_behind = "Poursuivant: ";
	main_split1 = "^7SP1: {0} {1}({2})&^7TPB:{3}";
	main_split2 = "^7SP2: {0} {1}({2})&^7TPB:{3}";
	main_split3 = "^7SP3: {0} {1}({2})&^7TPB:{3}";
	main_splitlast = "^7SPL: {0} {1}({2})&^7TPB:{3} Avg:{4}{5}";
	main_great1 = "Superbe 1er split ({0}) par {1}^8!";
	main_good1 = "Bon 1er split ({0}) par {1}^8!";
	main_great2 = "Superbe 2ème split ({0}) par {1}^8!";
	main_good2 = "Bon 2ème split ({0}) par {1}^8!";
	main_great3 = "Superbe 3ème split ({0}) par {1}^8!";
	main_good3 = "Bon 3ème split ({0}) par {1}^8!";
	main_greatlap = "Superbe tour ({0}) par {1}^8!";
	main_goodlap = "Bon tour ({0}) par {1}^8!";
	main_help1 = "^2Liste des commandes";
	main_help = "^2Commandes générales"
			. "&^3!myconfig ^8Configurer lapper pour vous"
			. "&^3!top ^8[table offset] [3-letter car name] ['filter' pattern]"
			. "&^3!drf ^8[table offset] [3-letter car name] ['filter' pattern]"
			. "&^3!stats ^8[playername pattern]"
			. "&^3!dstats ^8[playername pattern]"
			. "&^3!near ^8Liste des records centrés sur vous"
			. "&^3!spb ^8Temps des splits et meilleurs temps théoriques TPB (Theoretical PB)"
			. "&^3!razspb ^8Remise à zéro des temps de session"
			. "&^3!track ^8Nom du circuit actuel"
			. "&^3!time ^8Heure du serveur (pour les championnats)"
			. "&^3!ver ^8Version de LFSLapper"
			. "&"
			. "&^2Commandes spéciales ligue"
			. "&^3!topqual ^8Position des pilotes participant à la qualification"
			. "&^3!statsqual ^8Votre position de préqualification actuelle"
			. "&"
			. "&^2Nouvelles fonctions"
			. "&^3!laps ^8Totaux des nombres de tours, par session et pour le serveur"
			. "&^3!hand ^8Handicaps requis"
			. "&^3!pit ^8Temps total passée aux stands"
			. "&^3!closepb ^8Fermer Pitboard de manière temporaire"
			. "&^3!config ^8Configure Pitboard"
			. "&^3!ctrack ^8Ouvre la platine d'administration du serveur(Seulement Admins)"
			. "&^3!pitwindow ^8Montre les ouvertures de stand"
			. "&^3!pwgui ^8Ouvre la platine des ouvertures de stands (seulement Admins)"
			. "&^3!sc ^8Ouvre la platine de la safetycar (seulement Admins)";
	main_flood = "{0}^3 kické car trop de flood";
	main_brake = "^3SVP, freinez à temps!";
	main_on_result = "Position finale = {0}";
	main_lost_control = "^1Danger! ^8{0} ^2a perdu le contrôle!";
	main_toslow1 = "Vous être trop lent! Max : {0}";
	main_toslow2 = "Vous serez kické dans {0}";
	main_toslowvery1 = "Vous êtes vraiment trop lent, spectateur!";
	main_toslowvery2 = "{0} est trop lent, spectateur!";
	main_idle1 = "^3Vous êtes inactif et passerez spectateur dans 10 secondes" ;
	main_idle2 = "^3Vous êtes passé spectateur car inactif!";
	main_newdriftpb = "{0}^3 réalise un nouveau PB: ^7{1} ^3pts!";
	main_driftlap = "{0} ^3réalise ^7{1} ^3pts de drift";
	main_ondriftscore = "Score: ^7{0} ^3{1}";
	main_ongooddrift = "{0} ^3réalise un drift excellent : ^7{1} ^3pts";
	main_drifttolow = "{0}^3 disqualifié";
	main_onnewpb = "Nouveau PB par {0}^8 ({1}): {2}";
	main_onnewpb_rank = "Position absolue : {0}";
	main_onnewpb_sesslaps = "Tours réalisés durant la session = {0}";
	main_onnewpb_servlaps = "Tours réalisés sur le serveur = {0}";
	main_onnewpb_avgspeed = "Vitesse moyanne: {0}{1}";
	main_onnewpb_rank2 = "Voiture {0} position: ^7{1}";
	main_onnewpbqual = "Ligue - Nouveau temps de qualif par {0}^8:{1}";
	main_onnewpbqual_rank = "Position absolue: ^7{0}";
	main_onnewpbqual_pos = "^2Position Qualifiquation.: {0}";
	main_onnewpbqual_pool = "^6Poule actuelle: {0}";
	main_onnewpbqual_avgspeed = "Vitesse moyenne: {0}{1}";
	main_onnewpbqual_posqual = "{0} ^2Pos:{1} - Poule:{2}";
	main_accel = "^8De 0 à {1}{2} en ^3{0}^8 secondes!";
	main_notpitwindow = "{0} ^1Stand fermés, ouverture entre {1}-{2}";
	main_inpitwindows = "{0} ^1Vous êtes autorisé à pitter";
	main_outpitwindows = "{0}  ^1Vous n'êtes pas autorisé à pitter";
	main_beginpit = "{0}^8 s'arrête au stand";
	main_pitwork = "Début d'arrêt au stand! Travail en cours:{0}";
	main_endpit = "{0}^8 quitte les stands en {1}";
	main_endpitpriv = "Arrêt aux stands terminé en {0} - Total arrêts: {1}";
	main_fastdrivepitl1_1 = "{0}^1Attention vitesse excessive aux stands";
	main_fastdrivepitl1_2 = "^1ATTENTION-KICK POSSIBLE" ;
	main_fastdrivepitl2_1 = "{0}^1Spectateur car trop rapide dans les stands";
	main_fastdrivepitl2_2 = "^1ENCORE {0} ESSAIS AVANT LE KICK" ;
	main_maxfastdrivepit1 = "{0}^1Kické car trop rapide dans les stands";
	main_maxfastdrivepit2 = "^1VOUS ETES KICKE";
	main_maxreset = "{0} mis en spectateur pour excès de reset de voiture";
	main_oncarreset = "Reset de voiture par {0} au tour {1}";
	main_specwarn = "^1Attention mise en spectateur";
	main_resetrest = "^2Il vous reste^3 {0} ^2reset de voiture";

	built_pos = "Position";
	built_grp = "Poule";
	built_car = "Voiture";
	built_track = "Circuit";
	built_nick = "Pseudo";
	built_pb = "PB";
	built_split = "Split";
	built_splits = "Splits";
	built_points = "Points";
	built_nolfspb = "Les record de LFS World ne sont pas encore récupérés";
	built_nolfspbcrit = "Pas de records LFS World pour ce critère";
	built_lapsdone = "Tours réalisés";
	built_hand_nick = "^9 Handicap pour ^3{0}^9 :";
	built_hand_curr = "  - Actuel {0}Kg - Restr. admission.: {1}%";
	built_hand_req =  "  - Requis {0}^9 {1}Kg - Restr. admission.: {2}%";
EndLang

