<?php
/**
 ********************************************
 * Masters of Endurance tracker / LFS-Tracker 
 ********************************************
 * 
 * Copyright © 2007 Wolfgang Tom (WolleT)
 * v1.0 originally written by Wolfgang Tom
 * 
 * Copyright © 2009-2011 Michael Booth (Boothy)
 * v2.0 tracker modified by Michael Booth
 * 
 * Thanks also to Casper Roescher (Kaspur).  
 * 
 * Latest tracker version available from the LFS forum thread - http://www.lfsforum.net/showthread.php?t=73414
 * Any code changes/improvements can be submitted for inclusion in the public tracker version. 
 * E-mail me at web@michaelbooth.me.uk or PM me via http://www.lfsforum.net/private.php?do=newpm&u=202039
 * 
 ********************************************
 * 
 * DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
 * Version 2, December 2004

 * Copyright © 2004 Sam Hocevar <sam@hocevar.net>

 * Everyone is permitted to copy and distribute verbatim or modified
 * copies of this license document, and changing it is allowed as long
 * as the name is changed.

 * DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
 * TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

 * 0. You just DO WHAT THE FUCK YOU WANT TO. 
 * 
 ******************************************** 
 * See http://sam.zoy.org/wtfpl/ for more information
 **/

unset($bodypage);
$bodypage = "teamstats";
include 'qheader.php';
echo "<table id='raceStandings'>";
echo "<thead>";
echo "<tr>";
echo "<th scope='col'>Pos</th>";
echo "<th scope='col'>Num</th>";
if ($qualifyingFocus == "driver") {
    echo "<th scope='col'>Driver</th>";
    $teamcol = $XMLTEAM[$i]['team_data']['name'] ? true : false;
    if ($teamcol) {
        echo "<th scope='col'>Team</th>";
    }
} else {
    echo "<th scope='col'>Team Name</th>";
}
if ($showCars) {
    echo "<th scope='col'>Car</th>";
    $colspanExtra++;
}

$pitcol = $XMLTEAM[$i]['race_data']['num_pits'] ? true : false;
if ($pitcol) {
    echo "<th scope='col'>Pit</th>";
}
if ($qualifyingFocus == "team" && $driverName == "fastest") {
    echo "<th scope='col'>Fastest Driver</th>";
} elseif ($qualifyingFocus == "team" && $driverName != "fastest") {
    echo "<th scope='col'>Current Driver</th>";
}
if ($showPrev) {
    echo "<th scope='col'>Prev</th>";
    $colspanExtra++;
}
echo "<th scope='col'>Best</th>";
$swapcol = $XMLTEAM[$i]['race_data']['num_swap'] ? true : false;
if ($swapcol) {
    echo "<th scope='col'>Swap</th>";
    $colspanExtra++;
}

echo "<th scope='col'>On</th>";
echo "<th scope='col'>Laps</th>";
echo "<th scope='col'>Gap</th>";
echo "<th scope='col'>Diff</th>";
echo "<th scope='col'>" . strtolower($distanceUnits) . "</th>";
$pencolfull = false;
$pencollaps = false;
$pencoltime = false;
if ($XMLTEAM[$i]['race_data']['penalty_laps'])
    $pencollaps = true;
if ($XMLTEAM[$i]['race_data']['penalty_time'])
    $pencoltime = true;
if ($XMLTEAM[$i]['race_data']['penalty_laps'] && $XMLTEAM[$i]['race_data']['penalty_time'])
    $pencolfull = true;

if ($pencolfull) {
    $colspanExtra++;
    echo "<th scope='col' colspan='2'>Penalty</th>";
    $colspanExtra++;
} elseif ($pencollaps || $pencoltime) {
    echo "<th scope='col'>Pen</th>";
    $colspanExtra++;
}

echo "</tr>";
echo "</thead>";
echo "<tbody>";
if ($XMLTEAM[$i]['race_data']['laps'])
    $teamlaps = $XMLTEAM[$i]['race_data']['laps'] - 1;
if ($raceClassCSS[$XMLTEAM[$i]['team_data']['class']]) {
    $classrow = $raceClassCSS[$XMLTEAM[$i]['team_data']['class']];
} else {
    $classrow = strtolower($XMLTEAM[$i]['team_data']['class']);
}
echo "<tr class='" . $classrow . "'>";
// GRID/SERVER if pre-race
if (strtoupper($XMLRACE['session_status']) == "PRE-RACE") {
    echo "<td class='pos'>" . $XMLTEAM[$i]['team_data']['grid'] . "</td>";
    // SERVER
    if ($showServer) {
        echo "<td class='pos'>" . $XMLTEAM[$i]['team_data']['server'] . "</td>";
    }
} else {
    //CLASS POSITION
    if ($XMLRACE['numClasses'] > 1) {
        if ($XMLTEAM[$i]['team_data']['class_position'] !== $XMLTEAM[$i]['race_data']['position']) {
            echo "<td class='pos'><abbr title='" . ordinalSuffix($XMLTEAM[$i]['race_data']['position']) .
                " overall'>" . $XMLTEAM[$i]['team_data']['class_position'] . "</abbr></td>";
        } else {
            echo "<td class='pos'>" . $XMLTEAM[$i]['race_data']['position'] . "</td>";
        }
    } else {
        echo "<td class='pos'>" . $XMLTEAM[$i]['race_data']['position'] . "</td>";
    }
}
// TEAM NUMBER
echo "<td class='num'><a href='" . $trackerModeShort . "_" . $XMLTEAM[$i]['team_data']['number'] .
    ".html'><em>" . $XMLTEAM[$i]['team_data']['number'] . "</em></a></td>";


// TEAM NAME
if ($qualifyingFocus == "driver") {
    echo "<td class='teamName'>";
    $j = 0;
    echo "<img src='" . $trackerRoot . "flags/" . strtolower(str_replace(" ", "_", $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country'])) .
        ".gif' width='18' height='12' alt='' title='" . ucwords($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country']) .
        "'><span title='" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs'] .
        "'>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_full'] . "</span>";
    echo "</td>";
    if ($teamcol) {
        echo "<td class='currentDriver'>" . $XMLTEAM[$i]['team_data']['name'] . "</td>";
    }
} else {
    echo "<td class='teamName'>" . $XMLTEAM[$i]['team_data']['name'] . "</td>";
}

if ($showCars) {
    // TEAM CAR - LMP, FZR, FZ2, FZ3
    if ($XMLTEAM[$i]['team_data']['class'] == "GT2" || $XMLTEAM[$i]['team_data']['class'] ==
        "GUE") {
        $XMLTEAM[$i]['team_data']['car'] = substr_replace($XMLTEAM[$i]['team_data']['car'],
            "2", -1);
    } elseif ($XMLTEAM[$i]['team_data']['class'] == "GT3") {
        $XMLTEAM[$i]['team_data']['car'] = substr_replace($XMLTEAM[$i]['team_data']['car'],
            "3", -1);
    } elseif ($raceClassName[1] !== "GT1" && $XMLTEAM[$i]['team_data']['class'] ==
    "GT1") {
        $XMLTEAM[$i]['team_data']['car'] = substr_replace($XMLTEAM[$i]['team_data']['car'],
            "1", -1);
    }
    echo "<td>" . $XMLTEAM[$i]['team_data']['car'] . "</td>";
}

// NUMBER OF DRIVER SWAPS
if ($swapcol and $XMLTEAM[$i]['race_data']['num_swap']) {
    echo "<td>" . $XMLTEAM[$i]['race_data']['num_swap'] . "</td>";
} elseif ($swapcol) {
    echo "<td></td>";
}

//PIT STOPS
if ($pitcol) {
    if ($XMLTEAM[$i]['race_data']['num_pits'] == 0) {
        echo "<td></td>";
    } elseif ($XMLTEAM[$i]['race_data']['pitstops'][($XMLTEAM[$i]['race_data']['last_pit_index'] -
    1)]['type'] == "PITIN")
        echo "<td class='pitin'><strong>" . $XMLTEAM[$i]['race_data']['num_pits'] .
            "</strong></td>";
    else
        echo "<td>" . $XMLTEAM[$i]['race_data']['num_pits'] . "</td>";
}


// DISPLAY FASTEST TEAM LAP, BOLD IF BEST OVERALL, PURPLE IF LAST LAP WAS BEST OVERALL, GREEN IF LAST LAP WAS TEAM BEST
if (!$XMLTEAM[$i]['race_data']['laps']) {
    $bestlapconstruct = "";
    $prevlapconstruct = "";
} else {
    $bestlapconstruct = normalTime($XMLTEAM[$i]['race_data']['fastest_lap'], true, false, true, true, false);
    $prevlapconstruct = normalTime($XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime'], true, false, true, true, false);
}
if ($XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime'] == $XMLTEAM[$i]['race_data']['fastest_lap'] or
    $XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap']) {
    $bestlapconstruct = "<em class='teambestlap'>" . normalTime($XMLTEAM[$i]['race_data']['fastest_lap'], true, false, true, true, false) .
        "</em>";
    $prevlapconstruct = $bestlapconstruct;
}
if ($XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime'] == $XMLRACE['fastest_lap'] or
    $XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap']) {
    $bestlapconstruct = "<em class='classbestlap'>" . normalTime($XMLTEAM[$i]['race_data']['fastest_lap'], true, false, true, true, false) .
        "</em>";
    $prevlapconstruct = $bestlapconstruct;
}
if ($XMLRACE['fastest_lap'] == $XMLTEAM[$i]['race_data']['fastest_lap'] or $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap'] ==
    $XMLTEAM[$i]['race_data']['fastest_lap']) {
    $bestlapconstruct = "$bestlapconstruct";
}


// CURRENT DRIVER
if ($qualifyingFocus != "driver") {
    if ($driverName == "fastest") {
        $XMLTEAM[$i]['race_data']['current_driver'] = $XMLTEAM[$i]['race_data']['fastest_driver'];
        echo "<td class='currentDriver'>";
        for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++) {
            if ($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs'] == $XMLTEAM[$i]['race_data']['current_driver'])
                echo "<img src='" . $trackerRoot . "flags/" . strtolower(str_replace(" ", "_", $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country'])) .
                    ".gif' width='18' height='12' alt='' title='" . ucwords($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country']) .
                    "'><span title='" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_full'] .
                    " / " . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs'] . "'>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_real'] .
                    "</span>";
        }
    }
    echo "</td>";
}
// echo PREV LAP CONSTRUCTED
if ($showPrev && ($XMLTEAM[$i]['race_data']['fastest_lap'] != 99999999999)) {
    if ($XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime'] == 3600000) {
        echo "<td class='pitin'><strong>OUTLAP</strong></td>";
    } else {
        echo "<td><strong>$prevlapconstruct</strong></td>";
    }
} elseif ($showPrev) {
    echo "<td class='qualibest'></td>";
}

// echo BEST LAP CONSTRUCTED
if ($XMLTEAM[$i]['race_data']['fastest_lap'] != 99999999999) {
    echo "<td class='qualibest'><strong>$bestlapconstruct</strong></td>";
} else {
    echo "<td class='qualibest'></td>";
}
// ON LAP
if ($XMLTEAM[$i]['race_data']['fastest_lap_on'] > 0)
    echo "<td>" . ($XMLTEAM[$i]['race_data']['fastest_lap_on'] - 1) . "</td>";
else
    echo "<td>" . $XMLTEAM[$i]['race_data']['fastest_lap_on'] . "</td>";

// LAPS
echo "<td>" . $XMLTEAM[$i]['race_data']['laps'] . "</td>";
// GAP
if ($i == 0 || ($XMLTEAM[$i]['race_data']['fastest_lap_on'] == 0) || $XMLTEAM[$i]['team_data']['class_position'] ==
    1)
    echo "<td></td>";
elseif (($XMLTEAM[$i]['race_data']['percent'] > $percentLimit) && $percentLimit >
    100)
    echo "<td class='pitin'><span title='" . number_format($XMLTEAM[$i]['race_data']['percent'],
        2) . "%'>" . normalTime($XMLTEAM[$i]['race_data']['dist_to_lead_car'], true, false, false, false, false) .
        "</span></td>";
else
    echo "<td><span title='" . number_format($XMLTEAM[$i]['race_data']['percent'], 2) .
        "%'>" . normalTime($XMLTEAM[$i]['race_data']['dist_to_lead_car'], true, false, false, false, false) .
        "</span></td>";
// DIFF
if ($i == 0 || ($XMLTEAM[$i]['race_data']['fastest_lap_on'] == 0) || $XMLTEAM[$i]['team_data']['class_position'] ==
    1) {
    echo "<td></td>";
} elseif ($XMLTEAM[$i]['race_data']['dist_to_car_in_front'] < 0) {
    echo "<td></td>";
} else {
    echo "<td>" . normalTime($XMLTEAM[$i]['race_data']['dist_to_car_in_front'], true, false, false, false, false) .
        "</td>";
}
// SPEED
if ($XMLTEAM[$i]['race_data']['fastest_lap'] != 99999999999) {
    if ($distanceUnits == "mph") {
        echo "<td><span title='" . number_format($XMLTEAM[$i]['race_data']['kph'], 2) .
            " kph'>" . number_format($XMLTEAM[$i]['race_data']['mph'], 2) . "</span></td>";
    } else {
        echo "<td><span title='" . number_format($XMLTEAM[$i]['race_data']['mph'], 2) .
            " mph'>" . number_format($XMLTEAM[$i]['race_data']['kph'], 2) . "</span></td>";
    }
} else {
    echo "<td></td>";
}
// PENALTY LAPS & TIME
if ($pencolfull) {
    if (!$XMLTEAM[$i]['race_data']['penalty_laps'])
        echo "<td></td>";
    if (!$XMLTEAM[$i]['race_data']['penalty_time'])
        echo "<td></td>";
} elseif ($pencoltime or $pencollaps) {
    if (!$XMLTEAM[$i]['race_data']['penalty_laps'] && !$XMLTEAM[$i]['race_data']['penalty_time'])
        echo "<td></td>";
}
if ($XMLTEAM[$i]['race_data']['penalty_laps'] == 1)
    echo "<td class='penlapspos'>+" . $XMLTEAM[$i]['race_data']['penalty_laps'] .
        " lap</td>";
if ($XMLTEAM[$i]['race_data']['penalty_laps'] > 1)
    echo "<td class='penlapspos'>+" . $XMLTEAM[$i]['race_data']['penalty_laps'] .
        " laps</td>";
if ($XMLTEAM[$i]['race_data']['penalty_laps'] == -1)
    echo "<td class='penlaps'>" . $XMLTEAM[$i]['race_data']['penalty_laps'] .
        " lap</td>";
if (($XMLTEAM[$i]['race_data']['penalty_laps'] < -1) && ($XMLTEAM[$i]['race_data']['penalty_laps']))
    echo "<td class='penlaps'>" . $XMLTEAM[$i]['race_data']['penalty_laps'] .
        " laps</td>";
if ($XMLTEAM[$i]['race_data']['penalty_time'] < 0)
    echo "<td class='penlaps'>+" . substr($XMLTEAM[$i]['race_data']['penalty_time'],
        1) . "s</td>";
if ($XMLTEAM[$i]['race_data']['penalty_time'] > 0)
    echo "<td class='penlapspos'>-" . $XMLTEAM[$i]['race_data']['penalty_time'] .
        "s</td>";
echo "</tr>";
echo "<tr class='collapsed_stats " . $classrow . "'>";
echo "<td colspan='" . (8 + $colspanExtra) . "'>";
echo "<table>";
echo "<tr>";
echo "<th></th>";
for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++)
    echo "<th><img src='" . $trackerRoot . "flags/" . strtolower(str_replace(" ",
        "_", $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country'])) .
        ".gif' width='18' height='12' alt='' title='" . ucwords($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country']) .
        "'><br><span title=\"" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_full'] .
        "\">" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_real'] . "</span></th>";
echo "</tr>";
echo "<tr>";
echo "<th scope='row'>Username</th>";
for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++)
    echo "<td><a href='http://spdoracing.com/eventdb/driver/" . urlencode($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs']) .
        "'>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs'] . "</a></td>";
echo "</tr>";
echo "<tr>";
echo "<th scope='row'>Laps</th>";
for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++)
    echo "<td>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['laps'] . "</td>";
echo "</tr>";
echo "<tr>";
echo "<th scope='row'>Best lap</th>";
for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++) {
    if ($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'] != 99999999999) {
        if (normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'], true) ==
            $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap']) {
            echo "<td><strong class='classbestlap'>" . normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'], true) .
                "</strong></td>";
        } elseif ($XMLTEAM[$i]['race_data']['fastest_lap'] == normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'], true))
            echo "<td><strong class='teambestlap'>" . normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'], true) .
                "</strong></td>";
        else
            echo "<td>" . normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'], true) .
                "</td>";
    } else
        echo "<td></td>";
}
echo "</tr>";
echo "</table>";

echo "<table style='width:99%'>";
echo "<tr>";
echo "<td colspan='" . ($XMLTEAM[$i]['team_data']['num_drivers'] + 1) .
    "' class='expandedbottom'>";
if ($showServer) {
    echo "<p>Server: #" . $XMLTEAM[$i]['team_data']['server'];
    if (!$XMLTEAM[$i]['team_data']['grid'] > 0) {
        echo "</p>";
    }
}
echo "</td>";
echo "</tr>";
echo "</table>";
if ($showCar) {
    $showcarimgsrc = $showCarBaseUrl . $XMLTEAM[$i]['team_data']['number'] .
        strtolower($XMLTEAM[$i]['team_data']['class']) . $thumbCar[removeszeros($XMLTEAM[$i]['team_data']['number'])] .
        ".png";
    list($width, $height, $type, $attr) = getimagesize($showcarimgsrc);
    if ($width) {
        echo "<img src='", $showcarimgsrc, "' ", $attr, " alt='' class='carimage'>";
    }
}
echo "</td>";
echo "</tr>";

echo "<tr class='collapsed_stats " . $classrow . "'>";
echo "<td colspan='" . (8 + $colspanExtra) . "'>";
echo "<table>";
echo "<thead><tr>";
echo "<th>Lap</th>";
echo "<th>Lap time</th>";
echo "<th>Gap to pole</th>";
echo "<th>Session time</th>";
echo "<th>% of pole</th>";
echo "<th>Driver</th>";
echo "</tr></thead>";
echo "<tbody>";
for ($n = 0; $n < $XMLTEAM[$i]['race_data']['laps']; $n++) {
    $outlap = false;
    echo "<tr";
    if ($XMLTEAM[$i]['race_data']['fastest_lap_on'] == $n + 2) {
        echo " class='qualibest'";
    }
    echo ">";
    echo "<td>" . ($n + 1) . "</td>";
    if ($XMLTEAM[$i]['raw_laps'][$n]['laptime'] == 3600000 || ($XMLTEAM[$i]['raw_laps'][$n]['laptime'] >=
        3600000 && $XMLTEAM[$i]['raw_laps'][$n]['laptime'] == $XMLTEAM[$i]['raw_laps'][$n]['sessiontime'])) {
        echo "<td class='pitin'>OUTLAP</td>";
        $outlap = true;
    } elseif (($XMLTEAM[$i]['raw_laps'][$n]['laptime'] == $XMLRACE['fastest_lap'] or
    $XMLTEAM[$i]['raw_laps'][$n]['laptime'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap']) &&
        $XMLTEAM[$i]['race_data']['fastest_lap_on'] == $n + 2) {
        echo "<td><strong class='classbestlap'>" . normalTime($XMLTEAM[$i]['raw_laps'][$n]['laptime'], true) .
            "</strong></td>";
    } elseif (($XMLTEAM[$i]['raw_laps'][$n]['laptime'] == $XMLTEAM[$i]['race_data']['fastest_lap']) &&
    $XMLTEAM[$i]['race_data']['fastest_lap_on'] == $n + 2) {
        echo "<td><strong class='teambestlap'>" . normalTime($XMLTEAM[$i]['raw_laps'][$n]['laptime'], true) .
            "</strong></td>";
    } else {
        echo "<td>" . normalTime($XMLTEAM[$i]['raw_laps'][$n]['laptime'], true) .
            "</td>";
    }
    if ($n > 0 && !$outlap) {
        echo "<td>" . normalTime($XMLTEAM[$i]['raw_laps'][$n]['laptime'] - $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap'], true, true) .
            "</td>";
    } else {
        echo "<td></td>";
    }
    echo "<td>" . normalTime($XMLTEAM[$i]['raw_laps'][$n]['sessiontime'], true) .
        "</td>";
    if ($n > 0 && !$outlap) {
        if ((number_format($XMLTEAM[$i]['raw_laps'][$n]['laptime'] / $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap'] *
            100, 2)) > 107) {
            echo "<td class='pitin'>" . number_format($XMLTEAM[$i]['raw_laps'][$n]['laptime'] /
                $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap'] * 100,
                2) . "%</td>";
        } else {
            echo "<td>" . number_format($XMLTEAM[$i]['raw_laps'][$n]['laptime'] / $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap'] *
                100, 2) . "%</td>";
        }
    } else {
        echo "<td></td>";
    }
    echo "<td class='currentDriver'>";
    if ($n == 0 or ($XMLTEAM[$i]['raw_laps'][$n]['driverUserName'] !== $XMLTEAM[$i]['raw_laps'][$n -
        1]['driverUserName']) or ($XMLTEAM[$i]['race_data']['fastest_lap_on'] == $n + 2)) {
        for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++) {
            if ($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs'] == strtolower($XMLTEAM[$i]['raw_laps'][$j]['driverUserName']))
                echo "<img src='" . $trackerRoot . "flags/" . strtolower(str_replace(" ", "_", $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country'])) .
                    ".gif' width='18' height='12' alt='' title='" . ucwords($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country']) .
                    "'><span title='" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_full'] .
                    " / " . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs'] . "'>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_real'] .
                    "</span>";
        }
    }
    echo "</td>";
    echo "</tr>";
}
echo "</tbody>";
echo "</table>";
echo "</td>";
echo "</tr>";
echo "</table>";
//echo "<table id='teamstatscomparison'>";
//echo "<tr>";
//if (strtoupper($XMLRACE['session_status']) == "PRE-RACE") {
//    echo "<th>Grid</th>";
//} else {
//    echo "<th>Pos</th>";
//}
//echo "<th>Team Name</th>";
//echo "<th>Diff</th>";
//for ($j = 0; $j < min($XMLTEAM[$i]['race_data']['corrected_laps'], $teamstatsComparisonLaps);
//    $j++)
//    echo "<th>Lap " . ($XMLTEAM[$i]['race_data']['corrected_laps'] - $j) . "</th>";
//echo "<th>Total</th>";
//echo "</tr>";
//$teamstatsmaxlaps = min($XMLTEAM[$i]['race_data']['corrected_laps'], $teamstatsComparisonLaps);
//for ($m = (0 - $teamstatsComparisonNumber); $m < ($teamstatsComparisonNumber + 1);
//    $m++) {
//    if (isset($XMLTEAM[$i + $m])) {
//        $teamstatscomparisongain = 0;
//        $classrow = strtolower($XMLTEAM[$i + $m]['team_data']['class']);
//        echo "<tr id='r" . ($i + $m) . "' class='" . $classrow . "'>";
//        // GRID if pre-race
//        if (strtoupper($XMLRACE['session_status']) == "PRE-RACE") {
//            echo "<td class='pos'>" . $XMLTEAM[$i + $m]['team_data']['grid'] . "</td>";
//
//        } else {
//            if ($XMLRACE['numClasses'] !== 1) {
//                if ($XMLTEAM[$i + $m]['team_data']['class_position'] !== $XMLTEAM[$i + $m]['race_data']['position']) {
//                    echo "<th scope='row' class='pos'><abbr title='" . ordinalSuffix($XMLTEAM[$i + 1]['race_data']['position']) .
//                        " overall'>" . $XMLTEAM[$i + $m]['team_data']['class_position'] . "</abbr></th>";
//                } else {
//                    echo "<th scope='row' class='pos'>" . $XMLTEAM[$i + $m]['team_data']['class_position'] .
//                        "</th>";
//                }
//            } else {
//                echo "<th scope='row' class='pos'>" . $XMLTEAM[$i + $m]['race_data']['position'] .
//                    "</th>";
//            }
//        }
//
//        echo "<td class='teamName'><a href='team_" . intval($XMLTEAM[$i + $m]['team_data']['number']) .
//            ".html'>" . $XMLTEAM[$i + $m]['team_data']['name'] . "</a></td>";
//        echo "<td class='diff'>" . $XMLTEAM[$i + $m]['race_data']['dist_to_car_in_front'] .
//            "</a></td>";
//        if ($m == 0) {
//            for ($j = 0; $j < $teamstatsmaxlaps; $j++) {
//                echo "<td class='teamStat'><strong>";
//                // print_r($XMLTEAM[$i]['raw_laps'][(($XMLTEAM[$i]['race_data']['corrected_laps']) -
//                //                    ($j + 1))]);
//                // echo "-$i,$j,$m-";
//                /*if ($XMLTEAM[$i]['race_data']['penalty_laps'] > 0) {
//                $teamstatsmain = $XMLTEAM[$i]['raw_laps'][($XMLTEAM[$i]['race_data']['corrected_laps'] -
//                ($j + 1 + $XMLTEAM[$i]['race_data']['penalty_laps_teamstats']))]['laptime'];
//                //echo $teamstatsmain;
//                echo normalTime($teamstatsmain, true, false);
//                } else
//                if (isset($XMLTEAM[$i]['raw_laps'][(($XMLTEAM[$i]['race_data']['corrected_laps']) -
//                ($j + 1 + $XMLTEAM[$i]['race_data']['penalty_laps_teamstats']))]['laptime'])) {*/
//                $teamstatsmain = $XMLTEAM[$i]['raw_laps'][($XMLTEAM[$i]['race_data']['corrected_laps'] -
//                    ($j + 1 + $XMLTEAM[$i]['race_data']['penalty_laps_teamstats']))]['laptime'];
//                //echo $teamstatsmain;
//                echo normalTime($teamstatsmain, true, false);
//                // }
//                echo "</strong></td>";
//            }
//            echo "<td></td></tr>";
//        } else {
//            for ($j = 0; $j < $teamstatsmaxlaps; $j++) {
//                if (isset($XMLTEAM[$i + $m]['raw_laps'][($XMLTEAM[$i]['race_data']['corrected_laps'] -
//                    ($j + 1 + $XMLTEAM[$i]['race_data']['penalty_laps_teamstats']))])) {
//                    if ($XMLTEAM[$i + $m]['raw_laps'][($XMLTEAM[$i]['race_data']['corrected_laps'] -
//                        ($j + 1 + $XMLTEAM[$i]['race_data']['penalty_laps_teamstats']))]['laptime'] < $XMLTEAM[$i]['raw_laps'][($XMLTEAM[$i]['race_data']['corrected_laps'] -
//                        ($j + 1 + $XMLTEAM[$i]['race_data']['penalty_laps_teamstats']))]['laptime'])
//                        echo "<td class='rf'>";
//                    else
//                        echo "<td class='gf'>";
//                    $teamstatscomparisongap = ($XMLTEAM[$i]['raw_laps'][($XMLTEAM[$i]['race_data']['corrected_laps'] -
//                        ($j + 1 + $XMLTEAM[$i]['race_data']['penalty_laps_teamstats']))]['laptime'] - $XMLTEAM[$i +
//                        $m]['raw_laps'][($XMLTEAM[$i]['race_data']['corrected_laps'] - ($j + 1 + $XMLTEAM[$i]['race_data']['penalty_laps_teamstats']))]['laptime']);
//                    echo "<span title='" . normalTime($XMLTEAM[$i + $m]['raw_laps'][($XMLTEAM[$i]['race_data']['corrected_laps'] -
//                        ($j + 1 + $XMLTEAM[$i]['race_data']['penalty_laps_teamstats']))]['laptime'], true) .
//                        "'>" . normalTime($teamstatscomparisongap, true, true) . "</span>";
//                    $teamstatscomparisongain += $teamstatscomparisongap;
//                } else
//                    echo "<td>";
//                echo "</td>";
//            }
//            if ($teamstatscomparisongain == 0) {
//                echo "<td></td>";
//            } elseif ($teamstatscomparisongain > 0) {
//                echo "<td class='rf'>" . normalTime($teamstatscomparisongain, true, true) .
//                    "</td>";
//            } else
//                echo "<td class='gf'>" . normalTime($teamstatscomparisongain, true, true) .
//                    "</td>";
//            echo "</tr>";
//            $teamstatscomparisongain = 0;
//        }
//    }
//
//}
//echo "</table>";
if ($qualifyingFocus == "driver") {
    if ($XMLRACE['numClasses'] > 1) {
        echo "<h3>#" . $XMLTEAM[$i]['team_data']['number'] . " " . $XMLTEAM[$i]['team_data']['class'] .
            " &mdash; " . $XMLTEAM[$i]['team_data']['drivers'][0]['driver_full'];
        echo $XMLTEAM[$i]['team_data']['name'] ? " &mdash; " . $XMLTEAM[$i]['team_data']['name'] :
            "";
        echo "</h3>";
    } else
        echo "<h3>#" . $XMLTEAM[$i]['team_data']['number'] . " " . $XMLTEAM[$i]['team_data']['drivers'][0]['driver_full'];
    echo $XMLTEAM[$i]['team_data']['name'] ? " &mdash; " . $XMLTEAM[$i]['team_data']['name'] :
        "";
    echo "</h3>";
} else {
    if ($XMLRACE['numClasses'] > 1) {
        echo "<h3>#" . $XMLTEAM[$i]['team_data']['number'] . " " . $XMLTEAM[$i]['team_data']['class'] .
            " &mdash; " . $XMLTEAM[$i]['team_data']['name'] . "</h3>";
    } else
        echo "<h3>#" . $XMLTEAM[$i]['team_data']['number'] . " " . $XMLTEAM[$i]['team_data']['name'] .
            "</h3>";
}
echo "<div id='lapchart'>";
//echo("$i = " . $i);
$column = 0;
//echo(" -- $column = " . $column);
$stintLap = 1;
//echo(" -- $stintLap = " . $stintLap);
$newStint = false;
//echo(" -- $newStint = " . $newStint);
$swapDriver = true;
//echo(" -- $swapDriver = " . $swapDriver);

//echo_r($XMLTEAM[0]);
if ($raceClassCSS[$XMLTEAM[$i]['team_data']['class']]) {
    $classrow = $raceClassCSS[$XMLTEAM[$i]['team_data']['class']];
} else {
    $classrow = strtolower($XMLTEAM[$i]['team_data']['class']);
}
for ($j = 0; $j < $XMLTEAM[$i]['race_data']['laps']; $j++) {
    if ($swapDriver || $newStint) {
        if ($newStint) {
            //echo ("newstint: $j $pitInAtKey ");
            if (isset($XMLTEAM[$i]['race_data']['pitstops'][$pitInAtKey + 1])) {
                if ($XMLTEAM[$i]['race_data']['pitstops'][$pitInAtKey + 1]['type'] == 'PITOUT') {
                    echo "<td colspan=3><strong>Pitstop " . normalTime(($XMLTEAM[$i]['race_data']['pitstops'][$pitInAtKey +
                        1]['time'] - $XMLTEAM[$i]['race_data']['pitstops'][$pitInAtKey]['time']) * 1000, false) .
                        "</strong></td>";
                } else {
                    echo "<td colspan=3>No time recorded</td>";
                }
            } else {
                echo "<td colspan=3>Driver didn't leave pitlane yet.</td>";
            }
        }
        if ($column % 33 == 0 && $j == 0) {
            $column = 0;
            echo "<table class='" . $classrow . "'><tr><td colspan='3'>";
            foreach ($XMLTEAM[$i]['team_data']['drivers'] as $driver) {
                if (strtolower($driver['driver_lfs']) == strtolower($XMLTEAM[$i]['raw_laps'][$j]['driverUserName']))
                    echo "<img src='" . $trackerRoot . "flags/" . strtolower(str_replace(" ", "_", $driver['driver_country'])) .
                        ".gif'/><br>" . $driver['driver_real'] . "</td></tr>";
            }
        } else
            if ($column % 33 != 0 && $j != 0 && $j != ($XMLTEAM[$i]['race_data']['laps'])) {
                echo "<table class='" . $classrow . "'><tr><td colspan=3>";
                foreach ($XMLTEAM[$i]['team_data']['drivers'] as $driver) {
                    if (strtolower($driver['driver_lfs']) == strtolower($XMLTEAM[$i]['raw_laps'][$j]['driverUserName']))
                        echo "<img src='" . $trackerRoot . "flags/" . strtolower(str_replace(" ", "_", $driver['driver_country'])) .
                            ".gif'/><br/>" . $driver['driver_real'] . "</td></tr>";
                }
            } else
                if ($column % 7 == 0 && $j != 0 && $j != ($XMLTEAM[$i]['race_data']['laps'])) {
                    $column = 0;
                    echo "</table><table class='" . $classrow . "'><tr><td colspan=3>";
                    foreach ($XMLTEAM[$i]['team_data']['drivers'] as $driver) {
                        if (strtolower($driver['driver_lfs']) == strtolower($XMLTEAM[$i]['raw_laps'][$j]['driverUserName']))
                            echo "<img src='" . $trackerRoot . "flags/" . strtolower(str_replace(" ", "_", $driver['driver_country'])) .
                                ".gif'/><br/>" . $driver['driver_real'] . "</td></tr>";
                    }
                } else {
                    echo "</table></td></tr>";
                }
                $stintLap = 1;
        $column++;
    }
    echo "<tr>";


    if ($XMLTEAM[$i]['raw_laps'][$j]['laptime'] == 3600000 || ($XMLTEAM[$i]['raw_laps'][$j]['laptime'] >=
        3600000 && $XMLTEAM[$i]['raw_laps'][$j]['laptime'] == $XMLTEAM[$i]['raw_laps'][$j]['sessiontime'])) {
        $teamsstatslapconstruct = "<span class='pitin'>OUTLAP</span>";
    } elseif (($XMLTEAM[$i]['raw_laps'][$j]['laptime'] == $XMLRACE['fastest_lap'] or
    $XMLTEAM[$i]['raw_laps'][$j]['laptime'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap']) &&
        $XMLTEAM[$i]['race_data']['fastest_lap_on'] == $j + 2) {
        $teamsstatslapconstruct = "<strong class='classbestlap'>" . normalTime($XMLTEAM[$i]['race_data']['fastest_lap']) .
            "</strong>";
    } elseif (($XMLTEAM[$i]['raw_laps'][$j]['laptime'] == $XMLTEAM[$i]['race_data']['fastest_lap'] or
    $XMLTEAM[$i]['raw_laps'][$j]['laptime'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap']) &&
        $XMLTEAM[$i]['race_data']['fastest_lap_on'] == $j + 2) {
        $teamsstatslapconstruct = "<strong class='teambestlap'>" . normalTime($XMLTEAM[$i]['race_data']['fastest_lap']) .
            "</strong>";
    } elseif ($XMLTEAM[$i]['raw_laps'][$j]['laptime'] == $XMLTEAM[$i]['team_data']['drivers'][($XMLTEAM[$i]['race_data']['current_driver_num'])]['fastest_lap']) {
        $teamsstatslapconstruct = "<strong class='driverbestlap'>" . normalTime($XMLTEAM[$i]['raw_laps'][$j]['laptime']) .
            "</strong>";
    } else {
        $teamsstatslapconstruct = normalTime($XMLTEAM[$i]['raw_laps'][$j]['laptime']);
    }


    echo "<td>" . ($j + 1) . "</td><td>" . $stintLap . "</td><td>$teamsstatslapconstruct</td>";


    echo "</tr>";
    $stintLap++;
    $newStint = false;
    for ($k = 0; $k < count($XMLTEAM[$i]['race_data']['pitstops']); $k++) {
        if ($j - 1 > -1) {
            if (is_array($XMLTEAM[$i]['raw_laps'][$j - 1])) {
                if ($XMLTEAM[$i]['race_data']['pitstops'][$k]['mysqlid'] > $XMLTEAM[$i]['raw_laps'][$j -
                    1]['mysqlid'] && $XMLTEAM[$i]['race_data']['pitstops'][$k]['mysqlid'] < $XMLTEAM[$i]['raw_laps'][$j]['mysqlid'] &&
                    $XMLTEAM[$i]['race_data']['pitstops'][$k]['type'] == 'PITIN') {
                    $pitInAtKey = $k;
                    $newStint = true;
                    //    echo ("hi $k");
                    //   echo ($newStint);
                }
            }
        }
    }
    $swapDriver = false;
    if ($j - 1 > -1) {
        if (is_array($XMLTEAM[$i]['raw_laps'][$j - 1]) && $XMLTEAM[$i]['raw_laps'][$j -
            1]['driverUserName'] != $XMLTEAM[$i]['raw_laps'][$j]['driverUserName'])
            $swapDriver = true;
    }
}
echo "</table>";
echo "</div>";
include 'footer.php'; ?>