<?php
/**
 ********************************************
 * Masters of Endurance tracker / LFS-Tracker 
 ********************************************
 * 
 * Copyright © 2007 Wolfgang Tom (WolleT)
 * v1.0 originally written by Wolfgang Tom
 * 
 * Copyright © 2009-2011 Michael Booth (Boothy)
 * v2.0 tracker modified by Michael Booth
 * 
 * Thanks also to Casper Roescher (Kaspur).  
 * 
 * Latest tracker version available from the LFS forum thread - http://www.lfsforum.net/showthread.php?t=73414
 * Any code changes/improvements can be submitted for inclusion in the public tracker version. 
 * E-mail me at web@michaelbooth.me.uk or PM me via http://www.lfsforum.net/private.php?do=newpm&u=202039
 * 
 ********************************************
 * 
 * DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
 * Version 2, December 2004

 * Copyright © 2004 Sam Hocevar <sam@hocevar.net>

 * Everyone is permitted to copy and distribute verbatim or modified
 * copies of this license document, and changing it is allowed as long
 * as the name is changed.

 * DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
 * TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

 * 0. You just DO WHAT THE FUCK YOU WANT TO. 
 * 
 ******************************************** 
 * See http://sam.zoy.org/wtfpl/ for more information
 **/

$bodypage = "index";
unset($extendedColspan);
unset($colspanExtra);
include 'qheader.php';
$teamcol = false;
$pencolfull = false;
$pencollaps = false;
$pencoltime = false;
for ($i = 0; $i < $amountTeams; $i++) {
    if ($XMLTEAM[$i]['team_data']['name'])
        $teamcol = true;
    if ($XMLTEAM[$i]['race_data']['penalty_laps'])
        $pencollaps = true;
    if ($XMLTEAM[$i]['race_data']['penalty_time'])
        $pencoltime = true;
    if ($XMLTEAM[$i]['race_data']['penalty_laps'] && $XMLTEAM[$i]['race_data']['penalty_time'])
        $pencolfull = true;
}
echo "<table id='raceStandings'>";
echo "<thead>";
echo "<tr>";
echo "<th></th>";
echo "<th scope='col'>Pos</th>";
echo "<th scope='col'>Num</th>";
if ($qualifyingFocus == "driver") {
    echo "<th scope='col'>Driver</th>";
    if ($teamcol) {
        echo "<th scope='col'>Team</th>";
    }
} else {
    echo "<th scope='col'>Team Name</th>";
}
if ($showCars) {
    echo "<th scope='col'>Car</th>";
    $colspanExtra++;
}
if ($qualifyingFocus == "team" && $driverName == "fastest") {
    echo "<th scope='col'>Fastest Driver</th>";
} elseif ($qualifyingFocus == "team" && $driverName != "fastest") {
    echo "<th scope='col'>Current Driver</th>";
}
if ($showPrev) {
    echo "<th scope='col'>Prev</th>";
    $colspanExtra++;
}
echo "<th scope='col'>Best</th>";
echo "<th scope='col'>On</th>";
echo "<th scope='col'>Laps</th>";
echo "<th scope='col'>Gap</th>";
echo "<th scope='col'>Diff</th>";
echo "<th scope='col'>" . strtolower($distanceUnits) . "</th>";
if ($pencolfull) {
    $colspanExtra++;
    echo "<th scope='col' colspan='2'>Penalty</th>";
    $colspanExtra++;
} elseif ($pencollaps or $pencoltime) {
    echo "<th scope='col'>Pen</th>";
    $colspanExtra++;
}
echo "</tr>";
echo "</thead>";
echo "<tbody>";
for ($i = 0; $i < $amountTeams; $i++) {
    if ((strtoupper($XMLRACE['session_status']) == "PRE-RACE") or ($XMLTEAM[$i]['race_data']['laps'] >
        0) or $showUnqualified) {
        if ($XMLTEAM[$i]['race_data']['laps'])
            $teamlaps = $XMLTEAM[$i]['race_data']['laps'] - 1;
        if ($raceClassCSS[$XMLTEAM[$i]['team_data']['class']]) {
            $classrow = $raceClassCSS[$XMLTEAM[$i]['team_data']['class']];
        } else {
            $classrow = strtolower($XMLTEAM[$i]['team_data']['class']);
        }
        echo "<tr class='" . $classrow . "'>";
        echo "<td><a id='" . $i . "' class='collapsable'><img src='" . $trackerRoot .
            "images/expand.png' width='20' height='16' alt='&#8595;'></a></td>";
        // GRID/SERVER if pre-race
        if (strtoupper($XMLRACE['session_status']) == "PRE-RACE") {
            echo "<td class='pos'>" . $XMLTEAM[$i]['team_data']['grid'] . "</td>";
            // SERVER
            if ($showServer) {
                echo "<td class='pos'>" . $XMLTEAM[$i]['team_data']['server'] . "</td>";
            }
        } else {
            //CLASS POSITION
            if ($XMLRACE['numClasses'] > 1) {
                if ($XMLTEAM[$i]['team_data']['class'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['name']) {
                    if ($XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position'] !== $XMLTEAM[$i]['race_data']['position']) {
                        echo "<td class='pos'><abbr title='" . ordinalSuffix($XMLTEAM[$i]['race_data']['position']) .
                            " overall'>" . $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position'] .
                            "</abbr></td>";
                        $XMLTEAM[$i]['team_data']['class_position'] = $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position'];
                    } else {
                        echo "<td class='pos'>" . $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position'] .
                            "</td>";
                        $XMLTEAM[$i]['team_data']['class_position'] = $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position'];
                    }
                    $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position']++;
                }
            } else {
                echo "<td class='pos'>" . $XMLTEAM[$i]['race_data']['position'] . "</td>";
            }
        }
        // TEAM NUMBER
        echo "<td class='num'><a href='" . $trackerModeShort . "_" . $XMLTEAM[$i]['team_data']['number'] .
            ".html'><em>" . $XMLTEAM[$i]['team_data']['number'] . "</em></a></td>";


        // TEAM NAME
        if ($qualifyingFocus == "driver") {
            echo "<td class='teamName'>";
            $j = 0;
            echo "<img src='" . $trackerRoot . "flags/" . strtolower(str_replace(" ", "_", $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country'])) .
                ".gif' width='18' height='12' alt='' title='" . ucwords($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country']) .
                "'><span title='" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs'] .
                "'>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_full'] . "</span>";
            echo "</td>";
            echo "<td class='currentDriver'>" . $XMLTEAM[$i]['team_data']['name'] . "</td>";
        } else {
            echo "<td class='teamName'>" . $XMLTEAM[$i]['team_data']['name'] . "</td>";
        }

        if ($showCars) {
            // TEAM CAR - LMP, FZR, FZ2, FZ3
            if ($XMLTEAM[$i]['team_data']['class'] == "GT2" || $XMLTEAM[$i]['team_data']['class'] ==
                "GUE") {
                $XMLTEAM[$i]['team_data']['car'] = substr_replace($XMLTEAM[$i]['team_data']['car'],
                    "2", -1);
            } elseif ($XMLTEAM[$i]['team_data']['class'] == "GT3") {
                $XMLTEAM[$i]['team_data']['car'] = substr_replace($XMLTEAM[$i]['team_data']['car'],
                    "3", -1);
            } elseif ($raceClassName[1] !== "GT1" && $XMLTEAM[$i]['team_data']['class'] ==
            "GT1") {
                $XMLTEAM[$i]['team_data']['car'] = substr_replace($XMLTEAM[$i]['team_data']['car'],
                    "1", -1);
            }
            echo "<td>" . $XMLTEAM[$i]['team_data']['car'] . "</td>";
        }

        // OVERALL BEST, TEAM BEST, DRIVER BEST LAP
        if ($XMLTEAM[$i]['race_data']['laps']) {
            if ($XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime'] == $XMLRACE['fastest_lap'] or
                $XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap']) {
                $bestlapconstruct = "<strong class='classbestlap'>" . normalTime($XMLTEAM[$i]['race_data']['fastest_lap']) .
                    "</strong>";
                $prevlapconstruct = $bestlapconstruct;
            } elseif ($XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime'] == $XMLTEAM[$i]['race_data']['fastest_lap'] or
            $XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap']) {
                $bestlapconstruct = "<strong class='teambestlap'>" . normalTime($XMLTEAM[$i]['race_data']['fastest_lap']) .
                    "</strong>";
                $prevlapconstruct = $bestlapconstruct;
            } elseif ($XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime'] == $XMLTEAM[$i]['team_data']['drivers'][($XMLTEAM[$i]['race_data']['current_driver_num'])]['fastest_lap']) {
                $prevlapconstruct = "<strong class='driverbestlap'>" . normalTime($XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime']) .
                    "</strong>";
                $bestlapconstruct = normalTime($XMLTEAM[$i]['race_data']['fastest_lap']);
            } elseif ($XMLRACE['fastest_lap'] == $XMLTEAM[$i]['race_data']['fastest_lap'] or
            $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap'] == $XMLTEAM[$i]['race_data']['fastest_lap']) {
                $bestlapconstruct = "<strong>" . normalTime($XMLTEAM[$i]['race_data']['fastest_lap']) .
                    "</strong>";
                $prevlapconstruct = normalTime($XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime']);
            } else {
                $bestlapconstruct = normalTime($XMLTEAM[$i]['race_data']['fastest_lap']);
                $prevlapconstruct = normalTime($XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime']);
            }
        } else {
            $bestlapconstruct = "";
            $prevlapconstruct = "";
        }

        // CURRENT DRIVER
        if ($qualifyingFocus != "driver") {
            if ($driverName == "fastest") {
                $XMLTEAM[$i]['race_data']['current_driver'] = $XMLTEAM[$i]['race_data']['fastest_driver'];
                echo "<td class='currentDriver'>";
                for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++) {
                    if ($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs'] == $XMLTEAM[$i]['race_data']['current_driver'])
                        echo "<img src='" . $trackerRoot . "flags/" . strtolower(str_replace(" ", "_", $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country'])) .
                            ".gif' width='18' height='12' alt='' title='" . ucwords($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country']) .
                            "'><span title='" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_full'] .
                            " / " . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs'] . "'>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_real'] .
                            "</span>";
                }
            }
            echo "</td>";
        }
        // echo PREV LAP CONSTRUCTED
        if ($showPrev && ($XMLTEAM[$i]['race_data']['fastest_lap'] != 99999999999)) {
            if ($XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime'] == 3600000) {
                echo "<td class='pitin'><strong>OUTLAP</strong></td>";
            } else {
                echo "<td>$prevlapconstruct</td>";
            }
        } elseif ($showPrev) {
            echo "<td class='qualibest'></td>";
        }

        // echo BEST LAP CONSTRUCTED
        if ($XMLTEAM[$i]['race_data']['fastest_lap'] != 99999999999) {
            echo "<td class='qualibest'>$bestlapconstruct</td>";
        } else {
            echo "<td class='qualibest'></td>";
        }
        // ON LAP
        if ($XMLTEAM[$i]['race_data']['fastest_lap_on'] > 0)
            echo "<td>" . ($XMLTEAM[$i]['race_data']['fastest_lap_on'] - 1) . "</td>";
        else
            echo "<td>" . $XMLTEAM[$i]['race_data']['fastest_lap_on'] . "</td>";

        // LAPS
        echo "<td>" . $XMLTEAM[$i]['race_data']['laps'] . "</td>";

        // GAP
        if ($i == 0 || ($XMLTEAM[$i]['race_data']['fastest_lap_on'] == 0) || $XMLTEAM[$i]['team_data']['class_position'] ==
            1)
            echo "<td></td>";
        elseif (($XMLTEAM[$i]['race_data']['percent'] > $percentLimit) && $percentLimit >
            100)
            echo "<td class='pitin'><span title='" . number_format($XMLTEAM[$i]['race_data']['percent'],
                2) . "%'>" . normalTime($XMLTEAM[$i]['race_data']['dist_to_lead_car'], true, false, false, false, false) .
                "</span></td>";
        else
            echo "<td><span title='" . number_format($XMLTEAM[$i]['race_data']['percent'], 2) .
                "%'>" . normalTime($XMLTEAM[$i]['race_data']['dist_to_lead_car'], true, false, false, false, false) .
                "</span></td>";
        // DIFF
        if ($i == 0 || ($XMLTEAM[$i]['race_data']['fastest_lap_on'] == 0) || $XMLTEAM[$i]['team_data']['class_position'] ==
            1) {
            echo "<td></td>";
        } elseif ($XMLTEAM[$i]['race_data']['dist_to_car_in_front'] < 0) {
            echo "<td></td>";
        } else {
            echo "<td>" . normalTime($XMLTEAM[$i]['race_data']['dist_to_car_in_front'], true, false, false, false, false) .
                "</td>";
        }

        // SPEED
        if ($XMLTEAM[$i]['race_data']['fastest_lap'] != 99999999999) {
            if ($distanceUnits == "mph") {
                echo "<td><span title='" . number_format($XMLTEAM[$i]['race_data']['kph'], 2) .
                    " kph'>" . number_format($XMLTEAM[$i]['race_data']['mph'], 2) . "</span></td>";
            } else {
                echo "<td><span title='" . number_format($XMLTEAM[$i]['race_data']['mph'], 2) .
                    " mph'>" . number_format($XMLTEAM[$i]['race_data']['kph'], 2) . "</span></td>";
            }
        } else {
            echo "<td></td>";
        }

        // PENALTY LAPS & TIME
        if ($pencolfull) {
            if (!$XMLTEAM[$i]['race_data']['penalty_laps'])
                echo "<td></td>";
            if (!$XMLTEAM[$i]['race_data']['penalty_time'])
                echo "<td></td>";
        } elseif ($pencoltime or $pencollaps) {
            if (!$XMLTEAM[$i]['race_data']['penalty_laps'] && !$XMLTEAM[$i]['race_data']['penalty_time'])
                echo "<td></td>";
        }
        if ($XMLTEAM[$i]['race_data']['penalty_laps'] == 1)
            echo "<td class='penlapspos'>+" . $XMLTEAM[$i]['race_data']['penalty_laps'] .
                " lap</td>";
        if ($XMLTEAM[$i]['race_data']['penalty_laps'] > 1)
            echo "<td class='penlapspos'>+" . $XMLTEAM[$i]['race_data']['penalty_laps'] .
                " laps</td>";
        if ($XMLTEAM[$i]['race_data']['penalty_laps'] == -1)
            echo "<td class='penlaps'>" . $XMLTEAM[$i]['race_data']['penalty_laps'] .
                " lap</td>";
        if (($XMLTEAM[$i]['race_data']['penalty_laps'] < -1) && ($XMLTEAM[$i]['race_data']['penalty_laps']))
            echo "<td class='penlaps'>" . $XMLTEAM[$i]['race_data']['penalty_laps'] .
                " laps</td>";
        if ($XMLTEAM[$i]['race_data']['penalty_time'] < 0)
            echo "<td class='penlaps'>+" . substr($XMLTEAM[$i]['race_data']['penalty_time'],
                1) . "s</td>";
        if ($XMLTEAM[$i]['race_data']['penalty_time'] > 0)
            echo "<td class='penlapspos'>-" . $XMLTEAM[$i]['race_data']['penalty_time'] .
                "s</td>";


        echo "</tr>";
        echo "<tr id='" . $i . "-collapse' style=\"display:none;\" class='collapsed_stats " .
            $classrow . "'>";
        echo "<td colspan='" . (11 + $colspanExtra) . "'>";
        echo "<table>";
        echo "<tr>";
        echo "<th></th>";
        for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++)
            echo "<th><img src='" . $trackerRoot . "flags/" . strtolower(str_replace(" ",
                "_", $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country'])) .
                ".gif' width='18' height='12' alt='' title='" . ucwords($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country']) .
                "'><br><span title=\"" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_full'] .
                "\">" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_real'] . "</span></th>";
        echo "</tr>";
        echo "<tr>";
        echo "<th scope='row'>Username</th>";
        for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++)
            echo "<td><a href='http://spdoracing.com/eventdb/driver/" . urlencode($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs']) .
                "'>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs'] . "</a></td>";
        echo "</tr>";
        echo "<tr>";
        echo "<th scope='row'>Laps</th>";
        for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++)
            echo "<td>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['laps'] . "</td>";
        echo "</tr>";
        if ($XMLTEAM[$i]['team_data']['num_drivers'] > 1) {
            echo "<tr>";
            echo "<th scope='row'>Best lap</th>";
            for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++) {
                if ($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'] != 99999999999) {
                    if (normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'], true) ==
                        $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap']) {
                        echo "<td><strong class='classbestlap'>" . normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'], true) .
                            "</strong></td>";
                    } elseif ($XMLTEAM[$i]['race_data']['fastest_lap'] == normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'], true))
                        echo "<td><strong class='teambestlap'>" . normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'], true) .
                            "</strong></td>";
                    else
                        echo "<td>" . normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'], true) .
                            "</td>";
                } else
                    echo "<td></td>";
            }
            echo "</tr>";
        }
        echo "</table>";
        echo "<table style='width:99%'>";
        echo "<tr>";
        echo "<td colspan='" . ($XMLTEAM[$i]['team_data']['num_drivers'] + 1) .
            "' class='expandedbottom'>";
        // link to extended stats
        echo "<p><a href='qual_" . $XMLTEAM[$i]['team_data']['number'] .
            ".html'>Qualifying statistics</a>";
        if (file_exists('practice.html')) {
            echo " &mdash; <a href='qual_" . $XMLTEAM[$i]['team_data']['number'] .
                ".html'>Practice statistics</a>";
        }
        echo "</p>";
        if ($showServer) {
            echo "<p>Server: #" . $XMLTEAM[$i]['team_data']['server'];
            if (!$XMLTEAM[$i]['team_data']['grid'] > 0) {
                echo "</p>";
            }
        }
        echo "</td>";
        echo "</tr>";
        echo "</table>";
        if ($showCar) {
            $showcarimgsrc = $showCarBaseUrl . $XMLTEAM[$i]['team_data']['number'] .
                strtolower($XMLTEAM[$i]['team_data']['class']) . $thumbCar[removeszeros($XMLTEAM[$i]['team_data']['number'])] .
                ".png";
            list($width, $height, $type, $attr) = getimagesize($showcarimgsrc);
            if ($width) {
                echo "<img src='", $showcarimgsrc, "' ", $attr, " alt='' class='carimage'>";
            }
        }

        echo "</td>";
        echo "</tr>";
    }
}
echo "</tbody></table>";
echo "<div id='bottom_help'>";
echo "<p>Click the <img src='" . $trackerRoot .
    "images/expand.png' width='20' height='16' alt='&#8595;'> icon to get the full statistics.</p>";
if ($finalGrid or $championshipStandings)
    echo "<p>";
if ($championshipStandings)
    echo "<a href='$championshipStandings'>$eventFull - standings after round $championshipRound</a>";
if ($finalGrid and $championshipStandings)
    echo " &mdash; ";
if ($finalGrid)
    echo "<a href='$finalGrid'>$h2eventName - Final Grid</a>";
if ($finalGrid or $championshipStandings)
    echo "</p>";
echo "</div>";
include 'footer.php';
?>