<?php
/**
 ********************************************
 * Masters of Endurance tracker / LFS-Tracker 
 ********************************************
 * 
 * Copyright © 2007 Wolfgang Tom (WolleT)
 * v1.0 originally written by Wolfgang Tom
 * 
 * Copyright © 2009-2011 Michael Booth (Boothy)
 * v2.0 tracker modified by Michael Booth
 * 
 * Thanks also to Casper Roescher (Kaspur).  
 * 
 * Latest tracker version available from the LFS forum thread - http://www.lfsforum.net/showthread.php?t=73414
 * Any code changes/improvements can be submitted for inclusion in the public tracker version. 
 * E-mail me at web@michaelbooth.me.uk or PM me via http://www.lfsforum.net/private.php?do=newpm&u=202039
 * 
 ********************************************
 * 
 * DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
 * Version 2, December 2004

 * Copyright © 2004 Sam Hocevar <sam@hocevar.net>

 * Everyone is permitted to copy and distribute verbatim or modified
 * copies of this license document, and changing it is allowed as long
 * as the name is changed.

 * DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
 * TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

 * 0. You just DO WHAT THE FUCK YOU WANT TO. 
 * 
 ******************************************** 
 * See http://sam.zoy.org/wtfpl/ for more information
 **/

require 'config.php';
//main session status if statement
unset($d);
unset($h);
unset($m);
unset($s);
unset($s2);
if (strtoupper($XMLRACE['session_status']) == "PRE-RACE") {
    $sessionStatus = "<td>PRE-RACE</td>";
    $timeRemaining = "<td>" . $XMLRACE['timeMins'] . " mins</td>";

} elseif (strtoupper($XMLRACE['session_status']) == "GREEN FLAG" || strtoupper($XMLRACE['session_status']) ==
"SAFETY CAR DEPLOYED" || strtoupper($XMLRACE['session_status']) ==
    "SAFETY CAR IN THIS LAP" || strtoupper($XMLRACE['session_status']) == "RED FLAG") {
    if ($XMLRACE['timeMins'] == 0) {
        $lapsremaining = $XMLRACE['timeLaps'] - $XMLTEAM[0]['race_data']['corrected_laps'];
        $lapsremaining .= ($lapsremaining > 1) ? " laps" : " lap";
        if ($lapsremaining > 0) {
            if ($XMLRACE['raceTrackLengthKm']) {
                $lapsremaining .= " / " . $XMLRACE['raceTrackLengthKm'] * $lapsremaining . " km";
            }
            echo ("<dt>Laps remaining</dt><dd>" . $lapsremaining . "</dd>");
        } else {
            echo ("<dt>Laps remaining</dt><dd>Laps completed</dd>");
        }
    } else {
        //time remaining if diff <=0 then time elapsed
        $diff = ($XMLRACE['race_start'] + ($XMLRACE['timeMins'] * 60) + ($raceFinishOffset *
            60)) - time();
        $current_hour = floor($diff / (60 * 60));
        if ($diff > 0 && (time() - $XMLRACE['race_start']) < ($XMLRACE['timeMins'] * 60 *
            60) + ($raceFinishOffset * 60)) {
            $h = floor($diff / (60 * 60));
            $diff -= $h * 60 * 60;
            $m = floor($diff / 60);
            $diff -= $m * 60;
            $s = $diff;
            if ($h < 10) {
                $h = "0" . $h;
            }
            if ($m < 10) {
                $m = "0" . $m;
            }
            if ($s < 10) {
                $s = "0" . $s;
            }
            $timeRemaining = "<td>$h:$m:$s</td>";
        } else {
            $timeRemaining = "<td>00:00:00</td>";
        }
    }
    switch (strtoupper($XMLRACE['session_status'])) {
        case "GREEN FLAG":
            $lapsremaining = $XMLRACE['timeLaps'] - $XMLTEAM[0]['race_data']['corrected_laps'];
            if ($lapsremaining == 1) {
                echo ("<dt>Race status</dt><dd><strong>FINAL LAP</strong></dd>");
            } else {
                $sessionStatus = "<td class='gf'><strong>" . strtoupper($XMLRACE['session_status']) .
                    "</strong></td>";
            }
            break;
        case "RED FLAG":
            $sessionStatus = "<td class='rf'><strong>" . strtoupper($XMLRACE['session_status']) .
                "</strong></td>";
            break;
    }

} else {
    if ($XMLRACE['timeMins'] == 0) {
        $sessionStatus = "<td colspan='2'><strong>CHEQUERED FLAG</strong></td><td></td>";
    } else {
        $sessionStatus = "<td><strong>CHEQUERED FLAG</strong></td><td></td>";
    }
}

echo "<!doctype html>
<html dir='ltr' lang='en'><head><meta charset='utf-8'><title>tracker - mobile version</title><meta http-equiv='refresh' content='30'><link rel='stylesheet' href='/css/mobile.css'></head><body><div id='full30'>";
echo "<table class='raceStandings'>";
echo "<thead><tr class='raceData'><td colspan='2'>" . date("H:i T") . "</td>" .
    $sessionStatus . "" . $timeRemaining .
    "</tr><tr><th scope='col'>Pos</th><th scope='col'>Num</th><th scope='col'>Team Name</th><th scope='col'>Time</th></tr></thead><tbody>";
//  for each team echo row

for ($i = 0; $i < $amountTeams; $i++) {

    if ($raceClassCSS[$XMLTEAM[$i]['team_data']['class']]) {
        $classrow = $raceClassCSS[$XMLTEAM[$i]['team_data']['class']];
    } else {
        $classrow = strtolower($XMLTEAM[$i]['team_data']['class']);
    }
    echo "<tr class='" . $classrow . "'>\n";
    // GRID/SERVER if pre-race
    if (strtoupper($XMLRACE['session_status']) == "PRE-RACE") {
        echo "<td class='pos'>" . $XMLTEAM[$i]['team_data']['grid'] . "</td>\n";
        // SERVER
        if ($showServer) {
            echo "<td class='pos'>" . $XMLTEAM[$i]['team_data']['server'] . "</td>\n";
        }
    } else {
        //CLASS POSITION
        if ($XMLRACE['numClasses'] > 1) {
            if ($XMLTEAM[$i]['team_data']['class'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['name']) {
                if ($XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position'] !== $XMLTEAM[$i]['race_data']['position']) {
                    echo "<td class='pos'><abbr title='" . ordinalSuffix($XMLTEAM[$i]['race_data']['position']) .
                        " overall'>" . $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position'] .
                        "</abbr></td>\n";
                    $XMLTEAM[$i]['team_data']['class_position'] = $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position'];
                } else {
                    echo "<td class='pos'>" . $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position'] .
                        "</td>\n";
                    $XMLTEAM[$i]['team_data']['class_position'] = $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position'];
                }
                $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position']++;
            }
        } else {
            echo "<td class='pos'>" . $XMLTEAM[$i]['race_data']['position'] . "</td>\n";
        }
    }
    if ($XMLTEAM[$i]['team_data']['class_position'] == 1) {
        $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['leaderslaps'] = $XMLTEAM[$i]['race_data']['corrected_laps'];
        $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['leaderstime'] = $XMLTEAM[$i]['race_data']['total_sessiontime'];
        $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['i'] = $i;
    }
    // TEAM NUMBER
    echo "<td class='num'><em>" . $XMLTEAM[$i]['team_data']['number'] . "</em></td>\n";

    // TEAM NAME
    if ($raceFocus == "driver") {
        echo "<td class='teamName'>";
        $j = 0;
        // for ($j = 0; $j < count($XMLTEAM[$i]['team_data']['drivers']); $j++) {
        //if ($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs'] == $XMLTEAM[$i]['race_data']['current_driver'])
        echo "<img src='" . $trackerRoot . "flags/" . strtolower(str_replace(" ", "_", $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country'])) .
            ".gif' width='18' height='12' alt='' title='" . ucwords($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country']) .
            "'><span title='" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs'] .
            "'>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_full'] . "</span>";
        //}
        echo "</td>\n";
    } else {
        echo "<td class='teamName'>" . $XMLTEAM[$i]['team_data']['name'] . "</td>\n";
    }


    /* elseif ($XMLTEAM[$i]['race_data']['num_pits'] and $XMLTEAM[$i]['race_data']['pitstops'][count
    ($XMLTEAM[$i]['race_data']['pitstops']) - 1]['type'] == "PITIN") {
    echo "<td class='teamStatus'><abbr title='In the Pit Lane'>PIT</abbr></td>";
    }*/

    // DISPLAY FASTEST TEAM LAP, BOLD IF BEST OVERALL, PURPLE IF LAST LAP WAS BEST OVERALL, GREEN IF LAST LAP WAS TEAM BEST
    if (!$XMLTEAM[$i]['race_data']['laps']) {
        $bestlapconstruct = "";
    } else {
        $bestlapconstruct = normalTime($XMLTEAM[$i]['race_data']['fastest_lap'], true, false, true, true, false);
    }
    if ($XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime'] == $XMLTEAM[$i]['race_data']['fastest_lap'] or
        $XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap']) {
        $bestlapconstruct = "<em class='teambestlap'>" . normalTime($XMLTEAM[$i]['race_data']['fastest_lap'], true, false, true, true, false) .
            "</em>";
    }
    if ($XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime'] == $XMLRACE['fastest_lap'] or
        $XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap']) {
        $bestlapconstruct = "<em class='classbestlap'>" . normalTime($XMLTEAM[$i]['race_data']['fastest_lap'], true, false, true, true, false) .
            "</em>";
    }
    if ($XMLRACE['fastest_lap'] == $XMLTEAM[$i]['race_data']['fastest_lap'] or $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap'] ==
        $XMLTEAM[$i]['race_data']['fastest_lap']) {
        $bestlapconstruct = "$bestlapconstruct";
    }

    /*// PRINT BEST LAP CONSTRUCTED
    if ($XMLTEAM[$i]['race_data']['fastest_lap'] != 99999999999) {
    echo "<td class='gap'><strong>$bestlapconstruct</strong></td>";
    } else {
    echo "<td class='gap'></td>";
    }*/
    // PRINT BEST LAP CONSTRUCTED
    if ($XMLTEAM[$i]['race_data']['fastest_lap'] != 99999999999 && $i == 0) {
        echo "<td class='gap'><strong>$bestlapconstruct</strong></td>";
    } elseif ($XMLTEAM[$i]['race_data']['fastest_lap'] != 99999999999 && $i != 0 && $i <
    10) {
        echo "<td class='gap'><strong>+" . normalTime($XMLTEAM[$i]['race_data']['dist_to_lead_car'], true, false, false, false, false) .
            "</strong></td>";
    } elseif ($XMLTEAM[$i]['race_data']['fastest_lap'] != 99999999999 && $i == 10) {
        echo "<td class='gap'><strong>$bestlapconstruct</strong></td>";
    } elseif ($XMLTEAM[$i]['race_data']['fastest_lap'] != 99999999999 && $i > 10 && $i <
    20) {
        echo "<td class='gap'><strong>+" . normalTime($XMLTEAM[$i]['race_data']['fastest_lap'] -
            $XMLTEAM[10]['race_data']['fastest_lap'], true, false, false, false, false) .
            "</strong></td>";
    } elseif ($XMLTEAM[$i]['race_data']['fastest_lap'] != 99999999999 && $i == 20) {
        echo "<td class='gap'><strong>$bestlapconstruct</strong></td>";
    } elseif ($XMLTEAM[$i]['race_data']['fastest_lap'] != 99999999999 && $i > 20 && $XMLTEAM[$i]['race_data']['fastest_lap_on'] >
    0) {
        echo "<td class='gap'><strong>+" . normalTime($XMLTEAM[$i]['race_data']['fastest_lap'] -
            $XMLTEAM[20]['race_data']['fastest_lap'], true, false, false, false, false) .
            "</strong></td>";
    } else {
        echo "<td class='gap'></td>";
    }
    /*
    // GAP
    if (strtoupper($XMLRACE['session_status']) == "PRE-RACE") {
    echo "<td class='gap'><strong>GRID</strong></td>\n";
    } else {
    if ($XMLTEAM[$i]['team_data']['team_status']) {
    if (strtoupper($XMLTEAM[$i]['team_data']['team_status']) == 'RET') {
    $team_status_long = 'Retired';
    } elseif (strtoupper($XMLTEAM[$i]['team_data']['team_status']) == "DNS") {
    $team_status_long = 'DNS';
    } elseif (strtoupper($XMLTEAM[$i]['team_data']['team_status']) == "DQ") {
    $team_status_long = 'DQ';
    } elseif (strtoupper($XMLTEAM[$i]['team_data']['team_status']) == "NC") {
    $team_status_long = 'NC';
    }
    echo "<td class='gap'><strong>" . strtoupper($XMLTEAM[$i]['team_data']['team_status']) .
    "</strong></td>\n";
    } else {
    if ($i == 0) {
    echo "<td class='gap'><strong><span title='" . normalTime($XMLTEAM[$i]['raw_laps'][($XMLTEAM[$i]['race_data']['laps'] -
    1)]['sessiontime'], true, false, false, true, false, true, true) . "'>" . $XMLTEAM[$i]['race_data']['dist_to_lead_car'] .
    "</span></strong></td>\n";
    } elseif (isset($XMLTEAM[$i]['race_data']['indexgap'])) {
    echo "<td class='gap'><span title='" . normalTime($XMLTEAM[$i]['raw_laps'][($XMLTEAM[$i]['race_data']['laps'] -
    1)]['sessiontime'], true, false, false, true, false, true, true) . "'>" . $XMLTEAM[$i]['race_data']['indexgap'] .
    "</span></td>\n";
    } else {
    echo "<td class='gap'><strong><span title='" . normalTime($XMLTEAM[$i]['raw_laps'][($XMLTEAM[$i]['race_data']['laps'] -
    1)]['sessiontime'], true, false, false, true, false, true, true) . "'>" . $XMLTEAM[$i]['race_data']['dist_to_lead_car'] .
    "</span></strong></td>\n";
    
    }
    }
    }*/
    echo "</tr>\n";
}
echo "</tbody></table></div>";

echo "<table class='raceStandings' id='top10'>";
echo "<thead><tr class='raceData'><td colspan='2'>" . date("H:i T") . "</td>" .
    $sessionStatus . "" . $timeRemaining .
    "</tr><tr class='jabba'><th scope='col'>Pos</th><th scope='col'>Num</th><th scope='col'>Team Name</th><th scope='col'>Gap</th></tr></thead><tbody>";
//  for each team echo row

for ($i = 0; $i < 10; $i++) {

    if ($raceClassCSS[$XMLTEAM[$i]['team_data']['class']]) {
        $classrow = $raceClassCSS[$XMLTEAM[$i]['team_data']['class']];
    } else {
        $classrow = strtolower($XMLTEAM[$i]['team_data']['class']);
    }
    echo "<tr class='" . $classrow . "'>\n";
    // GRID/SERVER if pre-race
    if (strtoupper($XMLRACE['session_status']) == "PRE-RACE") {
        echo "<td class='pos'>" . $XMLTEAM[$i]['team_data']['grid'] . "</td>\n";
        // SERVER
        if ($showServer) {
            echo "<td class='pos'>" . $XMLTEAM[$i]['team_data']['server'] . "</td>\n";
        }
    } else {
        //CLASS POSITION
        if ($XMLRACE['numClasses'] > 1) {
            if ($XMLTEAM[$i]['team_data']['class'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['name']) {
                if ($XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position'] !== $XMLTEAM[$i]['race_data']['position']) {
                    echo "<td class='pos'><abbr title='" . ordinalSuffix($XMLTEAM[$i]['race_data']['position']) .
                        " overall'>" . $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position'] .
                        "</abbr></td>\n";
                    $XMLTEAM[$i]['team_data']['class_position'] = $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position'];
                } else {
                    echo "<td class='pos'>" . $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position'] .
                        "</td>\n";
                    $XMLTEAM[$i]['team_data']['class_position'] = $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position'];
                }
                $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position']++;
            }
        } else {
            echo "<td class='pos'>" . $XMLTEAM[$i]['race_data']['position'] . "</td>\n";
        }
    }
    if ($XMLTEAM[$i]['team_data']['class_position'] == 1) {
        $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['leaderslaps'] = $XMLTEAM[$i]['race_data']['corrected_laps'];
        $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['leaderstime'] = $XMLTEAM[$i]['race_data']['total_sessiontime'];
        $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['i'] = $i;
    }
    // TEAM NUMBER
    echo "<td class='num'><em>" . $XMLTEAM[$i]['team_data']['number'] . "</em></td>\n";

    // TEAM NAME
    echo "<td class='teamName'>" . $XMLTEAM[$i]['team_data']['name'] . "</td>\n";

    /* elseif ($XMLTEAM[$i]['race_data']['num_pits'] and $XMLTEAM[$i]['race_data']['pitstops'][count
    ($XMLTEAM[$i]['race_data']['pitstops']) - 1]['type'] == "PITIN") {
    echo "<td class='teamStatus'><abbr title='In the Pit Lane'>PIT</abbr></td>";
    }*/
    // DISPLAY FASTEST TEAM LAP, BOLD IF BEST OVERALL, PURPLE IF LAST LAP WAS BEST OVERALL, GREEN IF LAST LAP WAS TEAM BEST
    if (!$XMLTEAM[$i]['race_data']['laps']) {
        $bestlapconstruct = "";
    } else {
        $bestlapconstruct = normalTime($XMLTEAM[$i]['race_data']['fastest_lap'], true, false, true, true, false);
    }
    if ($XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime'] == $XMLTEAM[$i]['race_data']['fastest_lap'] or
        $XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap']) {
        $bestlapconstruct = "<em class='teambestlap'>" . normalTime($XMLTEAM[$i]['race_data']['fastest_lap'], true, false, true, true, false) .
            "</em>";
    }
    if ($XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime'] == $XMLRACE['fastest_lap'] or
        $XMLTEAM[$i]['raw_laps'][$teamlaps]['laptime'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap']) {
        $bestlapconstruct = "<em class='classbestlap'>" . normalTime($XMLTEAM[$i]['race_data']['fastest_lap'], true, false, true, true, false) .
            "</em>";
    }
    if ($XMLRACE['fastest_lap'] == $XMLTEAM[$i]['race_data']['fastest_lap'] or $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap'] ==
        $XMLTEAM[$i]['race_data']['fastest_lap']) {
        $bestlapconstruct = "$bestlapconstruct";
    }

    // PRINT BEST LAP CONSTRUCTED
    if ($XMLTEAM[$i]['race_data']['fastest_lap'] != 99999999999 && $i == 0) {
        echo "<td class='gap'><strong>$bestlapconstruct</strong></td>";
    } elseif ($XMLTEAM[$i]['race_data']['fastest_lap'] != 99999999999) {
        echo "<td class='gap'><strong>+" . normalTime($XMLTEAM[$i]['race_data']['dist_to_lead_car'], true, false, false, false, false) .
            "</strong></td>";

    } else {
        echo "<td class='gap'></td>";
    }

    /*
    // GAP
    if (strtoupper($XMLRACE['session_status']) == "PRE-RACE") {
    echo "<td class='gap'><strong>GRID</strong></td>\n";
    } else {
    if ($XMLTEAM[$i]['team_data']['team_status']) {
    if (strtoupper($XMLTEAM[$i]['team_data']['team_status']) == 'RET') {
    $team_status_long = 'Retired';
    } elseif (strtoupper($XMLTEAM[$i]['team_data']['team_status']) == "DNS") {
    $team_status_long = 'DNS';
    } elseif (strtoupper($XMLTEAM[$i]['team_data']['team_status']) == "DQ") {
    $team_status_long = 'DQ';
    } elseif (strtoupper($XMLTEAM[$i]['team_data']['team_status']) == "NC") {
    $team_status_long = 'NC';
    }
    echo "<td class='gap'><strong>" . strtoupper($XMLTEAM[$i]['team_data']['team_status']) .
    "</strong></td>\n";
    } else {
    if ($i == 0) {
    echo "<td class='gap'><strong><span title='" . normalTime($XMLTEAM[$i]['raw_laps'][($XMLTEAM[$i]['race_data']['laps'] -
    1)]['sessiontime'], true, false, false, true, false, true, true) . "'>" . $XMLTEAM[$i]['race_data']['dist_to_lead_car'] .
    "</span></strong></td>\n";
    } elseif (isset($XMLTEAM[$i]['race_data']['indexgap'])) {
    echo "<td class='gap'><span title='" . normalTime($XMLTEAM[$i]['raw_laps'][($XMLTEAM[$i]['race_data']['laps'] -
    1)]['sessiontime'], true, false, false, true, false, true, true) . "'>" . $XMLTEAM[$i]['race_data']['indexgap'] .
    "</span></td>\n";
    } else {
    echo "<td class='gap'><strong><span title='" . normalTime($XMLTEAM[$i]['raw_laps'][($XMLTEAM[$i]['race_data']['laps'] -
    1)]['sessiontime'], true, false, false, true, false, true, true) . "'>" . $XMLTEAM[$i]['race_data']['dist_to_lead_car'] .
    "</span></strong></td>\n";

    }
    }
    }*/
    echo "</tr>\n";
}
echo "</tbody></table>";
?>