<?php
/**
 ********************************************
 * Masters of Endurance tracker / LFS-Tracker 
 ********************************************
 * 
 * Copyright © 2007 Wolfgang Tom (WolleT)
 * v1.0 originally written by Wolfgang Tom
 * 
 * Copyright © 2009-2011 Michael Booth (Boothy)
 * v2.0 tracker modified by Michael Booth
 * 
 * Thanks also to Casper Roescher (Kaspur).  
 * 
 * Latest tracker version available from the LFS forum thread - http://www.lfsforum.net/showthread.php?t=73414
 * Any code changes/improvements can be submitted for inclusion in the public tracker version. 
 * E-mail me at web@michaelbooth.me.uk or PM me via http://www.lfsforum.net/private.php?do=newpm&u=202039
 * 
 ********************************************
 * 
 * DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
 * Version 2, December 2004

 * Copyright © 2004 Sam Hocevar <sam@hocevar.net>

 * Everyone is permitted to copy and distribute verbatim or modified
 * copies of this license document, and changing it is allowed as long
 * as the name is changed.

 * DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
 * TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

 * 0. You just DO WHAT THE FUCK YOU WANT TO. 
 * 
 ******************************************** 
 * See http://sam.zoy.org/wtfpl/ for more information
 **/

$bodypage = "index";
unset($extendedColspan);
unset($colspanExtra);
include 'header.php';
$teamcol = false;
$swapcol = false;
$pitcol = false;
$dtcol = false;
$sgcol = false;
$pencolfull = false;
$pencollaps = false;
$pencoltime = false;
for ($i = 0; $i < $amountTeams; $i++) {
    if ($XMLTEAM[$i]['team_data']['name'])
        $teamcol = true;
    if ($XMLTEAM[$i]['race_data']['num_swap'])
        $swapcol = true;
    if ($XMLTEAM[$i]['race_data']['num_pits'])
        $pitcol = true;
    if ($XMLTEAM[$i]['race_data']['num_dt'])
        $dtcol = true;
    if ($XMLTEAM[$i]['race_data']['num_sg'])
        $sgcol = true;
    if ($XMLTEAM[$i]['race_data']['penalty_laps'])
        $pencollaps = true;
    if ($XMLTEAM[$i]['race_data']['penalty_time'])
        $pencoltime = true;
    if ($XMLTEAM[$i]['race_data']['penalty_laps'] && $XMLTEAM[$i]['race_data']['penalty_time'])
        $pencolfull = true;
}
echo "<table id='raceStandings'>";
echo "<thead>";
echo "<tr>";
echo "<th></th>";
if (strtoupper($XMLRACE['session_status']) == "PRE-RACE") {
    echo "<th scope='col'>Grid</th>";
    if ($showServer) {
        echo "<th scope='col'>Server</th>";
        $colspanExtra++;
    }
} else {
    echo "<th scope='col'>Pos</th>";
}
echo "<th scope='col'>Num</th>";
if ($raceFocus == "driver") {
    echo "<th scope='col'>Driver</th>";
    if ($teamcol) {
        echo "<th scope='col'>Team</th>";
    }
} else {
    echo "<th scope='col'>Team Name</th>";
}
if ($showCars) {
    echo "<th scope='col'>Car</th>";
    $colspanExtra++;
}
if ($swapcol) {
    echo "<th scope='col'>Swap</th>";
    $colspanExtra++;
}
if ($pitcol) {
    echo "<th scope='col'>Pit</th>";
    $colspanExtra++;
    echo "<th scope='col'>Last &dagger;</th>";
    $colspanExtra++;
}
if ($dtcol or $sgcol)
    $colspanExtra++;
if ($dtcol and $sgcol)
    echo "<th scope='col'>DT / SG</th>";
elseif ($dtcol)
    echo "<th scope='col'>DT</th>";
elseif ($sgcol)
    echo "<th scope='col'>SG</th>";
echo "<th scope='col'>Best</th>";
if ($showStatus) {
    echo "<th scope='col'>Status</th>";
    $colspanExtra++;
}
if ($raceFocus != "driver") {
    echo "<th scope='col'>Current Driver</th>";
}
if ($showPrev) {
    echo "<th scope='col'>Prev</th>";
    $colspanExtra++;
}
if ($showSector) {
    echo "<th scope='col'>Sector</th>";
    $colspanExtra++;
}
echo "<th scope='col'>Gap</th>";
echo "<th scope='col'>Diff</th>";

if ($pencolfull) {
    $colspanExtra++;
    echo "<th scope='col' colspan='2'>Penalty</th>";
    $colspanExtra++;
} elseif ($pencollaps or $pencoltime) {
    echo "<th scope='col'>Pen</th>";
    $colspanExtra++;
}
echo "</tr>";
echo "</thead>";
echo "<tbody>";
for ($i = 0; $i < $amountTeams; $i++) {
    if ($XMLTEAM[$i]['race_data']['laps'])
        $teamlaps = $XMLTEAM[$i]['race_data']['laps'] - 1;
    if ($raceClassCSS[$XMLTEAM[$i]['team_data']['class']]) {
        $classrow = $raceClassCSS[$XMLTEAM[$i]['team_data']['class']];
    } else {
        $classrow = strtolower($XMLTEAM[$i]['team_data']['class']);
    }
    echo "<tr class='" . $classrow . "'>";
    echo "<td><a id='" . $i . "' class='collapsable'><img src='" . $trackerRoot .
        "images/expand.png' width='20' height='16' alt='&#8595;'></a></td>";
    // GRID/SERVER if pre-race
    if (strtoupper($XMLRACE['session_status']) == "PRE-RACE") {
        echo "<td class='pos'>" . $XMLTEAM[$i]['team_data']['grid'] . "</td>";
        // SERVER
        if ($showServer) {
            echo "<td class='pos'>" . $XMLTEAM[$i]['team_data']['server'] . "</td>";
        }
    } else {
        //CLASS POSITION
        if ($XMLRACE['numClasses'] > 1) {
            if ($XMLTEAM[$i]['team_data']['class'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['name']) {
                if ($XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position'] !== $XMLTEAM[$i]['race_data']['position']) {
                    echo "<td class='pos'><abbr title='" . ordinalSuffix($XMLTEAM[$i]['race_data']['position']) .
                        " overall'>" . $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position'] .
                        "</abbr></td>";
                    $XMLTEAM[$i]['team_data']['class_position'] = $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position'];
                } else {
                    echo "<td class='pos'>" . $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position'] .
                        "</td>";
                    $XMLTEAM[$i]['team_data']['class_position'] = $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position'];
                }
                $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['position']++;
            }
        } else {
            echo "<td class='pos'>" . $XMLTEAM[$i]['race_data']['position'] . "</td>";
        }
    }
    if ($XMLTEAM[$i]['team_data']['class_position'] == 1) {
        $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['leaderslaps'] = $XMLTEAM[$i]['race_data']['corrected_laps'];
        $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['leaderstime'] = $XMLTEAM[$i]['race_data']['total_sessiontime'];
        $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['i'] = $i;
    }
    // TEAM NUMBER
    echo "<td class='num'><a href='team_" . $XMLTEAM[$i]['team_data']['number'] .
        ".html'><em>" . $XMLTEAM[$i]['team_data']['number'] . "</em></a></td>";

    // TEAM NAME
    if ($raceFocus == "driver") {
        echo "<td class='teamName'>";
        $j = 0;
        echo "<img src='" . $trackerRoot . "flags/" . strtolower(str_replace(" ", "_", $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country'])) .
            ".gif' width='18' height='12' alt='' title='" . ucwords($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country']) .
            "'><span title='" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs'] .
            "'>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_full'] . "</span>";
        echo "</td>";
        if ($teamcol) {
            echo "<td class='currentDriver'>" . $XMLTEAM[$i]['team_data']['name'] . "</td>";
        }
    } else {
        echo "<td class='teamName'>" . $XMLTEAM[$i]['team_data']['name'] . "</td>";
    }

    if ($showCars) {
        // TEAM CAR - LMP, FZR, FZ2, FZ3
        if ($XMLTEAM[$i]['team_data']['class'] == "GT2" || $XMLTEAM[$i]['team_data']['class'] ==
            "GUE") {
            $XMLTEAM[$i]['team_data']['car'] = substr_replace($XMLTEAM[$i]['team_data']['car'],
                "2", -1);
        } elseif ($XMLTEAM[$i]['team_data']['class'] == "GT3") {
            $XMLTEAM[$i]['team_data']['car'] = substr_replace($XMLTEAM[$i]['team_data']['car'],
                "3", -1);
        } elseif ($raceClassName[1] !== "GT1" && $XMLTEAM[$i]['team_data']['class'] ==
        "GT1") {
            $XMLTEAM[$i]['team_data']['car'] = substr_replace($XMLTEAM[$i]['team_data']['car'],
                "1", -1);
        }
        echo "<td>" . $XMLTEAM[$i]['team_data']['car'] . "</td>";
    }

    // NUMBER OF DRIVER SWAPS
    if ($swapcol and $XMLTEAM[$i]['race_data']['num_swap']) {
        echo "<td>" . $XMLTEAM[$i]['race_data']['num_swap'] . "</td>";
    } elseif ($swapcol) {
        echo "<td></td>";
    }

    //PIT STOPS AND LAST PIT
    if ($pitcol) {
        if ($XMLTEAM[$i]['race_data']['num_pits'] == 0) {
            echo "<td></td>";
        } elseif ($XMLTEAM[$i]['race_data']['pitstops'][($XMLTEAM[$i]['race_data']['last_pit_index'] -
        1)]['type'] == "PITIN")
            echo "<td class='pitin'><strong>" . $XMLTEAM[$i]['race_data']['num_pits'] .
                "</strong></td>";
        else
            echo "<td>" . $XMLTEAM[$i]['race_data']['num_pits'] . "</td>";


        if ($XMLTEAM[$i]['race_data']['num_pits'] == 0) {
            echo "<td></td>";
        } elseif ($XMLTEAM[$i]['race_data']['num_pits'] and $XMLTEAM[$i]['race_data']['pitstops'][($XMLTEAM[$i]['race_data']['last_pit_index'] -
        1)]['type'] == "PITIN") {
            echo "<td class='teamStatus'><abbr title='In the Pit Lane'>PIT</abbr></td>";
        } elseif (($XMLTEAM[$i]['filter_laps'][$teamlaps]['logged'] - ($XMLTEAM[$i]['race_data']['pitstops'][($XMLTEAM[$i]['race_data']['last_pit_index'] -
        1)]['time'] + ($timeOffset * 60 * 60))) < 0) {
            echo "<td class='teamStatus'><abbr title='Exited the Pit Lane'>OUT</abbr></td>";
        } else {
            echo "<td><span title='" . date("H:i:s O", $XMLTEAM[$i]['race_data']['pitstops'][($XMLTEAM[$i]['race_data']['last_pit_index'] -
                1)]['time']) . "'>" . date("G:i", $XMLTEAM[$i]['filter_laps'][$teamlaps]['logged'] -
                ($XMLTEAM[$i]['race_data']['pitstops'][($XMLTEAM[$i]['race_data']['last_pit_index'] -
                1)]['time'] + ($timeOffset * 60 * 60))) . "</span></td>";
        }
    }

    // DT AND SG COLUMN - SHOULD COLLAPSE IF NO DT/SG FOR ANY TEAM
    if (($dtcol and $sgcol) and ($XMLTEAM[$i]['race_data']['num_dt'] or $XMLTEAM[$i]['race_data']['num_sg'])) {
        echo "<td>" . $XMLTEAM[$i]['race_data']['num_dt'] . " / " . $XMLTEAM[$i]['race_data']['num_sg'] .
            "</td>";
    } elseif ($dtcol and $XMLTEAM[$i]['race_data']['num_dt']) {
        echo "<td>" . $XMLTEAM[$i]['race_data']['num_dt'] . "</td>";
    } elseif ($sgcol and $XMLTEAM[$i]['race_data']['num_sg']) {
        echo "<td>" . $XMLTEAM[$i]['race_data']['num_sg'] . "</td>";
    } elseif ($dtcol or $sgcol) {
        echo "<td></td>";
    }

    // OVERALL BEST, TEAM BEST, DRIVER BEST LAP
    if ($XMLTEAM[$i]['race_data']['laps']) {
        if ($XMLTEAM[$i]['filter_laps'][$teamlaps]['laptime'] == $XMLRACE['fastest_lap'] or
            $XMLTEAM[$i]['filter_laps'][$teamlaps]['laptime'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap']) {
            $bestlapconstruct = "<strong class='classbestlap'>" . normalTime($XMLTEAM[$i]['race_data']['fastest_lap']) .
                "</strong>";
            $prevlapconstruct = $bestlapconstruct;
        } elseif ($XMLTEAM[$i]['filter_laps'][$teamlaps]['laptime'] == $XMLTEAM[$i]['race_data']['fastest_lap'] or
        $XMLTEAM[$i]['filter_laps'][$teamlaps]['laptime'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap']) {
            $bestlapconstruct = "<strong class='teambestlap'>" . normalTime($XMLTEAM[$i]['race_data']['fastest_lap']) .
                "</strong>";
            $prevlapconstruct = $bestlapconstruct;
        } elseif ($XMLTEAM[$i]['filter_laps'][$teamlaps]['laptime'] == $XMLTEAM[$i]['team_data']['drivers'][($XMLTEAM[$i]['race_data']['current_driver_num'])]['fastest_lap']) {
            $prevlapconstruct = "<strong class='driverbestlap'>" . normalTime($XMLTEAM[$i]['filter_laps'][$teamlaps]['laptime']) .
                "</strong>";
            $bestlapconstruct = normalTime($XMLTEAM[$i]['race_data']['fastest_lap']);
        } elseif ($XMLRACE['fastest_lap'] == $XMLTEAM[$i]['race_data']['fastest_lap'] or
        $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap'] == $XMLTEAM[$i]['race_data']['fastest_lap']) {
            $bestlapconstruct = "<strong>" . normalTime($XMLTEAM[$i]['race_data']['fastest_lap']) .
                "</strong>";
            $prevlapconstruct = normalTime($XMLTEAM[$i]['filter_laps'][$teamlaps]['laptime']);
        } else {
            $bestlapconstruct = normalTime($XMLTEAM[$i]['race_data']['fastest_lap']);
            $prevlapconstruct = normalTime($XMLTEAM[$i]['filter_laps'][$teamlaps]['laptime']);
        }


    } else {
        $bestlapconstruct = "";
        $prevlapconstruct = "";
    }
    // PRINT BEST LAP CONSTRUCTED
    echo "<td>$bestlapconstruct</td>";

    // TEAM STATUS
    if ($showStatus) {
        if ($XMLTEAM[$i]['team_data']['finished'] && $trimFinished) {
            echo "<td class='teamStatus'><abbr title='Finished the race'>FIN</abbr></td>";
        } elseif ($XMLTEAM[$i]['team_data']['team_status_num'] === 2) {
            echo "<td class='teamStatus'><abbr title='Not a classified finisher'>NC</abbr></td>";
        } elseif ($XMLTEAM[$i]['team_data']['team_status_num'] === 3) {
            echo "<td class='teamStatus'><abbr title='Retired'>RET</abbr></td>";
        } elseif ($XMLTEAM[$i]['team_data']['team_status_num'] === 4) {
            echo "<td class='teamStatus'><abbr title='Disqualified'>DQ</abbr></td>";
        } elseif ($XMLTEAM[$i]['team_data']['team_status_num'] === 5) {
            echo "<td class='teamStatus'><abbr title='Did Not Start'>DNS</abbr></td>";
        } else {
            if (strtoupper($XMLRACE['session_status']) == "PRE-RACE") {
                echo "<td class='teamStatus'><abbr title='On the Grid'>GRID</abbr></td>";
            } elseif (($XMLTEAM[0]['filter_laps'][($XMLTEAM[0]['race_data']['laps'] - 1)]['logged'] -
            $XMLTEAM[$i]['filter_laps'][$teamlaps]['logged']) > $inactiveTime) {
                echo "<td class='teamStatus'><abbr title='Not Completing Laps'>OUT</abbr></td>";
            } elseif ($XMLTEAM[$i]['race_data']['num_pits'] and $XMLTEAM[$i]['race_data']['pitstops'][count
            ($XMLTEAM[$i]['race_data']['pitstops']) - 1]['type'] == "PITIN") {
                echo "<td class='teamStatus'><abbr title='In the Pit Lane'>PIT</abbr></td>";
            } elseif ($XMLTEAM[$i]['team_data']['team_status_num'] === 1) {
                echo "<td class='teamStatus'><abbr title='Running on track'>RUN</abbr></td>";
            }
        }
    }


    if ($raceFocus != "driver") {
        echo "<td class='currentDriver'>";
        for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++) {
            if ($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs'] == $XMLTEAM[$i]['race_data']['current_driver'])
                echo "<img src='" . $trackerRoot . "flags/" . strtolower(str_replace(" ", "_", $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country'])) .
                    ".gif' width='18' height='12' alt='' title='" . ucwords($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country']) .
                    "'><span title='" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_full'] .
                    " / " . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs'] . "'>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_real'] .
                    "</span>";
        }
        echo "</td>";
    }

    // PRINT PREV LAP CONSTRUCTED
    if ($showPrev) {
        echo "<td>$prevlapconstruct</td>";
    }
    // SECTORS
    if ($showSector && strtoupper($XMLTEAM[$i]['team_data']['team_status']) !==
        "DNS") {
        if ($XMLTEAM[$i]['team_data']['finished'] && $trimFinished) {
            $XMLTEAM[$i]['race_data']['current_sector'] = "f";
        }
        echo "<td><img src='" . $trackerRoot . "images/" . $XMLRACE['num_sectors'] . "s" .
            $XMLTEAM[$i]['race_data']['current_sector'] . ".gif' ";
        switch ($XMLRACE['num_sectors']) {
            case 4:
                echo "width='35' height='3'";
                break;
            case 3:
                echo "width='32' height='3'";
                break;
            case 2:
                echo "width='21' height='3'";
        }
        echo " alt='sector " . ($XMLTEAM[$i]['race_data']['current_sector'] + 1) .
            "'></td>";
    } elseif (strtoupper($XMLTEAM[$i]['team_data']['team_status']) == "DNS") {
        echo "<td></td>";
    }

    // GAP
    if ($i == 0) {
        echo "<td class='gap'><strong><span title='" . normalTime($XMLTEAM[$i]['filter_laps'][($XMLTEAM[$i]['race_data']['laps'] -
            1)]['sessiontime'], true, false, false, true, false, true, true) . "'>" . $XMLTEAM[$i]['race_data']['dist_to_lead_car'] .
            "</span></strong></td>";
    } elseif (isset($XMLTEAM[$i]['race_data']['indexgap'])) {
        echo "<td class='gap'><span title='" . normalTime($XMLTEAM[$i]['filter_laps'][($XMLTEAM[$i]['race_data']['laps'] -
            1)]['sessiontime'], true, false, false, true, false, true, true) . "'>" . $XMLTEAM[$i]['race_data']['indexgap'] .
            "</span></td>";
    } else {
        echo "<td class='gap'><strong><span title='" . normalTime($XMLTEAM[$i]['filter_laps'][($XMLTEAM[$i]['race_data']['laps'] -
            1)]['sessiontime'], true, false, false, true, false, true, true) . "'>" . $XMLTEAM[$i]['race_data']['dist_to_lead_car'] .
            "</span></strong></td>";
    }
    // DIFF
    if ($i == 0 || ($XMLTEAM[$i]['race_data']['dist_to_car_in_front'] < 1)) {
        echo "<td class='diff'><strong>" . $XMLTEAM[$i]['race_data']['dist_to_car_in_front'] .
            "</strong></td>";
    } elseif ($XMLTEAM[$i]['team_data']['team_status_num'] == 4) {
        echo "<td class='diff'></td>";
    } else {
        echo "<td class='diff'>" . $XMLTEAM[$i]['race_data']['dist_to_car_in_front'] .
            "</td>";
    }

    // PENALTY LAPS & TIME
    if ($pencolfull) {
        if (!$XMLTEAM[$i]['race_data']['penalty_laps'])
            echo "<td></td>";
        if (!$XMLTEAM[$i]['race_data']['penalty_time'])
            echo "<td></td>";
    } elseif ($pencoltime or $pencollaps) {
        if (!$XMLTEAM[$i]['race_data']['penalty_laps'] && !$XMLTEAM[$i]['race_data']['penalty_time'])
            echo "<td></td>";
    }
    if ($XMLTEAM[$i]['race_data']['penalty_laps'] == 1)
        echo "<td class='penlapspos'>+" . $XMLTEAM[$i]['race_data']['penalty_laps'] .
            " lap</td>";
    if ($XMLTEAM[$i]['race_data']['penalty_laps'] > 1)
        echo "<td class='penlapspos'>+" . $XMLTEAM[$i]['race_data']['penalty_laps'] .
            " laps</td>";
    if ($XMLTEAM[$i]['race_data']['penalty_laps'] == -1)
        echo "<td class='penlaps'>" . $XMLTEAM[$i]['race_data']['penalty_laps'] .
            " lap</td>";
    if (($XMLTEAM[$i]['race_data']['penalty_laps'] < -1) && ($XMLTEAM[$i]['race_data']['penalty_laps']))
        echo "<td class='penlaps'>" . $XMLTEAM[$i]['race_data']['penalty_laps'] .
            " laps</td>";
    if ($XMLTEAM[$i]['race_data']['penalty_time'] < 0)
        echo "<td class='penlaps'>+" . substr($XMLTEAM[$i]['race_data']['penalty_time'],
            1) . "s</td>";
    if ($XMLTEAM[$i]['race_data']['penalty_time'] > 0)
        echo "<td class='penlapspos'>-" . $XMLTEAM[$i]['race_data']['penalty_time'] .
            "s</td>";


    echo "</tr>";
    echo "<tr id='" . $i . "-collapse' style=\"display:none;\" class='collapsed_stats " .
        $classrow . "'>";
    echo "<td colspan='" . (8 + $colspanExtra) . "'>";
    echo "<table>";
    echo "<tr>";
    echo "<th></th>";
    for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++)
        echo "<th><img src='" . $trackerRoot . "flags/" . strtolower(str_replace(" ",
            "_", $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country'])) .
            ".gif' width='18' height='12' alt='' title='" . ucwords($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country']) .
            "'><br><span title=\"" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_full'] .
            "\">" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_real'] . "</span></th>";
    echo "</tr>";
    echo "<tr>";
    echo "<th scope='row'>Username</th>";
    for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++)
        echo "<td><a href='http://spdoracing.com/eventdb/driver/" . urlencode($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs']) .
            "'>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs'] . "</a></td>";
    echo "</tr>";
    if ($XMLTEAM[$i]['team_data']['num_drivers'] > 1) {
        echo "<tr>";
        echo "<th scope='row'><span title='Calculated using the teams laps, not including penalty laps'>Race %</span></th>";
        for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++) {
            if ($driverPercentMax && ($XMLTEAM[$i]['team_data']['drivers'][$j]['percent'] >
                $driverPercentMax) && ($XMLTEAM[$i]['team_data']['[team_status_num]'] < 3)) {
                echo "<td class='pitin'><strong>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['percent'] .
                    "</strong></td>";
            } else {
                echo "<td>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['percent'] . "</td>";
            }
        }
        echo "</tr>";
        echo "<tr>";
        echo "<th scope='row'>Race laps</th>";
        for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++)
            echo "<td>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['laps'] . "</td>";
        echo "</tr>";

        echo "<tr>";
        echo "<th scope='row'>Best lap</th>";
        for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++) {
            if ($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap']) {
                if ($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap']) {
                    echo "<td><strong class='classbestlap'>" . normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'], true) .
                        "</strong></td>";
                } elseif ($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'] == $XMLTEAM[$i]['race_data']['fastest_lap']) {
                    echo "<td><strong class='teambestlap'>" . normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'], true) .
                        "</strong></td>";
                } else {
                    echo "<td>" . normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'], true) .
                        "</td>";
                }
            } else {
                echo "<td></td>";
            }
        }
        echo "</tr>";
    }
    if ($averagelap !== false) {
        if ($averagelap > 100) {
            echo "<tr>";
            echo "<th scope='row'><span title='Excludes laps above " . $averagelap .
                "% of each drivers fastest lap'>Average lap</span></th>";
            for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++) {
                echo "<td>";
                if ($XMLTEAM[$i]['team_data']['drivers'][$j]['average_time'] != 0) {
                    echo normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['average_time'], true);
                }
                echo "</td>";
            }
            echo "</tr>";
        } else {
            echo "<tr>";
            echo "<th scope='row'><span title='Calculated using all of the laps completed by each driver'>Average lap</span></th>";
            for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++) {
                echo "<td>";
                if ($XMLTEAM[$i]['team_data']['drivers'][$j]['average_time'] != 0) {
                    echo normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['average_time'], true);
                }
                echo "</td>";
            }
            echo "</tr>";
        }
    }
    if ($XMLTEAM[$i]['team_data']['num_drivers'] > 1) {
        echo "<tr>";
        if ($standingStartOffset > 0) {
            $drivingTimeText = "<span title='Excludes any formation laps, time might be 1 lap out for either driver, check the race statistics or lapchart'>Driving time</span>";
        } else {
            $drivingTimeText = "Driving time";
        }
        echo "<th scope='row'>$drivingTimeText</th>";
        for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++) {
            if ($driverTimeMax && ($XMLTEAM[$i]['team_data']['drivers'][$j]['driving_time'] >
                ($driverTimeMax * 1000)) && ($XMLTEAM[$i]['team_data']['[team_status_num]'] < 3)) {
                echo "<td class='pitin'><strong>" . normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['driving_time']) .
                    "</strong></td>";
            } elseif ($XMLTEAM[$i]['team_data']['drivers'][$j]['driving_time'] != 0) {
                echo "<td>" . normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['driving_time']) .
                    "</td>";
            } else {
                echo "<td></td>";
            }
        }
        echo "</tr>";
    }
    echo "</table>";
    echo "<table style='width:99%'>";
    echo "<tr>";
    echo "<td colspan='" . ($XMLTEAM[$i]['team_data']['num_drivers'] + 1) .
        "' class='expandedbottom'>";
    // link to extended stats
    echo "<p><a href='team_" . $XMLTEAM[$i]['team_data']['number'] .
        ".html'>Race statistics</a> &mdash; ";
    // link to unfiltered stats
    echo "<a href='race_" . $XMLTEAM[$i]['team_data']['number'] .
        ".html'>Race lapchart</a>";
    if (file_exists('qualifying.html')) {
        echo " &mdash; <a href='qual_" . $XMLTEAM[$i]['team_data']['number'] .
            ".html'>Qualifying statistics</a>";
    }
    echo "</p><p>";
    // number of laps + total laps
    echo "Laps: " . $XMLTEAM[$i]['race_data']['laps'];
    if ($XMLTEAM[$i]['race_data']['laps'] !== $XMLTEAM[$i]['race_data']['corrected_laps']) {
        echo ", Total laps: " . $XMLTEAM[$i]['race_data']['corrected_laps'];
    }
    // total time
    echo "</p><p>";
    echo "Session time: " . normalTime($XMLTEAM[$i]['race_data']['total_sessiontime']);


    if ($XMLTEAM[$i]['race_data']['corrected_laps'] !== $XMLTEAM[0]['race_data']['corrected_laps']) {
        echo ", behind leader: " . normalTime($XMLTEAM[$i]['race_data']['total_sessiontime'] -
            $XMLTEAM[0]['filter_laps'][($XMLTEAM[$i]['race_data']['corrected_laps'] - 1)]['sessiontime']);
    }
    if ($XMLRACE['numClasses'] > 1) {
        if (($XMLTEAM[$i]['team_data']['class_position'] !== 1) && ($XMLTEAM[$i]['team_data']['class']
            !== $XMLTEAM[0]['team_data']['class'])) {
            echo ", behind " . $XMLTEAM[$i]['team_data']['class'] . " leader: " . normalTime($XMLTEAM[$i]['race_data']['total_sessiontime'] -
                $XMLTEAM[$XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['i']]['filter_laps'][($XMLTEAM[$i]['race_data']['corrected_laps'] -
                1)]['sessiontime']);
        }
    }
    echo "</p>";
    if ($showServer) {
        echo "<p>Server: #" . $XMLTEAM[$i]['team_data']['server'];
        if (!$XMLTEAM[$i]['team_data']['grid'] > 0) {
            echo "</p>";
        }
    }

    if ($XMLTEAM[$i]['team_data']['grid'] > 0) {
        if ($showServer) {
            echo " &mdash; ";
        } else {
            echo "<p>";
        }
        $gridchange = $XMLTEAM[$i]['team_data']['grid'] - $XMLTEAM[$i]['race_data']['position'];
        $gridchange = ($gridchange > 0) ? "+" . $gridchange : $gridchange;

        echo "Grid: " . $XMLTEAM[$i]['team_data']['grid'] . ", Position: " . $XMLTEAM[$i]['race_data']['position'] .
            ", Change: " . $gridchange;
        echo "</p>";
    }
    echo "</td>";
    echo "</tr>";
    echo "</table>";
    if ($showCar) {
        $showcarimgsrc = $showCarBaseUrl . $XMLTEAM[$i]['team_data']['number'] .
            strtolower($XMLTEAM[$i]['team_data']['class']) . $thumbCar[removeszeros($XMLTEAM[$i]['team_data']['number'])] .
            ".png";
        list($width, $height, $type, $attr) = getimagesize($showcarimgsrc);
        if ($width) {
            echo "<img src='", $showcarimgsrc, "' ", $attr, " alt='' class='carimage'>";
        }
    }

    echo "</td>";
    echo "</tr>";
}
echo "</tbody></table>";
echo "<div id='bottom_help'>";
echo "<p>Click the <img src='" . $trackerRoot .
    "images/expand.png' width='20' height='16' alt='&#8595;'> icon to get the full statistics.</p>";
if ($pitcol) {
    echo "<p>&dagger; Last pit - the difference in time between the car's last completed lap and the time they exited the pit lane.</p>";
}
if ($finalGrid or $championshipStandings)
    echo "<p>";
if ($championshipStandings)
    echo "<a href='$championshipStandings'>$eventFull - standings after round $championshipRound</a>";
if ($finalGrid and $championshipStandings)
    echo " &mdash; ";
if ($finalGrid)
    echo "<a href='$finalGrid'>$h2eventName - Final Grid</a>";
if ($finalGrid or $championshipStandings)
    echo "</p>";
if (file_exists('qualifying.html')) {
    echo "<a href='qualifying.html'>Qualifying results</a>";
}
if ($showHourly) {
    echo "<ul id='hourlystandings'>";
    for ($k = 1; $k < $XMLRACE['timeHours']; $k++) {
        echo "<li><a href='hour_" . $k . ".html'>Standings at hour " . $k . "</a></li>";
    }
    echo "</p>";
}
echo "</div>";
include 'footer.php';
?>