<?php
/**
 ********************************************
 * Masters of Endurance tracker / LFS-Tracker 
 ********************************************
 * 
 * Copyright © 2007 Wolfgang Tom (WolleT)
 * v1.0 originally written by Wolfgang Tom
 * 
 * Copyright © 2009-2011 Michael Booth (Boothy)
 * v2.0 tracker modified by Michael Booth
 * 
 * Thanks also to Casper Roescher (Kaspur).  
 * 
 * Latest tracker version available from the LFS forum thread - http://www.lfsforum.net/showthread.php?t=73414
 * Any code changes/improvements can be submitted for inclusion in the public tracker version. 
 * E-mail me at web@michaelbooth.me.uk or PM me via http://www.lfsforum.net/private.php?do=newpm&u=202039
 * 
 ********************************************
 * 
 * DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
 * Version 2, December 2004

 * Copyright © 2004 Sam Hocevar <sam@hocevar.net>

 * Everyone is permitted to copy and distribute verbatim or modified
 * copies of this license document, and changing it is allowed as long
 * as the name is changed.

 * DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
 * TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

 * 0. You just DO WHAT THE FUCK YOU WANT TO. 
 * 
 ******************************************** 
 * See http://sam.zoy.org/wtfpl/ for more information
 **/

if ($useTeamsCSV) {
    setlocale(LC_ALL, 'en_US.UTF-8');
    $array = array();
    if (($handle = fopen("teams.csv", "r")) !== false) {
        $i = -1;
        while (($data = fgetcsv($handle, 1000, ",")) !== false) {
            $array[$i]['teamName'] = $data[0];
            $array[$i]['class'] = $data[1];
            $array[$i]['car'] = $data[2];
            $array[$i]['number'] = $data[3];
            if (isset($data[4])) {
                $array[$i]['server'] = $data[4];
            } else {
                $array[$i]['server'] = "";
            }
            if (isset($data[5])) {
                $array[$i]['grid'] = $data[5];
            } else {
                $array[$i]['grid'] = "";
            }
            if (isset($data[6])) {
                $array[$i]['penaltyLaps'] = $data[6];
            } else {
                $array[$i]['penaltyLaps'] = "";
            }
            if (isset($data[7])) {
                $array[$i]['penaltyTime'] = $data[7];
            } else {
                $array[$i]['penaltyTime'] = "";
            }
            if (isset($data[8])) {
                $array[$i]['teamStatus'] = $data[8];
            } else {
                $array[$i]['teamStatus'] = "";
            }
            $j = 0;
            $k = 0;
            while ((isset($data[$k + 9])) !== false) {
                $array[$i]['drivers'][$j][0] = $data[$k + 9];
                $array[$i]['drivers'][$j][1] = $data[$k + 10];
                $array[$i]['drivers'][$j][2] = $data[$k + 11];
                $j++;
                $k = $k + 3;
            }
            $i++;
        }


        fclose($handle);
    }
    unset($array[-1]);
} else {
    require ('spyc.php');
    $array = Spyc::YAMLLoad('teams.yaml');
}

$driver = array();
$TEAMS = array();
foreach ($array as $arr) {
    $record = array();
    $record['team_name'] = $arr['teamName'];
    $record['class'] = $arr['class'];
    $record['car'] = $arr['car'];
    if ($addZeros) {
        $record['number'] = addzeros($arr['number']);
    } else {
        $record['number'] = $arr['number'];
    }
    $record['server'] = $arr['server'];
    $record['grid'] = $arr['grid'];
    $record['penalty_laps'] = $arr['penaltyLaps'];
    $record['penalty_time'] = $arr['penaltyTime'];
    //$record['standings_correction'] = $arr['standings_correction'];
    $record['team_status'] = $arr['teamStatus'];
    foreach ($arr['drivers'] as $drivers) {
        $record['driver_lfs'][] = trim($drivers[0]);
        $record['driver_real'][] = trim($drivers[1]);
        $record['driver_country'][] = trim($drivers[2]);
        $record['driver_active'][] = true;
    }
    $TEAMS[] = $record;
}
?>