﻿<?php
/**
 ********************************************
 * Masters of Endurance tracker / LFS-Tracker 
 ********************************************
 * 
 * Copyright © 2007 Wolfgang Tom (WolleT)
 * v1.0 originally written by Wolfgang Tom
 * 
 * Copyright © 2009-2011 Michael Booth (Boothy)
 * v2.0 tracker modified by Michael Booth
 * 
 * Thanks also to Casper Roescher (Kaspur).  
 * 
 * Latest tracker version available from the LFS forum thread - http://www.lfsforum.net/showthread.php?t=73414
 * Any code changes/improvements can be submitted for inclusion in the public tracker version. 
 * E-mail me at web@michaelbooth.me.uk or PM me via http://www.lfsforum.net/private.php?do=newpm&u=202039
 * 
 ********************************************
 * 
 * DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
 * Version 2, December 2004

 * Copyright © 2004 Sam Hocevar <sam@hocevar.net>

 * Everyone is permitted to copy and distribute verbatim or modified
 * copies of this license document, and changing it is allowed as long
 * as the name is changed.

 * DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
 * TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

 * 0. You just DO WHAT THE FUCK YOU WANT TO. 
 * 
 ******************************************** 
 * See http://sam.zoy.org/wtfpl/ for more information
 **/
if ($debugArrays) {
    print_r($XMLCHAT);
}
$color = array();
$color["BADCHAT"] = '#FFFF00';
$color["DRIVERCHAT"] = '#FF00FF';
$color["ADMINCHAT"] = '#FF80FF';
$color["FASTESTLAP"] = '#d480ff';
$color["TCPERRORS"] = '#ff8080';
$color["JOOSERRORS"] = '#ffd580';
$color["RCMS"] = '#CCCCCC';
$color["DTPEN"] = '#00FFFF';
$color["DTPENC"] = '#80FFFF';
$color["SGPEN"] = '#00FF00';
$color["SGPENC"] = '#80FF00';
$color["SHIFTS"] = '#FF0000';
$color["LEAVE"] = '#FFA800';
$color["RACE_START"] = '#999999';
$color["QUAL_START"] = '#999999';
$color["PRAC_START"] = '#999999';
$color["JOIN"] = '#008AFF';
$color["MSG"] = '#FFFFFF';
$color["MSGBLOCK"] = '#804000';
$color["MSGUNBLOCK"] = '#654321';
echo "<!DOCTYPE html>";
echo "<html lang='en'>";
echo "<head>";
echo "<meta charset='utf-8'><title>Race Control - ";
echo ($windowTitle) ? $windowTitle : "LFS-Tracker";
echo "</title>";
if (strtoupper($XMLRACE['session_status']) == "CHEQUERED FLAG" || strtoupper($XMLRACE['session_status']) ==
    "FINISHED") {
} else {
    echo "<meta http-equiv='refresh' content='";
    echo ($refreshTime < 30) ? 30 : $refreshTime;
    echo "'>";

}
if ($faviconFilepath) {
    if ($faviconFilepath == "leader") {
        $leadingCar = strtolower(substr_replace($XMLTEAM[0]['team_data']['car'], "R", -
            1));
        echo ("<link rel='shortcut icon' href='/favicon$leadingCar.ico' type='image/x-icon'>");
    } else
        echo ("<link rel='shortcut icon' href='$faviconFilepath' type='image/x-icon'>");
}
echo "</head>";
echo "<body>";
echo "<div id='container'>";
echo "<div id='container2'>";
echo "Current time: " . date("H:i:s O") . "";
echo "<table cellpadding=1 cellspacing=0 border=0 style='width:100%;border:none;background-color:#f5f5f5;'>";
echo "<thead>";
echo "<tr>";
echo "<th>ID</th>";
echo "<th>Type</th>";
echo "<th>LFSWorld</th>";
echo "<th>Message</th>";
echo "<th>Filtered</th>";
echo "<th>Race time</th>";
echo "<th>Timecode</th>";
echo "</tr>";
echo "</thead>";
echo "<tbody>";
foreach ($XMLCHAT as $k => $chat) {
    $text = $chat['value'];
    $chat['value'] = codepage_convert($text);
    $c = $color[$chat['type']];
    $trackstatusfilename = "trackstatus.txt";
    if (($text == "GREEN FLAG" || $text == "SAFETY CAR DEPLOYED" || $text ==
        "SAFETY CAR IN THIS LAP" || $text == "RED FLAG" || $text == "FINISHED" || $text ==
        "CHEQUERED FLAG") && ($chat['logged'] > filemtime($trackstatusfilename)))
        $XMLRACE['session_status'] = $text;

    if ($chat['type'] == "MSG") {
        if (strstr($chat['value'], " : ")) {
            $c = $color["BADCHAT"];
            $filteredtype = "chat";
            if (substr($text, 0, 2) > 0) {
                if (strpos($text, "PENALTY CLEARED")) {
                    $c = $color["BADCHAT"];
                    $filteredtype = "chat";
                } else {
                    $c = $color["DRIVERCHAT"];
                    $filteredtype = "driver chat";
                }

            }

            $admins = array(
                "Jonathan Palmer",
                "Michael Booth",
                "Miro Rauti",
                "Chris Ford",
                "Teemu Iivonen");
            $numadmins = count($admins);
            $i = 0;
            for ($i = 0; $i < $numadmins; $i++) {
                if (strpos($text, $admins[$i]) === 0) {
                    $c = $color["ADMINCHAT"];
                    $filteredtype = "admin chat";
                }
            }

            if ((substr($text, 0, 4) == "IGTC") || (substr($text, 0, 3) == "MoE") || (substr
                ($text, 0, 5) == "ADMIN") || (substr($text, 0, 2) == "RA")) {
                $c = $color["ADMINCHAT"];
                $filteredtype = "admin chat";
            } elseif ((substr($text, 0, 7) == "Fastest")) {
                $c = $color["FASTESTLAP"];
                $filteredtype = "fastest lap";
            } elseif ((substr($text, 0, 3) == "TCP") || (substr($text, 0, 5) == "FATAL")) {
                $c = $color["TCPERRORS"];
                $filteredtype = "tcp error";
            } elseif (strpos($text, "JOOS")) {
                $c = $color["JOOSERRORS"];
                $filteredtype = "joos error";
            } elseif (strpos($text, "DRIVE-THROUGH PENALTY")) {
                $c = $color["DTPEN"];
                $filteredtype = "dt penalty";
            } elseif (strpos($text, "completed drive-through penalty")) {
                $c = $color["DTPENC"];
                $filteredtype = "dt complete";
            } elseif (strpos($text, "STOP-GO PENALTY")) {
                $c = $color["SGPEN"];
                $filteredtype = "sg penalty";
            } elseif (strpos($text, "completed stop-go penalty")) {
                $c = $color["SGPENC"];
                $filteredtype = "sg complete";
            }

        }
        if (strpos($text, "completed his drive-through penalty") || strpos($text,
            "completed her drive-through penalty")) {
            $c = $color["DTPENC"];
            $filteredtype = "dt complete";
        } elseif (strpos($text, "completed his stop-go penalty") || strpos($text,
        "completed her stop-go penalty")) {
            $c = $color["SGPENC"];
            $filteredtype = "sg complete";
        }
        if (substr($text, -18) == "unblocked messages") {
            $c = $color["MSGUNBLOCK"];
            $filteredtype = "msg unblocked";
        } elseif (substr($text, -16) == "blocked messages") {
            $c = $color["MSGBLOCK"];
            $filteredtype = "msg blocked";
        } elseif ($text == "GREEN FLAG" || $text == "SAFETY CAR DEPLOYED" || $text ==
        "SAFETY CAR IN THIS LAP" || $text == "RED FLAG" || $text == "FINISHED" || $text ==
            "CHEQUERED FLAG" || $text == "PIT EXIT CLOSED" || $text == "PIT EXIT OPEN" || $text ==
            "GT1 -- GREEN FLAG!" || $text == "GT2 -- GREEN FLAG!") {
            $c = $color["RCMS"];
            $filteredtype = "rcm / msg";
        }
    }

    if ($c == "#FFF") {
        echo "<tr id='" . $k . "'>";
    } else {
        echo "<tr bgcolor='" . $c . "' id='" . $k . "'>";
    }
    echo "<td>" . $k . "</td>";
    echo "<td>" . $chat['type'] . "</td>";
    echo "<td>" . $chat['lfsworld'] . "</td>";
    echo "<td>" . str_replace("^L", "", $chat['value']) . "</td>";
    echo "<td>" . $filteredtype . "</td>";
    echo "<td>" . normalTime(($chat['logged'] - $XMLRACE['race_start']) * 1000, false, false, false) .
        "</td>";
    echo "<td>" . date("H:i:s O", $chat['logged']) . "</td>";
    echo "</tr>";
    unset($filteredtype);
}
echo "</tbody>";
echo "</table>";
echo "Current time: " . date("H:i:s O") . "";
echo "</body>";
echo "</html>"; ?>