#include "cinsim/cinsim.h"	//Headers for CInsim library
#include "cinsim/insim.h"
#include <iostream>
#include <pthread.h>
#include <stdlib.h>
#include <string>

CInsim insim;			//CInsim object, handles the communication with LFS
std::string hostAddr;
std::string adminPass;
int port = 0;
int pktCount = 0;
int salvoDelay = 0;
int pktDelay = 0;

volatile bool canRun = true;

void* sendBtns(void* arg)
{
	struct IS_BTN pack_btn;
	char* btnText = new char[240];
	memset(btnText, 'x', 239);
	btnText[239] = '\0';
	memset(&pack_btn, 0, sizeof(struct IS_BTN));

	pack_btn.Size = sizeof(struct IS_BTN);
	pack_btn.Type = ISP_BTN;
	pack_btn.ReqI = 1;
	pack_btn.UCID = 255;
	pack_btn.ClickID = 0;
	pack_btn.BStyle = ISB_DARK | ISB_CLICK;
	pack_btn.L = 1;
	pack_btn.T = 70;
	pack_btn.W = 60;
	pack_btn.H = 10;
	memcpy(pack_btn.Text, btnText, 240);

	std::cout << "Bombs away..." << std::endl;
	std::cout << "Bytes per bomb: " << sizeof(pack_btn) * pktCount << std::endl;
	while (canRun) {
		if (salvoDelay > 0)
			Sleep(salvoDelay);

		for (int i = 0; i < pktCount; i++) {
			insim.send_packet(&pack_btn);
			if (pktDelay > 0)
				Sleep(pktDelay);

			pack_btn.ClickID++;
			pack_btn.L++;
		}

	    pack_btn.ClickID = 0;
		pack_btn.L = 1;
  }

  return NULL;
}

int main()
{
	int retVal = 0;

	std::cout << "Host address: ";
	std::cin >> hostAddr;
	std::cout << "Port: ";
	std::cin >> port;
	std::cout << "Admin password: ";
	std::cin.ignore();
	std::getline(std::cin, adminPass);
	std::cout << "Packet count [1 - 240]: ";
	std::cin >> pktCount;
	std::cout << "Packet delay (msecs): ";
	std::cin >> pktDelay;
	std::cout << "Salvo delay (msecs): ";
	std::cin >> salvoDelay;

	if (port <= 0 || port > 65535) {
		std::cerr << "ERROR: Invalid port number." << std::endl;
		retVal = 1;
		goto exit;
	}
	if (pktCount <= 0) {
		std::cerr << "ERROR: Invalid packet count." << std::endl;
		retVal = 1;
		goto exit;
	} else if (pktCount > 240)
		pktCount = 240;
	if (pktDelay < 0) {
		std::cerr << "ERROR: Invalid packet delay." << std::endl;
		retVal = 1;
		goto exit;
	}
	if (salvoDelay < 0) {
		std::cerr << "ERROR: Invalid salvo delay." << std::endl;
		retVal = 1;
		goto exit;
	}

	int strSize = hostAddr.length() + 1;
	char* hostAddrCStr = new char[strSize];
	memset(hostAddrCStr, 0, strSize);
	strcpy_s(hostAddrCStr, strSize, hostAddr.c_str());
	char adminPassCStr[16];
	memset(adminPassCStr, 0, sizeof(adminPassCStr));
	strncpy(adminPassCStr, adminPass.c_str(), 15);

	struct IS_VER verPack;	//LFS can tell us info about it's version and InSim version, store that info in this struct.

	//Try to connect to LFS
	retVal = insim.init(hostAddrCStr,
					    (UINT16)port,		//InSim will accept connection on port 29999
					    "ButtonBomb",		//Short name for our app, will appear in LFS
						adminPassCStr,
						&verPack,			//Pointer to IS_VERSION packet
						'!',				//InSim command character
						0,
						1000,				//Receive updates every 1000 msecs
						0);					//No UDP
  
	//Could we connect to LFS?
	if(retVal < 0) {
		//We could not, tell the user and exit
		std::cerr << "Error connecting to LFS!" << std::endl;
		retVal = 1;
		goto exit;
	}
 
	//All OK, report version of LFS and InSim
	std::cout << "Connected to LFS " << verPack.Version << ", InSim ver. " << verPack.InSimVer << std::endl;

	//Now enter the main loop which will receive packets from LFS
	int recvErr = 0;
	int packetType = 0;

	pthread_t bombThr;
	int tRet = pthread_create(&bombThr, NULL, sendBtns, NULL);
	if (tRet < 0) {
		std::cerr << "ERROR: Could not start bombing thread." << std::endl;
		insim.isclose();
		retVal = 1;
		goto exit;
	}

	while (canRun) {
		//Get the next packet in the buffer
		recvErr = insim.next_packet();
		if (recvErr < 0)	{ //Something went wrong
			//Tell the user and exit
			std::cerr << "Error receiving packets from LFS!" << std::endl;
			break;
		}

		//We have a packet, check it's type
		packetType = insim.peek_packet();
		if (packetType == 46)
			canRun = false;

		std::cout << "Got InSim packet type " << packetType << std::endl;
	}

	pthread_join(bombThr, NULL);

	//Successful exit
	insim.isclose();
	return 0;

exit:
	system("pause");
	return retVal;
}

