// G27LEDsHelper.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <iostream>
#include <sstream>
#include <string>
#include <WinSock2.h>
#include <Windows.h>

#define VERSION "1.05D"

#pragma comment(lib, "Ws2_32.lib")

#pragma pack(1)
struct SharedData {
	float rpm;
	char car[4];
} sharedData;
LPVOID pSharedData;

volatile bool run = true;
DWORD thrID;
HANDLE exitThread;
unsigned short port;
SOCKET sock;
WSAData wsaData;

struct OutGaugePack
{
	unsigned	Time;			// time in milliseconds (to check order)

	char		Car[4];			// Car name
	short		Flags;			// Info (see OG_x below)
	byte		Gear;			// Reverse:0, Neutral:1, First:2...
	byte		PLID;			// Unique ID of viewed player (0 = none)
	float		Speed;			// M/S
	float		RPM;			// RPM
	float		Turbo;			// BAR
	float		EngTemp;		// C
	float		Fuel;			// 0 to 1
	float		OilPressure;	// BAR
	float		OilTemp;		// C
	unsigned	DashLights;		// Dash lights available (see DL_x below)
	unsigned	ShowLights;		// Dash lights currently switched on
	float		Throttle;		// 0 to 1
	float		Brake;			// 0 to 1
	float		Clutch;			// 0 to 1
	char		Display1[16];	// Usually Fuel
	char		Display2[16];	// Usually Settings

	int			ID;				// optional - only if OutGauge ID is specified
};

template <class T> bool StrToNum(T& t, const std::string& str)
{
	std::istringstream iss(str);
	return !(iss >> std::dec >> t).fail();
}

DWORD WINAPI WaitForExit(LPVOID arg)
{
	std::cout << "Press any key to exit..." << std::endl;
	HANDLE hStdIn = GetStdHandle(STD_INPUT_HANDLE);
	TCHAR ch;
	DWORD cnt;
	DWORD mode;

	GetConsoleMode(hStdIn, &mode);
	SetConsoleMode(hStdIn, 0);
	ReadConsole(hStdIn, &ch, 1, &cnt, NULL);
	std::cout << "Exiting." << std::endl;
	run = false;

	return 0;
}

int _tmain(int argc, char* argv[])
{
	std::cout << "G27LEDS for LFS mod helper app version " << VERSION << " starting..." << std::endl;
	/* Parse OutGauge port */
	if (argc >= 2) {
		std::string strPort(argv[1]);
		if (!StrToNum<unsigned short>(port, strPort)) {
			std::cerr << "! Invalid port number." << std::endl;
			goto ErrorExit;
		}
	} else {
		std::cerr << "! Port number not specified." << std::endl;
		goto ErrorExit;
	}

	/**  Initialize OutGauge connection */
	/* Init WinSock */
	if (WSAStartup(MAKEWORD(2, 2), &wsaData) != 0) {
		std::cerr << "! Cannot initialize WinSock." << std::endl;
		goto ErrorExit;
	}

	/* Create socket */
	sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
	if (!sock) {
		std::cerr << "! Cannot create socket." << std::endl;
		WSACleanup();
		goto ErrorExit;
	}

	sockaddr_in saddr;
	saddr.sin_addr.s_addr = inet_addr("127.0.0.1");
	saddr.sin_family = AF_INET;
	saddr.sin_port = htons(port);
	if (bind(sock, (const sockaddr*)&saddr, sizeof(saddr)) == SOCKET_ERROR) {
		closesocket(sock);
		WSACleanup();
		std::cerr << "! Cannot bind socket." << std::endl;
		goto ErrorExit;
	}

	ZeroMemory(&sharedData, sizeof(SharedData));

	/* Create shared memory */
	HANDLE hMapFile = CreateFileMapping(INVALID_HANDLE_VALUE, NULL, PAGE_READWRITE, 0, sizeof(SharedData), "G27LEDS_LFS_SHARED");
	if (hMapFile == NULL) {
		std::cerr << "Cannot create shared memory, G27LEDS will not work (error: " << GetLastError() << ")." << std::endl;
		goto ErrorExit;
	}

	pSharedData = MapViewOfFile(hMapFile, FILE_MAP_WRITE, 0, 0, sizeof(SharedData));
	if (pSharedData == NULL) {
		std::cerr << "Null pointer to shared memory, G27LEDS will not work (error: " << GetLastError() << ")." << std::endl;
		CloseHandle(hMapFile);
		goto ErrorExit;
	}
	/* Copy default data to the shared memory */
	sharedData.rpm = 0;
	sharedData.car[0] = 'N'; sharedData.car[1] = 'O'; sharedData.car[2] = 'N';
	CopyMemory(pSharedData, &sharedData, sizeof(SharedData));

	/* Wait for user interrupt to exit */
	exitThread = CreateThread(NULL, 0, WaitForExit, NULL, NULL, &thrID);

	/* Start receiving packets from OutGauge */
	char recvBuf[128];
	fd_set fds;
	timeval tval;
	//Set timeout
	tval.tv_usec = 0;
	tval.tv_sec = 1;	//1 second timeout

	std::cout << "Initialization complete." << std::endl;

	while (run) {
		FD_ZERO(&fds);
		FD_SET(sock, &fds);
		/* Copy shared buffer to our local buffer to check if we should continue receiving data */

		int sel = select(sock+1, &fds, NULL, NULL, &tval);
		if (sel == 0)
			continue;	/* Timeout, continue receiving packets */
		else if (sel < 0) {
			std::cerr << "Error receiving data from OutGauge (error: " << WSAGetLastError() << ")." << std::endl;
			run = false;
		} else {
			if (FD_ISSET(sock, &fds)) {
				int recvd = recv(sock, recvBuf, sizeof(recvBuf), NULL);

				if (recvd == 92 || recvd == 96) {
					sharedData.rpm = ((OutGaugePack*)recvBuf)->RPM;
					memcpy(sharedData.car, ((OutGaugePack*)recvBuf)->Car, 4);
					CopyMemory(pSharedData, &sharedData, sizeof(SharedData));
					DWORD err = GetLastError();
					if (err > 0)
						std::cerr << "Error copying data to shared memory (error: " << err << ")." << std::endl;
				} else if (recvd <= 0) {
					std::cerr << "Error reading packet from OutGauge (ret: " << recvd << ", error: " << WSAGetLastError() << ".)" << std::endl;
					run = false;
				}
			}
		}
	}

	UnmapViewOfFile(pSharedData);
	CloseHandle(hMapFile);

	closesocket(sock);
	WSACleanup();

	return 0;

ErrorExit:
	system("pause");
	return 1;
}
