#include "StdAfx.h"
#include "myIDinput.h"

// ---------------------------------------------------------------------------------------------------
myIDirectInput8::myIDirectInput8(IDirectInput8 *pOriginal)
{	
	extern std::ofstream globalDebug;
	m_pIDirectInput8 = pOriginal;

	/* Init output to debug file */
	SYSTEMTIME sysTime;
	GetSystemTime(&sysTime);
	globalDebug << std::endl << sysTime.wHour << ":" << sysTime.wMinute << ":" << sysTime.wSecond << "." << sysTime.wMilliseconds << " ----------------" << std::endl;
	globalDebug << "- DI> Initializing DirectInput8 interface\n";
}

myIDirectInput8::~myIDirectInput8(void)
{  }
	
HRESULT  myIDirectInput8::QueryInterface(REFIID riid, LPVOID * ppvObj)
{ 
	*ppvObj = NULL;

	// call this to increase AddRef at original object
	// and to check if such an interface is there

	HRESULT hRes = m_pIDirectInput8->QueryInterface(riid, ppvObj); 

	if (hRes == NOERROR) // if OK, send our "fake" address
	{
		*ppvObj = this;
	}
	
	return hRes;
}

ULONG    myIDirectInput8::AddRef(void)
{ return(m_pIDirectInput8->AddRef()); }

ULONG    myIDirectInput8::Release(void)
{ 
	extern myIDirectInput8* gl_pmyIDirectInput8;

	// call original routine
	ULONG count = m_pIDirectInput8->Release();
	
    // in case no further Ref is there, the Original Object has deleted itself
	// so do we here
	if (count == 0) 
	{
		gl_pmyIDirectInput8 = NULL;
  	    delete(this); 
	}

	return(count);
}

HRESULT myIDirectInput8::CreateDevice(REFGUID a, LPDIRECTINPUTDEVICE8W *b, LPUNKNOWN c)
{
	extern std::ofstream globalDebug;
	extern std::vector<GUID> gl_myG27Instance;
	std::vector<GUID>::iterator it;
	for (it = gl_myG27Instance.begin(); it < gl_myG27Instance.end(); it++) {
		if (IsEqualGUID(a, *it)) {
			/* A G27 (or DFP) found, take control over this device */
			// global var
			extern myIDirectInputDevice8* gl_pmyIDirectInputDevice8Array[];

			// we intercept this call and provide our own "fake" Device Object
			HRESULT hres = m_pIDirectInput8->CreateDevice(a,b,c);

			// find free Device slot
			int i;
			for (i=0; i<MAXNUMBER_DEVICES; i++)
				if (gl_pmyIDirectInputDevice8Array[i] == NULL) break;
	
			// Create our own Device object and store it in global pointer
			// note: the object will delete itself once Ref count is zero (similar to COM objects)
			gl_pmyIDirectInputDevice8Array[i] = new myIDirectInputDevice8(*b, i, *it);
	
			// store our pointer (the fake one) for returning it to the calling progam
			*b = gl_pmyIDirectInputDevice8Array[i];

			OLECHAR guidHash[32];
			StringFromGUID2(a, guidHash, 32);
			globalDebug << "- DI> Creating DIDevice, GUID hash " << guidHash << std::endl;
			return(hres);
		}
	}

	/* Not a G27 (or DFP), don't touch this device */
	return m_pIDirectInput8->CreateDevice(a, b, c);
}

HRESULT  myIDirectInput8::EnumDevices(DWORD a, LPDIENUMDEVICESCALLBACKW b, LPVOID c, DWORD d)
{
	m_pIDirectInput8->EnumDevices(a, MyDevEnumCallBack, c, d);
	return m_pIDirectInput8->EnumDevices(a, b, c, d);
}

HRESULT  myIDirectInput8::GetDeviceStatus(REFGUID a)
{ return(m_pIDirectInput8->GetDeviceStatus(a)); }

HRESULT  myIDirectInput8::RunControlPanel(HWND a, DWORD b)
{ return(m_pIDirectInput8->RunControlPanel(a, b)); }

HRESULT  myIDirectInput8::Initialize(HINSTANCE a, DWORD b)
{ return(m_pIDirectInput8->Initialize(a, b)); }

HRESULT  myIDirectInput8::FindDevice(REFGUID a, LPCWSTR b, LPGUID c)
{ return(m_pIDirectInput8->FindDevice(a, b, c)); }

HRESULT  myIDirectInput8::EnumDevicesBySemantics(LPCWSTR a, LPDIACTIONFORMATW b, LPDIENUMDEVICESBYSEMANTICSCBW c, LPVOID d, DWORD e)
{ return(m_pIDirectInput8->EnumDevicesBySemantics(a,b,c,d,e)); }

HRESULT  myIDirectInput8::ConfigureDevices(LPDICONFIGUREDEVICESCALLBACK a, LPDICONFIGUREDEVICESPARAMSW b, DWORD c, LPVOID d)
{ return(m_pIDirectInput8->ConfigureDevices(a,b,c,d)); }

BOOL CALLBACK myIDirectInput8::MyDevEnumCallBack(const DIDEVICEINSTANCE* inst, VOID* context)
{
	extern std::ofstream globalDebug;
	extern std::vector<GUID> gl_myG27Instance;
	if ((inst->guidProduct.Data1 == G27ID) /* || (inst->guidProduct.Data1 == DFPID) */) {
		gl_myG27Instance.push_back(inst->guidInstance);
		globalDebug << "Found G27 IDX: " << gl_myG27Instance.size() << std::endl;
	}

	if (gl_myG27Instance.size() > 20)
		return DIENUM_STOP;
	else
		return DIENUM_CONTINUE;
}
// ---------------------------------------------------------------------------------------------------

myIDirectInputDevice8::myIDirectInputDevice8(IDirectInputDevice8 *pOriginal, int iInterfaceNumber, GUID g)
{   
	m_iInterfaceNumber     = iInterfaceNumber;
	m_pIDirectInputDevice8 = pOriginal;
	m_GUID = g;

	extern std::ofstream globalDebug;

	/* G27 LEDS speficic stuff */
	ZeroMemory(&wheelData, sizeof(wheelData));

	wheelData.size = sizeof(WheelData);
	wheelData.versionNbr = LEDS_VERSION_NUMBER;
	wheelData.rpmData.currentRPM = 0.0f;
	wheelData.rpmData.rpmFirstLedTurnsOn = 3000.0f;
	wheelData.rpmData.rpmRedLine = 6950.0f;

	ZeroMemory(&escData, sizeof(escData));
		
	escData.dwSize = sizeof(DIEFFESCAPE);
	escData.dwCommand = ESCAPE_COMMAND_LEDS;
	escData.lpvInBuffer = &wheelData;
	escData.cbInBuffer = sizeof(wheelData);

	cfgLdr = new ConfigLoader();
	cfgLdr->ReadConfig(&globalDebug);
	inited = false;
}

myIDirectInputDevice8::~myIDirectInputDevice8(void)
{
	delete cfgLdr;
}

HRESULT  myIDirectInputDevice8::QueryInterface(REFIID riid, LPVOID * ppvObj)
{ 
	*ppvObj = NULL;

	// call this to increase AddRef at original object
	// and to check if such an interface is there

	HRESULT hRes = m_pIDirectInputDevice8->QueryInterface(riid, ppvObj); 

	if (hRes == NOERROR) // if OK, send our "fake" address
	{
		*ppvObj = this;
	}
	
	return hRes;
}

ULONG    myIDirectInputDevice8::AddRef(void)
{ return(m_pIDirectInputDevice8->AddRef()); }

ULONG    myIDirectInputDevice8::Release(void)
{ 
    extern myIDirectInputDevice8* gl_pmyIDirectInputDevice8Array[];
	extern myIDirectInputEffect*  gl_pmyIDirectInputEffectArray[];
	extern std::ofstream globalDebug;
	extern std::vector<GUID> gl_myG27Instance;
	std::vector<GUID>::iterator it;

	/* Try to switch the LEDs off */
	wheelData.rpmData.currentRPM = 0.0f;
	wheelData.rpmData.rpmFirstLedTurnsOn = 1.0f;
	wheelData.rpmData.rpmRedLine = 2.0f;

	//Find an active effect we can sent the LEDs command through
	int i;
	for (i = 0; i < MAXNUMBER_EFFECTS; i++) {
		if (gl_pmyIDirectInputEffectArray[i] != NULL) {
			gl_pmyIDirectInputEffectArray[i]->Escape(&escData);
			break;
		}
	}

	if (dataSource == USE_SHAREDMEM) {
		UnmapViewOfFile(pSharedData);
		CloseHandle(hMapFile);
	} else if (dataSource == USE_READFROMLFS)
		CloseHandle(hProc);

	// call original routine
	ULONG count = m_pIDirectInputDevice8->Release();
	
    // in case no further Ref is there, the Original Object has deleted itself
	// so do we here
	if (count == 0) {	
		/* G27 LEDs specific stuff */
		OLECHAR oles[32];
		StringFromGUID2(m_GUID, oles, 32);
		globalDebug << "- DIDEV::Release> Release requested, cleaning up (GUID hash " << oles << ")" << std::endl;
		/* Remove device from the G27 list */
		for (it = gl_myG27Instance.begin(); it < gl_myG27Instance.end(); it++) {
			if (IsEqualGUID(m_GUID, *it)) {
				gl_myG27Instance.erase(it);
				globalDebug << "- DIDEV::Release> Removing device with GUID hash " << oles << std::endl;
			}
		}

		runTimer = false;
		WaitForSingleObject(timerThread, INFINITE);
		globalDebug << "- DIDEV::Release> Cleanup complete." << std::endl;
		globalDebug << "- DIDEV::Release> Exiting." << std::endl;	

		gl_pmyIDirectInputDevice8Array[m_iInterfaceNumber] = NULL;
		delete(this); 
	}

	return(count);}

HRESULT  myIDirectInputDevice8::GetCapabilities(LPDIDEVCAPS a)
{ return(m_pIDirectInputDevice8->GetCapabilities(a)); }

HRESULT  myIDirectInputDevice8::EnumObjects(LPDIENUMDEVICEOBJECTSCALLBACKW a, LPVOID b, DWORD c)
{ return(m_pIDirectInputDevice8->EnumObjects(a,b,c)); }

HRESULT  myIDirectInputDevice8::GetProperty(REFGUID a,LPDIPROPHEADER b)
{ return(m_pIDirectInputDevice8->GetProperty(a,b)); }

HRESULT  myIDirectInputDevice8::SetProperty(REFGUID a,LPCDIPROPHEADER b)
{ return(m_pIDirectInputDevice8->SetProperty(a,b)); }

HRESULT  myIDirectInputDevice8::Acquire(void)
{ return(m_pIDirectInputDevice8->Acquire()); }

HRESULT  myIDirectInputDevice8::Unacquire(void)
{ return(m_pIDirectInputDevice8->Unacquire()); }

HRESULT  myIDirectInputDevice8::GetDeviceState(DWORD a,LPVOID b)
{
	if (!inited) {
		inited = InitializeLeds();
		/* Return here so we don't attempt to read LFS' memory if the initalization failed */
		return m_pIDirectInputDevice8->GetDeviceState(a, b);
	}

	extern myIDirectInputEffect* gl_pmyIDirectInputEffectArray[];
	extern std::ofstream globalDebug;

	if (inited && updateRPM) {
		float rpm;
		char car[4];
		switch (dataSource) {
			case USE_SHAREDMEM:
				if (!ReadFromSharedMem(rpm, car)) {
					globalDebug << "? DIDEV::GetDeviceState> Error reading data from shared memory." << std::endl;
					return m_pIDirectInputDevice8->GetDeviceState(a,b);
				}
				break;
			case USE_READFROMLFS:
				if (!ReadFromLFS(&rpm, car)) {
					globalDebug << "? DIDEV::GetDeviceState> Error reading data from LFS memory." << std::endl;	
					return m_pIDirectInputDevice8->GetDeviceState(a,b);
				}
				break;
			case USE_NOSOURCE:
			default:
				return m_pIDirectInputDevice8->GetDeviceState(a,b);
				break;
		}
		std::string carID(car);
		/* Check is we got a valid car ID */
		if (cfgLdr->rpmCfg.count(carID) == 0)
			return m_pIDirectInputDevice8->GetDeviceState(a,b);

		wheelData.rpmData.currentRPM = rpm;
		wheelData.rpmData.rpmFirstLedTurnsOn = cfgLdr->rpmCfg[carID].firstLeds;
		wheelData.rpmData.rpmRedLine = cfgLdr->rpmCfg[carID].redline;

		// WORKING ? (apparently yes)
		/* Find a DirectInputEffect we can use to send the LED command through */
		int i;
		for (i = 0; i < MAXNUMBER_EFFECTS; i++) {
			if (gl_pmyIDirectInputEffectArray[i] != NULL) {
				HRESULT hrEsc = gl_pmyIDirectInputEffectArray[i]->Escape(&escData);
				if (cfgLdr->debugCfg)
					globalDebug << std::hex << hrEsc << " RPM: " << std::dec << rpm << " Car: " << carID << std::endl;
				break;
			}
		}
		if (i == MAXNUMBER_EFFECTS) {
			globalDebug << "! DIDEV::GetDeviceState> No FFB effect object found. Make sure Force Feedback is enabled in LFS." << std::endl;
			return m_pIDirectInputDevice8->GetDeviceState(a,b);
		}

		WaitForSingleObject(timerMutex, INFINITE);
		updateRPM = false;
		ReleaseMutex(timerMutex);

		/** Through the gates of hell,
			as we make our way to heaven... */
	}

	return m_pIDirectInputDevice8->GetDeviceState(a,b);
}

HRESULT  myIDirectInputDevice8::GetDeviceData(DWORD a,LPDIDEVICEOBJECTDATA b,LPDWORD c,DWORD d)
{ return(m_pIDirectInputDevice8->GetDeviceData(a,b,c,d)); }

HRESULT  myIDirectInputDevice8::SetDataFormat(LPCDIDATAFORMAT a)
{ return(m_pIDirectInputDevice8->SetDataFormat(a)); }

HRESULT  myIDirectInputDevice8::SetEventNotification(HANDLE a)
{ return(m_pIDirectInputDevice8->SetEventNotification(a)); }

HRESULT  myIDirectInputDevice8::SetCooperativeLevel(HWND a,DWORD b)
{ return(m_pIDirectInputDevice8->SetCooperativeLevel(a,b)); }

HRESULT  myIDirectInputDevice8::GetObjectInfo(LPDIDEVICEOBJECTINSTANCEW a,DWORD b,DWORD c)
{ return(m_pIDirectInputDevice8->GetObjectInfo(a,b,c)); }

HRESULT  myIDirectInputDevice8::GetDeviceInfo(LPDIDEVICEINSTANCEW a)
{ return m_pIDirectInputDevice8->GetDeviceInfo(a); }

HRESULT  myIDirectInputDevice8::RunControlPanel(HWND a,DWORD b)
{ return(m_pIDirectInputDevice8->RunControlPanel(a,b)); }

HRESULT  myIDirectInputDevice8::Initialize(HINSTANCE a,DWORD b,REFGUID c)
{ return(m_pIDirectInputDevice8->Initialize(a,b,c)); }

HRESULT myIDirectInputDevice8::CreateEffect(REFGUID a,LPCDIEFFECT b,LPDIRECTINPUTEFFECT *c,LPUNKNOWN d)
{	
	extern myIDirectInputEffect* gl_pmyIDirectInputEffectArray[];
	extern std::ofstream globalDebug;

	HRESULT hr = m_pIDirectInputDevice8->CreateEffect(a,b,c,d);

	//Find free Effect slot
	int i;
	for (i = 0; i < MAXNUMBER_EFFECTS; i++)
		if (gl_pmyIDirectInputEffectArray[i] == NULL) break;
	if (i == MAXNUMBER_EFFECTS)	{ /* We ran our of effect slots, report failure to the calling application and release the effect */
		(*c)->Release();
		return E_FAIL;
	}

	//Create our "fake" effect
	gl_pmyIDirectInputEffectArray[i] = new myIDirectInputEffect(*c, i);

	//Pass pointer to our "fake" effect back to calling application
	*c = gl_pmyIDirectInputEffectArray[i];
	return hr;
}

HRESULT  myIDirectInputDevice8::EnumEffects(LPDIENUMEFFECTSCALLBACKW a,LPVOID b,DWORD c)
{ return(m_pIDirectInputDevice8->EnumEffects(a,b,c)); }

HRESULT  myIDirectInputDevice8::GetEffectInfo(LPDIEFFECTINFOW a,REFGUID b)
{ return(m_pIDirectInputDevice8->GetEffectInfo(a,b)); }

HRESULT  myIDirectInputDevice8::GetForceFeedbackState(LPDWORD a)
{ return(m_pIDirectInputDevice8->GetForceFeedbackState(a)); }

HRESULT  myIDirectInputDevice8::SendForceFeedbackCommand(DWORD a)
{ return(m_pIDirectInputDevice8->SendForceFeedbackCommand(a)); }

HRESULT  myIDirectInputDevice8::EnumCreatedEffectObjects(LPDIENUMCREATEDEFFECTOBJECTSCALLBACK a,LPVOID b,DWORD c)
{ return(m_pIDirectInputDevice8->EnumCreatedEffectObjects(a,b,c)); }

HRESULT  myIDirectInputDevice8::Escape(LPDIEFFESCAPE a)
{ return(m_pIDirectInputDevice8->Escape(a)); }

HRESULT  myIDirectInputDevice8::Poll(void)
{ return(m_pIDirectInputDevice8->Poll());}

HRESULT  myIDirectInputDevice8::SendDeviceData(DWORD a,LPCDIDEVICEOBJECTDATA b,LPDWORD c,DWORD d)
{ return(m_pIDirectInputDevice8->SendDeviceData(a,b,c,d)); }

HRESULT  myIDirectInputDevice8::EnumEffectsInFile(LPCWSTR a,LPDIENUMEFFECTSINFILECALLBACK b,LPVOID c,DWORD d)
{ return(m_pIDirectInputDevice8->EnumEffectsInFile(a,b,c,d)); }

HRESULT  myIDirectInputDevice8::WriteEffectToFile(LPCWSTR a,DWORD b,LPDIFILEEFFECT c,DWORD d)
{ return(m_pIDirectInputDevice8->WriteEffectToFile(a,b,c,d)); }

HRESULT  myIDirectInputDevice8::BuildActionMap(LPDIACTIONFORMATW a,LPCWSTR b,DWORD c)
{ return(m_pIDirectInputDevice8->BuildActionMap(a,b,c)); }

HRESULT  myIDirectInputDevice8::SetActionMap(LPDIACTIONFORMATW a,LPCWSTR b,DWORD c)
{ return(m_pIDirectInputDevice8->SetActionMap(a,b,c)); }

HRESULT  myIDirectInputDevice8::GetImageInfo(LPDIDEVICEIMAGEINFOHEADERW a)
{ return(m_pIDirectInputDevice8->GetImageInfo(a)); }


DWORD WINAPI myIDirectInputDevice8::TimerThr(LPVOID lpArg)
{
	TimerThrData* data = (TimerThrData*)lpArg;
	while(*data->run) {	/* Stop spinning when we don't want to receive OutGauge data anymore */
		Sleep(20);	   /* Allow for the LEDs to be updated at 50 Hz so that we don't choke up the interface */
		WaitForSingleObject(*data->mutex, INFINITE);
		*data->updateRPM = true;
		ReleaseMutex(*data->mutex);
	}

	return 0;
}

bool myIDirectInputDevice8::InitializeLeds()
{
	extern std::ofstream globalDebug;
	
	if (IsProcessRunning(L"G27LEDsHelper.exe")) {
		hMapFile = OpenFileMapping(FILE_MAP_READ, FALSE, "G27LEDS_LFS_SHARED");
		if (hMapFile == NULL) {
			globalDebug << "! DIDEV::InitializeLeds> Unable to open shared memory (error: " << GetLastError()
					    << "). G27LEDs will not work." << std::endl;
			dataSource = USE_NOSOURCE;
			return true;
		}
		pSharedData = MapViewOfFile(hMapFile, FILE_MAP_READ, 0, 0, sizeof(SharedData));
		if (pSharedData == NULL) {
			globalDebug << "! DIDEV::InitializeLeds> Null pointer to mapped memory (error: " << GetLastError()
					    << "). G27LEDs will not work." << std::endl;
			dataSource = USE_NOSOURCE;
			CloseHandle(hMapFile);
			return true;
		}

		dataSource = USE_SHAREDMEM;
	} else {
		/* Find LFS window and get its handle. Repeat as necessary until the window is found. */
		lfsWin = FindWindow("LFS", NULL);
		if (lfsWin == NULL) {
			globalDebug << "! DIDEV::InitializeLeds> Cannot find LFS window." << std::endl;
			return false;
		}

		/* Get process ID and obtain access to its memory */
		GetWindowThreadProcessId(lfsWin, &lfsPID);
		if (!lfsPID) {
			HRESULT hr = GetLastError();
			globalDebug << "! DIDEV::InitializeLeds> Cannot get LFS process ID. (" << std::hex << hr << ")" << std::endl;
			return false;
		}

		hProc = OpenProcess(PROCESS_VM_READ, FALSE, lfsPID);
		if (!hProc) {
			HRESULT hr = GetLastError();
			globalDebug << "! DIDEV::InitializeLeds> Cannon open LFS process for reading. (" << std::hex << hr << ")" << std::endl;
			return false;
		}

		globalDebug << "- Helper app not running, data will be read from LFS process memory." << std::endl;
		dataSource = USE_READFROMLFS;
	}

	runTimer = true;
	timerMutex = CreateMutex(NULL, FALSE, NULL);
	ttData.mutex = &timerMutex;
	ttData.run = &runTimer;
	ttData.updateRPM = &updateRPM;
	timerThread = CreateThread(NULL, 0, TimerThr, &ttData, NULL, &timerThreadID);
	globalDebug << "- DIDEV::InitializeLeds> Init complete." << std::endl;
	return true;
}

/* Iterates though the list of running processes and returns true
   if the helper application is running */
bool myIDirectInputDevice8::IsProcessRunning(const WCHAR* procName)
{
	HANDLE snapshot = CreateToolhelp32Snapshot(TH32CS_SNAPPROCESS, NULL);
	if (snapshot == INVALID_HANDLE_VALUE)
		return false;

	PROCESSENTRY32 procEntry;
	procEntry.dwSize = sizeof(procEntry);

	if (!Process32First(snapshot, &procEntry))
		return false;

	do {
		if (cfgLdr->debugCfg) {
			extern std::ofstream globalDebug;
			char a[260];
			char b[255];
			wcstombs(a, procEntry.szExeFile, 260);
			wcstombs(b, procName, 255);
			globalDebug << std::string(a) << std::endl;
		}
		if (wcsicmp(procEntry.szExeFile, procName) == 0)
			return true;
	} while (Process32Next(snapshot, &procEntry));

	return false;
}

bool myIDirectInputDevice8::ReadFromSharedMem(float& rpm, char* car)
{
	extern std::ofstream globalDebug;

	SharedData data;
	CopyMemory(&data, pSharedData, sizeof(SharedData));
	DWORD err = GetLastError();
	if (err > 0) {
		globalDebug << "! DIDEV::ReadFromSharedMem> Error " << err << std::endl;
		return false;
	}

	rpm = data.rpm;
	memcpy(car, data.car, 3);
	car[3] = '\0';

	return true;
}

bool myIDirectInputDevice8::ReadFromLFS(float* rpm, char* car)
{
	extern std::ofstream globalDebug;
	/* Read RPM from LFS process memory */
	BOOL ok = ReadProcessMemory(hProc, (LPVOID)0x0086D328, rpm, sizeof(float), NULL);
	if (!ok)
		return false;

	/* Read the type of car from LFS process memory */
	ok = ReadProcessMemory(hProc, (LPVOID)0x00624940, car, 3, NULL);
	car[3] = '\0';	/* Add null terminator */
	if (!ok)
		return false;

	return true;
}

// ---------------------------------------------------------------------------------------------------

myIDirectInputEffect::myIDirectInputEffect(IDirectInputEffect *pOriginal, int iFaceNum)
{
	extern std::ofstream globalDebug;

	m_pIDirectInputEffect = pOriginal;
	m_interfaceNumber = iFaceNum;

	globalDebug << "- DIEFF> Creating FFB effect." << std::endl;
}

myIDirectInputEffect::~myIDirectInputEffect(void)
{ }

HRESULT  myIDirectInputEffect::QueryInterface(REFIID riid, LPVOID * ppvObj)
{ return(m_pIDirectInputEffect->QueryInterface(riid, ppvObj)); }

ULONG    myIDirectInputEffect::AddRef(void)
{ return(m_pIDirectInputEffect->AddRef()); }

ULONG    myIDirectInputEffect::Release(void)
{ 
	extern myIDirectInputEffect* gl_pmyIDirectInputEffectArray[];
	extern std::ofstream globalDebug;

	globalDebug << "- DIEFF::Release> Effect release requested." << std::endl;

	ULONG count = m_pIDirectInputEffect->Release();
	//Our "fake" effect is no longer referenced anywhere, dispose it
	if (count == 0) {
		globalDebug << "- DIEFF::Release> Disposing effect." << std::endl;
		gl_pmyIDirectInputEffectArray[m_interfaceNumber] = NULL;
		delete(this);
	}

	return count;
}

HRESULT  myIDirectInputEffect::Initialize(HINSTANCE a,DWORD b,REFGUID c)
{ return(m_pIDirectInputEffect->Initialize(a,b,c)); }

HRESULT  myIDirectInputEffect::GetEffectGuid(LPGUID a)
{ return(m_pIDirectInputEffect->GetEffectGuid(a)); }

HRESULT  myIDirectInputEffect::GetParameters(LPDIEFFECT a,DWORD b)
{ return(m_pIDirectInputEffect->GetParameters(a,b)); }

HRESULT  myIDirectInputEffect::SetParameters(LPCDIEFFECT a,DWORD b)
{ return(m_pIDirectInputEffect->SetParameters(a,b)); }

HRESULT  myIDirectInputEffect::Start(DWORD a,DWORD b)
{ return(m_pIDirectInputEffect->Start(a,b)); }

HRESULT  myIDirectInputEffect::Stop(void)
{ return(m_pIDirectInputEffect->Stop()); }

HRESULT  myIDirectInputEffect::GetEffectStatus(LPDWORD a)
{ return(m_pIDirectInputEffect->GetEffectStatus(a)); }

HRESULT  myIDirectInputEffect::Download(void)
{ return(m_pIDirectInputEffect->Download()); }

HRESULT  myIDirectInputEffect::Unload(void)
{ return(m_pIDirectInputEffect->Unload()); }

HRESULT  myIDirectInputEffect::Escape(LPDIEFFESCAPE a)
{ return(m_pIDirectInputEffect->Escape(a)); }