#pragma once
#ifndef _CONFIGLOADER_H_
#define _CONFIGLOADER_H_

//#include <windows.h>
#include <map>
#include <string>
#include <vector>

typedef struct
		{
			float firstLeds;
			float redline;
		} ledCfg;
typedef std::map<std::string, ledCfg> rpmCfgMap;

class ConfigLoader
{
public:
	ConfigLoader(void);
	~ConfigLoader(void);
	HRESULT ReadConfig(std::ofstream*);

	rpmCfgMap rpmCfg;
	bool debugCfg;

private:
	HRESULT ParseConfig(const std::vector<std::string>&);
};

template <class T> bool NumericFromString(T& t, const std::string& str)
{
	std::istringstream iss(str);
	return !(iss >> std::dec >> t).fail();
};

#endif