<?

require_once('cp_unicode_tables.php');

function WriteColor ($str) {
    codepage_convert ($str);

    $foundstart = False;
    $tmp = '';
    for ($i=0; $i<strlen (trim ($str)); $i++) {
		if ($str[$i] == '^' && isset ($str[$i+1]) && ereg ("[0-8]", $str[$i+1])) {
		    if (!$foundstart) {
		        $tmp .= '<span style="color: '.getcolorcode ($str[$i+1]).';">';
		        $foundstart = True;
		    } else {
		        $tmp .= '</span><span style="color: '.getcolorcode ($str[$i+1]).';">';
		    }
		    $i++;
		
		} else if ($str[$i] == '^' && isset ($str[$i+1]) && $str[$i+1] == 9) {
		    $tmp .= '</span>';
		    $i++;
		
		} else if ($str[$i] == '^' && isset ($str[$i+1]) && !ereg("[acdhlqrstvLGCETBJSKH]", $str[$i+1])) {
			$tmp .= $str[$i+1];
			$i++;
		
		} else {
		    $tmp .= $str[$i];
		}
    }
    if ($foundstart) {
        $str = $tmp.'</span>';
    } else {
    	$str = $tmp;
    }
    return $str;
}

function getcolorcode($type) {
    switch ($type) {
        case 0 : $type = "#000000"; return $type; Break;
        case 1 : $type = "#FF0000"; return $type; Break;
        case 2 : $type = "#00FF00"; return $type; Break;
        case 3 : $type = "#FFFF00"; return $type; Break;
        case 4 : $type = "#0000FF"; return $type; Break;
        case 5 : $type = "#FF00FF"; return $type; Break;
        case 6 : $type = "#00FFFF"; return $type; Break;
        case 7 : $type = "#FFFFFF"; return $type; Break;
        case 8 : $type = "#000000"; return $type; Break;
        case 9 : $type = "#000000"; return $type; Break;
        return $type;
    }
}

function UnWriteColor ($str) {
    $tmp = '';
    for ($i = 0; $i < strlen($str); $i++) {
        if ($str[$i] == '^' && isset ($str[$i+1]) && ereg("[0-9]", $str[$i+1])) {
            $i+=1;

		} else if ($str[$i] == '^' && isset ($str[$i+1]) && !ereg("[acdhlqrstvLGCETBJSKH]", $str[$i+1])) {
			$tmp .= $str[$i+1];
			$i += 1;
		
        } else {
            $tmp .= $str[$i];
        }
    }
    $str = $tmp;
    return $str;
}

// L = Latin 1
// G = Greek
// C = Cyrillic
// E = Central Europe
// T = Turkish
// B = Baltic
// J = Japanese
// S = Simplified Chinese
// K = Korean
// H = Traditional Chinese
function codepage_convert (&$str, $conv_to = 'HTML-ENTITIES') {
	$sets = array ('L' => 'CP1252',
                   'G' => 'ISO-8859-7',
                   'C' => 'CP1251',
                   'E' => 'ISO-8859-2',
                   'T' => 'ISO-8859-9',
                   'B' => 'ISO-8859-13',
                   'J' => 'SJIS-win',
                   'S' => 'CP936',
                   'K' => 'CP949',
                   'H' => 'CP950');

	//$str = convertLFSSpecialChars ($str);
	
	$newstr = $tmp = '';
	$current_cp = 'L';
	$len = strlen ($str);
	for ($i=0; $i<$len; $i++) {
        if ($str{$i} == '^' && isset ($sets[$str{$i+1}])) {
            if ($tmp != '') {
            	if ($current_cp == 'G' || $current_cp == 'B' || $current_cp == 'E' || $current_cp == 'T') {
            		$tmp = '^'.$current_cp.$tmp;
            		codepage_convert_old ($tmp);
            		$newstr .= $tmp;
            	} else {
               		$newstr .= mb_convert_encoding ($tmp, $conv_to, $sets[$current_cp]);
               	}
                $tmp = '';
            }
            $current_cp = $str{++$i};
        
        } else {
        	$dec = ord ($str{$i});
            if ($current_cp == 'L' || $current_cp == 'T' || $current_cp == 'J' || $current_cp == 'G') {
                switch ($dec) {
                    case 144 :
                        $tmp .= '&#9660;';
                        break;
                    default :
                        if ($dec > 31)
                            $tmp .= $str{$i};
                        break;
                }

            } else if ($dec > 31)
                $tmp .= $str{$i};
        }
	}
	if ($tmp != '') {
       	if ($current_cp == 'G' || $current_cp == 'B' || $current_cp == 'E' || $current_cp == 'T') {
       		$tmpstr = '^'.$current_cp.$tmp;
       		codepage_convert_old ($tmpstr);
       		$newstr .= $tmpstr;
       	} else {
			$newstr .= mb_convert_encoding ($tmp, $conv_to, $sets[$current_cp]);
		}
	}
	
	//$str = convertLFSSpecialChars ($newstr, true);
	$str = $newstr;
}

function codepage_convert_old (&$str) {
    global $cp_tables;

    $newstr = '';
    $current_cp = 'L';
    $len = strlen ($str);
    for ($i=0; $i<$len; $i++) {
        if ($str{$i} == '^' && !is_numeric($str{$i+1}) && is_array ($cp_tables[$str{$i+1}])) {
            $i++;
            $current_cp = $str{$i};
            continue;
        }

        $decimal = ord ($str{$i});
        if ($decimal > 127) $newstr .= sprintf ('&#%05d;', $cp_tables[$current_cp][$decimal]);
        else $newstr .= $str{$i};
    }

    $str = $newstr;
}

function convertLFSSpecialChars ($str, $Final = false) {
    $tr_ptrn	= array ('^h', '^d', '^s', '^c', '^a', '^q', '^t', '^l', '^r', '^v');
	$tr_ptrn_r	= array ('#', '\\', '/' , ':' , '*' , '?' , '"', '<' , '>' , '|');
	
	if ($Final)
		return str_replace ('^^', '^', $str);
	else
		return str_replace ($tr_ptrn, $tr_ptrn_r, $str);
}

function encodeLFSUrl ($String) {
	$tr_ptrn	= array ('#', '\\', '/' , ':' , '*' , '?' , '"', '<' , '>' , '|');
	$tr_ptrn_r	= array ('^h', '^d', '^s', '^c', '^a', '^q', '^t', '^l', '^r', '^v');
	$String		= str_replace ($tr_ptrn, $tr_ptrn_r, $String);

	$Out = '';
	$Len = strlen ($String);
	for ($a=0; $a<$Len; $a++) {
		$Dec = ord ($String[$a]);
		
		if ($Dec > 127 || $Dec == 32 || $Dec == 35 || $Dec == 37 || $Dec == 38 || $Dec == 91 || $Dec == 93) {
			$Out .= '%'.sprintf ('%2X', $Dec);
		
		} else {
			$Out .= $String[$a];
		}
	}
	
	return $Out;
}

?>
