#############################################################################
# LFS Lapper Who by Krayy
#############################################################################
# This is a more informative command to display current players, PBs and
# a pit summary.
#############################################################################
# Ver 1.0.1 - 11 Aug 09 Initial release
# Ver 1.0.3 - 20 Oct 09 Updated to include PM capabilities
# Ver 1.0.4 - 04 Nov 09 Updated by Gai-Luron for using new ListofPlayers Array
# Ver 1.0.5 - 05 Nov 09 Updated for release 5.852
# Ver 1.0.6 - 14 Feb 10 Updated for release 5.926b
#############################################################################

CatchEvent OnLapperStart()
	### Global vars for penalty short names ####
	GlobalVar $penalty_shortnames;
	$penalty_shortnames[0] = "--";
	$penalty_shortnames[1] = "DT";
	$penalty_shortnames[2] = "DT";
	$penalty_shortnames[3] = "SG";
	$penalty_shortnames[4] = "SG";
	$penalty_shortnames[5] = "30";
	$penalty_shortnames[6] = "45";
	$penalty_shortnames[7] = "";
EndCatchEvent

CatchEvent OnMSO( $userName, $text ) # Player event

	$idxOfFirstSpace = indexOf( $text, " ");
	IF( $idxOfFirstSpace == -1 ) THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirstSpace );
	  $argv = trim( subStr( $text,$idxOfFirstSpace ) );
	ENDIF

	SWITCH( $command )
		CASE "!who":		# This is the command that the user types
			DoWho(1);		# This is the function
			BREAK;
	ENDSWITCH
EndCatchEvent

Sub DoWho ( $kWhoPageNum )

	### Set Dialog prefix and initial left/right and top/bottom coordinates ###
	$DialogPrefix = "DoWho_";		# Dialog prefix...used in Close Regex
	$DialogTitle = "^0Who's on " . getLapperVar( "HostName" );	# Dialog title
	$origL = 45;			# Left edge of main content window
	$origT = 37;			# Top edge of main content window
	$Height = 107;			# ...height of Dialog box
	$Width = 110;			# ...width of Dialog box
	$ShowClose = true;		# ...show a close button?
	$secondsDisplayed = -1;	# ...display for how many seconds (-1 = permanent)

	# Create the new dialog box if it isn't already open
	IF ( ButtonExists(GetCurrentPlayerVar("UserName"), $DialogPrefix . ".*bg") == FALSE)
	THEN
		DialogCreate ( GetCurrentPlayerVar("UserName"), $DialogPrefix, $origL-1, $origT, $Width, $Height, $DialogTitle, $ShowClose, $secondsDisplayed);
	ENDIF

	# Function vars
	setCurrentPlayerVar( "DoWhoPageNum", $kWhoPageNum);
	$numConns = GetLapperVar("numconns");

	# This is for 2 page output
	$iStart = 0;
	$kWhoMaxPages = 1;
	$iMax = 16;
	IF ( $numConns > 16 )
	THEN
		$kWhoMaxPages = 2;
		IF ( ToNum($kWhoPageNum) > 1) 
		THEN
			$iStart = 16;
			$iMax = 32;
			openPrivButton ( $DialogPrefix . "prev",$origL,$origT+$Height+1,15,6,8,-1,16,"^0<< Prev",DoWho_Page1 );
		ELSE
			openPrivButton ( $DialogPrefix . "next",$origL+$Width-15,$origT+$Height+1,15,6,8,-1,16,"^0Next >>",DoWho_Page2 );
		ENDIF
	ENDIF

	# Set initial values for left/right and top/bottom coordinates ###
	$rowheight = 6;
	$dowho_origT=$origT+1;

	# Set the header row
	openPrivButton ($DialogPrefix . "nick",$origL+1,$dowho_origT,33,$rowheight,1,-1,96,"Nickname");
	openPrivButton ($DialogPrefix . "car",$origL+33,$dowho_origT,8,$rowheight,1,-1,32,"Car");
	openPrivButton ($DialogPrefix . "pb",$origL+41,$dowho_origT,12,$rowheight,1,-1,32,"PB Time");
	openPrivButton ($DialogPrefix . "wr",$origL+53,$dowho_origT,12,$rowheight,1,-1,32,"WR Time");
	openPrivButton ($DialogPrefix . "pittime",$origL+65,$dowho_origT,20,$rowheight,1,-1,32,"Pits (Time)");
	openPrivButton ($DialogPrefix . "reset",$origL+85,$dowho_origT,8,$rowheight,1,-1,32,"Rst");
	openPrivButton ($DialogPrefix . "penalty",$origL+93,$dowho_origT,8,$rowheight,1,-1,32,"Pty");
	openPrivButton ($DialogPrefix . "pm",$origL+101,$dowho_origT,8,$rowheight,1,-1,32,"PM");

	$ListOfPlayersDoWho	= GetListOfPlayers();
	FOR ( $i=$iStart; $i<$iMax; $i=$i+1 )
		IF ( $ListOfPlayersDoWho[$i] != "" )
		THEN
			# Increase $dowho_origT by 5 before drawing next row
			$dowho_origT=$dowho_origT+5;
			$currUserName = $ListOfPlayersDoWho[$i];
#			unset( $currPly );
			$currPly = getplayerinfo($ListOfPlayersDoWho[$i] );
			openPrivButton ($DialogPrefix . $i."_nickname",$origL+1,$dowho_origT+1,33,$rowheight,5,-1,81,$currPly[NickName]);
			openPrivButton ($DialogPrefix . $i."_car",$origL+33,$dowho_origT+1,8,$rowheight,1,-1,17,$currPly[Car]);
			openPrivButton ($DialogPrefix . $i."_pb",$origL+41,$dowho_origT+1,12,$rowheight,1,-1,17,NumToMSH( $currPly[PBLapTime]));
			openPrivButton ($DialogPrefix . $i."_wr",$origL+53,$dowho_origT+1,12,$rowheight,1,-1,17,NumToMSH( $currPly[WR]));
			openPrivButton ($DialogPrefix . $i."_pitnum",$origL+65,$dowho_origT+1,20,$rowheight,1,-1,17,$currPly[PitStops] . "(" . NumToMSH( $currPly[TotalPitTime]) . ")");
			openPrivButton ($DialogPrefix . $i."_reset",$origL+85,$dowho_origT+1,8,$rowheight,1,-1,17,$currPly[NumCarResets]);
			openPrivButton ($DialogPrefix . $i."_penalty",$origL+93,$dowho_origT+1,8,$rowheight,1,-1,17,$penalty_shortnames[$currPly[PenaltyNew]]);
			openPrivButton ($DialogPrefix . $i."_pm",$origL+101,$dowho_origT+1,8,$rowheight,1,-1,17,"^7PM",DoPmCompose);
		ENDIF
	ENDFOR
EndSub

Sub DoWho_Page1 ( $KeyFlags, $id )
	DialogClose(0,$id);
	DoWho(1);
EndSub

Sub DoWho_Page2 ( $KeyFlags, $id )
	DialogClose(0,$id);
	DoWho(2);
EndSub

Sub DoPmCompose ( $KeyFlags,$id )
	DialogClose(0,$id);
	IF ($id != "")
	THEN
		$ListOfPlayersDoWho	= GetListOfPlayers();
		$uName = $ListOfPlayersDoWho[ToNum(split( $id,"_",1 ))];
		$nName = GetPlayerVar($uName,"NickName");
		setCurrentPlayerVar( "pm_send_uname", $uName);

		# Open the PM dialog box
		$DialogPrefix = "dopm_";
		DialogCreate ( GetCurrentPlayerVar("UserName"), $DialogPrefix, 55, 50, 90, 14, "^0Message to: ^8" . $nName, FALSE, -1);
		openPrivTextButton ( $DialogPrefix . "message",56,52,88,9,5,ISB_LEFT,"^3Type message (up to 50 chars)","^3Click here to edit message",50,pm_text_input );
		openPrivButton( $DialogPrefix . "cancel",75,65,20,6,6,-1,ISB_LIGHT,"^0Cancel",DoPm_Close );
		openPrivButton( $DialogPrefix . "send",105,65,20,6,6,-1,ISB_LIGHT,"^0Send",DoPm_Send );
	ENDIF
EndSub

Sub pm_text_input ( $KeyFlags,$id )
	$uName = getCurrentPlayerVar( "pm_send_uname");
	setCurrentPlayerVar( "pm_send_message", $id);
	TextPrivButton( "dopm_message","^2" . $id );
EndSub

Sub DoPm_Send ( $KeyFlags,$id )
	DialogClose(0,$id);
	$uName = getCurrentPlayerVar( "pm_send_uname");
	$msg = getCurrentPlayerVar( "pm_send_message");
	privMsg ($uName, "^7PM from ^8" . GetCurrentPlayerVar("NickName") ."^8: " . $msg);
EndSub

Sub DoPm_Close ( $KeyFlags, $id )
	DialogClose(0,$id);
	# Reload DoWho if this was called via the Cancel button
	IF ( $id == "dopm_cancel")
	THEN
		$kWhoPageNum = getCurrentPlayerVar( "DoWhoPageNum");
		DoWho($kWhoPageNum);
	ENDIF
EndSub
