CatchEvent OnLapperStart()
	  OnLapperStart_Ctrack();
EndCatchEvent
CatchEvent OnMSO( $userName, $text ) # Player event

	$idxOfFirtsSpace = indexOf( $text, " ");
	IF( $idxOfFirtsSpace == -1 ) THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirtsSpace );
	  $argv = trim( subStr( $text,$idxOfFirtsSpace ) );
	ENDIF

	SWITCH( $command )

		CASE "!ctrack":
			IF ( UserIsAdmin( $userName ) == 1 )
			THEN
				Ctrack(0,0);
			ELSE
				privMsg(langEngine( "%{main_notadmin}%" ));
			ENDIF
			BREAK;
	ENDSWITCH
EndCatchEvent

Sub OnLapperStart_Ctrack()
	GlobalVar $track_code;
	GlobalVar $track_array;
	GlobalVar $count_track_array;
	
 	$track_array[1]="AS1";
	$track_array[2]="AS2";
	$track_array[3]="AS3";
	$track_array[4]="AS4";
	$track_array[5]="AS5";
	$track_array[6]="AS6";
	$track_array[7]="AS7";
	$track_array[8]="BL1";
	$track_array[9]="BL2";
	$track_array[10]="FE1";
	$track_array[11]="FE2";
	$track_array[12]="FE3";
	$track_array[13]="FE4";
	$track_array[14]="FE5";
	$track_array[15]="FE6";
	$track_array[16]="KY1";
	$track_array[17]="KY2";
	$track_array[18]="KY3";
	$track_array[19]="SO1";
	$track_array[20]="SO2";
	$track_array[21]="SO3";
	$track_array[22]="SO4";
	$track_array[23]="SO5";
	$track_array[24]="SO6";
	$track_array[25]="WE1";
	$track_array[26]="REV";

	$count_track_array = 25;
EndSub

Sub Ctrack ( $KeyFlags,$id )
	$left_right=18;
	$top_bottom=75;

	IF( $track_code == "" )
	THEN
	  $track_code= GetLapperVar( "ShortTrackName" );
 	ENDIF

	openPrivButton( "change_track_bg",$left_right,$top_bottom,164,67,5,-1,16,"" );
	openPrivButton( "change_track_title",$left_right+1,$top_bottom+1,162,5,5,-1,32,"^7Change track GUI - V1.06b" );

	$oldGroup = "";
	$left_right_for=-8;
	
	FOR ($i=1;$i<=$count_track_array;$i=$i+1)
		IF (substr( $track_code,3,1 ) == "R")
		THEN
		  IF (substr( $track_code,0,3 ) == $track_array[$i])
		  THEN
		    $color_2="^2";
		  ELSE
		    $color_2="^3";
		  ENDIF
		  $color="^3";
		ELSE
		  IF (substr( $track_code,0,3 ) == $track_array[$i])
		  THEN
		    $color="^2";
		  ELSE
		    $color="^3";
		  ENDIF
		  $color_2="^3";
		ENDIF
		$group = GetGroupTrack( $track_array[$i] );

		IF( $oldGroup != $group )
		THEN
		  $top_bottom_for=86;
		  $left_right_for= $left_right_for + 27;
		  $oldGroup = $group;
		  openPrivButton( "tracks_" . $group,$left_right_for,$top_bottom_for,20,5,5,-1,0,"^7" . $group );
		  $top_bottom_for= $top_bottom_for + 5;
		ENDIF
  		
		openPrivButton( "track_" . $track_array[$i] . "_ext" ,$left_right_for,$top_bottom_for,15,5,5,-1,32,"^7" . GetExtTrack( $track_array[$i] ),changeTrackWithButton );
		openPrivButton( "track_" . $track_array[$i] . "_short",$left_right_for + 15,$top_bottom_for,6,5,5,-1,32,$color . $track_array[$i], changeTrackWithButton );
		openPrivButton( "track_" . $track_array[$i] . "R_short",$left_right_for + 21,$top_bottom_for,6,5,5,-1,32,$color_2 . $track_array[$i]."R", changeTrackWithButton );
		$top_bottom_for= $top_bottom_for + 5;

		IF( $max_top_bottom < $top_bottom_for )
		THEN
		  $max_top_bottom = $top_bottom_for;
		ENDIF

	ENDFOR
	
	$top_bottom_for= $max_top_bottom + 5;
	openPrivButton( "new_track_name",$left_right+1,$top_bottom_for,81,5,5,-1,32,"^7New track name: " );
	
	IF ($track_code == "")
	THEN
	  openPrivTextButton( "new_track_name_input",$left_right+82,$top_bottom_for,81,5,5,32,"^3Track code (example: as2 or as2r (r=reversed)","^3Track code",4,track_code_input );
	ELSE
	  openPrivTextButton( "new_track_name_input",$left_right+82,$top_bottom_for,81,5,5,32,"^3Track code (example: as2 or as2r (r=reversed)","^3".$track_code,4,track_code_input );
	ENDIF
	
	openPrivButton( "close_gui",$left_right+1,$top_bottom_for+5,81,5,5,-1,32,"^3Close GUI",ctr_change_track );
	openPrivButton( "change_track",$left_right+82,$top_bottom_for+5,81,5,5,-1,32,"^3Close GUI and change track",ctr_change_track );
EndSub

Sub track_code_input ( $track_code_input )
	TextPrivButton( "track_" . $track_code . "_short","^3" . $track_code );
	$track_code=ToUpper($track_code_input);
	TextPrivButton( "track_" . $track_code . "_short","^2" . $track_code );
	TextPrivButton( "new_track_name_input","^3" . $track_code );
EndSub

Sub changeTrackWithButton( $KeyFlags,$id )
	TextPrivButton( "track_" . $track_code . "_short","^3" . $track_code );
	IF (subStr( $id, 9,1) == "R")
	THEN
	  $track_code = subStr( $id, 6,4 );
	ELSE
	  $track_code = subStr( $id, 6,3 );
	ENDIF
	TextPrivButton( "track_" . $track_code . "_short","^2" . $track_code );
	TextPrivButton( "new_track_name_input","^3" . $track_code );
EndSub

Sub ctr_change_track( $KeyFlags,$id )
	closePrivButton( "change_track_bg&change_track_title");

	FOR ($i=1;$i<=$count_track_array;$i=$i+1)
		$group = GetGroupTrack( $track_array[$i] );
		
		IF( $oldGroup != $group )
		THEN
		  $oldGroup = $group;
		  closePrivButton( "tracks_" . $group );
		ENDIF
  		
		closePrivButton( "track_" . $track_array[$i] . "R_short" );
		closePrivButton( "track_" . $track_array[$i] . "_short" );
 		closePrivButton( "track_" . $track_array[$i] . "_ext" );
	ENDFOR

	closePrivButton( "new_track_name&new_track_name_input&close_gui&change_track");
	
	IF ($id == "change_track")
	THEN
	  cmdLFS("/end");
	  openGlobalButton ("test",60,95,80,10,5,6,16,"^7Track will be changed in (%cpt%) second(s)");
	  DelayedCommand( 5, change_track_2 );
	ENDIF
EndSub

Sub change_track_2()
	cmdLFS("/track " . $track_code);
EndSub