#include "sslspawner.h"
#include <iostream>

SSLSpawner* SSLSpawner::s_me = nullptr;

SSLSpawner::SSLSpawner()
{
  /* Initialize OpenSSL */
  SSL_load_error_strings();
  ERR_load_BIO_strings();
  OpenSSL_add_all_algorithms();
}

/**
  @return SSLSpawner instance
  */
const SSLSpawner& SSLSpawner::getSpawner()
{
  if (s_me == nullptr) {
    s_me = new SSLSpawner();
  }
  
  return *s_me;
}

/**
  Creates a new SSL socket to listen on.
  
  @return SSL socket for incoming connections
  */
std::shared_ptr<InSSLConnection> SSLSpawner::newListen(const uint16_t port) const
{
  return InSSLConnection::open(port);
}

/**
  Creates a new SSL socket for outgoing connections.
  
  @return SSL socket for outgoing connections
  */
std::shared_ptr<OutSSLConnection> SSLSpawner::newRemote(const std::string& address, const uint16_t port) const
{
  return OutSSLConnection::open(address, port);
}

SSLSpawner::~SSLSpawner()
{
  delete SSLSpawner::s_me;
}