#ifndef _SSLCONNECTION_H
#define _SSLCONNECTION_H

#include <openssl/bio.h>
#include <openssl/err.h>
#include <openssl/ssl.h>
#include <memory>
#include <string>

class SSLConnection
{
  public:
    ~SSLConnection();
    int read(std::string&);
    int send(const void*, const int);

  protected:
    explicit SSLConnection(const std::string&, const uint16_t);
    BIO* m_BIO;
    std::string m_address;
    uint16_t m_port;
};

#endif