#include "sslconnection.h"
#include <iostream>
#include <memory>
#include <sstream>

SSLConnection::SSLConnection(const std::string& address, const uint16_t port) :
  m_address(address), m_port(port), m_BIO(nullptr)
{
}

/**
  Reads pending data on the socket.
  
  @param[in,out] incoming Received data stored as std::string
  @return On success returns the number of bytes read, 0 or -1 on failure.
  */
int SSLConnection::read(std::string& incoming)
{
  if (m_BIO == nullptr) {
    std::cerr << "ERROR: Connection has not been opened!" << std::endl;
    return -1;
  }
  char* recvbuf = new char[512];
  
  int ret = BIO_read(m_BIO, recvbuf, 512);
  if (ret <= 0) {
    std::cerr << "Error reading data from SSL!" << std::endl;
    delete[] recvbuf;
    return 0;
  }
  
  std::cout << "Received stream: " << recvbuf << std::endl;
  incoming = recvbuf;
  delete[] recvbuf;
  
  return ret;
}

/**
  Sends a chunk of data to the remote host
  
  @param[in] data Pointer to the data to be sent
  @param[in] length How many bytes to send
  
  @return On success returns the number of bytes sent, 0 or -1 on failure.
  */
int SSLConnection::send(const void* data, const int length)
{
  if (m_BIO == nullptr) {
    std::cerr << "ERROR: Connection has not been opened!" << std::endl;
    return -1;
  }
  int ret = BIO_write(m_BIO, data, length);
  if (ret <= 0) {
    std::cerr << "Error sending data via SSL!" << std::endl;
    return 0;
  }

  return ret;
}

SSLConnection::~SSLConnection()
{
  if (m_BIO != nullptr)
    BIO_free(m_BIO);
}