#include "insimiface.h"
#include <utility>

InSimIFace::InSimIFace(BanKeeper* const bansys) : m_banSystem(bansys)
{
}

/**
  Creates a new connection to InSim.
  
  @param[in] address Address of the InSim server we want to connect to
  @param[in] port Port on which the InSim server is listening
  @param[in] pass Admin password
  @return True on success, false otherwise
  */
bool InSimIFace::addConnectionToInSim(const std::string& address, const uint16_t port, const std::string& pass)
{
    std::shared_ptr<InSimConnection> pConn(new InSimConnection(address, port, pass, m_banSystem));
    if (pConn->connect()) {
      m_inSimConns.push_back(pConn);
      return true;
    }
    
    return false;
}

/**
  Disconnects all active InSim connections
  
  @return Always true
  */
bool InSimIFace::disconnectAll()
{
  std::vector<std::shared_ptr<InSimConnection>>::iterator it;
  for (it = m_inSimConns.begin(); it != m_inSimConns.end(); it++) {
    (*it)->disconnect();
  }
  
  return true;
}

InSimIFace::~InSimIFace()
{
  disconnectAll();
}