#ifndef _INSIMCONNECTION_H
#define _INSIMCONNECTION_H

#include "../bansystem/bankeeper.h"
#include "cinsim/cinsim.h"
#include <atomic>
#include <map>
#include <thread>

class InSimConnection {
  public:
    explicit InSimConnection(const std::string&, const uint16_t, const std::string&, BanKeeper* const);
    ~InSimConnection();
    bool connect();
    void disconnect();

  private:
    void on_IS_NCN(struct IS_NCN*);
    void on_IS_CNL(struct IS_CNL*);
    void recvFunc();
    
    const std::string m_address;
    const std::string m_adminPass;
    BanKeeper* const m_banSystem;
    std::atomic<bool> m_canRun;
    CInsim m_cis;
    const uint16_t m_port;
    std::thread m_recvWorker;
    std::map<uint8_t, std::string> m_UCIDxUName;
};

#endif