#ifndef _BANKEEPER_H
#define _BANKEEPER_H

#include "bandb.h"
#include "banexchanger.h"
#include "localbanstorage.h"

class BanKeeper {
  public:
    explicit BanKeeper();
    bool initialize(uint16_t);
    bool shutdown();
    
    bool banPlayer(std::string&);
    bool isBanned(std::string&);
    bool unbanPlayer(std::string&);

  private:
    std::shared_ptr<BanDB> m_bandb;
    BanExchanger m_exchanger;
    LocalBanStorage m_localStorage;
};

#endif