#ifndef _BANEXCHANGER_H
#define _BANEXCHANGER_H

#include "bandb.h"
#include "../ssl_layer/sslspawner.h"
#include <vector>

class BanExchanger {
  public:
    explicit BanExchanger(std::shared_ptr<BanDB>);
    bool announceBan(std::string&);
    bool receiveBan(std::string&);
    bool initialize(uint16_t);

  private:
    typedef struct {
      std::string address;
      uint16_t port;
    } Peer;
    bool loadPeers();
    template <typename T> T strToNum(const std::string&);

    std::shared_ptr<BanDB> m_bandb;
    std::vector<std::shared_ptr<OutSSLConnection>> m_connections;
    std::shared_ptr<InSSLConnection> m_listening;
    std::vector<Peer> m_peers;
};

#endif