#include "bandb.h"
#include <iostream>

BanDB::BanDB() : m_bannedUNames(new std::vector<std::string>)
{
}

bool BanDB::addBan(std::string& uname)
{
  std::lock_guard<std::mutex> grd(m_dbLock);
  if (contains(uname))	/* This username is already banned here */
    return true;
  else {
    try {
      m_bannedUNames->push_back(uname);
    } catch (std::bad_alloc ex) {
      std::cerr << "Insufficient memory to add username to database: " << ex.what() << std::endl;
      return false;
    }
    
    std::cout << "Banned username \"" << uname << "\"" << std::endl;
    return true;
  }
}

bool BanDB::contains(std::string& uname)
{
  std::vector<std::string>::iterator it;
  for (it = m_bannedUNames->begin(); it != m_bannedUNames->end(); it++) {
    if (it->compare(uname) == 0)
      return true;
  }
  return false; 
}

int BanDB::indexOf(std::string& uname)
{
  int idx = 0;
  std::vector<std::string>::iterator it;
  for (it = m_bannedUNames->begin(); it != m_bannedUNames->end(); it++, idx++) {
    if (it->compare(uname) == 0)
      return idx;
  }
  
  return -1;
}

bool BanDB::isBanned(std::string& uname)
{
  std::lock_guard<std::mutex> grd(m_dbLock);
  return contains(uname);
}

bool BanDB::removeBan(std::string& uname)
{
  std::lock_guard<std::mutex> grd(m_dbLock);
  int idx = indexOf(uname);
  if (idx < 0)	/* No such user in the database */
    return false;
  else {
    m_bannedUNames->erase(m_bannedUNames->begin() + idx);
    return true;
  }
}

void BanDB::walkThrough(std::function<void(const std::string&)> f)
{
  std::lock_guard<std::mutex> grd(m_dbLock);
  std::vector<std::string>::iterator it;
  for (it = m_bannedUNames->begin(); it != m_bannedUNames->end(); it++) {
    f(*it);
  }
}