#ifndef _SSLSPAWNER_H
#define _SSLSPAWNER_H

#include "insslconnection.h"
#include "outsslconnection.h"
#include <memory>

class SSLSpawner
{
  public:
    static const SSLSpawner& getSpawner();
    std::shared_ptr<InSSLConnection> newListen(uint16_t) const;
    std::shared_ptr<OutSSLConnection> newRemote(const std::string&, const uint16_t) const;
    
  private:
    explicit SSLSpawner();
    explicit SSLSpawner(const SSLSpawner&);
    SSLSpawner& operator=(const SSLSpawner&) = delete;
    ~SSLSpawner();
    
    static SSLSpawner* s_me;
};

#endif