#ifndef _INSSLCONNECTION_H
#define _INSSLCONNECTION_H

#include "sslconnection.h"
#include <atomic>
#include <thread>

class InSSLConnection : public SSLConnection
{
  public:
    ~InSSLConnection();
    void listen();
    static std::shared_ptr<InSSLConnection> open(const uint16_t);

  private:
    explicit InSSLConnection(const uint16_t);
    int readIncoming(BIO*, std::string&);
    void recvLoop();
    
    std::thread m_recvWorker;
    std::atomic<bool> m_canRun;
};

#endif