#include "bansystem/bankeeper.h"
#include "insimiface/insimiface.h"
#include <memory>
#include <iostream>


int main(int argc, char** argv)
{
  uint16_t lPort = 0;	// Port to listen on
  uint16_t isPort = 0;	// Port where the InSim is running
  if (argc == 3) {
    lPort = static_cast<uint16_t>(atoi(argv[1]));
    isPort = static_cast<uint16_t>(atoi(argv[2]));
  } else {
    std::cout << "Usage: BanDamme <listen on port> <InSim port>" << std::endl;
    return 1;
  }

  BanKeeper keeper;
  InSimIFace insim(&keeper);

  if (!keeper.initialize(lPort)) {
    std::cerr << "Initialization not successful" << std::endl;
    return 1;
  }
  std::cout << "BanSystem initialization complete" << std::endl;

  if (!insim.addConnectionToInSim("127.0.0.1", isPort, "")) {
    std::cout << "Failed to connect to InSim" << std::endl;
    return 1;
  }

  getchar();
  insim.disconnectAll();
  keeper.shutdown();
  return 0;
}