#include "insimconnection.h"
#include <future>
#include <iostream>

InSimConnection::InSimConnection(const std::string& address, const uint16_t port, const std::string& pass, BanKeeper* const banSys) :
  m_address(address),
  m_port(port),
  m_adminPass(pass),
  m_banSystem(banSys),
  m_canRun(true)
{
}

/**
  Attempts to open connection to InSim server.
  
  @return True on success, false otherwise
  */
bool InSimConnection::connect()
{
  if (m_banSystem == nullptr) {
    std::cout << "NULL pointer to BanSystem" << std::endl;
    return false;
  }
  if (m_cis.init(m_address.c_str(), static_cast<word>(m_port), "BanHammer", m_adminPass.c_str()) != 0) {
    std::cout << "Error connecting to LFS" << std::endl;
    return false;
  }
  
  //TODO: Check IS_VER
  m_recvWorker = std::thread(&InSimConnection::recvFunc, this);
  return true;
}

/**
  Tell the receiving loop to end.
  */
void InSimConnection::disconnect()
{
  m_canRun = false;
}

/**
  New player has connected, check if he is banned.
  
  @param[in] pkt IS_NCN packet
  */
void InSimConnection::on_IS_NCN(struct IS_NCN* pkt)
{
  std::string uname(pkt->UName);
  std::cout << uname <<std::endl;
  
  if (m_banSystem->isBanned(uname)) {
    std::cout << "This " << uname << " guy is banned!" << std::endl;
    return;
  }
  
  m_UCIDxUName[pkt->UCID] = uname;
}

/**
  Player has left, check if he was banned.
  
  @param[in] pkt IS_CNL packet
  */
void InSimConnection::on_IS_CNL(struct IS_CNL* pkt)
{
  if (pkt->Reason == LEAVR_BANNED) {
    std::string uname = m_UCIDxUName[pkt->UCID];
    m_banSystem->banPlayer(uname);
    std::cout << "Banning " << uname << " (UCID: " << int(pkt->UCID) << ")" << std::endl;
  }
}

/**
  InSim receiving loop.
  */
void InSimConnection::recvFunc()
{
  while (m_canRun) {
    /* Get the next packet in line */
    if (m_cis.next_packet() < 0) {
      std::cerr << "Error talking with InSim" << std::endl;
      break;
    }
    
    switch (m_cis.peek_packet()) {
      case ISP_NCN:
	std::cout << "IS_NCN" << std::endl;
	on_IS_NCN(static_cast<struct IS_NCN*>(m_cis.get_packet()));
	break;
      case ISP_CNL:
	std::cout << "IS_CNL" << std::endl;
	on_IS_CNL(static_cast<struct IS_CNL*>(m_cis.get_packet()));
	break;
      default:
	std::cout << "Unhandled packet" << std::endl;
	break;
    }
  }
  
  m_cis.isclose();
}

InSimConnection::~InSimConnection()
{
  if (m_recvWorker.joinable()) {
    m_canRun = false;
    m_recvWorker.join();
  }
}