#include "localbanstorage.h"
#include <algorithm>
#include <fstream>
#include <iostream>

LocalBanStorage::LocalBanStorage(std::shared_ptr<BanDB> p) : m_bandb(p)
{
}

bool LocalBanStorage::loadBans()
{
  std::ifstream banFile;
  banFile.open("bans.txt");
  if (!banFile.is_open()) {
    std::cerr << "Cannot open local ban database." << std::endl;
    return false;
  }
  
  while (banFile.good()) {
    std::string uname;
    std::getline(banFile, uname);
    std::transform(uname.begin(), uname.end(), uname.begin(), ::tolower);
    m_bandb->addBan(uname);
  }
  
  banFile.close();
  
  return true;
}

bool LocalBanStorage::saveBans()
{
  std::shared_ptr<std::ofstream> banFile(new std::ofstream);
  banFile->open("bans.txt", std::ios::trunc);
  if (!banFile->is_open()) {
    std::cerr << "Cannot open local ban database for writing." << std::endl;
    return false;
  }
  
  m_bandb->walkThrough([banFile](const std::string& s) {
    *banFile << s.c_str() << std::endl;
  });
  
  banFile->close();
}