#ifndef _BANDB_H
#define _BANDB_H

#include <memory>
#include <mutex>
#include <vector>

class BanDB {
  public:
    explicit BanDB();
    bool addBan(std::string&);
    bool isBanned(std::string&);
    bool removeBan(std::string&);
    void walkThrough(std::function<void(const std::string&)>);
    
  private:
    int indexOf(std::string&);
    bool contains(std::string&);
    std::unique_ptr<std::vector<std::string>> m_bannedUNames;
    std::mutex m_dbLock;
};

#endif