//  
//  NodeEvent.cs
//  
//  Author:
//       Robert BRACCAGNI alias Gai-Luron <lfsgailuron@free.fr>
// 
//  Copyright (c) 2010 Gai-Luron
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.

using System;
using System.Collections;
using System.Text;

namespace LFSLapper
{
    class NodeEvent
    {
        int node;
		public string commandEnter = "";
		public string commandLeave = "";
		public string idTask = "";
		public NodeEvent(string pidTask, int pnode, string pcommandEnter, string pcommandLeave)
        {
            node = pnode;
			commandEnter = pcommandEnter;
			commandLeave = pcommandLeave;
			idTask = pidTask;
        }
    }
    class ListNodeEvent
    {
        System.Collections.Hashtable listOfNodes = new System.Collections.Hashtable();
        Hashtable currArNode = null;

		public void Add(string idTask, string trackName, int node, string commandEnter, string commandLeave)
        {
            if (!listOfNodes.ContainsKey(trackName))
            {
                listOfNodes[trackName] = new Hashtable();
            }
			(listOfNodes[trackName] as Hashtable)[node] = new NodeEvent(idTask, node, commandEnter, commandLeave );
        }
		public string getCommandNodeEnter(string trackName, int node)
		{
			if (!listOfNodes.ContainsKey(trackName))
				return "";
			currArNode = (Hashtable)listOfNodes[trackName];
			if (currArNode != null && node != -1 && currArNode.ContainsKey(node))
			{
				return (currArNode[node] as NodeEvent).commandEnter;
			}
			return "";
		}
		public string getCommandNodeLeave(string trackName, int node)
		{
			if (!listOfNodes.ContainsKey(trackName))
				return "";
			currArNode = (Hashtable)listOfNodes[trackName];
			if (currArNode != null && node != -1 && currArNode.ContainsKey(node))
			{
				return (currArNode[node] as NodeEvent).commandLeave;
			}
			return "";
		}
		public void Remove(string idTask, string trackName)
		{
			currArNode = (Hashtable)listOfNodes[trackName];
			bool removed = false;
			while (true)
			{
				removed = false;
				foreach (DictionaryEntry de in currArNode)
				{
					if ((de.Value as NodeEvent).idTask == idTask)
					{
						currArNode.Remove(de.Key);
						removed = true;
						break;
					}
				}
				if (removed == false)
					break;
			}
		}
	}
}
