#############################################################################
# Race Pitboard by Yisc[NL]
#############################################################################
#############################################################################################################################
# Pitboard V2.05	21-06-11	Added option to set wether to show the Pitboard config screen on connect or not			    #
# Pitboard V2.05b	22-06-11	Removed double entry for BL1 , Changed structure looking up trackname for number of splits	#
# Pitboard V2.06b	22-03-12	Converted to use CIF - Krayy																#
#############################################################################################################################

CatchEvent OnLapperStart()
	# CifRegisterModule("Group_Name", "Module Name", MODULE_VERSION);
	CifRegisterModule("Config", "Pitboard", "1.00");

	# Pitboard Display type: 0 = off, 1 = text, 2 = Graphical
	GlobalVar $PB_OFF;  $PB_OFF  = 0; # Pitboard is off
	GlobalVar $PB_TEXT; $PB_TEXT = 1; # Pitboard displayed as text
	GlobalVar $PB_GUI;  $PB_GUI  = 2; # Pitboard displayed as GUI

	### Pitboard ####
	GlobalVar $user_array;
	GlobalVar $pitboard_offset;
	GlobalVar $pitboard_hight;
	GlobalVar $splits_value;
	GlobalVar $qualify;
	$pitboard_offset="";
	$pitboard_hight="";
	$splits_value="";
	$qualify=FALSE;
	### End ###

	### Pitwindow GUI ###
	GlobalVar $left_right_pw_gui;
	GlobalVar $top_bottom_pw_gui;
	GlobalVar $number_of_windows;
	GlobalVar $number_of_stops_w1;
	GlobalVar $number_of_stops_w2;
	GlobalVar $number_of_stops_w3;
	GlobalVar $penalty_laps;
	GlobalVar $force_tyre_change;
	GlobalVar $start_window_1;
	GlobalVar $end_window_1;
	GlobalVar $start_window_2;
	GlobalVar $end_window_2;
	GlobalVar $start_window_3;
	GlobalVar $end_window_3;
	
	$left_right_pw_gui=70;
	$top_bottom_pw_gui=70;
	$number_of_windows="";
	$number_of_stops_w1="";
	$number_of_stops_w2="";
	$number_of_stops_w3="";
	$penalty_laps="";
	$force_tyre_change="No";
	$start_window_1="";
	$end_window_1="";
	$start_window_2="";
	$end_window_2="";
	$start_window_3="";
	$end_window_3="";
	### End ###
EndCatchEvent

Event OnConnect( $userName ) # Player event
	$NickName = GetCurrentPlayerVar("NickName");
	$Posabs = GetCurrentPlayerVar("PosAbs");
	$Groupqual = GetCurrentPlayerVar("GroupQual");

	openPrivButton( "welc",25,50,150,15,12,-1,ISB_NONE, langEngine("%{main_welc1}%", $NickName ) );
	openPrivButton( "pos",25,80,150,10,8,-1,ISB_NONE,langEngine("%{main_welc2}%",$Posabs,$Posqual,$Groupqual  ) );
	openPrivButton( "clos",78,120,20,10,10,-1,ISB_DARK,langEngine("%{main_accept}%"),OnConnectClosePB );
	openPrivButton( "ref",103,120,20,10,10,-1,ISB_DARK,langEngine("%{main_deny}%"),OnConnectCloseKickPB );
EndEvent

Sub OnConnectClosePB( $KeyFlags,$id )
	closePrivButton("welc&pos&clos&ref");
	config_pb_default_settings(0,0);
	# Display the GUI every time we connect by default
	IF ( GetUserStoredNum ("config_pb_display_gui_on_startup") != 0 )
	THEN
		SetUserStoredNum ("config_pb_display_gui_on_startup", 1);
		DoCifConfigPitboard(0,0);
	ENDIF
EndSub

Sub OnConnectCloseKickPB( $KeyFlags,$id )
	closePrivButton("welc&pos&clos&ref");
	cmdLFS("/kick " . GetCurrentPlayerVar("UserName") );
EndSub

CatchEvent OnNewPlayerJoin( $userName ) # Player event
	OnNewPlayerJoin_Pitboard();
EndCatchEvent

CatchEvent OnNewGapPlayerBefore( $userName,$split ) # Player Event
	OnNewGapPlayerBefore_Pitboard( $split );
EndCatchEvent

CatchEvent OnNewGapPlayerBehind( $userName,	$split ) # Player Event
	OnNewGapPlayerBehind_Pitboard( $split );
EndCatchEvent

CatchEvent OnSpbSplit1( $userName ) # Player event
	### Do actions in first lap of qualify/race ###
	IF ( GetCurrentPlayerVar( "LapsDone" ) == 0)
	THEN
		OnSpbSplit_Pitboard_Lap1( );
	ENDIF
	OnSpbSplit_Pitboard(1);
EndCatchEvent

CatchEvent OnSpbSplit2( $userName ) # Player event
	OnSpbSplit_Pitboard(2);
EndCatchEvent

CatchEvent OnSpbSplit3( $userName ) # Player event
	OnSpbSplit_Pitboard(3);
EndCatchEvent

CatchEvent OnSpbLast( $userName ) # Player event
	OnSpbSplit_Pitboard(0);
#	OnSpbLast_Pitboard();
EndCatchEvent

CatchEvent OnMSO( $userName, $text ) # Player event
	$idxOfFirtsSpace = indexOf( $text, " ");

	IF( $idxOfFirtsSpace == -1 ) THEN
		$command = $text;
		$argv = "";
	ELSE
		$command = subStr( $text,0,$idxOfFirtsSpace );
		$argv = trim( subStr( $text,$idxOfFirtsSpace ) );
	ENDIF

	SWITCH( $command )
		CASE "!closepb":
			pitboardClose( );
			BREAK;
		CASE "!config":
			DoCifConfigPitboard(0,0);
			BREAK;
		CASE "!pitwindow":
			pitwindowOpen( );
			BREAK;
	ENDSWITCH
EndCatchEvent

CatchEvent OnRaceStart( $NumP ) # Lapper event
	DelayedCommand( 5, ORS_Pitboard );
EndCatchEvent

CatchEvent OnEndPit( $userName ) # Player event
	OnEndPit_Pitboard();
EndCatchEvent

Sub ORS_Pitboard()
	OnRaceStart_Pitboard();
EndSub

Sub OnConnect_Pitboard() # Player event
	### Add UserName to $user_array together with $number_of_stops ###
	FOR ($i=1;$i<=32;$i=$i+1)
		IF ($user_array[$i,1] == "")
		THEN
			$user_array[$i,1] = GetCurrentPlayerVar( "UserName" );
			$user_array[$i,2] = $number_of_stops_w1;
			$user_array[$i,3] = $number_of_stops_w2;
			$user_array[$i,4] = $number_of_stops_w3;
			$user_array[$i,5] = GetCurrentPlayerVar( "NickName" ); # Store Nickname to be used in the !connected event
			$user_array[$i,6] = 1; # Initial value for player status (0 = ready , 1 = not ready , 2 = spectator)
			$user_array[$i,7] = 0; # Initial value for pitlane exit (0 = not done , 1 = done)
			$user_array[$i,8] = 0; # Initial value for start qualify (0 = not done , 1 = done)
			BREAK;
		ENDIF
	ENDFOR
	### End ###

EndSub

Sub OnNewPlayerJoin_Pitboard()
	### Determine number of splits on current track and set corresponding offset value ###
	$myShortTrackName = getLapperVar( "ShortTrackName" );
	IF ( $myShortTrackName == "FE4" || $myShortTrackName == "FE4R" || $myShortTrackName == "AS6" || $myShortTrackName == "AS6R" || $myShortTrackName == "AS7" || $myShortTrackName == "AS7R")
	THEN
		$pitboard_offset = 37;
		$pitboard_hight = 50;
		$splits_value= 4;
	ELSE
		IF ( $myShortTrackName == "BL1" || $myShortTrackName == "BL1R" || $myShortTrackName == "SO4" || $myShortTrackName == "SO4R" || $myShortTrackName == "SO5" || $myShortTrackName == "SO5R" || $myShortTrackName == "FE2" || $myShortTrackName == "FE2R" || $myShortTrackName == "FE3" || $myShortTrackName == "FE3R" || $myShortTrackName == "KY2" || $myShortTrackName == "KY2R" || $myShortTrackName == "KY3" || $myShortTrackName == "KY3R" || $myShortTrackName == "WE1" || $myShortTrackName == "WE1R" || $myShortTrackName == "AS4" || $myShortTrackName == "AS4R" || $myShortTrackName == "AS5" || $myShortTrackName == "AS5R")
		THEN
			$pitboard_offset = 29;
			$pitboard_hight = 42;
			$splits_value= 3;
		ELSE
			IF ( $myShortTrackName == "BL2" || $myShortTrackName == "BL2R" || $myShortTrackName =="SO1" || $myShortTrackName == "SO1R" || $myShortTrackName == "SO2" || $myShortTrackName == "SO2R" || $myShortTrackName == "SO3" || $myShortTrackName == "SO3R" || $myShortTrackName == "SO6" || $myShortTrackName == "SO6R" || $myShortTrackName == "FE1" || $myShortTrackName == "FE1R" || $myShortTrackName == "FE5" || $myShortTrackName == "FE5R" || $myShortTrackName == "FE6" || $myShortTrackName == "FE6R" || $myShortTrackName == "KY1" || $myShortTrackName == "KY1R" || $myShortTrackName == "AS1" || $myShortTrackName == "AS1R" || $myShortTrackName == "AS2" || $myShortTrackName == "AS2R" || $myShortTrackName == "AS3" || $myShortTrackName == "AS3R")
			THEN
				$pitboard_offset = 21;
				$pitboard_hight = 42;
				$splits_value= 2;
			ENDIF
		ENDIF
	ENDIF
	### End

	IF ( GetCurrentPlayerVar( "config_pb_display_mode") == $PB_GUI )
	THEN
		### Display: Nickname, Start PW, End PW, Stops and their values ###
		IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == TRUE)
		THEN
			openPrivButton( "pitboard_total",GetCurrentPlayerVar ( "pb_left_right_coordinate"),GetCurrentPlayerVar ( "pb_top_bottom_coordinate"),32,$pitboard_hight+4,5,-1,32,"");
		ELSE
			openPrivButton( "pitboard_total",GetCurrentPlayerVar ( "pb_left_right_coordinate"),GetCurrentPlayerVar ( "pb_top_bottom_coordinate"),32,$pitboard_hight,5,-1,32,"");
		ENDIF
		openPrivButton( "pitboard_txt",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+1,30,4,4,-1,0,"^7Pitboard:^0 " . GetCurrentPlayerVar( "NickName" ) );
	
		openPrivButton( "pitboard_start_pitwindow",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+5,10,4,4,-1,16,"^2Start PW:");
		openPrivButton( "pitboard_end_pitwindow",GetCurrentPlayerVar ( "pb_left_right_coordinate")+11,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+5,10,4,4,-1,16,"^1End PW:");
		openPrivButton( "pitboard_pw_stops",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+5,10,4,4,-1,16,"^7Stops: ");

		IF ($number_of_windows != "" && $qualify == FALSE)
		THEN
			FOR ($i=1;$i<=32;$i=$i+1)
				IF ($user_array[$i,1] == GetCurrentPlayerVar( "UserName" ) )
				THEN
					closePrivButton( "pitboard_no_pitwindow");

					IF ($number_of_windows == 1 && $qualify == FALSE)
					THEN
						openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_1);
						openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+11,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_1);
						openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,2] );
					ENDIF

					IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == FALSE)
					THEN
						openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_1);
						openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+11,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_1);
						openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,2] );
					ELSE
						IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && $qualify == FALSE)
						THEN
							openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_2);
							openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+11,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_2);
							openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,3] );
						ENDIF
					ENDIF

					IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == FALSE)
					THEN
						openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_1);
						openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+11,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_1);
						openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,2] );
					ELSE
						IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_2)
						THEN
							openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_2);
							openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+11,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_2);
							openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,3] );
						ELSE
							IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_2)
							THEN
								openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_3);
								openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+11,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_3);
								openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,4] );
							ENDIF
						ENDIF
					ENDIF
				ENDIF
			ENDFOR
		ELSE
			IF ($number_of_windows == "" || $qualify == TRUE)
			THEN
				closePrivButton( "pitboard_start_pitwindow_lap&pitboard_end_pitwindow_lap&pitboard_number_of_stops" );
				openPrivButton( "pitboard_no_pitwindow",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,30,4,4,-1,16,"^7No pitwindow");
			ENDIF
		ENDIF
		### END ###
	ENDIF
EndSub

Sub OnNewGapPlayerBefore_Pitboard( $split )
	IF ( GetCurrentPlayerVar ( "pb_left_right_coordinate") != -1 && GetCurrentPlayerVar ( "pb_top_bottom_coordinate") != -1 )
	THEN
		### Check if UNameBefore is empty or not ### 
		IF( GetCurrentPlayerVar( "UNameBefore" ) != "" )
		THEN
			### Check if race is ON and splits is ON ###
			IF ( GetCurrentPlayerVar( "config_pb_race" ) == TRUE && ( GetCurrentPlayerVar( "config_pb_race_splits" ) == TRUE ) )
			THEN
				SWITCH ($split)
					CASE 1:
						$splitnumber="1";
						$extra_tb=17;
					CASE 2:
						$splitnumber="2";
						$extra_tb=25;
					CASE 3:
						$splitnumber="3";
						$extra_tb=33;
					CASE 4:
						$splitnumber="Last";
						$extra_tb=$pitboard_offset+4;
				ENDSWITCH

				$Before_split=NumToMSH(GetPlayerVar( GetCurrentPlayerVar( "UNameBefore" ),"SectorSplit" . $splitnumber ));

				IF ( $Before_split > NumToMSH(GetCurrentPlayerVar( "SectorSplit" . $splitnumber )) )
				THEN
					$Before_split="^2".$Before_split;
				ELSE
					$Before_split="^1".$Before_split;
				ENDIF

				openPrivButton( "pitboard_before_sector_" . $splitnumber,GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$extra_tb,10,4,4,-1,16, $Before_split );
			### END ###
			ELSE
				### Check if race is ON and gaps is ON ###
				IF ( GetCurrentPlayerVar( "config_pb_race" ) == TRUE && ( GetCurrentPlayerVar( "config_pb_race_gaps" ) == TRUE ) )
				THEN
					IF ($split == 1)
					THEN
						SetCurrentPlayerVar( "Before_gap_1", GetCurrentPlayerVar( "GapBefore" ) );
						IF ( GetCurrentPlayerVar( "Before_gap_last" ) != "")
						THEN
							IF ( GetCurrentPlayerVar( "Before_gap_1" ) >= GetCurrentPlayerVar( "Before_gap_last" ) )
							THEN
								openPrivButton( "pitboard_before_sector_1",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+17,10,4,4,-1,16,"^1" . GetCurrentPlayerVar( "Before_gap_1" ) );
							ELSE
								openPrivButton( "pitboard_before_sector_1",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+17,10,4,4,-1,16,"^2" . GetCurrentPlayerVar( "Before_gap_1" ) );
							ENDIF
						ELSE
							openPrivButton( "pitboard_before_sector_1",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+17,10,4,4,-1,16,"^7" . GetCurrentPlayerVar( "Before_gap_1" ) );
						ENDIF
					ENDIF

					IF ($split == 2)
					THEN
						SetCurrentPlayerVar( "Before_gap_2", GetCurrentPlayerVar( "GapBefore" ) );
						IF ( GetCurrentPlayerVar( "Before_gap_2" ) >= GetCurrentPlayerVar( "Before_gap_1" ) )
						THEN
							openPrivButton( "pitboard_before_sector_2",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+25,10,4,4,-1,16,"^1" . GetCurrentPlayerVar( "Before_gap_2" ) );
						ELSE
							openPrivButton( "pitboard_before_sector_2",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+25,10,4,4,-1,16,"^2" . GetCurrentPlayerVar( "Before_gap_2" ) );
						ENDIF
					ENDIF

					IF ($split == 3)
					THEN
						SetCurrentPlayerVar( "Before_gap_3", GetCurrentPlayerVar( "GapBefore" ) );
						IF ( GetCurrentPlayerVar( "Before_gap_3" ) >= GetCurrentPlayerVar( "Before_gap_2" ) )
						THEN
							openPrivButton( "pitboard_before_sector_3",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+33,10,4,4,-1,16,"^1" . GetCurrentPlayerVar( "Before_gap_3" ) );
						ELSE
							openPrivButton( "pitboard_before_sector_3",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+33,10,4,4,-1,16,"^2" . GetCurrentPlayerVar( "Before_gap_3" ) );
						ENDIF
					ENDIF

					IF ($split == 4)
					THEN
						SetCurrentPlayerVar( "Before_gap_last", GetCurrentPlayerVar( "GapBefore" ) );
						IF ( $splits_value == 4 )
						THEN
							IF ( GetCurrentPlayerVar( "Before_gap_last" ) >= GetCurrentPlayerVar( "Before_gap_3" ))
							THEN
								$Color_gap_before="^1";
							ELSE
								$Color_gap_before="^2";
							ENDIF
						ENDIF

						IF ( $splits_value == 3 )
						THEN
							IF ( GetCurrentPlayerVar( "Before_gap_last" ) >= GetCurrentPlayerVar( "Before_gap_2" ) )
							THEN
								$Color_gap_before="^1";
							ELSE
								$Color_gap_before="^2";
							ENDIF
						ENDIF

						IF ( $splits_value == 2 )
						THEN
							IF ( GetCurrentPlayerVar( "Before_gap_last" ) >= GetCurrentPlayerVar( "Before_gap_1" ) )
							THEN
								$Color_gap_before="^1";
							ELSE
								$Color_gap_before="^2";
							ENDIF
						ENDIF

						openPrivButton( "pitboard_before_sector_last",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$pitboard_offset+4,10,4,4,-1,16,$Color_gap_before . GetCurrentPlayerVar( "Before_gap_last" ) );
					ENDIF
				ENDIF
				### END ###
			ENDIF
		ELSE
			### Check if race is ON ###
			IF ( GetCurrentPlayerVar( "config_pb_race" ) == TRUE )
			THEN
				IF ($split == 1)
				THEN
					openPrivButton( "pitboard_before_sector_1",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+17,10,4,4,-1,16,"" );
				ENDIF

				IF ($split == 2)
				THEN
					openPrivButton( "pitboard_before_sector_2",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+25,10,4,4,-1,16,"" );
				ENDIF

				IF ($split == 3)
				THEN
					openPrivButton( "pitboard_before_sector_3",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+33,10,4,4,-1,16,"" );
				ENDIF

				IF ($split == 4)
				THEN
					openPrivButton( "pitboard_before_sector_last",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$pitboard_offset+4,10,4,4,-1,16,"" );
				ENDIF
			ENDIF
		ENDIF
	ENDIF
EndSub

Sub OnNewGapPlayerBehind_Pitboard( $split )
	IF ( GetCurrentPlayerVar ( "pb_left_right_coordinate") != -1 && GetCurrentPlayerVar ( "pb_top_bottom_coordinate") != -1 )
	THEN
		### Check if UNameBehind is empty or not ###
		IF( GetCurrentPlayerVar( "UNameBehind" ) != "" )
		THEN
			### Check if race is ON and splits is ON ###
			IF ( GetCurrentPlayerVar( "config_pb_race" ) == TRUE && ( GetCurrentPlayerVar( "config_pb_race_splits" ) == TRUE ) )
			THEN
				SWITCH ($split)
					CASE 1:
						$splitnumber="1";
						$extra_tb=17;
					CASE 2:
						$splitnumber="2";
						$extra_tb=25;
					CASE 3:
						$splitnumber="3";
						$extra_tb=33;
					CASE 4:
						$splitnumber="Last";
						$extra_tb=$pitboard_offset+4;
				ENDSWITCH

				$Behind_split=NumToMSH(GetPlayerVar( GetCurrentPlayerVar( "UNameBehind" ),"SectorSplit" . $splitnumber ));

				IF ( $Behind_split > NumToMSH(GetCurrentPlayerVar( "SectorSplit" . $splitnumber )) )
				THEN
					$Behind_split="^2".$Behind_split;
				ELSE
					$Behind_split="^1".$Behind_split;
				ENDIF

				openPrivButton( "pitboard_behind_sector_" . $splitnumber,GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$extra_tb,10,4,4,-1,16, $Behind_split );
				### END ###
			ELSE
				### Check if race is ON and gaps is ON ###
				IF ( GetCurrentPlayerVar( "config_pb_race" ) == TRUE && ( GetCurrentPlayerVar( "config_pb_race_gaps" ) == TRUE ) )
				THEN
					IF ($split == 1)
					THEN
						SetCurrentPlayerVar( "Behind_gap_1", GetCurrentPlayerVar( "GapBehind" ) );
						IF ( GetCurrentPlayerVar( "Behind_gap_last" ) != "")
						THEN
							IF ( GetCurrentPlayerVar( "Behind_gap_1" ) >= GetCurrentPlayerVar( "Behind_gap_last" ) )
							THEN
								openPrivButton( "pitboard_behind_sector_1",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+17,10,4,4,-1,16,"^2" . GetCurrentPlayerVar( "Behind_gap_1" ) );
							ELSE
								openPrivButton( "pitboard_behind_sector_1",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+17,10,4,4,-1,16,"^1" . GetCurrentPlayerVar( "Behind_gap_1" ) );
							ENDIF
						ELSE
							openPrivButton( "pitboard_behind_sector_1",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+17,10,4,4,-1,16,"^7" . GetCurrentPlayerVar( "Behind_gap_1" ) );
						ENDIF
					ENDIF

					IF ($split == 2)
					THEN
						SetCurrentPlayerVar( "Behind_gap_2", GetCurrentPlayerVar( "GapBehind" ) );
						IF ( GetCurrentPlayerVar( "Behind_gap_2" ) >= GetCurrentPlayerVar( "Behind_gap_1" ))
						THEN
							openPrivButton( "pitboard_behind_sector_2",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+25,10,4,4,-1,16,"^2" . GetCurrentPlayerVar( "Behind_gap_2" ) );
						ELSE
							openPrivButton( "pitboard_behind_sector_2",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+25,10,4,4,-1,16,"^1" . GetCurrentPlayerVar( "Behind_gap_2" ) );
						ENDIF
					ENDIF

					IF ($split == 3)
					THEN
						SetCurrentPlayerVar( "Behind_gap_3", GetCurrentPlayerVar( "GapBehind" ) );
						IF ( GetCurrentPlayerVar( "Behind_gap_3" ) >= GetCurrentPlayerVar( "Behind_gap_2" ) )
						THEN
							openPrivButton( "pitboard_behind_sector_3",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+33,10,4,4,-1,16,"^2" . GetCurrentPlayerVar( "Behind_gap_3" ) );
						ELSE
							openPrivButton( "pitboard_behind_sector_3",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+33,10,4,4,-1,16,"^1" . GetCurrentPlayerVar( "Behind_gap_3" ) );
						ENDIF
					ENDIF

					IF ($split == 4)
					THEN
						SetCurrentPlayerVar( "Behind_gap_last", GetCurrentPlayerVar( "GapBehind" ) );
						IF ( $splits_value == 4 )
						THEN
							IF ( GetCurrentPlayerVar( "Behind_gap_last" ) >= GetCurrentPlayerVar( "Behind_gap_3" ) )
							THEN
								$Color_gap_behind="^2";
							ELSE
								$Color_gap_behind="^1";
							ENDIF
						ENDIF

						IF ( $splits_value == 3 )
						THEN
							IF ( GetCurrentPlayerVar( "Behind_gap_last" ) >= GetCurrentPlayerVar( "Behind_gap_2" ) )
							THEN
								$Color_gap_behind="^2";
							ELSE
								$Color_gap_behind="^1";
							ENDIF
						ENDIF

						IF ( $splits_value == 2 )
						THEN
							IF ( GetCurrentPlayerVar( "Behind_gap_last" ) >= GetCurrentPlayerVar( "Behind_gap_1" ) )
							THEN
								$Color_gap_behind="^2";
							ELSE
								$Color_gap_behind="^1";
							ENDIF
						ENDIF

						openPrivButton( "pitboard_behind_sector_last",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$pitboard_offset+4,10,4,4,-1,16,$Color_gap_behind . GetCurrentPlayerVar( "Behind_gap_last" ) );
					ENDIF
				ENDIF
			ENDIF
			### END ####
		ELSE
			### Check if race is ON ###
			IF ( GetCurrentPlayerVar( "config_pb_race" ) == TRUE )
			THEN
				IF ($split == 1)
				THEN
					openPrivButton( "pitboard_behind_sector_1",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+17,10,4,4,-1,16,"" );
				ENDIF

				IF ($split == 2)
				THEN
					openPrivButton( "pitboard_behind_sector_2",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+25,10,4,4,-1,16,"" );
				ENDIF

				IF ($split == 3)
				THEN
					openPrivButton( "pitboard_behind_sector_3",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+33,10,4,4,-1,16,"" );
				ENDIF

				IF ($split == 4)
				THEN
					openPrivButton( "pitboard_behind_sector_last",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$pitboard_offset+4,10,4,4,-1,16,"" );
				ENDIF
			ENDIF
		ENDIF
	ENDIF
EndSub

Sub OnSpbSplit_Pitboard_Lap1( ) # Player event
	### Do actions in first lap of qualify/race ###
	### Clear values of last practice/qualify/race ###
	SetCurrentPlayerVar("Lastsplit1","");
	SetCurrentPlayerVar("Lastsplit2","");
	SetCurrentPlayerVar("Lastsplit3","");
	SetCurrentPlayerVar("Lastsplitlast","");
	SetCurrentPlayerVar("Information","");
	SetCurrentPlayerVar("Information_2","");
	### End ###

	### Set penalty check and laps to orginal value ###
	SetCurrentPlayerVar( "Penalty_check","false");
	SetCurrentPlayerVar( "Penalty_laps",$penalty_laps);
	### End ###

	### Close buttons for sector 2,3,last and information ###
	closePrivButton( "pitboard_current_sector_2_txt&pitboard_last_sector_2_txt&pitboard_best_sector_2_txt");
	closePrivButton( "pitboard_current_sector_2&pitboard_last_sector_2&pitboard_best_sector_2" );
	closePrivButton( "pitboard_before_sector_2&pitboard_behind_sector_2&pitboard_before_sector_3&pitboard_behind_sector_3&pitboard_before_sector_last&pitboard_behind_sector_last" );
	closePrivButton( "pitboard_current_sector_3_txt&pitboard_last_sector_3_txt&pitboard_best_sector_3_txt");
	closePrivButton( "pitboard_current_sector_3&pitboard_last_sector_3&pitboard_best_sector_3" );
	closePrivButton( "pitboard_current_sector_last_txt&pitboard_last_sector_last_txt&pitboard_best_sector_last_txt");
	closePrivButton( "pitboard_current_sector_last&pitboard_last_sector_last&pitboard_best_sector_last" );
	closePrivButton( "pitboard_information&pitboard_information_2" ); 
	### End ###

	### Display Pitlane status in case Pitlane is opened from lap 1 ####
	IF ( GetCurrentPlayerVar("Information") == "" )
	THEN
		IF ( $qualify == FALSE && GetCurrentPlayerVar( "LapsDone" ) == $start_window_1-1 || GetCurrentPlayerVar( "LapsDone" ) == $start_window_2-1 || GetCurrentPlayerVar( "LapsDone" ) == $start_window_3-1 )
		THEN
			SetCurrentPlayerVar("Information","^2Pitlane open^8");
		ELSE
			IF ( $qualify == FALSE && GetCurrentPlayerVar( "LapsDone" ) == $end_window_1 || GetCurrentPlayerVar( "LapsDone" ) == $end_window_2 || GetCurrentPlayerVar( "LapsDone" ) == $end_window_3 )
			THEN
				SetCurrentPlayerVar("Information","^1Pitlane closed^8");
			ENDIF
		ENDIF
	ENDIF
	### End ###
EndSub

Sub OnSpbSplit_Pitboard( $splitNum ) # Player event
	### Get value Penalty_laps ###
	$Player_penalty_laps = GetCurrentPlayerVar("Penalty_laps");
	### End ##

	### Set colors when current S1 is best S1 or within set limit of best S1 ###
	IF ( GetCurrentPlayerVar("IsBestSectorSplit1") == 1)
	THEN
		$Color_split1 = "^2";
		SetCurrentPlayerVar("Lastsplit1_color","^1" );
		IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == TRUE)
		THEN
			IF ( GetCurrentPlayerVar("Information_2") == "")
			THEN
				SetCurrentPlayerVar("Information_2", "^2you've gained^7: " . NumToMSH(GetCurrentPlayerVar( "DiffSectorSplit1" )) );
			ENDIF
		ENDIF
	ELSE
		IF ( GetCurrentPlayerVar("IsBestSectorSplit1") == 0)
		THEN
			IF ( NumToMSH(GetCurrentPlayerVar( "SectorSplit1" )) <= NumToMSH(GetCurrentPlayerVar("BestSectorSplit1")+GetCurrentPlayerVar ("split_setting")) )
			THEN
				$Color_split1 = "^3";
				IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == TRUE)
				THEN
					IF ( GetCurrentPlayerVar("Information_2") == "")
					THEN
						SetCurrentPlayerVar("Information_2", "^3you're on/within your best split" );
					ENDIF
				ENDIF
			ELSE
				$Color_split1 = "^1";
				IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == TRUE)
				THEN
					IF ( GetCurrentPlayerVar("Information_2") == "")
					THEN
						SetCurrentPlayerVar("Information_2", "^1you've lost^7: " . NumToMSH(GetCurrentPlayerVar( "DiffSectorSplit1" )) );
					ENDIF
				ENDIF
			ENDIF
		ENDIF
	ENDIF
	### End ###

	### Set Information when it's empty and when spb_setting is set to "splits" ###
	IF ( GetCurrentPlayerVar( "spb_setting" ) == "splits")
	THEN
		IF ( GetCurrentPlayerVar("Information") == "" )
		THEN
			IF ( GetCurrentPlayerVar("IsBestSectorSplit1") == 1 )
			THEN
				SetCurrentPlayerVar("Information","^2 Best possible lap is: " . NumToMSH(GetCurrentPlayerVar("Tpb")) );
			ENDIF
		ENDIF
	ENDIF
	### End ###

	IF ($safetycar_status == "out" || $safetycar_status == "in" )
		THEN
			closePrivButton( "pitboard_current_sector_1_txt&pitboard_last_sector_1_txt&pitboard_best_sector_1_txt");
			closePrivButton( "pitboard_current_sector_1&pitboard_last_sector_1&pitboard_best_sector_1" );
			closePrivButton( "pitboard_before_sector_1&pitboard_behind_sector_1" );
			closePrivButton( "pitboard_current_sector_2_txt&pitboard_last_sector_2_txt&pitboard_best_sector_2_txt");
			closePrivButton( "pitboard_current_sector_2&pitboard_last_sector_2&pitboard_best_sector_2" );
			closePrivButton( "pitboard_before_sector_2&pitboard_behind_sector_2");
			closePrivButton( "pitboard_current_sector_3_txt&pitboard_last_sector_3_txt&pitboard_best_sector_3_txt");
			closePrivButton( "pitboard_current_sector_3&pitboard_last_sector_3&pitboard_best_sector_3" );
			closePrivButton( "pitboard_before_sector_3&pitboard_behind_sector_3");
			closePrivButton( "pitboard_current_sector_last_txt&pitboard_last_sector_last_txt&pitboard_best_sector_last_txt");
			closePrivButton( "pitboard_current_sector_last&pitboard_last_sector_last&pitboard_best_sector_last" );
			closePrivButton( "pitboard_before_sector_last&pitboard_behind_sector_last" );
			closePrivButton( "pitboard_information&pitboard_information_2" );
			closePrivButton( "pitboard_safetycar_message_1&pitboard_safetycar_message_2&pitboard_safetycar_message_3" );
			openPrivButton( "pitboard_safetycar_bg",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+13,30,28,4,-1,16,"" );
			openPrivButton( "pitboard_safetycar_message_1",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+13,30,14,4,-1,0, $safetycar_message_1 );
			openPrivButton( "pitboard_safetycar_message_2",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+27,30,7,4,-1,0, $safetycar_message_2 );
			openPrivButton( "pitboard_safetycar_message_3",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+34,30,7,4,-1,0, $safetycar_message_3 );
		ELSE
			### Display values Curr S1, Last S1, Best S1 ###
			closePrivButton( "pitboard_safetycar_bg&pitboard_safetycar_message_1&pitboard_safetycar_message_2&pitboard_safetycar_message_3" );

			IF ( GetCurrentPlayerVar( "config_pb_race" ) == FALSE )
			THEN
				openPrivButton( "pitboard_current_sector_1_txt",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+13,10,4,4,-1,16,"^7Curr S1:");
				openPrivButton( "pitboard_last_sector_1_txt",GetCurrentPlayerVar ( "pb_left_right_coordinate")+11,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+13,10,4,4,-1,16,"^7Last S1:");
				openPrivButton( "pitboard_best_sector_1_txt",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+13,10,4,4,-1,16,"^7Best S1:");

				IF ( GetCurrentPlayerVar("IsBestSectorSplit1") == 1)
				THEN
					openPrivButton( "pitboard_best_sector_1",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+17,10,4,4,-1,16,"^7" . NumToMSH(GetCurrentPlayerVar( "SectorSplit1" )) );
				ELSE
					openPrivButton( "pitboard_best_sector_1",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+17,10,4,4,-1,16,"^7" . NumToMSH(GetCurrentPlayerVar( "BestSectorSplit1" )) );
				ENDIF
	  
				openPrivButton( "pitboard_current_sector_1",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+17,10,4,4,-1,16,$Color_split1 . NumToMSH(GetCurrentPlayerVar( "SectorSplit1" )) );
				openPrivButton( "pitboard_last_sector_1",GetCurrentPlayerVar ( "pb_left_right_coordinate")+11,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+17,10,4,4,-1,16,GetCurrentPlayerVar( "Lastsplit1_color" ) . GetCurrentPlayerVar( "Lastsplit1" ) );
			ELSE
				openPrivButton( "pitboard_current_sector_1_txt",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+13,10,4,4,-1,16,"^7Fr S1:");
				openPrivButton( "pitboard_last_sector_1_txt",GetCurrentPlayerVar ( "pb_left_right_coordinate")+11,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+13,10,4,4,-1,16,"^7Own S1:");
				openPrivButton( "pitboard_best_sector_1_txt",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+13,10,4,4,-1,16,"^7Bh S1:");

				openPrivButton( "pitboard_current_sector_1",GetCurrentPlayerVar ( "pb_left_right_coordinate")+11,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+17,10,4,4,-1,16,$Color_split1 . NumToMSH(GetCurrentPlayerVar( "SectorSplit1" )) );
			ENDIF
			### End ###

			openPrivButton( "pitboard_information",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$pitboard_offset+8,30,4,4,-1,16,GetCurrentPlayerVar("Information") );
			SetCurrentPlayerVar("Information","");
	    
			IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == TRUE)
			THEN
				openPrivButton( "pitboard_information_2",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$pitboard_offset+12,30,4,4,-1,16,GetCurrentPlayerVar("Information_2") );
				SetCurrentPlayerVar("Information_2","");
			ENDIF
		ENDIF
	ELSE
		IF ( GetCurrentPlayerVar( "config_pb_display_mode" ) == $PB_TEXT )
		THEN
			### Text mode messages when Safetycar is on track ###
			IF ($safetycar_status == "out" || $safetycar_status == "in" )
			THEN
				IF ($number_of_windows != "" && $qualify == FALSE)
				THEN
					FOR ($i=1;$i<=32;$i=$i+1)
						IF ($user_array[$i,1] == GetCurrentPlayerVar( "UserName" ) )
						THEN
							IF ($number_of_windows == 1 && $qualify == FALSE)
							THEN
								PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
							ENDIF

							IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == FALSE)
							THEN
								PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
							ELSE
								IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && $qualify == FALSE)
								THEN
									PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
								ENDIF
							ENDIF

							IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == FALSE)
							THEN
								PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
							ELSE
								IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_2)
								THEN
									PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
								ELSE
									IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_2)
									THEN
										PrivMsg ("^7Pitwindow start: ^2L" . $start_window_3 . " ^7| end: ^1L" . $end_window_3 . " ^7| stops: " . $user_array[$i,4]);
									ENDIF
								ENDIF
							ENDIF
						ENDIF
					ENDFOR
				ELSE
					IF ($number_of_windows == "" || $qualify == TRUE)
					THEN
						PrivMsg ("^7No Pitwindow set");
					ENDIF
				ENDIF

				PrivMsg ("^7INF: " . $safetycar_message_1 );
				PrivMsg ("^7INF: " . $safetycar_message_2 );
				PrivMsg ("^7INF: " . $safetycar_message_3 );
				### End ###
			ELSE
				### Text-mode when people choose not to use the Pitboard ###
				IF ( GetCurrentPlayerVar("IsBestSectorSplit1") == 1)
				THEN
					PrivMsg ("^7CS1: " . $Color_split1 . NumToMSH(GetCurrentPlayerVar( "SectorSplit1" )) . " ^7| LS1: " . GetCurrentPlayerVar( "Lastsplit1_color" ) . GetCurrentPlayerVar( "Lastsplit1" ) . " ^7| BS1: " . NumToMSH(GetCurrentPlayerVar( "SectorSplit1" )) );	
				ELSE
					PrivMsg ("^7CS1: " . $Color_split1 . NumToMSH(GetCurrentPlayerVar( "SectorSplit1" )) . " ^7| LS1: " . GetCurrentPlayerVar( "Lastsplit1_color" ) . GetCurrentPlayerVar( "Lastsplit1" ) . " ^7| BS1: " . NumToMSH(GetCurrentPlayerVar( "BestSectorSplit1" )) );
				ENDIF

				IF ($number_of_windows != "" && $qualify == FALSE)
				THEN
					FOR ($i=1;$i<=32;$i=$i+1)
						IF ($user_array[$i,1] == GetCurrentPlayerVar( "UserName" ) )
						THEN
							IF ($number_of_windows == 1 && $qualify == FALSE)
							THEN
								PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
							ENDIF

							IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == FALSE)
							THEN
								PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
							ELSE
								IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && $qualify == FALSE)
								THEN
									PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
								ENDIF
							ENDIF

							IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == FALSE)
							THEN
								PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
							ELSE
								IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_2)
								THEN
									PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
								ELSE
									IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_2)
									THEN
										PrivMsg ("^7Pitwindow start: ^2L" . $start_window_3 . " ^7| end: ^1L" . $end_window_3 . " ^7| stops: " . $user_array[$i,4]);
									ENDIF
								ENDIF
							ENDIF
						ENDIF
					ENDFOR
				ELSE
					IF ($number_of_windows == "" || $qualify == TRUE)
					THEN
						PrivMsg ("^7No Pitwindow set");
					ENDIF
				ENDIF

				PrivMsg ("^7INF: " . GetCurrentPlayerVar("Information") );
				PrivMsg ("^7INF: " . GetCurrentPlayerVar("Information_2") );
				SetCurrentPlayerVar("Information_2","");
				IF ( GetCurrentPlayerVar("Information" ) != " ^1!!! ^0Black ^7flag in ^0" . $Player_penalty_laps . " ^7lap(s) ^1!!! " )
				THEN
					SetCurrentPlayerVar("Information","");
				ENDIF
				### End ###
			ENDIF
		ENDIF
	ENDIF

	### Store value last SectorSplit1 ###
	SetCurrentPlayerVar("Lastsplit1_color",$Color_split1 );
	SetCurrentPlayerVar("Lastsplit1", NumToMSH(GetCurrentPlayerVar( "SectorSplit1" )) );
	### End ###

EndSub

Sub OnSpbLast_Pitboard() # Player event

	$Penalty_check = GetCurrentPlayerVar("Penalty_check");
	$Player_penalty_laps = GetCurrentPlayerVar("Penalty_laps");
	$Lapsdone = GetCurrentPlayerVar( "LapsDone" )+0; ### extra code to convert LapsDone to numerical value ###

	### Check if Pitstop is done before the end of Pitwindow 1,2,3 ###
	### If not, set Penalty_check to true ###
	### If Penalty_check is true, reduce Penalty_laps by one ###
	### If Penalty_laps is zero, spectate player ###
	FOR ($i=1;$i<=32;$i=$i+1)
		IF ($user_array[$i,1] == GetCurrentPlayerVar( "UserName" ) )
		THEN
		  IF ($number_of_windows == 1 && $qualify == FALSE)
		  THEN
		    IF ($end_window_3 != "" && $Lapsdone >= $end_window_3)
		    THEN
		      IF ($user_array[$i,4] != 0)
		      THEN
		        IF ($Penalty_check == "false")
		        THEN
		          cmdLFS("/p_sg " . GetCurrentPlayerVar( "UserName" ) );
			  $Penalty_check="true_window_3";
			  SetCurrentPlayerVar("Penalty_check",$Penalty_check);
		        ELSE
		          $Player_penalty_laps=$Player_penalty_laps-1;
			  SetCurrentPlayerVar("Penalty_laps",$Player_penalty_laps);
			  IF ($Player_penalty_laps == 0)
			  THEN
			    cmdLFS ("/spec " . GetCurrentPlayerVar( "UserName" ) );
			  ENDIF
		        ENDIF
		      ENDIF
		    ELSE
		      IF ($end_window_2 != "" && $Lapsdone >= $end_window_2)
		      THEN
		        IF ($user_array[$i,3] != 0)
		        THEN
		          IF ($Penalty_check == "false")
			  THEN
			    cmdLFS("/p_sg " . GetCurrentPlayerVar( "UserName" ) );
			    $Penalty_check="true_window_2";
			    SetCurrentPlayerVar("Penalty_check",$Penalty_check);
			  ELSE
			    $Player_penalty_laps=$Player_penalty_laps-1;
			    SetCurrentPlayerVar("Penalty_laps",$Player_penalty_laps);
			    IF ($Player_penalty_laps == 0)
			    THEN
			      cmdLFS ("/spec " . GetCurrentPlayerVar( "UserName" ) );
			    ENDIF
			  ENDIF
		        ENDIF
		      ELSE
		        IF ($end_window_1 != "" && $Lapsdone >= $end_window_1)
		        THEN
		          IF ($user_array[$i,2] != 0)
			  THEN
			    IF ($Penalty_check == "false")
			    THEN
			      cmdLFS("/p_sg " . GetCurrentPlayerVar( "UserName" ) );
			      $Penalty_check="true_window_1";
			      SetCurrentPlayerVar("Penalty_check",$Penalty_check);
			    ELSE
			      $Player_penalty_laps=$Player_penalty_laps-1;
			      SetCurrentPlayerVar("Penalty_laps",$Player_penalty_laps);
			      IF ($Player_penalty_laps == 0)
			      THEN
			        cmdLFS ("/spec " . GetCurrentPlayerVar( "UserName" ) );
			      ENDIF
			    ENDIF
			  ENDIF
		        ENDIF
		      ENDIF
		    ENDIF
		  ENDIF

		  IF ( GetCurrentPlayerVar( "config_pb_display_mode" ) == $PB_GUI )
		  THEN
		    IF ($number_of_windows == 1 && $qualify == FALSE)
		    THEN
		      openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_1);
		      openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+11,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_1);
		      openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,2] );
		    ENDIF

		    IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == FALSE)
		    THEN
		      openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_1);
		      openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+11,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_1);
		      openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,2] );
		    ELSE
		      IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && $qualify == FALSE)
		      THEN
		        openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_2);
		        openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+11,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_2);
		        openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,3] );
		      ENDIF
		    ENDIF

		    IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == FALSE)
		    THEN
		      openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_1);
		      openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+11,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_1);
		      openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,2] );
		    ELSE
		      IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_2)
		      THEN
		        openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_2);
		        openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+11,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_2);
		        openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,3] );
		      ELSE
		        IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_2)
		        THEN
		          openPrivButton( "pitboard_start_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^2Lap " . $start_window_3);
		          openPrivButton( "pitboard_end_pitwindow_lap",GetCurrentPlayerVar ( "pb_left_right_coordinate")+11,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^1Lap " . $end_window_3);
		          openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,4] );
		        ENDIF
		      ENDIF
		    ENDIF
		  ENDIF

		  ### Set information about Black flag or Pitlane status and display information button ###
		  IF ($Penalty_check == "true_window_1" || $Penalty_check == "true_window_2" || $Penalty_check == "true_window_3")
		  THEN
		    SetCurrentPlayerVar("Information"," ^1!!! ^0Black ^7flag in ^0" . $Player_penalty_laps . " ^7lap(s) ^1!!! ");
		  ENDIF

		  IF ( GetCurrentPlayerVar("Information") == "" )
		  THEN
		    IF ( $qualify == FALSE && GetCurrentPlayerVar( "LapsDone" ) == $start_window_1-1 || GetCurrentPlayerVar( "LapsDone" ) == $start_window_2-1 || GetCurrentPlayerVar( "LapsDone" ) == $start_window_3-1 )
		    THEN
		      SetCurrentPlayerVar("Information","^2Pitlane open^8");
		    ELSE
		      IF ( $qualify == FALSE && GetCurrentPlayerVar( "LapsDone" ) == $end_window_1 || GetCurrentPlayerVar( "LapsDone" ) == $end_window_2 || GetCurrentPlayerVar( "LapsDone" ) == $end_window_3 )
		      THEN
		        SetCurrentPlayerVar("Information","^1Pitlane closed^8");
		      ENDIF
		    ENDIF
		  ENDIF
		    
		  IF ( GetCurrentPlayerVar( "spb_setting" ) == "splits")
		  THEN
		    IF ( GetCurrentPlayerVar("Information") == "" )
		    THEN
		      IF ( GetCurrentPlayerVar("IsBestSectorSplitLast") == 1 )
		      THEN
		        SetCurrentPlayerVar("Information","^2 Best possible lap is: " . NumToMSH(GetCurrentPlayerVar("Tpb")) );
		      ENDIF
		    ENDIF
		  ELSE
		    IF ( GetCurrentPlayerVar("Information") == "" )
		    THEN
		      IF ( GetCurrentPlayerVar("IsBestSectorSplit1") == 1 || GetCurrentPlayerVar("IsBestSectorSplit2") == 1	|| GetCurrentPlayerVar("IsBestSectorSplit3") == 1 || GetCurrentPlayerVar("IsBestSectorSplitLast") == 1 )
		      THEN
		        SetCurrentPlayerVar("Information","^2 Best possible lap is: " . NumToMSH(GetCurrentPlayerVar("Tpb")) );
		      ENDIF
		    ENDIF
		  ENDIF
		  ### End ###

		  IF ( GetCurrentPlayerVar( "config_pb_display_mode" ) == $PB_GUI )
		  THEN
		    openPrivButton( "pitboard_information",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$pitboard_offset+8,30,4,4,-1,16,GetCurrentPlayerVar("Information") );
		    IF ( GetCurrentPlayerVar("Information" ) != " ^1!!! ^0Black ^7flag in ^0" . $Player_penalty_laps . " ^7lap(s) ^1!!! " )
		    THEN
		      SetCurrentPlayerVar("Information","");
		    ENDIF
		  ENDIF
	        ENDIF
	ENDFOR
	### End ###

	### Set colors when current S1 is best S1 or within set limit of best S1 ###
	IF ( GetCurrentPlayerVar("IsBestSectorSplitLast") == 1)
	THEN
	  $Color_splitlast = "^2";
	  SetCurrentPlayerVar("Lastsplitlast_color","^1" );
	  IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == TRUE)
	  THEN
	    IF ( GetCurrentPlayerVar("Information_2") == "")
	    THEN
	      SetCurrentPlayerVar("Information_2", "^2you've gained^7: " . NumToMSH(GetCurrentPlayerVar( "DiffSectorSplitLast" )) );
	    ENDIF
	  ENDIF
	ELSE
	  IF ( GetCurrentPlayerVar("IsBestSectorSplitLast") == 0)
	  THEN
	    IF ( NumToMSH(GetCurrentPlayerVar( "SectorSplitLast" )) <= NumToMSH(GetCurrentPlayerVar("BestSectorSplitLast")+GetCurrentPlayerVar ("split_setting")) )
	    THEN
	      $Color_splitlast = "^3";
	      IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == TRUE)
	      THEN
	        IF ( GetCurrentPlayerVar("Information_2") == "")
		THEN
		  SetCurrentPlayerVar("Information_2", "^3you're on/within your best split" );
		ENDIF
	      ENDIF
	    ELSE
	      $Color_splitlast = "^1";
	      IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == TRUE)
	      THEN
	        IF ( GetCurrentPlayerVar("Information_2") == "")
		THEN
		  SetCurrentPlayerVar("Information_2", "^1you've lost^7: " . NumToMSH(GetCurrentPlayerVar( "DiffSectorSplitLast" )) );
		ENDIF
	      ENDIF
	    ENDIF
	  ENDIF
	ENDIF
	### End ###

	IF ( GetCurrentPlayerVar( "config_pb_display_mode" ) == $PB_GUI )
	THEN
	  IF ($safetycar_status == "out" || $safetycar_status == "in" )
	  THEN
	    closePrivButton( "pitboard_current_sector_1_txt&pitboard_last_sector_1_txt&pitboard_best_sector_1_txt");
	    closePrivButton( "pitboard_current_sector_1&pitboard_last_sector_1&pitboard_best_sector_1" );
	    closePrivButton( "pitboard_before_sector_1&pitboard_behind_sector_1" );
	    closePrivButton( "pitboard_current_sector_2_txt&pitboard_last_sector_2_txt&pitboard_best_sector_2_txt");
	    closePrivButton( "pitboard_current_sector_2&pitboard_last_sector_2&pitboard_best_sector_2" );
	    closePrivButton( "pitboard_before_sector_2&pitboard_behind_sector_2");
	    closePrivButton( "pitboard_current_sector_3_txt&pitboard_last_sector_3_txt&pitboard_best_sector_3_txt");
	    closePrivButton( "pitboard_current_sector_3&pitboard_last_sector_3&pitboard_best_sector_3" );
	    closePrivButton( "pitboard_before_sector_3&pitboard_behind_sector_3");
	    closePrivButton( "pitboard_current_sector_last_txt&pitboard_last_sector_last_txt&pitboard_best_sector_last_txt");
	    closePrivButton( "pitboard_current_sector_last&pitboard_last_sector_last&pitboard_best_sector_last" );
	    closePrivButton( "pitboard_before_sector_last&pitboard_behind_sector_last" );
	    closePrivButton( "pitboard_information&pitboard_information_2" );
	    closePrivButton( "pitboard_safetycar_message_1&pitboard_safetycar_message_2&pitboard_safetycar_message_3" );
	    openPrivButton( "pitboard_safetycar_bg",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+13,30,28,4,-1,16,"" );
	    openPrivButton( "pitboard_safetycar_message_1",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+13,30,14,4,-1,0, $safetycar_message_1 );
	    openPrivButton( "pitboard_safetycar_message_2",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+27,30,7,4,-1,0, $safetycar_message_2 );
	    openPrivButton( "pitboard_safetycar_message_3",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+34,30,7,4,-1,0, $safetycar_message_3 );
	  ELSE
	    ### Display Curr last, Last last, Best last and their values ###
	    closePrivButton( "pitboard_safetycar_bg&pitboard_safetycar_message_1&pitboard_safetycar_message_2&pitboard_safetycar_message_3" );

	    IF ( GetCurrentPlayerVar( "config_pb_race" ) == FALSE )
	    THEN
	      openPrivButton( "pitboard_current_sector_last_txt",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$pitboard_offset,10,4,4,-1,16,"^7Curr S" . $splits_value . ":" );
	      openPrivButton( "pitboard_last_sector_last_txt",GetCurrentPlayerVar ( "pb_left_right_coordinate")+11,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$pitboard_offset,10,4,4,-1,16,"^7Last S" . $splits_value . ":");
	      openPrivButton( "pitboard_best_sector_last_txt",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$pitboard_offset,10,4,4,-1,16,"^7Best S" . $splits_value . ":");

	      IF ( GetCurrentPlayerVar("IsBestSectorSplitLast") == 1)
	      THEN
	        openPrivButton( "pitboard_best_sector_last",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$pitboard_offset+4,10,4,4,-1,16,"^7" . NumToMSH(GetCurrentPlayerVar( "SectorSplitLast" )) );
	      ELSE
	        openPrivButton( "pitboard_best_sector_last",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$pitboard_offset+4,10,4,4,-1,16,"^7" . NumToMSH(GetCurrentPlayerVar( "BestSectorSplitLast" )) );
	      ENDIF

	      openPrivButton( "pitboard_current_sector_last",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$pitboard_offset+4,10,4,4,-1,16,$Color_splitlast . NumToMSH(GetCurrentPlayerVar( "SectorSplitLast" )) );
	      openPrivButton( "pitboard_last_sector_last",GetCurrentPlayerVar ( "pb_left_right_coordinate")+11,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$pitboard_offset+4,10,4,4,-1,16,GetCurrentPlayerVar( "Lastsplitlast_color" ) . GetCurrentPlayerVar( "Lastsplitlast" ) );
	    ELSE
	      openPrivButton( "pitboard_current_sector_last_txt",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$pitboard_offset,10,4,4,-1,16,"^7Fr S" . $splits_value . ":" );
	      openPrivButton( "pitboard_last_sector_last_txt",GetCurrentPlayerVar ( "pb_left_right_coordinate")+11,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$pitboard_offset,10,4,4,-1,16,"^7Own S" . $splits_value . ":");
	      openPrivButton( "pitboard_best_sector_last_txt",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$pitboard_offset,10,4,4,-1,16,"^7Bh S" . $splits_value . ":");

	      openPrivButton( "pitboard_current_sector_last",GetCurrentPlayerVar ( "pb_left_right_coordinate")+11,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$pitboard_offset+4,10,4,4,-1,16,$Color_splitlast . NumToMSH(GetCurrentPlayerVar( "SectorSplitLast" )) );
	    ENDIF
	    ### End ###

	    IF ( GetCurrentPlayerVar( "lost_gained_messages" ) == TRUE)
	    THEN
	      openPrivButton( "pitboard_information_2",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$pitboard_offset+12,30,4,4,-1,16,GetCurrentPlayerVar("Information_2") );
	      SetCurrentPlayerVar("Information_2","");
	    ENDIF
	  ENDIF
	ELSE
	  IF ( GetCurrentPlayerVar( "config_pb_display_mode" ) == $PB_TEXT )
	  THEN
	    ### Text mode messages when Safetycar is on track ###
	    IF ($safetycar_status == "out" || $safetycar_status == "in" )
	    THEN
	      IF ($number_of_windows != "" && $qualify == FALSE)
	      THEN
	        FOR ($i=1;$i<=32;$i=$i+1)
		    IF ($user_array[$i,1] == GetCurrentPlayerVar( "UserName" ) )
		    THEN
		      IF ($number_of_windows == 1 && $qualify == FALSE)
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ENDIF

		      IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == FALSE)
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ELSE
		        IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && $qualify == FALSE)
		        THEN
		          PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
		        ENDIF
		      ENDIF

		      IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == FALSE)
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ELSE
		        IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_2)
		        THEN
		          PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
		        ELSE
		          IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_2)
		          THEN
		            PrivMsg ("^7Pitwindow start: ^2L" . $start_window_3 . " ^7| end: ^1L" . $end_window_3 . " ^7| stops: " . $user_array[$i,4]);
		          ENDIF
		        ENDIF
		      ENDIF
		    ENDIF
 	        ENDFOR
	      ELSE
	        IF ($number_of_windows == "" || $qualify == TRUE)
	        THEN
	          PrivMsg ("^7No Pitwindow set");
	        ENDIF
	      ENDIF

	      PrivMsg ("^7INF: " . $safetycar_message_1 );
	      PrivMsg ("^7INF: " . $safetycar_message_2 );
	      PrivMsg ("^7INF: " . $safetycar_message_3 );
	      ### End ###
	    ELSE
	      ### Text-mode when people choose not to use the Pitboard ###
	      IF ( GetCurrentPlayerVar("IsBestSectorSplitLast") == 1)
	      THEN
	        PrivMsg ("^7CS" . $splits_value . ": " . $Color_splitlast . NumToMSH(GetCurrentPlayerVar( "SectorSplitLast" )) . " ^7| LS" . $splits_value . ": " . GetCurrentPlayerVar( "Lastsplitlast_color" ) . GetCurrentPlayerVar( "Lastsplitlast" ) . " ^7| BS" . $splits_value . ": " . NumToMSH(GetCurrentPlayerVar( "SectorSplitLast" )) );  
	      ELSE
	        PrivMsg ("^7CS" . $splits_value . ": " . $Color_splitlast . NumToMSH(GetCurrentPlayerVar( "SectorSplitLast" )) . " ^7| LS" . $splits_value . ": " . GetCurrentPlayerVar( "Lastsplitlast_color" ) . GetCurrentPlayerVar( "Lastsplitlast" ) . " ^7| BS" . $splits_value . ": " . NumToMSH(GetCurrentPlayerVar( "BestSectorSplitLast" )) );
	      ENDIF

	      IF ($number_of_windows != "" && $qualify == FALSE)
	      THEN
	        FOR ($i=1;$i<=32;$i=$i+1)
		    IF ($user_array[$i,1] == GetCurrentPlayerVar( "UserName" ) )
		    THEN
		      IF ($number_of_windows == 1 && $qualify == FALSE)
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ENDIF

		      IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == FALSE)
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ELSE
		        IF ($number_of_windows == 2 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && $qualify == FALSE)
		        THEN
		          PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
		        ENDIF
		      ENDIF

		      IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1 && $qualify == FALSE)
		      THEN
		        PrivMsg ("^7Pitwindow start: ^2L" . $start_window_1 . " ^7| end: ^1L" . $end_window_1 . " ^7| stops: " . $user_array[$i,2]);
		      ELSE
		        IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_2)
		        THEN
		          PrivMsg ("^7Pitwindow start: ^2L" . $start_window_2 . " ^7| end: ^1L" . $end_window_2 . " ^7| stops: " . $user_array[$i,3]);
		        ELSE
		          IF ($number_of_windows == 3 && GetCurrentPlayerVar( "LapsDone" ) >= $end_window_2)
		          THEN
		            PrivMsg ("^7Pitwindow start: ^2L" . $start_window_3 . " ^7| end: ^1L" . $end_window_3 . " ^7| stops: " . $user_array[$i,4]);
		          ENDIF
		        ENDIF
		      ENDIF
		    ENDIF
 	        ENDFOR
	      ELSE
	        IF ($number_of_windows == "" || $qualify == TRUE)
	        THEN
	          PrivMsg ("^7No Pitwindow set");
	        ENDIF
	      ENDIF

	      PrivMsg ("^7INF: " . GetCurrentPlayerVar("Information") );
	      PrivMsg ("^7INF: " . GetCurrentPlayerVar("Information_2") );
	      SetCurrentPlayerVar("Information_2","");
	      IF ( GetCurrentPlayerVar("Information" ) != " ^1!!! ^0Black ^7flag in ^0" . $Player_penalty_laps . " ^7lap(s) ^1!!! " )
	      THEN
	        SetCurrentPlayerVar("Information","");
	      ENDIF
	      ### End ###
	    ENDIF
	  ENDIF
	ENDIF

	### Store value last SectorSplitLast ###
	SetCurrentPlayerVar("Lastsplitlast_color",$Color_splitlast );
	SetCurrentPlayerVar("Lastsplitlast", NumToMSH(GetCurrentPlayerVar( "SectorSplitLast" )) );
	### End ###

EndSub

####### Drawing the Pitboard configuration screen #######

Sub DoCifConfigPitboard ( $KeyFlags, $id )
	# Set default values for the module - these MUST be the same as the main Do function name
	$cifGroupName="Config";
	$cifModuleName="Pitboard";
	$DialogPrefix = "CIF" . $cifGroupName . $cifModuleName . "_";

	# Draw the CIF dialog box
	CifDraw($cifGroupName, $cifModuleName, "Pitboard Configuration");

	$origT = $CifOrigT+1;			# Top edge of main content window
	$origL = $CifOrigL+26;	# Left edge of main content window
	
#	pitboardClose( );
#	pitboardConfigBackground( );

	### Selection Config screen on/off ###
	openPrivButton ($DialogPrefix . "config_screen_label",$origL,$origT,48,$CifRowHeight,1,-1,32,"^7Show config screen on connect: ");
	$origT = $origT + $CifRowHeight;
	
	### Selection Config screen on/off ###
	IF ( GetUserStoredNum ("config_pb_display_gui_on_startup") != FALSE )
	THEN
		openPrivButton( $DialogPrefix . "config_screen-on",$origL+8,$origT,16,$CifRowHeight,1,-1,32,"^2Yes", config_pb_display_gui_on_startup );
		openPrivButton( $DialogPrefix . "config_screen-off",$origL+24,$origT,16,$CifRowHeight,1,-1,32,"^3No", config_pb_display_gui_on_startup );
	ELSE
		openPrivButton( $DialogPrefix . "config_screen-on",$origL+8,$origT,16,$CifRowHeight,1,-1,32,"^3Yes", config_pb_display_gui_on_startup );
		openPrivButton( $DialogPrefix . "config_screen-off",$origL+24,$origT,16,$CifRowHeight,1,-1,32,"^2No", config_pb_display_gui_on_startup );
	ENDIF

	$origT = $origT + ($CifRowHeight * 1.5);

	### Selection display mode ###
	openPrivButton( $DialogPrefix . "display_mode_label",$origL,$origT,48,$CifRowHeight,5,-1,32,"^7Display mode" );

	$origT = $origT + $CifRowHeight;
	openPrivButton( $DialogPrefix . "display_mode-graphical",$origL,$origT,16,$CifRowHeight,5,-1,32,"^3Graphical", config_pb_display_mode_graphical );
	openPrivButton( $DialogPrefix . "display_mode-text",$origL+16,$origT,16,$CifRowHeight,5,-1,32,"^3Text", config_pb_display_mode_text );
	openPrivButton( $DialogPrefix . "display_mode-off",$origL+32,$origT,16,$CifRowHeight,5,-1,32,"^3Off", config_pb_display_mode_off );

	pitboardConfigBody( );

	# Draw the Load/Save/Reset buttons
	CifCmdButton( 1, "^7Defaults", config_pb_default_settings );
	CifCmdButton( 2, "^7Save", config_pb_save_settings );
EndSub

Sub pitboardConfigBody( )

	$tb_coordinate=50;
	$lr_coordinate=75;
	$lr_coordinate=$CifOrigL+25;

	$DialogPrefix = "CIFConfigPitboard_";

#	$origT = $CifOrigT + ($CifRowHeight * 4) + ($CifRowHeight * .5) + 1;
	$origT = $CifOrigT + ($CifRowHeight * 4) + 4;
	$origL = $CifOrigL+26;	# Left edge of main content window

	### branch based on display mode ###
	$config_pb_display_mode=GetCurrentPlayerVar( "config_pb_display_mode");
	IF ( $config_pb_display_mode == $PB_GUI )
	THEN
		TextPrivButton( $DialogPrefix . "display_mode-graphical", "^2Graphical" );
		TextPrivButton( $DialogPrefix . "display_mode-text", "^3Text" );
		TextPrivButton( $DialogPrefix . "display_mode-off", "^3Off" );
		pitboardTestOpen();
	ELSE
		pitboardTestClose();
		IF ( $config_pb_display_mode == $PB_TEXT )
		THEN
			TextPrivButton( $DialogPrefix . "display_mode-graphical", "^3Graphical" );
			TextPrivButton( $DialogPrefix . "display_mode-text", "^2Text" );
			TextPrivButton( $DialogPrefix . "display_mode-off", "^3Off" );
		ELSE
			TextPrivButton( $DialogPrefix . "display_mode-graphical", "^3Graphical" );
			TextPrivButton( $DialogPrefix . "display_mode-text", "^3Text" );
			TextPrivButton( $DialogPrefix . "display_mode-off", "^2Off" );
		ENDIF
	ENDIF

	$DialogPrefix = "CIFConfigPitboard_body_";

	closeButtonRegex (GetCurrentPlayerVar("UserName"), $DialogPrefix . ".*");

#	$origT = $origT + $CifRowHeight;
	# Common if not set to OFF
	IF ( $config_pb_display_mode != $PB_OFF )
	THEN
		### Set value (in milliseconds) when split has to be shown in yellow. ###
		openPrivButton( $DialogPrefix . "split_setting_txt",$lr_coordinate+1,$origT,48, $CifRowHeight, 5,-1,32,"^7Yellow split setting (ms)" );
		$origT = $origT + $CifRowHeight;
		IF ( GetCurrentPlayerVar ("split_setting") == "")
		THEN
			openPrivTextButton( $DialogPrefix . "split_setting_value",$lr_coordinate+1,$origT,48, $CifRowHeight, 5,32,"^3Time in milliseconds","^3Time in ms",5,config_pb_split_setting_value );
		ELSE
			openPrivTextButton( $DialogPrefix . "split_setting_value",$lr_coordinate+1,$origT,48, $CifRowHeight, 5,32,"^3Time in milliseconds","^3".GetCurrentPlayerVar ("split_setting"),5,config_pb_split_setting_value );
		ENDIF
		### End ###
		$origT = $origT + $CifRowHeight;

		### Set when to show SPB messages ###
		openPrivButton( $DialogPrefix . "spb_setting_txt",$lr_coordinate+1,$origT,48, $CifRowHeight, 5,-1,32,"^7When to show SPB messages" );
		$origT = $origT + $CifRowHeight;
		openPrivButton( $DialogPrefix . "spb_setting-endlap",$lr_coordinate+1,$origT,24, $CifRowHeight, 5,-1,32,"^3End of lap",config_pb_spb_setting );
		openPrivButton( $DialogPrefix . "spb_setting-splits",$lr_coordinate+25,$origT,24, $CifRowHeight, 5,-1,32,"^3All splits",config_pb_spb_setting );
		IF ( GetCurrentPlayerVar ("spb_setting") == "end")
		THEN
			TextPrivButton( $DialogPrefix . "spb_setting-endlap", "^2End of lap" );
		ELSE
			TextPrivButton( $DialogPrefix . "spb_setting-splits", "^2All splits" );
		ENDIF
		### End ###
		$origT = $origT + $CifRowHeight;

		### Set option to wether lost/gained messages have to be shown ###
		openPrivButton( $DialogPrefix . "lost_gained_txt",$lr_coordinate+1,$origT,48, $CifRowHeight, 5,-1,32,"^7show lost/gained messages" );
		$origT = $origT + $CifRowHeight;
		openPrivButton( $DialogPrefix . "lost_gained-yes",$lr_coordinate+1,$origT,24, $CifRowHeight, 5,-1,32,"^3Yes", config_pb_lost_gained );
		openPrivButton( $DialogPrefix . "lost_gained-no",$lr_coordinate+25,$origT,24, $CifRowHeight, 5,-1,32,"^3No", config_pb_lost_gained );
		IF ( GetCurrentPlayerVar ("lost_gained_messages") == TRUE )
		THEN
			TextPrivButton( $DialogPrefix . "lost_gained-yes", "^2Yes" );
		ELSE
			TextPrivButton( $DialogPrefix . "lost_gained-no", "^2No" );
		ENDIF
		### End ###
	ENDIF

	$origT = $origT + $CifRowHeight;

	# GUI base buttons only
	IF ( $config_pb_display_mode == $PB_GUI )
	THEN
	  ### Selection information mode ###
		openPrivButton( $DialogPrefix . "information_mode_txt", $lr_coordinate+1, $origT, 48, $CifRowHeight, 5, -1, 32, "^7Information mode" );
		$origT = $origT + $CifRowHeight;
		IF ( GetCurrentPlayerVar( "config_pb_practise" ) == TRUE )
		THEN
			openPrivButton( $DialogPrefix . "practise", $lr_coordinate+1, $origT, 24, $CifRowHeight, 5, -1, 32, "^2Practise", config_pb_practise );
			openPrivButton( $DialogPrefix . "race", $lr_coordinate+25, $origT, 24, $CifRowHeight, 5, -1, 32, "^3Race", config_pb_race );
		ELSE
			openPrivButton( $DialogPrefix . "practise", $lr_coordinate+1, $origT, 24, $CifRowHeight, 5, -1, 32, "^3Practise", config_pb_practise );
			openPrivButton( $DialogPrefix . "race", $lr_coordinate+25, $origT, 24, $CifRowHeight, 5, -1, 32, "^2Race", config_pb_race );
		ENDIF

		$origT = $origT + $CifRowHeight;
		IF ( GetCurrentPlayerVar( "config_pb_race" ) == TRUE )
		THEN
			IF ( GetCurrentPlayerVar( "config_pb_race_gaps" ) == TRUE )
			THEN
				openPrivButton( $DialogPrefix . "race_gaps", $lr_coordinate+25, $origT, 24, $CifRowHeight, 5, -1, 32, "^2Gaps", config_pb_race_gaps );
			ELSE
				openPrivButton( $DialogPrefix . "race_gaps", $lr_coordinate+25, $origT, 24, $CifRowHeight, 5, -1, 32, "^3Gaps", config_pb_race_gaps );
			ENDIF

			IF ( GetCurrentPlayerVar( "config_pb_race_splits" ) == TRUE )
			THEN
				openPrivButton( $DialogPrefix . "race_splits", $lr_coordinate+25, $origT+$CifRowHeight, 24, $CifRowHeight, 5,-1,32,"^2Splits", config_pb_race_splits );
			ELSE
				openPrivButton( $DialogPrefix . "race_splits", $lr_coordinate+25, $origT+$CifRowHeight, 24, $CifRowHeight, 5,-1,32,"^3Splits", config_pb_race_splits );
			ENDIF
		ENDIF
		### End ###

		$origT = $origT + ($CifRowHeight*2);

		### Set left/right and top/bottom coordinates ###
		openPrivButton( $DialogPrefix . "tb_coordinate",$lr_coordinate+1,$origT,24, $CifRowHeight, 5,-1,32,"^7Top Location" );
		openPrivButton( $DialogPrefix . "lr_coordinate",$lr_coordinate+25,$origT,24, $CifRowHeight, 5,-1,32,"^7Left Location" );
		$origT = $origT + $CifRowHeight;
		openPrivButton( $DialogPrefix . "tb_coordinate-minus",$lr_coordinate+1,$origT,7, $CifRowHeight, 5,-1,32,"^3-", config_pb_tb_coordinate_minus );
		openPrivButton( $DialogPrefix . "tb_coordinate-value",$lr_coordinate+8,$origT,10, $CifRowHeight, 5,-1,32,"^7" . GetCurrentPlayerVar ( "pb_top_bottom_coordinate") );
		openPrivButton( $DialogPrefix . "tb_coordinate-plus",$lr_coordinate+18,$origT,7, $CifRowHeight, 5,-1,32,"^3+", config_pb_tb_coordinate_plus );

		openPrivButton( $DialogPrefix . "lr_coordinate-minus",$lr_coordinate+25,$origT,7, $CifRowHeight, 5,-1,32,"^3-", config_pb_lr_coordinate_minus );
		openPrivButton( $DialogPrefix . "lr_coordinate-value",$lr_coordinate+32,$origT,10, $CifRowHeight, 5,-1,32,"^7" . GetCurrentPlayerVar ( "pb_left_right_coordinate") );
		openPrivButton( $DialogPrefix . "lr_coordinate-plus",$lr_coordinate+42,$origT,7, $CifRowHeight, 5,-1,32,"^3+", config_pb_lr_coordinate_plus );	
		### End ###
	ENDIF
		
EndSub

Sub pitboardTestOpen()
	  IF ( GetCurrentPlayerVar ("lost_gained_messages") == TRUE )
	  THEN
	    openPrivButton( "pitboard_test",GetCurrentPlayerVar ( "pb_left_right_coordinate"),GetCurrentPlayerVar ( "pb_top_bottom_coordinate"),32,46,5,-1,32,"");
	  ELSE
	    openPrivButton( "pitboard_test",GetCurrentPlayerVar ( "pb_left_right_coordinate"),GetCurrentPlayerVar ( "pb_top_bottom_coordinate"),32,42,5,-1,32,"");
	  ENDIF
	  openPrivButton( "pitboard_test_txt",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+1,30,4,4,-1,0,"^7Pitboard:^0 " . GetCurrentPlayerVar( "NickName" ) );
EndSub

Sub pitboardTestClose()
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "pitboard_test.*");
EndSub

Sub config_pb_display_gui_on_startup ( $KeyFlags,$id )
	$DialogPrefix = split( $id,"-",0 );
	$Function = split( $id,"-",1 );
	IF ( $Function == "on" )
	THEN
		TextPrivButton( $DialogPrefix . "-on", "^2Yes" );
		TextPrivButton( $DialogPrefix . "-off", "^3No" );
		SetUserStoredNum ("config_pb_display_gui_on_startup", 1);
	ELSE
		TextPrivButton( $DialogPrefix . "-on", "^3Yes" );
		TextPrivButton( $DialogPrefix . "-off", "^2No" );
		SetUserStoredNum ("config_pb_display_gui_on_startup", 0);
	ENDIF
EndSub

Sub config_pb_display_mode_graphical ( $KeyFlags,$id )
	SetCurrentPlayerVar( "config_pb_display_mode", $PB_GUI );
	SetCurrentPlayerVar( "config_pb_practise",TRUE );
	SetCurrentPlayerVar( "config_pb_practise",FALSE );
	SetCurrentPlayerVar( "config_pb_race",TRUE );
	SetCurrentPlayerVar( "config_pb_race_gaps",FALSE );
	SetCurrentPlayerVar( "config_pb_race_splits", TRUE );
#	SetCurrentPlayerVar ( "pb_top_bottom_coordinate", GetUserStoredNum ("pb_top_bottom_coordinate") );
#	SetCurrentPlayerVar ( "pb_left_right_coordinate", GetUserStoredNum ("pb_left_right_coordinate") );

	# Close the current Pitboard config buttons and redraw the screen
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "config_pb_.*");
	pitboardConfigBody( );
EndSub

Sub config_pb_display_mode_text ( $KeyFlags,$id )
	SetCurrentPlayerVar( "config_pb_display_mode", $PB_TEXT );
	SetCurrentPlayerVar( "config_pb_practise",TRUE );
	SetCurrentPlayerVar( "config_pb_race",FALSE );
	SetCurrentPlayerVar( "config_pb_race_gaps",FALSE );
	SetCurrentPlayerVar( "config_pb_race_splits", FALSE );

	# Close the current Pitboard config buttons and redraw the screen
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "config_pb_.*");
	pitboardConfigBody( );
EndSub

Sub config_pb_display_mode_off ( $KeyFlags,$id )
	SetCurrentPlayerVar( "config_pb_display_mode", $PB_OFF );
	SetCurrentPlayerVar( "config_pb_practise",FALSE );
	SetCurrentPlayerVar( "config_pb_race",FALSE );
	SetCurrentPlayerVar( "config_pb_race_gaps",FALSE );
	SetCurrentPlayerVar( "config_pb_race_splits", FALSE );

	# Close the current Pitboard config buttons and redraw the screen
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "config_pb_.*");
	pitboardConfigBody( );
EndSub

Sub config_pb_practise( $KeyFlags,$id )
	SetCurrentPlayerVar( "config_pb_practise",TRUE );
	SetCurrentPlayerVar( "config_pb_race",FALSE );
	SetCurrentPlayerVar( "config_pb_race_gaps",FALSE );
	SetCurrentPlayerVar( "config_pb_race_splits",FALSE );

	pitboardClose( ); # Close the current Pitboard
	pitboardConfigBody( );
EndSub

Sub config_pb_race( $KeyFlags,$id )
	SetCurrentPlayerVar( "config_pb_race",TRUE );
	SetCurrentPlayerVar( "config_pb_practise",FALSE );

	pitboardClose( ); # Close the current Pitboard
	pitboardConfigBody( );
EndSub

Sub config_pb_race_gaps( $KeyFlags,$id )
	SetCurrentPlayerVar( "config_pb_race_gaps",TRUE );
	SetCurrentPlayerVar( "config_pb_race_splits",FALSE );
	pitboardConfigBody( );
EndSub

Sub config_pb_race_splits( $KeyFlags,$id )
	SetCurrentPlayerVar( "config_pb_race_gaps",FALSE );
	SetCurrentPlayerVar( "config_pb_race_splits",TRUE );
	pitboardConfigBody( );
EndSub

Sub config_pb_tb_coordinate_minus ( $KeyFlags,$id )
	$DialogPrefix = split( $id,"-",0 );

	IF ($KeyFlags == 1)
	THEN
		$pb_top_bottom_coordinate = GetCurrentPlayerVar ( "pb_top_bottom_coordinate") - 1;
	ELSE
		$pb_top_bottom_coordinate = GetCurrentPlayerVar ( "pb_top_bottom_coordinate") - 5;
	ENDIF

	IF ($pb_top_bottom_coordinate < 5)
	THEN
		$pb_top_bottom_coordinate = 5;
	ENDIF

	SetCurrentPlayerVar ( "pb_top_bottom_coordinate", $pb_top_bottom_coordinate);
	TextPrivButton( $DialogPrefix . "-value", "^7" . $pb_top_bottom_coordinate );
	pitboardTestOpen();
EndSub

Sub config_pb_tb_coordinate_plus ( $KeyFlags,$id )
	$DialogPrefix = split( $id,"-",0 );
	IF ($KeyFlags == 1)
	THEN
		$pb_top_bottom_coordinate = GetCurrentPlayerVar ( "pb_top_bottom_coordinate") + 1;
	ELSE
		$pb_top_bottom_coordinate = GetCurrentPlayerVar ( "pb_top_bottom_coordinate") + 5;
	ENDIF

	IF ($pb_top_bottom_coordinate > 195)
	THEN
		$pb_top_bottom_coordinate = 195;
	ENDIF

	SetCurrentPlayerVar( "pb_top_bottom_coordinate", $pb_top_bottom_coordinate );
	TextPrivButton( $DialogPrefix . "-value", "^7" . $pb_top_bottom_coordinate );
	pitboardTestOpen();
EndSub

Sub config_pb_lr_coordinate_minus ( $KeyFlags,$id )
	$DialogPrefix = split( $id,"-",0 );
	IF ($KeyFlags == 1)
	THEN
		$left_right_coordinate = GetCurrentPlayerVar ( "pb_left_right_coordinate") - 1;
	ELSE
		$left_right_coordinate = GetCurrentPlayerVar ( "pb_left_right_coordinate") - 5;
	ENDIF

	IF ($left_right_coordinate < 1)
	THEN
		$left_right_coordinate = 1;
	ENDIF

	SetCurrentPlayerVar ( "pb_left_right_coordinate", $left_right_coordinate);
	TextPrivButton( $DialogPrefix . "-value", "^7" . $left_right_coordinate );
	pitboardTestOpen();
EndSub

Sub config_pb_lr_coordinate_plus ( $KeyFlags,$id )
	$DialogPrefix = split( $id,"-",0 );
	IF ($KeyFlags == 1)
	THEN
		$left_right_coordinate = GetCurrentPlayerVar ( "pb_left_right_coordinate") + 1;
	ELSE
		$left_right_coordinate = GetCurrentPlayerVar ( "pb_left_right_coordinate") + 5;
	ENDIF

	# Set the default if we've exceeded it
	IF ($left_right_coordinate > 195)
	THEN
		$left_right_coordinate = 195;
	ENDIF

	SetCurrentPlayerVar ( "pb_left_right_coordinate", $left_right_coordinate);
	TextPrivButton( $DialogPrefix . "-value", "^7" . $left_right_coordinate );
	pitboardTestOpen();
EndSub

Sub config_pb_split_setting_value ( $split_setting )
	SetCurrentPlayerVar ("split_setting", $split_setting);
	pitboardConfigBody( );
EndSub

Sub config_pb_spb_setting ( $KeyFlags,$id )
	$DialogPrefix = split( $id,"-",0 );
	$Function = split( $id,"-",1 );
	IF ( $Function == "splits" )
	THEN
		TextPrivButton( $DialogPrefix . "-splits", "^2All splits" );
		TextPrivButton( $DialogPrefix . "-endlap", "^3End of lap" );
		SetCurrentPlayerVar ("spb_setting", "splits");
	ELSE
		TextPrivButton( $DialogPrefix . "-splits", "^3All splits" );
		TextPrivButton( $DialogPrefix . "-endlap", "^2End of lap" );
		SetCurrentPlayerVar ("spb_setting", "end");
	ENDIF
EndSub

Sub config_pb_lost_gained ( $KeyFlags,$id )
	$DialogPrefix = split( $id,"-",0 );
	$Function = split( $id,"-",1 );
	IF ( $Function == "yes" )
	THEN
		TextPrivButton( $DialogPrefix . "-yes", "^2Yes" );
		TextPrivButton( $DialogPrefix . "-no", "^3No" );
		SetCurrentPlayerVar( "lost_gained_messages", TRUE );
	ELSE
		TextPrivButton( $DialogPrefix . "-yes", "^3Yes" );
		TextPrivButton( $DialogPrefix . "-no", "^2No" );
		SetCurrentPlayerVar( "lost_gained_messages", FALSE );
	ENDIF
	pitboardTestOpen();
EndSub

Sub PbSetDefaultPlayerNum ( $varname, $value)
	# Grab some values from the database and set defaults if they don't exist (are -1)
	IF ( GetUserStoredNum ( $varname ) < 0 )
	THEN
		SetUserStoredNum ( $varname, $value);
	ENDIF
	SetCurrentPlayerVar( $varname, GetUserStoredNum ($varname) );
EndSub
	
Sub config_pb_default_settings ( $KeyFlags,$id )
	# Grab some values from the database and set defaults if they don't exist (are -1)
	PbSetDefaultPlayerNum ( "pb_top_bottom_coordinate", 90);
	PbSetDefaultPlayerNum ( "pb_left_right_coordinate", 10);
	PbSetDefaultPlayerNum ( "config_pb_display_mode", $PB_GUI);
	PbSetDefaultPlayerNum ( "config_pb_practise", FALSE );
	PbSetDefaultPlayerNum ( "config_pb_race", TRUE );
	PbSetDefaultPlayerNum ( "config_pb_race_gaps", FALSE );
	PbSetDefaultPlayerNum ( "config_pb_race_splits", TRUE );
	PbSetDefaultPlayerNum ( "lost_gained_messages", FALSE );
	privMsg ("^7Pitboard settings reset to defaults" );
EndSub

Sub config_pb_save_settings ( $KeyFlags,$id )
	$userName = GetCurrentPlayerVar( "UserName" );
	SetUserStoredValue ( "config_pb_display_mode", GetCurrentPlayerVar( "config_pb_display_mode" ) );	# Display the GUI every time we connect by default
	SetUserStoredValue( "config_pb_practise", GetCurrentPlayerVar( "config_pb_practise" ) );
	SetUserStoredValue( "config_pb_race", GetCurrentPlayerVar( "config_pb_race" ) );
	SetUserStoredValue( "config_pb_race_gaps", GetCurrentPlayerVar( "config_pb_race_gaps" ) );
	SetUserStoredValue( "config_pb_race_splits", GetCurrentPlayerVar( "config_pb_race_splits" ) );
	SetUserStoredValue( "pb_top_bottom_coordinate", GetCurrentPlayerVar( "pb_top_bottom_coordinate" ) );
	SetUserStoredValue( "pb_left_right_coordinate", GetCurrentPlayerVar( "pb_left_right_coordinate" ) );
	SetUserStoredValue( "split_setting", GetCurrentPlayerVar( "split_setting" ) );
	SetUserStoredValue( "spb_setting", GetCurrentPlayerVar( "spb_setting" ) );
	SetUserStoredValue( "lost_gained_messages", GetCurrentPlayerVar( "lost_gained_messages" ) );
	privMsg ("^7Pitboard settings saved" );
EndSub

Sub config_pb_close( $KeyFlags,$id )
	### Close Pitboard config screen ###
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "config_pb.*");
	pitboardClose( );

	### Close Pitboard when Text of Off mode is selected ###
	IF ( GetUserStoredNum ("config_pb_display_mode") == $PB_GUI)
	THEN
		OnNewPlayerJoin_Pitboard();
	ENDIF
	### End ###
EndSub

Sub pitboardClose( )
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "pitboard_*");
EndSub

Sub pitwindowOpen( $KeyFlags )
	OpenPrivButton( "pitwindow_bg",75,75,50,57,5,-1,16,"");
	OpenPrivButton( "pitwindow_title",76,76,48,5,5,-1,32,"^7Current set Pitwindow(s):");
	OpenPrivButton( "pitwindow_1",76,86,15,5,5,-1,0,"^7Pitwindow 1:");
	OpenPrivButton( "pitwindow_1_start",92,86,15,5,5,-1,96,"^2Start: " . $start_window_1);
	OpenPrivButton( "pitwindow_1_end",109,86,15,5,5,-1,96,"^1End: " . $end_window_1);
	OpenPrivButton( "pitwindow_2",76,96,15,5,5,-1,0,"^7Pitwindow 2:");
	OpenPrivButton( "pitwindow_2_start",92,96,15,5,5,-1,96,"^2Start: " . $start_window_2);
	OpenPrivButton( "pitwindow_2_end",109,96,15,5,5,-1,96,"^1End: " . $end_window_2);
	OpenPrivButton( "pitwindow_3",76,106,15,5,5,-1,0,"^7Pitwindow 3:");
	OpenPrivButton( "pitwindow_3_start",92,106,15,5,5,-1,96,"^2Start: " . $start_window_3);
	OpenPrivButton( "pitwindow_3_end",109,106,15,5,5,-1,96,"^1End: " . $end_window_3);
	OpenPrivButton( "pitwindow_blackflag",76,116,35,5,5,-1,0,"^7Laps before getting black flag: ");
	OpenPrivButton( "pitwindow_blackflag_2",114,116,10,5,5,-1,32, "^7" . $penalty_laps);
	OpenPrivButton( "pitwindow_close",76,126,48,5,5,-1,32, "^3Close", pitwindow_close);
EndSub

Sub pitwindow_close ( $KeyFlags,$id )
	closeButtonRegex (GetCurrentPlayerVar("UserName"), "pitwindow_.*");
EndSub

Sub OnRaceStart_Pitboard() # Lapper event

	IF ($start_window_1 == "")
	THEN
	  cmdLFS( "/rcm ^3Clean racing and have fun :-)" );
	ELSE
	  cmdLFS( "/rcm ^7Pitwindow is set to: ^2" . $start_window_1 . " ^7- ^1" . $end_window_1 );
	ENDIF
	cmdLFS( "/rcm_all" );

	### Set numbers of stops for every window on every player ###
	FOR ($i=1;$i<=32;$i=$i+1)
		IF ($user_array[$i,1] != "")
		THEN
		  $user_array[$i,2] = $number_of_stops_w1;
		  $user_array[$i,3] = $number_of_stops_w2;
		  $user_array[$i,4] = $number_of_stops_w3;
		  $user_array[$i,6] = 1; # Set player status to: not ready
		  $user_array[$i,7] = 0; # Set go to pitlane exit to: not done
		  $user_array[$i,8] = 0; # Set start qualify to: not done
		ENDIF
	ENDFOR
	### End ###

	### Set $qualify to off ###
	$qualify=FALSE;
	### End ###

EndSub

Sub OnQualStart_Pitboard() # Lapper event

	### Set numbers of stops for every window on every player ###
	FOR ($i=1;$i<=32;$i=$i+1)
		IF ($user_array[$i,1] != "")
		THEN
		  $user_array[$i,2] = 0;
		  $user_array[$i,3] = 0;
		  $user_array[$i,4] = 0;
		  $user_array[$i,6] = 1; # Set player status to: not ready
		  $user_array[$i,7] = 0; # Set go to pitlane exit to: not done
		  $user_array[$i,8] = 0; # Set start qualify to: not done
		ENDIF
	ENDFOR
	### End ###

	### Set $qualify to on ###
	$qualify=TRUE;
	### End ###

EndSub

Sub OnEndPit_Pitboard()  # Player event

	$Penalty_check = GetCurrentPlayerVar( "Penalty_check" );

	### Check if Pitstop is inside Window 1,2,3 ###
	### Reduce number of stops for that window by 1 ###
	### Display button with remaining number of stops for that window ###
	FOR ($i=1;$i<=32;$i=$i+1)
		IF ($user_array[$i,1] == GetCurrentPlayerVar( "UserName" ) )
		THEN
		  IF ( GetCurrentPlayerVar( "LapsDone" ) >= $start_window_1-1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1)
		  THEN
		    IF ($user_array[$i,2] > 0)
		    THEN
		      $user_array[$i,2]=$user_array[$i,2]-1;
		      IF ( GetCurrentPlayerVar( "config_pb_display_mode" ) == $PB_GUI )
		      THEN
		        openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,2] );
		      ENDIF
		    ENDIF
		  ENDIF

		  IF ( GetCurrentPlayerVar( "LapsDone" ) >= $start_window_2-1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_2)
		  THEN
		    IF ($user_array[$i,3] > 0)
		    THEN
		      IF ($Penalty_check == "false") # Check wether a penalty is active, if so: pitstop doesn't count
		      THEN
		        $user_array[$i,3]=$user_array[$i,3]-1;
		      ENDIF

		      IF ( GetCurrentPlayerVar( "config_pb_display_mode" ) == $PB_GUI )
		      THEN
		        openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,3] );
		      ENDIF
		    ENDIF
		  ENDIF

		  IF ( GetCurrentPlayerVar( "LapsDone" ) >= $start_window_3-1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_3)
		  THEN
		    IF ($user_array[$i,4] > 0)
		    THEN
		      IF ($Penalty_check == "false") # Check wether a penalty is active, if so: pitstop doesn't count
		      THEN
		        $user_array[$i,4]=$user_array[$i,4]-1;
		      ENDIF

		      IF ( GetCurrentPlayerVar( "config_pb_display_mode" ) == $PB_GUI )
		      THEN
		        openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,2] );
		      ENDIF
		    ENDIF
		  ENDIF
		
		ENDIF
	ENDFOR
	### End ###

	### Check if Penalty is active and if so, set it to false ###
	### Set remaining stops for that window to 0 and update button ###
	IF ($Penalty_check != "false")
	THEN
	  SetCurrentPlayerVar("Penalty_check","false");
	  SetCurrentPlayerVar("Penalty_laps",$penalty_laps);
	  SetCurrentPlayerVar("Information","");
	  FOR ($i=1;$i<=32;$i=$i+1)
		IF ($user_array[$i,1] == GetCurrentPlayerVar( "UserName" ) )
		THEN
		  IF ($Penalty_check == "true_window_1")
		  THEN
		    $user_array[$i,2] = 0;
		    IF ( GetCurrentPlayerVar( "config_pb_display_mode" ) == $PB_GUI )
		    THEN
		      openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,2] );
		    ENDIF
		  ENDIF

		  IF ($Penalty_check == "true_window_2")
		  THEN
		    $user_array[$i,3] = 0;
		    IF ( GetCurrentPlayerVar( "config_pb_display_mode" ) == $PB_GUI )
		    THEN
		      openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,3] );
		    ENDIF
		  ENDIF

		  IF ($Penalty_check == "true_window_3")
		  THEN
		    $user_array[$i,4] = 0;
		    IF ( GetCurrentPlayerVar( "config_pb_display_mode" ) == $PB_GUI )
		    THEN
		      openPrivButton( "pitboard_number_of_stops",GetCurrentPlayerVar ( "pb_left_right_coordinate")+21,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+9,10,4,4,-1,16,"^7" . $user_array[$i,4] );
		    ENDIF
		  ENDIF
		ENDIF
	  ENDFOR

	  IF ( GetCurrentPlayerVar( "config_pb_display_mode" ) == $PB_GUI )
	  THEN
	    openPrivButton( "pitboard_information",GetCurrentPlayerVar ( "pb_left_right_coordinate")+1,GetCurrentPlayerVar ( "pb_top_bottom_coordinate")+$pitboard_offset+8,30,4,4,-1,16,GetCurrentPlayerVar("Information") );
	  ENDIF
   	ENDIF
	### End ###

EndSub

#$FL_Changed -> Front Left Changed  : 1 Changed 0 No
#$FR_Changed -> Front Right Changed : 1 Changed 0 No
#$RL_Changed -> Rear Left Changed : 1 Changed 0 No
#$RR_Changed -> Rear Right Changed : 1 Changed 0 No
Sub OnChangeTyres_Pitboard( $FL_Changed, $FR_Changed, $RL_Changed, $RR_Changed )

	IF ( GetCurrentPlayerVar( "LapsDone" ) >= $start_window_1-1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_1)
	THEN
	  check_tyre_change($FL_Changed, $FR_Changed, $RL_Changed, $RR_Changed);
	ENDIF

	IF ( GetCurrentPlayerVar( "LapsDone" ) >= $start_window_2-1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_2)
	THEN
	  check_tyre_change($FL_Changed, $FR_Changed, $RL_Changed, $RR_Changed);
	ENDIF

	IF ( GetCurrentPlayerVar( "LapsDone" ) >= $start_window_3-1 && GetCurrentPlayerVar( "LapsDone" ) < $end_window_3)
	THEN
	  check_tyre_change($FL_Changed, $FR_Changed, $RL_Changed, $RR_Changed);
	ENDIF

EndSub

Sub check_tyre_change( $FL_Changed, $FR_Changed, $RL_Changed, $RR_Changed )
	IF ($force_tyre_change == "Yes")
	THEN
	  IF ($FL_Changed == 1)
	  THEN
	    IF ( GetCurrentPlayerVar ("OldTyreFrontLeft") == GetCurrentPlayerVar ("TyreFrontLeft") )
	    THEN
	      PrivMsg ("^1Tyre compound FL not changed");
	    ENDIF
	  ELSE
	    PrivMsg ("^1Tyre FL not changed");
	  ENDIF

	  IF ($FR_Changed == 1)
	  THEN
	    IF ( GetCurrentPlayerVar ("OldTyreFrontRight") == GetCurrentPlayerVar ("TyreFrontRight") )
	    THEN
	      PrivMsg ("^1Tyre compound FR not changed");
	    ENDIF
	  ELSE
	    PrivMsg ("^1Tyre FR not changed");
	  ENDIF

	  IF ($RL_Changed == 1)
	  THEN
	    IF ( GetCurrentPlayerVar ("OldTyreRearLeft") == GetCurrentPlayerVar ("TyreRearLeft") )
	    THEN
	      PrivMsg ("^1Tyre compound RL not changed");
	    ENDIF
	  ELSE
	    PrivMsg ("^1Tyre RL not changed");
	  ENDIF

	  IF ($RR_Changed == 1)
	  THEN
	    IF ( GetCurrentPlayerVar ("OldTyreRearRight") == GetCurrentPlayerVar ("TyreRearRight") )
	    THEN
			PrivMsg ("^1Tyre compound RR not changed");
		ENDIF
		ELSE
	    PrivMsg ("^1Tyre RR not changed");
	  ENDIF
	ENDIF
EndSub
