#############################################################################
# LFS Handicapping Interface by Krayy
#############################################################################
# Ver 1.0.1 11-08-09 Initial release based on idea from Sinanju
#############################################################################

CatchEvent OnLapperStart()
	CifRegisterModule("Config", "Penalties", "1.01");

EndCatchEvent

CatchEvent OnMSO( $userName, $text ) # Player event
	$idxOfFirstSpace = indexOf( $text, " ");
	IF( $idxOfFirstSpace == -1 ) THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirstSpace );
	  $argv = trim( subStr( $text,$idxOfFirstSpace ) );
	ENDIF

	SWITCH( $command )
		CASE "!pen":
			DoCifConfigPenalties(0,0);
			return();
   		BREAK;
	ENDSWITCH
EndCatchEvent

Sub DoCifConfigPenalties($KeyFlags,$id)
	# Set default values for the module - these MUST be the same as the main Do function name
	$cifGroupName="Config";
	$cifModuleName="Penalties";
	$DialogPrefix = "CIF" . $cifGroupName . $cifModuleName . "_";

	# Draw the CIF dialog box
	CifDraw($cifGroupName, $cifModuleName, "Penalties");

	# Set various vars for GUI size and location
	$thisRowHeight = 6;	# Left edge of main content window
	$thisOrigL = $CifOrigL+1;	# Left edge of main content window
	$thisOrigR = $CifOrigL+58;


	$thisOrigT = $CifOrigT+1;			# Top edge of main content window
	openPrivButton ($DialogPrefix . "penUser-title" . $i,$thisOrigL,$thisOrigT,99,$thisRowHeight,1,-1,64,"^7User Name:");

	# Get the list of players and cycle through all 32 possible racers
	$ListOfPlayers = GetListOfPlayers("N");
	FOR ( $i = 0; $i < 32; $i = $i + 1 )
		$thisRow = ToNum(split( $i / 4, ".", 0 ));
		$thisOrigT = $CifOrigT + (($thisRowHeight + 1) * ($thisRow + 1) + 1;			# Top edge of main content window
		$thisOrigL = $CifOrigL + (24 * Mod(ToNum($i),4)) + 1;	# Left edge of main content window
			
		IF ( $ListOfPlayers[$i] != "" )
		THEN
			$thisPlayer = GetPlayerInfo($ListOfPlayers[$i]);
			openPrivButton ($DialogPrefix . "penUser-" . $i,$thisOrigL,$thisOrigT,23,$thisRowHeight,1,-1,96,"^7". $thisPlayer["NickName"]);
			globalMsg("i = " . $i . " Name = " . $thisPlayer["NickName"] . " Row = " . $thisRow . " origL = " . $thisOrigL);
		ELSE
			openPrivButton ($DialogPrefix . "penUser-" . $i,$thisOrigL,$thisOrigT,23,$thisRowHeight,1,-1,96,"");
		ENDIF
	ENDFOR

	$thisOrigL = $CifOrigL+1;	# Left edge of main content window
	$thisRow = 9;
	$thisOrigT = $CifOrigT + (($thisRowHeight + 1) * $thisRow);			# Top edge of main content window
	openPrivButton ($DialogPrefix . "penUser-title" . $i,$thisOrigL,$thisOrigT,99,$thisRowHeight,1,-1,64,"^7Penalties:");
	
	IF ( UserIsAdmin( GetCurrentPlayerVar("UserName") ) == 1 ) THEN
		# Draw the Load/Save/Reset buttons
#		CifCmdButton( 1, "^7Set Grid", DoHandicapper_Load );
#		CifCmdButton( 2, "^7Save", DoHandicapper_Save );
#		CifCmdButton( 3, "^7Reset", DoHandicapper_Reset );
	ENDIF
EndSub

