#############################################################################
# LFS Handicapping Interface by Krayy
#############################################################################
# Ver 1.0.1 11-08-09 Initial release
# Ver 1.0.5 22-08-09 Major changes to functionality
#                    Added Save/Load code to store and retreive values
#                    Multiple column support for up to 32 players
#                    Changed button names to be unique
# Ver 1.0.6 27/12/09 Updated to be compatible with LFSLapper v5.918
#############################################################################

CatchEvent OnLapperStart()
	CifRegisterModule("Config", "Grid", "1.01");

	### Create and Initialise RaceGridOrder array ####
	GlobalVar $RaceGridOrder;
	FOR ( $i = 0; $i < 32; $i = $i + 1 )
		$RaceGridOrder[$i] = 0;
	ENDFOR
	RequestREO( );
EndCatchEvent

CatchEvent OnMSO( $userName, $text ) # Player event
	$idxOfFirstSpace = indexOf( $text, " ");
	IF( $idxOfFirstSpace == -1 ) THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirstSpace );
	  $argv = trim( subStr( $text,$idxOfFirstSpace ) );
	ENDIF

	SWITCH( $command )
		CASE "!grid":
			DoCifConfigGrid(0,0);
			return();
   		BREAK;
	ENDSWITCH
EndCatchEvent

CatchEvent OnREO ( $NumP, $ReqI, $GridOrder ) # Lapper event
#	globalMsg ( "OnReorder " . $NumP . ":" . $ReqI . " = " . $GridOrder);
	# Split the comma seperated list of PLIDs and transpose that to the RaceGridOrder global array
	$thisGrid = SplitTOArray(  $GridOrder , "," );
#	dumpvar($thisGrid);
	FOR ( $i=0; $i < 32; $i = $i + 1 )
		$RaceGridOrder[$i] = ToNum($thisGrid[$i]);
	ENDFOR
#	dumpVar ($RaceGridOrder);
EndCatchEvent

Sub DoCifConfigGrid($KeyFlags,$id)
	# Set default values for the module - these MUST be the same as the main Do function name
	$cifGroupName="Config";
	$cifModuleName="Grid";
	$DialogPrefix = "CIF" . $cifGroupName . $cifModuleName . "_";

	# Draw the CIF dialog box
	CifDraw($cifGroupName, $cifModuleName, "Race Grid");

	# Set various vars for GUI size and location
	$thisOrigT = $CifOrigT+1;			# Top edge of main content window
	$thisOrigL = $CifOrigL+1;	# Left edge of main content window
	$thisOrigR = $CifOrigL+58;

	# Left hand titles
#	openPrivButton ($DialogPrefix . "luser",$thisOrigL,$thisOrigT,27,$CifRowHeight,1,-1,99,"Nickname");
#	openPrivButton ($DialogPrefix . "lweight",$thisOrigL+27,$thisOrigT,11,$CifRowHeight,1,-1,35,"Weight");
#	openPrivButton ($DialogPrefix . "lintake",$thisOrigL+38,$thisOrigT,11,$CifRowHeight,1,-1,35,"Intake");

	# Right hand titles
#	openPrivButton ($DialogPrefix . "ruser",$thisOrigR,$thisOrigT,27,$CifRowHeight,1,-1,99,"Nickname");
#	openPrivButton ($DialogPrefix . "rweight",$thisOrigR+27,$thisOrigT,11,$CifRowHeight,1,-1,35,"Weight");
#	openPrivButton ($DialogPrefix . "rintake",$thisOrigR+38,$thisOrigT,11,$CifRowHeight,1,-1,35,"Intake");

#	dumpvar($RaceGridOrder);
	
	$thisOrigRow = $thisOrigT;
	# Cycle through the current RaceGridOrder array to get the display
	FOR ( $i = 0; $i < 32; $i = $i + 1 )
		IF ( ToNum($RaceGridOrder[$i]) > 0 )
		THEN
			$uName = GetPlayerVarByPLID( ToNum($RaceGridOrder[$i]), "UserName");
			$uNick = GetPlayerVar($uName,"NickName");
			$Pref = $DialogPrefix . $i . "_";

			$IsOdd = $i & 1;
			IF ($IsOdd == 0)	# Check if we are on left or right side
			THEN
				$thisOrigCol = $thisOrigL;
				$thisOrigNum = $thisOrigL + 41;
				$thisOrigMod = $thisOrigL + 45;
				$butFormat = ISB_RIGHT+ISB_DARK;
			ELSE
				$thisOrigCol = $thisOrigR;
				$thisOrigNum = $thisOrigR - 4;
				$thisOrigMod = $thisOrigR - 7;
				$butFormat = ISB_LEFT+ISB_DARK;
			ENDIF

			# Set the header row and display different info for Admins vs Players
			openPrivButton ($Pref . "hUser",$thisOrigCol,$thisOrigRow,41,$CifRowHeight,1,-1,$butFormat,"^7". $uNick);
			openPrivButton ($Pref . "hNum",$thisOrigNum,$thisOrigRow,4,$CifRowHeight,1,-1,ISB_DARK,"^3" . ($i + 1));
			IF ( UserIsAdmin( GetCurrentPlayerVar("UserName") ) == 1 ) THEN
				openPrivButton ($Pref . "wMore",$thisOrigMod,$thisOrigRow,3,3,1,-1,ISB_DARK,"^1+",GridMoveUp);
				openPrivButton ($Pref . "wLess",$thisOrigMod,$thisOrigRow+3,3,3,1,-1,ISB_DARK,"^2-",GridMoveDown);
			ENDIF
			$thisOrigRow = $thisOrigRow + Round($CifRowHeight / 2,0);
		ENDIF
	ENDFOR
	
	IF ( UserIsAdmin( GetCurrentPlayerVar("UserName") ) == 1 ) THEN
		# Draw the Load/Save/Reset buttons
#		CifCmdButton( 1, "^7Set Grid", DoHandicapper_Load );
#		CifCmdButton( 2, "^7Save", DoHandicapper_Save );
#		CifCmdButton( 3, "^7Reset", DoHandicapper_Reset );
	ENDIF
EndSub

Sub GridMoveUp ( $KeyFlags, $id )
	$Position = ToNum(split( $id,"_",1 ));
	$uName = GetPlayerVarByPLID( ToNum($RaceGridOrder[$Position]), "UserName");
	IF ( $Position != 0 )
	THEN
		privMsg( $id . " Moving racer " . $uName . " Up" );
	ENDIF
#	DoShowGridPrint();
EndSub

Sub GridMoveDown ( $KeyFlags, $id )
	$Position = ToNum(split( $id,"_",1 ));
	$uName = GetPlayerVarByPLID( ToNum($RaceGridOrder[$Position]), "UserName");
	privMsg( $id . " Moving racer " . $uName . " Down" );
#	DoShowGridPrint();
EndSub
