#############################################################################
# Pit Reminder by Krayy
#############################################################################
# This add-on displays warning messages if a racer has not pitted yet and the
# race has less than a certain percentage to run.
#############################################################################
# Ver 1.0.1 - 05 March 2010 Initial release
#############################################################################

CatchEvent OnLapperStart()
	GlobalVar $LastPitReminderAt;
	$LastPitReminderAt = 0;
EndCatchEvent

CatchEvent OnRaceStart ( $NumP ) # Lapper event
	$LastPitReminderAt = 0;
EndCatchEvent

CatchEvent OnNewPlayerJoin( $userName )  # Player event
	SetCurrentPlayerVar("NumTyresChanged","0");
EndCatchEvent

CatchEvent OnLap( $userName ) # Player event
	IF ( getLapperVar( "RaceInProg" ) == RACEINPROG_RACE && getLapperVar( "MustPit" ) == 1 )
	THEN
		# Check percentage done if this racer's position is 1st
		IF ( ToNum(GetCurrentPlayerVar("Pos")) == 1 )
		THEN
			$sendPitAlert = FALSE;
			$PercentDone = ToNum(getRacePercentComplete());

			IF ( $PercentDone > 85 )
			THEN
				$MustPitMsg = "ALERT";
				$LastPitReminderAt = $PercentDone;
				$sendPitAlert = TRUE;
			ENDIF
			IF ( $PercentDone >= 70 && $LastPitReminderAt < 70 )
			THEN
				$MustPitMsg = "WARNING";
				$LastPitReminderAt = $PercentDone;
				$sendPitAlert = TRUE;
			ENDIF
			IF ( $PercentDone >= 50 && $LastPitReminderAt < 50 )
			THEN
				$MustPitMsg = "INFO";
				$LastPitReminderAt = $PercentDone;
				$sendPitAlert = TRUE;
			ENDIF

			$ListOfPlayers = GetListOfPlayers("N");
			FOREACH ( $Player IN $ListOfPlayers)
				IF ( ToNum(GetPlayerVar($Player["value"], "PitStops")) < 1 && $sendPitAlert == TRUE )
				THEN
					DEBUG ("Pitstop Reminder: Alerting player: " . $Player["value"] );
					privMsg ( $Player["value"], langEngine ( "%{main_pitstopwarn}%", $MustPitMsg, $PercentDone) );
				ENDIF
			ENDFOREACH
		ENDIF
	ENDIF
EndCatchEvent

Sub getRacePercentComplete ()
	$RacePcLeft = Round(( ToNum(GetCurrentPlayerVar("LapsDone")) / getLapperVar("RaceLaps") ) * 100, 0);
	DEBUG ("Race percent complete: " . $RacePcLeft );
	return ( $RacePcLeft );
EndSub

Lang "EN"
	main_pitstopwarn = "^7PIT {0}: ^8Race ^3{1}^7%^8 done and you still have to  pit";
	main_pitstop3laps = "^7PIT INFO: ^1ALERT: ^8There are only 3 laps left in the race.%nl%If you do not pit now you be be disqualified!";
EndLang
