#############################################################################
# Event Config by Krayy
#############################################################################
# Ver 1.0.1 02-05-11 Initial release
#############################################################################

CatchEvent OnLapperStart()
	CifRegisterModule("Config", "Race_Event", "1.01");

    GlobalVar $EVENT_DURATION_TYPES;
	$EVENT_DURATION_TYPES[0] = "Laps";
	$EVENT_DURATION_TYPES[1] = "Kms";
	$EVENT_DURATION_TYPES[2] = "Mins";
    GlobalVar $EVENT_DURATION_TYPE_MAX; $EVENT_DURATION_TYPE_MAX = 2;

	GlobalVar $RaceEventStatus;
	$RaceEventStatus["InProgress"] = FALSE;

	### Create and Initialise Race Event array ####
	# For this plugin, the array index equates to the following:
	# 0 = Qualifying
	# 1,2,3 = race 1, 2 and 3 respectively
	GlobalVar $RaceEvent;

	# Initialise the RaceEvent array for all races and Qualifying
	FOR ( $i = 0; $i < 4; $i = $i + 1 )
		$RaceEvent[$i,"Name"] = "Race " . $i;
		$RaceEvent[$i,"Enabled"] = FALSE;  # Race 1 is enabled by default
		$RaceEvent[$i,"WaitTime"] = "5";  # 5 minute wait until this race starts
		$RaceEvent[$i,"Duration"] = "5";  # 5 lap race duration / 5 minute Qualifying
		$RaceEvent[$i,"DurationType"] = "0";  # 5 lap race duration / 5 minute Qualifying
	ENDFOR
	$RaceEvent[0,"Name"] = "Qualifying";
	$RaceEvent[0,"DurationType"] = "2"; # Qualifying defaults to Mins
	$RaceEvent[0,"Enabled"] = TRUE;  # Qualifying is enabled by default
	$RaceEvent[1,"Enabled"] = TRUE;  # Race 1 is enabled by default
EndCatchEvent

CatchEvent OnMSO( $userName, $text ) # Player event
	$idxOfFirstSpace = indexOf( $text, " ");
	IF( $idxOfFirstSpace == -1 ) THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirstSpace );
	  $argv = trim( subStr( $text,$idxOfFirstSpace ) );
	ENDIF

	SWITCH( $command )
		CASE "!rc":
		CASE "!raceconfig":
			DoCifConfigRace_Event(0,0);
			return();
   		BREAK;
	ENDSWITCH
EndCatchEvent

Sub DoCifConfigRace_Event($KeyFlags,$id)
	# Set default values for the module - these MUST be the same as the main Do function name
	$cifGroupName="Config";
	$cifModuleName="Race_Event";
	$DialogPrefix = "CIF" . $cifGroupName . $cifModuleName . "-";

	# Draw the CIF dialog box
	CifDraw($cifGroupName, $cifModuleName, "Setup Race Fixture");

	# Set various vars for GUI size and location
	$thisOrigT = $CifOrigT+1;			# Top edge of main content window
	$thisOrigL = $CifOrigL+1;	# Left edge of main content window

	# Global settings
#	openPrivButton ($DialogPrefix . "bgT1",$thisOrigL,$thisOrigT,$CifWidth-2,5,6,-1,96,"^7Global Settings%nl%%nl%");
#	$thisOrigT = $thisOrigT+18;

	# Create buttons for Qualifying options
	openPrivButton ($DialogPrefix . "bgQ",$thisOrigL,$thisOrigT,$CifWidth-2,5,4,-1,96,"%nl%%nl%%nl%");

	IF  ( $RaceEvent[0,"Enabled"] == TRUE )
	THEN
		openPrivButton ($DialogPrefix . "EnableRace-0",$thisOrigL+1,$thisOrigT+1,16,15,4,-1,16,"^3Qual", ToggleRaceEnabled);
	ELSE
		openPrivButton ($DialogPrefix . "EnableRace-0",$thisOrigL+1,$thisOrigT+1,16,15,4,-1,16,"^8Qual", ToggleRaceEnabled);
	ENDIF
	openPrivButton ($DialogPrefix . "Duration-Qual", $thisOrigL+17,$thisOrigT+1,12,5,1,-1,128, "^7Duration: " );
	openPrivButton ($DialogPrefix . "Duration-0", $thisOrigL+29,$thisOrigT+1,10,5,1,-1,32, "^7" . $RaceEvent[0,"Duration"] );
	IF ( UserIsAdmin( GetCurrentPlayerVar("UserName") ) == 1 ) THEN
		openPrivButton ($DialogPrefix . "DurAdd-0" . $i, $thisOrigL+37, $thisOrigT+1,2,3,1,-1,0,"^2+", RaceEventDurationAdd );
		openPrivButton ($DialogPrefix . "DurSub-0" . $i, $thisOrigL+37, $thisOrigT+3,2,3,1,-1,0,"^1-", RaceEventDurationSub );
	ENDIF
	openPrivButton ($DialogPrefix . "DurationType-0", $thisOrigL+39,$thisOrigT+1,14,5,1,-1,32, "^7" . $EVENT_DURATION_TYPES[ToNum($RaceEvent[0,"DurationType"])] );

	$thisOrigT = $thisOrigT+18;

	# Create sets of buttons for 3 races
	FOR ( $i = 1; $i < 4; $i = $i + 1 )
		# Buttons to set time to wait till next race
		openPrivButton ($DialogPrefix . "bgW-" . $i, $thisOrigL,$thisOrigT,22,5,5,-1,96,"^7Comfort break (Beer!):" );
		openPrivButton ($DialogPrefix . "WaitTime-" . $i, $thisOrigL+22,$thisOrigT,7,5,1,-1,32, "^7" . $RaceEvent[$i,"WaitTime"] );
		IF ( UserIsAdmin( GetCurrentPlayerVar("UserName") ) == 1 ) THEN
			openPrivButton ($DialogPrefix . "WtAdd-" . $i, $thisOrigL+29, $thisOrigT,2,3,1,-1,32,"^2+", RaceEventWaitTimeAdd );
			openPrivButton ($DialogPrefix . "WtSub-" . $i, $thisOrigL+29, $thisOrigT+2,2,3,1,-1,32,"^1-", RaceEventWaitTimeSub );
		ENDIF
		$thisOrigT = $thisOrigT+6;
		
		# Race button and options
		openPrivButton ($DialogPrefix . "bgR-" . $i,$thisOrigL,$thisOrigT,$CifWidth-2,5,4,-1,96,"%nl%%nl%%nl%%nl%");
		IF  ( $RaceEvent[$i,"Enabled"] == TRUE )
		THEN
			openPrivButton ($DialogPrefix . "EnableRace-" . $i,$thisOrigL+1,$thisOrigT+1,16,19,4,-1,16,"^3R" . $i, ToggleRaceEnabled);
		ELSE
			openPrivButton ($DialogPrefix . "EnableRace-" . $i,$thisOrigL+1,$thisOrigT+1,16,19,4,-1,16,"^8R" . $i, ToggleRaceEnabled);
		ENDIF
		# Race Duration
		openPrivButton ($DialogPrefix . "Duration-R" . $i, $thisOrigL+17,$thisOrigT+1,12,5,1,-1,128, "^7Duration: " );
		openPrivButton ($DialogPrefix . "Duration-" . $i, $thisOrigL+29,$thisOrigT+1,10,5,1,-1,32, "^7" . $RaceEvent[$i,"Duration"]);
		IF ( UserIsAdmin( GetCurrentPlayerVar("UserName") ) == 1 ) THEN
			openPrivButton ($DialogPrefix . "DurAdd-" . $i, $thisOrigL+37, $thisOrigT+1,2,3,1,-1,0,"^2+", RaceEventDurationAdd );
			openPrivButton ($DialogPrefix . "DurSub-" . $i, $thisOrigL+37, $thisOrigT+3,2,3,1,-1,0,"^1-", RaceEventDurationSub );
		ENDIF
		# Duration type
		openPrivButton ($DialogPrefix . "DurationType-" . $i, $thisOrigL+39,$thisOrigT+1,14,5,1,-1,32, "^7" . $EVENT_DURATION_TYPES[ToNum($RaceEvent[$i,"DurationType"])] );
		IF ( UserIsAdmin( GetCurrentPlayerVar("UserName") ) == 1 ) THEN
			openPrivButton ($DialogPrefix . "DtSub-" . $i, $thisOrigL+39, $thisOrigT+1,3,5,1,-1,0,"<", RaceEventDurationTypeSub );
			openPrivButton ($DialogPrefix . "DtAdd-" . $i, $thisOrigL+50, $thisOrigT+1,3,5,1,-1,0,">", RaceEventDurationTypeAdd );
		ENDIF

		$thisOrigT = $thisOrigT+22;
	ENDFOR

	IF ( UserIsAdmin( GetCurrentPlayerVar("UserName") ) == 1 ) THEN
		openPrivButton ($DialogPrefix . "Help",$thisOrigL+1,$thisOrigT-2,$CifWidth-2,4,4,-1,0,"^6(Click on large race number to toggle active/inactive)");
		# Draw the Start/End/Continue buttons
#		CifCmdButton( 1, "^7Set Grid", DoHandicapper_Load );
#		CifCmdButton( 2, "^7Save", DoHandicapper_Save );
		CifCmdButton( 1, "^7Cancel", RaceEventCancel );
		CifCmdButton( 4, "^7Start", RaceEventStart );
	ENDIF
EndSub

Sub RaceEventStart($KeyFlags, $id)
	$RaceEventStatus["InProgress"] = TRUE;
	globalMsg ("A new Race Event has been started");
EndSub

Sub RaceEventCancel($KeyFlags, $id)
	$RaceEventStatus["InProgress"] = FALSE;
	globalMsg ("Current Race Event has been cancelled");
EndSub

Sub ToggleRaceEnabled ( $KeyFlags, $id )
	$thisRaceNum = ToNum(split( $id,"-",2 ));
	IF ( $thisRaceNum == 0) THEN
		$thisRaceText = "Qual";
	ELSE
		$thisRaceText = "R" . ToString($thisRaceNum);
	ENDIF
	$thisRaceStatus = ToNum($RaceEvent[$thisRaceNum,"Enabled"]);
	IF ( $thisRaceStatus == FALSE) THEN
		$thisRaceStatus = TRUE;
		TextPrivButtonAll( $id, "^3" . $thisRaceText);
	ELSE
		$thisRaceStatus = FALSE;
		TextPrivButtonAll( $id, "^8" . $thisRaceText);
	ENDIF
	$RaceEvent[$thisRaceNum,"Enabled"] = ToString($thisRaceStatus);
EndSub

Sub RaceEventDurationAdd ( $KeyFlags, $id )
	$DialogPrefix = split( $id,"-",0 );
	$thisRaceNum = ToNum(split( $id,"-",2 ));
	$thisDuration = ToNum($RaceEvent[$thisRaceNum,"Duration"]);

	IF ($KeyFlags > 1)
	THEN
	    $thisDuration=$thisDuration + 5;
	ELSE
	    $thisDuration=$thisDuration + 1;
	ENDIF
	$RaceEvent[$thisRaceNum,"Duration"] = ToString($thisDuration);
	$StatusButton = $DialogPrefix . "-Duration-" . $thisRaceNum;
	TextPrivButtonAll( $StatusButton, "^7" . $RaceEvent[$thisRaceNum,"Duration"]);
EndSub

Sub RaceEventDurationSub ( $KeyFlags, $id )
	$DialogPrefix = split( $id,"-",0 );
	$thisRaceNum = ToNum(split( $id,"-",2 ));
	$thisDuration = ToNum($RaceEvent[$thisRaceNum,"Duration"]);

	IF ($KeyFlags > 1)
	THEN
	    $thisDuration=$thisDuration - 5;
	ELSE
	    $thisDuration=$thisDuration - 1;
	ENDIF
	IF ( $thisDuration < 1 )
	THEN
		$thisDuration = 1;
	ENDIF
	$RaceEvent[$thisRaceNum,"Duration"] = ToString($thisDuration);
	$StatusButton = $DialogPrefix . "-Duration-" . $thisRaceNum;
	TextPrivButtonAll( $StatusButton, "^7" . $RaceEvent[$thisRaceNum,"Duration"]);
EndSub

Sub RaceEventDurationTypeAdd ( $KeyFlags, $id )
	$DialogPrefix = split( $id,"-",0 );
	$thisRaceNum = ToNum(split( $id,"-",2 ));
	$thisDurationType = ToNum($RaceEvent[$thisRaceNum,"DurationType"]);

    $thisDurationType=$thisDurationType + 1;
	IF ( $thisDurationType > $EVENT_DURATION_TYPE_MAX )
	THEN
		$thisDurationType = $EVENT_DURATION_TYPE_MAX;
	ENDIF
	$RaceEvent[$thisRaceNum,"DurationType"] = ToString($thisDurationType);
	$StatusButton = $DialogPrefix . "-DurationType-" . $thisRaceNum;
#	DEBUG ("Updating button " . $StatusButton);
	TextPrivButtonAll( $StatusButton, "^7" . $EVENT_DURATION_TYPES[ToNum($RaceEvent[$thisRaceNum,"DurationType"])]);
EndSub

Sub RaceEventDurationTypeSub ( $KeyFlags, $id )
	$DialogPrefix = split( $id,"-",0 );
	$thisRaceNum = ToNum(split( $id,"-",2 ));
	$thisDurationType = ToNum($RaceEvent[$thisRaceNum,"DurationType"]);

    $thisDurationType=$thisDurationType - 1;
	IF ( $thisDurationType < 0 )
	THEN
		$thisDurationType = 0;
	ENDIF
	$RaceEvent[$thisRaceNum,"DurationType"] = ToString($thisDurationType);
	$StatusButton = $DialogPrefix . "-DurationType-" . $thisRaceNum;
	TextPrivButtonAll( $StatusButton, "^7" . $EVENT_DURATION_TYPES[ToNum($RaceEvent[$thisRaceNum,"DurationType"])]);
EndSub

Sub RaceEventWaitTimeAdd ( $KeyFlags, $id )
	$DialogPrefix = split( $id,"-",0 );
	$thisRaceNum = ToNum(split( $id,"-",2 ));
	$thisWaitTime = ToNum($RaceEvent[$thisRaceNum,"WaitTime"]);
	IF ($KeyFlags > 1)
	THEN
	    $thisWaitTime=$thisWaitTime + 5;
	ELSE
	    $thisWaitTime=$thisWaitTime + 1;
	ENDIF
	IF ( $thisWaitTime > 20 )
	THEN
		$thisWaitTime = 20;
	ENDIF
	$RaceEvent[$thisRaceNum,"WaitTime"] = ToString($thisWaitTime);
	$StatusButton = $DialogPrefix . "-WaitTime-" . $thisRaceNum;
	TextPrivButtonAll( $StatusButton, "^7" . $thisWaitTime);
EndSub

Sub RaceEventWaitTimeSub ( $KeyFlags, $id )
	$DialogPrefix = split( $id,"-",0 );
	$thisRaceNum = ToNum(split( $id,"-",2 ));
	$thisWaitTime = ToNum($RaceEvent[$thisRaceNum,"WaitTime"]);
	IF ($KeyFlags > 1)
	THEN
	    $thisWaitTime=$thisWaitTime - 5;
	ELSE
	    $thisWaitTime=$thisWaitTime - 1;
	ENDIF
	IF ( $thisWaitTime < 1 )
	THEN
		$thisWaitTime = 1;
	ENDIF
	$RaceEvent[$thisRaceNum,"WaitTime"] = ToString($thisWaitTime);
	$StatusButton = $DialogPrefix . "-WaitTime-" . $thisRaceNum;
	TextPrivButtonAll( $StatusButton, "^7" . $thisWaitTime);
EndSub
