#############################################################################
# Event Config by Krayy
#############################################################################
# Ver 1.0.1 02-05-11 Initial release
#############################################################################

CatchEvent OnLapperStart()
    GlobalVar $EVENT_DURATION_TYPES;
	$EVENT_DURATION_TYPES[0] = "Laps";
	$EVENT_DURATION_TYPES[1] = "Kms";
	$EVENT_DURATION_TYPES[2] = "Mins";
    GlobalVar $EVENT_DURATION_TYPE_MAX; $EVENT_DURATION_TYPE_MAX = 2;

	GlobalVar $reInProgress; $reInProgress = FALSE;
	GlobalVar $reTimeToWait; $reTimeToWait = 0;
	GlobalVar $reNextEvent; $reNextEvent = -1; # Next event is qualifying
	GlobalVar $reLastEvent; $reLastEvent = -1; # Next event is qualifying

	GlobalVar $raceStarted; $raceStarted = FALSE; # Is a Race in progress
	GlobalVar $raceFinishing; $raceFinishing = FALSE; # Is a race finishing?

	### Create and Initialise Race Event array ####
	# For this plugin, the array index equates to the following:
	# 1,2,3 = race 1, 2 and 3 respectively
	GlobalVar $RaceEvent;

	# Initialise the RaceEvent array for all races and Qualifying
	FOR ( $i = 0; $i < 4; $i = $i + 1 )
		$RaceEvent[$i,"Name"] = "Race " . $i;
		$RaceEvent[$i,"Enabled"] = FALSE;  # Race 1 is enabled by default
		$RaceEvent[$i,"WaitTime"] = "5";  # 5 minute wait until this race starts
		$RaceEvent[$i,"Duration"] = "5";  # 5 lap race duration / 5 minute Qualifying
		$RaceEvent[$i,"DurationType"] = "0";  # 5 lap race duration / 5 minute Qualifying
	ENDFOR
	$RaceEvent[1,"Enabled"] = TRUE;  # Race 1 is enabled by default
EndCatchEvent

CatchEvent OnMSO( $userName, $text ) # Player event
	$idxOfFirstSpace = indexOf( $text, " ");
	IF( $idxOfFirstSpace == -1 ) THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirstSpace );
	  $argv = trim( subStr( $text,$idxOfFirstSpace ) );
	ENDIF

#	SWITCH( $command )
#		CASE "!rc":
#		CASE "!raceconfig":
#			DoCifConfigRace_Event(0,0);
#			return();
 #  		BREAK;
#	ENDSWITCH
EndCatchEvent

CatchEvent OnNewPlayerJoin( $userName )  # Player event
	IF ( $raceFinishing == TRUE && $raceStarted == TRUE)
	THEN
		privMsg ("^1RACE CONTROL: ^7Race is in it's finishing state...%nl%Unable to join until all racers have finished.");
		cmdLFS ("/spec " . GetCurrentPlayerVar("NickName") );
	ENDIF
EndCatchEvent

CatchEvent OnFinish( $userName ) # Player event
	$raceFinishing = TRUE;
EndCatchEvent

CatchEvent OnResult( $userName,$flagConfirm ) # Player event
	$raceFinishing = TRUE;
	CheckRaceComplete();
#	IF ( GetCurrentPlayerVar ("FinishedPos") == 1 )
#	THEN
#		HostDelayedCommand ( "RaceForceFinish", (GetCurrentPlayerVar ("FinishedPos") / 1000) + 15, RaceForceFinish );
#	ENDIF
EndCatchEvent

Sub RaceForceFinish ( $userName )
	$thisLOP = GetListOfPlayers("N");
	FOREACH ( $Player IN $thisLOP)
		IF ( ToNum(GetPlayerVar($Player["value"], "FinishedPos")) < 0 && ToNum(GetPlayerVar($Player["value"], "OnTrack")) == 1)
		THEN
			DEBUG ("Player specced for not finishing race in reasonable time: " . $Player["value"] );
			cmdLFS ("/spec " . GetPlayerVar($Player["value"], "NickName") );
		ENDIF
	ENDFOREACH
	CheckRaceComplete();
EndSub

CatchEvent OnPit( $userName )  # Player teleported to pit () Shift + P )'
	CheckRaceComplete();
EndCatchEvent

CatchEvent OnLeaveRace( $userName )  # Player event
	CheckRaceComplete();
EndCatchEvent

Sub CheckRaceComplete()
	IF ( $raceStarted == TRUE )
	THEN
		IF ( ToNum( AllRacersFinished() ) == 1 )
		THEN
			DEBUG ("All racers have finished the race");
			RaceEventScheduler( GetCurrentPlayerVar("UserName") );
			$raceFinishing = FALSE;
			$raceStarted = FALSE;
		ENDIF
	ENDIF
EndSub

Sub RaceEventStart ( $userName )
	RemoveHostDelayedCommand( "RaceEventStartWarning" );
	RemoveHostDelayedCommand( "RaceEventStartNext" );
	closeGlobalButton ( "reCd1&reCd2&reCd3" );
	IF ( $reNextEvent > -1 && $reInProgress == TRUE )
	THEN
		DEBUG ("Race Name = " . $RaceEvent[$reNextEvent,"Name"] );
		$thisDuration = $RaceEvent[$reNextEvent,"Duration"];
	
		IF ( $EVENT_DURATION_TYPES[ToNum($RaceEvent[$reNextEvent,"DurationType"])] != "Laps" )
		THEN
			IF ( $EVENT_DURATION_TYPES[ToNum($RaceEvent[$reNextEvent,"DurationType"])] == "Kms" )
			THEN
				cmdLFS ("!kms " . $thisDuration);
			ELSE
				cmdLFS ("!mins " . $thisDuration);
			ENDIF
		ELSE
			cmdLFS ("/laps " . $thisDuration);
		ENDIF
		$raceFinishing = TRUE;
		$raceStarted = TRUE; # Race has started
		cmdLFS ("/restart");

		# Set the next event
		IF ( $reNextEvent == $reLastEvent )
		THEN
			DEBUG ("This was the last event: " . $reNextEvent );
			RaceEventCancel(0,0);
		ELSE
			FOR ( $i = 1; $i < 4; $i = $i + 1 )
				IF ( $RaceEvent[$i,"Enabled"] == TRUE && $i > $reNextEvent )
				THEN
					DEBUG ("Setting reNextEvent to " . $i );
					$reNextEvent = $i;
					$reTimeToWait = $RaceEvent[$reNextEvent,"WaitTime"];
					BREAK;
				ENDIF
			ENDFOR
		ENDIF
	ELSE
#	globalMsg ("Current Race Event has been cancelled");
		RaceEventCancel(0,0);
	ENDIF
EndSub

Sub RaceEventScheduler ( $userName )
	IF ( $reNextEvent > -1 && $reInProgress == TRUE)
	THEN
		IF ( $reTimeToWait < 1 )
		THEN
			DEBUG ("RaceEventScheduler: race start" );
			RaceEventStart ( $userName );
		ELSE
			DEBUG ("RaceEventScheduler: starting race " . $reNextEvent );
			openGlobalButton ("reCd1",35,123,23,12,12,-1,32,"^3" . $RaceEvent[$reNextEvent,"Name"] . "%nl%starts in:%nl% ");
			openGlobalButton ("reCd3",35,143,23,10,5,$reTimeToWait * 60,0,"^7%cpt% secs");
			HostDelayedCommand ( "RaceEventStartNext", ($reTimeToWait * 60) + 1, RaceEventStart );
			RaceCountDown ( $userName);
		ENDIF
	ELSE
		DEBUG ("RaceEventScheduler: no next race" );
		RaceEventCancel(0,0);
	ENDIF
EndSub

Sub RaceCountDown ( $userName )
	IF ( ToNum( $reTimeToWait ) > 0 )
	THEN
		globalMsg ( "^1RACE CONTROL: ^7" . $RaceEvent[$reNextEvent,"Name"]  . " will start in " . ($reTimeToWait * 60) . " seconds"); 
		HostDelayedCommand ( "RaceEventStartWarning", 60, RaceCountDown );
		$reTimeToWait = $reTimeToWait - 1;
#	ELSE
#		globalMsg ( "Starting " . $RaceEvent[$reNextEvent,"Name"] ); 
#		$reTimeToWait = 0;
#		RaceEventScheduler ();
##		RaceEventStart ( $userName );
	ENDIF
EndSub

Sub RaceEventInit ()
	$reInProgress = TRUE;
	FOR ( $i = 1; $i < 4; $i = $i + 1 )
		IF ( $RaceEvent[$i,"Enabled"] == TRUE )
		THEN
			$reTimeToWait = $RaceEvent[$i,"WaitTime"];
		DEBUG ("Setting reNextEvent to " . $i );
			$reNextEvent = $i;
			BREAK;
		ENDIF
	ENDFOR
	FOR ( $i = 3; $i > 0; $i = $i - 1 )
		IF ( $RaceEvent[$i,"Enabled"] == TRUE )
		THEN
		DEBUG ("Setting reLastEvent to " . $i );
			$reLastEvent = $i;
			BREAK;
		ENDIF
	ENDFOR
	RaceEventScheduler ( GetCurrentPlayerVar("UserName") );
EndSub

Sub RaceEventCancel($KeyFlags, $id)
	$reInProgress = FALSE;
	$reNextEvent = -1;
	closeGlobalButton ( "reCd1&reCd2&reCd3" );
	RemoveHostDelayedCommand( "RaceEventStartWarning" );
	RemoveHostDelayedCommand( "RaceEventStartNext" );
#	globalMsg ("Current Race Event has been cancelled");
EndSub
