#############################################################################
# LFS Handicapping Interface by Krayy
#############################################################################
# Ver 1.0.1 11-08-09 Initial release
# Ver 1.0.5 22-08-09 Major changes to functionality
#                    Added Save/Load code to store and retreive values
#                    Multiple column support for up to 32 players
#                    Changed button names to be unique
# Ver 1.0.6 27/12/09 Updated to be compatible with LFSLapper v5.918
#############################################################################

CatchEvent OnLapperStart()
	CifRegisterModule("Config", "Server", "1.01");
EndCatchEvent

CatchEvent OnMSO( $userName, $text ) # Player event
	$idxOfFirstSpace = indexOf( $text, " ");
	IF( $idxOfFirstSpace == -1 ) THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirstSpace );
	  $argv = trim( subStr( $text,$idxOfFirstSpace ) );
	ENDIF

	SWITCH( $command )
		CASE "!sc":
		CASE "!serverconfig":
			DoCifConfigServer(0,0);
			return();
   		BREAK;
	ENDSWITCH
EndCatchEvent

Sub DoCifConfigServer($KeyFlags,$id)
	# Set default values for the module - these MUST be the same as the main Do function name
	$cifGroupName="Config";
	$cifModuleName="Server";
	$DialogPrefix = "CIF" . $cifGroupName . $cifModuleName . "_";

	# Draw the CIF dialog box
	CifDraw($cifGroupName, $cifModuleName, "Configure Server");

	# Set various vars for GUI size and location
	$thisOrigT = $CifOrigT+1;			# Top edge of main content window
	$thisOrigL = $CifOrigL+1;	# Left edge of main content window

	# Qualifying
	openPrivButton ($DialogPrefix . "bgQ",$thisOrigL,$thisOrigT,34,15,1,-1,96,"");
	# Race 1
	$thisOrigT = $thisOrigT+30;
	openPrivButton ($DialogPrefix . "bgR1",$thisOrigL,$thisOrigT,34,20,1,-1,96,"");
	# Race 2
	$thisOrigT = $thisOrigT+30;
	openPrivButton ($DialogPrefix . "bgR2",$thisOrigL,$thisOrigT,34,20,1,-1,96,"");

	IF ( UserIsAdmin( GetCurrentPlayerVar("UserName") ) == 1 ) THEN
		# Draw the Load/Save/Reset buttons
#		CifCmdButton( 1, "^7Set Grid", DoHandicapper_Load );
#		CifCmdButton( 2, "^7Save", DoHandicapper_Save );
#		CifCmdButton( 3, "^7Reset", DoHandicapper_Reset );
	ENDIF
EndSub
