####	Drag Race Add-on
####	================
####
####	by Sinanju
####
####	An Add-On for LFSLapper V5.926 and later
####	(but preferably v6.011 and later)
####
####
####	Install this file into ..\bin\default\includes
####	then open the addonsused.lpr file and paste the following line (without hashes)
####	include( "./drag.lpr");
####
#############################################################################################
# Ver 0.1 - 02 Mar 2012 - Made AU1 Layout, Set christmas light positions, and set drag stages
#############################################################################################
#
#     NOTE: Drag system must be started (type !drag) before going over speed bump!
#
#############################################################################################
#
#     Christmas Light Simulation: http://www.youtube.com/watch?v=9sktN55FYg8
#
#############################################################################################

# Colour Codes:
# ^0 - black
# ^1 - red
# ^2 - green
# ^3 - yellow
# ^4 - blue
# ^5 - violet
# ^6 - cyan
# ^7 - white
# ^8 - no color (grey) (or leave text colour blank)

# Variables that could be used on expressions
# &&		-> and
# ||		-> or
# +			-> plus
# -			-> minus
# /			-> divide
# *			-> multiply
# ^			-> pow
# ==		-> equal to
# !=		-> not equal to
# >			-> bigger then
# <			-> smaller then
# <=		-> smaller then and equal to
# >=		-> bigger then and equal to


CatchEvent OnLapperStart()
	### Set initial coordinates for Drag sub-routines (lights, etc) to start
	RegisterZoneAction( "Over Bump Left","AU1" , 27,-615, 1 , SE_DragStart,"" ); # Redraws lights
	RegisterZoneAction( "Pre Stage Left","AU1" , 27,-632, 1 , SE_PreStageLeft,"" );
	RegisterZoneAction( "Stage Left","AU1" , 27,-638, 1 , SE_StageLeft,"" );
	RegisterZoneAction( "Penalty Line Left","AU1" , 26,-640, 1 , SE_PenaltyLineLeft,"" );
	RegisterZoneAction( "100m Line Left","AU1" , 26,-739, 1 , SE_100mLineLeft,"" );	
	RegisterZoneAction( "200m Line Left","AU1" , 26,-839, 1 , SE_200mLineLeft,"" );	
	RegisterZoneAction( "Finish Menu Trigger Left","AU1" , 27,-1000, 1 , SE_FinishLeft, "" );		
	RegisterZoneAction( "Finish Results Left","AU1" , 27,-1052, 1 , SE_ResultsLeft, "" );
  	
  RegisterZoneAction( "Over Bump Right","AU1" , 23,-615, 1 , SE_DragStartRight,"" ); # Redraws lights	
	RegisterZoneAction( "Pre Stage Right","AU1" , 23,-632, 1 , SE_PreStageRight,"" );
	RegisterZoneAction( "Stage Right","AU1" , 23,-638, 1 , SE_StageRight,"" );
	RegisterZoneAction( "Penalty Line Right","AU1" , 23,-640, 1 , SE_PenaltyLineRight,"" );
	RegisterZoneAction( "100m Line Right","AU1" , 23,-739, 1 , SE_100mLineRight,"" );	
	RegisterZoneAction( "200m Line Right","AU1" , 23,-839, 1 , SE_200mLineRight,"" );
	RegisterZoneAction( "Finish Menu Trigger Right","AU1" , 23,-1000, 1 , SE_FinishRight, "" );	
	RegisterZoneAction( "Finish Results Right","AU1" , 23,-1052, 1 , SE_ResultsRight, "" );

	### Set initial coordinates for Christmas Light buttons	
	GlobalVar $DRorigL; $DRorigL = 178;	# Increase / Decrease to move lights left or right
	GlobalVar $DRorigT; $DRorigT = 28;	# Increase / Decrease to move lights up or down
	GlobalVar $DRWidth; $DRWidth = 7;	# Do NOT change (this sets width of the background and the lights)
	GlobalVar $DRHeight; $DRHeight = 8;	# Do NOT change (this sets height of the background and the lights)
	GlobalVar $DRspacing; $DRspacing = 8;	# Do NOT change  (this sets spacing of the background and the lights)
	GlobalVar $DRtime; $DRtime = -1;	# Do NOT change  (this sets timing of the lights)

 	### Set initial coordinates for Results table (after reached just past finish line)	
	GlobalVar $RBorigL; $RBorigL = 79;	# Increase / Decrease to move results board left or right
	GlobalVar $RBorigT; $RBorigT = 29;	# Increase / Decrease to move  results board up or down
	GlobalVar $RBWidth; $RBWidth = 4;	# Do NOT change (this sets width of the  results board)
	GlobalVar $RBHeight; $RBHeight = 4;	# Do NOT change (this sets height of the  results board)
	GlobalVar $RBSpacing; $RBSpacing = 4;	# Do NOT change  (this sets spacing of the results board)
	GlobalVar $RBtime; $RBtime = -1;	# Do NOT change  (this sets timing of the  results board)

	### Set initial values for events	
	GlobalVar $DragMode; $DragMode = "off"; #Drag option turned OFF, unless switched on 
	GlobalVar $RTime;	$RTime = round( RandomNum( 4,9 ),0); # Random time from Stage lights (2nd set of double yellows) to when first of 3 vertical yellow lights start
	GlobalVar $RandTime; $RandTime = round( RandomNum( 1,2 ),0); # Random time between vertical yellow and green lights going on				

	GlobalVar $drag_penalty; $drag_penalty = "off"; # Needed to see if anyone jumps green light - assume no penalty when add-on starts	

#  $ShowSplitPB = false;

EndCatchEvent


CatchEvent OnMSO( $userName, $text )

	$idxOfFirtsSpace = indexOf( $text, " ");

	IF ( $idxOfFirtsSpace == -1 ) 
	THEN
		$command = $text;
		$argv = "";
	ELSE
		$command = subStr( $text,0,$idxOfFirtsSpace );
		$argv = trim( subStr( $text,$idxOfFirtsSpace ) );
	ENDIF

	SWITCH ( $command)
	

CASE "!drag":
CASE "!Drag":
CASE "!DRAG":
			IF ( UserIsAdmin( $userName ) == 1 )    # Use this part (IF-THEN-ELSE-ENDIF statement) if you only want Admin to switch Drag system on
			THEN
	$DragMode = "Drag";			
	SE_DragStart($KeyFlags); # Starts Drag system	
			ELSE
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{drag_notadmin}%" ) );
			ENDIF	
BREAK;


CASE "!dragoff":
CASE "!Dragoff":
CASE "!DragOff":
CASE "!DRAGOFF":
			IF ( UserIsAdmin( $userName ) == 1 )    # Use this part (IF - ENDIF statement) if you only want Admin to switch Drag system off
			THEN		
	SE_DragOff($KeyFlags); # Closes Drag system	
			ELSE
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{drag_notadmin}%" ) );
			ENDIF	
BREAK;

ENDSWITCH
EndCatchEvent


Sub SE_DragStart($KeyFlags) # A Sinanju Event (opens christmas light cluster)
	IF ( $DragMode == "Drag" )
	THEN
  closeButtonRegex (GetCurrentPlayerVar("UserName"), "drag_*"); # closes Drag system if running, then redraws lights (but not results board) 

# Left side
	openGlobalButton( "drag_left_back",$DRorigL+6,$DRorigT+1,$DRWidth,$DRHeight+50,$DRspacing,$DRtime,32,""); # Left back lightboard
	openGlobalButton( "drag_left_psl1",$DRorigL+1,$DRorigT,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^0•"); # Pre-stage lights	
	openGlobalButton( "drag_left_psl2",$DRorigL+10,$DRorigT,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^0•");	
	openGlobalButton( "drag_left_sl1",$DRorigL+1,$DRorigT+7,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^0•"); # Stage lights		
	openGlobalButton( "drag_left_sl2",$DRorigL+10,$DRorigT+7,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^0•");	
	openGlobalButton( "drag_left_cdyt",$DRorigL,$DRorigT+14,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^0•"); # Count Down Yellow top	
	openGlobalButton( "drag_left_cdym",$DRorigL,$DRorigT+21,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^0•"); # Count Down Yellow middle		
	openGlobalButton( "drag_left_cdyb",$DRorigL,$DRorigT+28,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^0•"); # Count Down Yellow bottom
	openGlobalButton( "drag_left_st",$DRorigL,$DRorigT+35,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^6•"); # Start Light	
	openGlobalButton( "drag_left_rp",$DRorigL,$DRorigT+42,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^8•"); # Red Penalty Light
	
# Right side	
	openGlobalButton( "drag_right_back",$DRorigL+15,$DRorigT+1,$DRWidth,$DRHeight+50,$DRspacing,$DRtime,32,""); # Right back lightboard                 
	openGlobalButton( "drag_right_psl1",$DRorigL+3,$DRorigT,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^0 •");	
	openGlobalButton( "drag_right_psl2",$DRorigL+12,$DRorigT,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^0 •");	
	openGlobalButton( "drag_rights_sl1",$DRorigL+3,$DRorigT+7,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^0 •");
	openGlobalButton( "drag_rights_sl2",$DRorigL+12,$DRorigT+7,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^0 •");		
	openGlobalButton( "drag_right_cdyt",$DRorigL+8,$DRorigT+14,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^0 •");		
	openGlobalButton( "drag_right_cdym",$DRorigL+8,$DRorigT+21,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^0 •");		
	openGlobalButton( "drag_right_cdyb",$DRorigL+8,$DRorigT+28,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^0 •");	
	openGlobalButton( "drag_right_st",$DRorigL+8,$DRorigT+35,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^6 •");  	
	openGlobalButton( "drag_right_rp",$DRorigL+8,$DRorigT+42,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^8 •");
	ELSE
	ENDIF   
EndSub
 

Sub SE_DragStartRight($KeyFlags) # A Sinanju Event (opens christmas light cluster)
	IF ( $DragMode == "Drag" )
	THEN
  closeGlobalButton ("drag_right_psl1&drag_right_psl2&drag_rights_sl1&drag_rights_sl2&drag_right_cdym&drag_right_cdyb&drag_right_st&drag_right_rp");               
	openGlobalButton( "drag_right_psl1",$DRorigL+3,$DRorigT,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^0 •"); # Pre-stage lights
	openGlobalButton( "drag_right_psl2",$DRorigL+12,$DRorigT,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^0 •");# Pre-stage lights		
	openGlobalButton( "drag_rights_sl1",$DRorigL+3,$DRorigT+7,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^0 •"); # Stage lights
	openGlobalButton( "drag_rights_sl2",$DRorigL+12,$DRorigT+7,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^0 •");	# Stage lights	
	openGlobalButton( "drag_right_cdyt",$DRorigL+8,$DRorigT+14,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^0 •");# Count Down Yellow top		 
	openGlobalButton( "drag_right_cdym",$DRorigL+8,$DRorigT+21,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^0 •");# Count Down Yellow middle			
	openGlobalButton( "drag_right_cdyb",$DRorigL+8,$DRorigT+28,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^0 •");# Count Down Yellow bottom		
	openGlobalButton( "drag_right_st",$DRorigL+8,$DRorigT+35,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^6 •"); # Start Light 		
	openGlobalButton( "drag_right_rp",$DRorigL+8,$DRorigT+42,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^8 •");   # Penalty Light
	
# Redraws part of Left side in case left side still shows green
  closeGlobalButton ("drag_left_cdyt&drag_left_cdym&drag_left_cdyb&drag_left_st&drag_left_rp"); 	
	openGlobalButton( "drag_left_cdyt",$DRorigL,$DRorigT+14,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^0•"); # Count Down Yellow top	
	openGlobalButton( "drag_left_cdym",$DRorigL,$DRorigT+21,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^0•"); # Count Down Yellow middle		
	openGlobalButton( "drag_left_cdyb",$DRorigL,$DRorigT+28,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^0•"); # Count Down Yellow bottom
	openGlobalButton( "drag_left_st",$DRorigL,$DRorigT+35,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^6•"); # Start Light	
	openGlobalButton( "drag_left_rp",$DRorigL,$DRorigT+42,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^8•"); # Penalty Light	
	ELSE
	ENDIF   
EndSub

Sub SE_DragOff ($KeyFlags) # A Sinanju Event (turns drag system off and removes xmas lights from screen)
  closeButtonRegex (GetCurrentPlayerVar("UserName"), "drag_*");
	$DragMode = "off";
EndSub


Sub SE_PreStageLeft($userName)
		$NickName = GetCurrentPlayerVar("NickName");
	IF ( $DragMode == "Drag" )
	THEN
  closeGlobalButton ("drag_left_psl1&drag_right_psl1");
	openGlobalButton( "drag_left_driver",45,1,50,6,6,$DRtime,128,$NickName); # Driver on Left
	openGlobalButton( "drag_left_psl1",$DRorigL+1,$DRorigT,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^3•"); # shows Pre-stage lights for driver on left	
	openGlobalButton( "drag_right_psl1",$DRorigL+3,$DRorigT,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^3 •");	
	ENDIF
EndSub


Sub SE_PreStageRight($userName)
		$r_NickName = GetCurrentPlayerVar("NickName");
	IF ( $DragMode == "Drag" )
	THEN
  closeGlobalButton ("drag_left_psl2&drag_right_psl2");
	openGlobalButton( "drag_driverV",95,1,10,7,6,$DRtime,0,"^1V");   
	openGlobalButton( "drag_right_driver",105,1,50,6,6,$DRtime,64,$r_NickName); # Driver on Right 
	openGlobalButton( "drag_left_psl2",$DRorigL+10,$DRorigT,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^3•"); # shows Pre-stage lights for driver on right	
	openGlobalButton( "drag_right_psl2",$DRorigL+12,$DRorigT,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^3 •");
	ENDIF
EndSub


Sub SE_StageLeft($userName)
	IF ( $DragMode == "Drag" )
	THEN
  closeGlobalButton ("drag_left_sl1&drag_rights_sl1");
	openGlobalButton( "drag_left_sl1",$DRorigL+1,$DRorigT+7,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^3•"); # shows Stage lights for driver on left
	openGlobalButton( "drag_rights_sl1",$DRorigL+3,$DRorigT+7,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^3 •");
	  DelayedCommand( $RTime, SE_CountDownTop );
	ENDIF	  
EndSub


Sub SE_StageRight ($userName)
	IF ( $DragMode == "Drag" )
	THEN
  closeGlobalButton ("drag_left_sl2&drag_rights_sl2");
	openGlobalButton( "drag_left_sl2",$DRorigL+10,$DRorigT+7,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^3•"); # shows Stage lights for driver on right	
	openGlobalButton( "drag_rights_sl2",$DRorigL+12,$DRorigT+7,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^3 •");
#		DelayedCommand( $RTime, SE_CountDownTop );
	ENDIF		
EndSub


Sub SE_CountDownTop()
#	IF ( $drag_penalty == "off" )	
#	 THEN 
	closeGlobalButton ("drag_left_cdyt&drag_right_cdyt"); 						
	openGlobalButton( "drag_left_cdyt",$DRorigL,$DRorigT+14,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^3•"); # Changes top single light to yellow
	openGlobalButton( "drag_right_cdyt",$DRorigL+8,$DRorigT+14,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^3 •");
		DelayedCommand( $RandTime, SE_CountDownMiddle );		
#  ELSE		
#		SE_PenaltyLineLeft ($KeyFlags)		
#	ENDIF      
EndSub


Sub SE_CountDownMiddle()
  closeGlobalButton ("drag_left_cdym&drag_right_cdym");						
	openGlobalButton( "drag_left_cdym",$DRorigL,$DRorigT+21,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^3•"); # Count Down Yellow middle	
	openGlobalButton( "drag_right_cdym",$DRorigL+8,$DRorigT+21,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^3 •");  	
		DelayedCommand(  $RandTime, SE_CountDownBottom );  	     
EndSub


Sub SE_CountDownBottom ()
  closeGlobalButton ("drag_left_cdyb&drag_right_cdyb");						
	openGlobalButton( "drag_left_cdyb",$DRorigL,$DRorigT+28,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^3•"); # Count Down Yellow bottom	
	openGlobalButton( "drag_right_cdyb",$DRorigL+8,$DRorigT+28,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^3 •");     	
		DelayedCommand( $RandTime, SE_Start );   	     
EndSub


Sub SE_Start ()
	
  $drag_penalty = "off"	

  closeGlobalButton ("drag_left_psl1&drag_left_psl2&drag_left_sl1&drag_left_sl2&drag_left_cdyt&drag_left_cdym&drag_left_cdyb&drag_left_st&drag_left_rp");
  closeGlobalButton ("drag_right_psl1&drag_right_psl2&drag_rights_sl1&drag_rights_sl2&drag_right_cdyt&drag_right_cdym&drag_right_cdyb&drag_right_st&drag_right_rp");  

# Left side
	openGlobalButton( "drag_left_psl1",$DRorigL+1,$DRorigT,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^0•"); # Pre-stage lights	
	openGlobalButton( "drag_left_psl2",$DRorigL+10,$DRorigT,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^0•");	
	openGlobalButton( "drag_left_sl1",$DRorigL+1,$DRorigT+7,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^0•"); # Stage lights
	openGlobalButton( "drag_left_sl2",$DRorigL+10,$DRorigT+7,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^0•");
	openGlobalButton( "drag_left_cdyt",$DRorigL,$DRorigT+14,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^0•"); # Count Down Yellow top	
	openGlobalButton( "drag_left_cdym",$DRorigL,$DRorigT+21,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^0•"); # Count Down Yellow middle	
	openGlobalButton( "drag_left_cdyb",$DRorigL,$DRorigT+28,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^0•"); # Count Down Yellow bottom               
	openGlobalButton( "drag_left_st",$DRorigL,$DRorigT+35,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^2•"); # Start Light turns green	
	openGlobalButton( "drag_left_rp",$DRorigL,$DRorigT+42,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^0•"); # Penalty Light	

# Right side
	openGlobalButton( "drag_right_psl1",$DRorigL+3,$DRorigT,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^0 •");
	openGlobalButton( "drag_right_psl2",$DRorigL+12,$DRorigT,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^0 •");
 	openGlobalButton( "drag_rights_sl1",$DRorigL+3,$DRorigT+7,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^0 •");
	openGlobalButton( "drag_rights_sl2",$DRorigL+12,$DRorigT+7,$DRWidth+7,$DRHeight+6,$DRspacing,$DRtime,0,"^0 •");	
	openGlobalButton( "drag_right_cdyt",$DRorigL+8,$DRorigT+14,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^0 •");		
	openGlobalButton( "drag_right_cdym",$DRorigL+8,$DRorigT+21,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^0 •");		
	openGlobalButton( "drag_right_cdyb",$DRorigL+8,$DRorigT+28,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^0 •");
	openGlobalButton( "drag_right_st",$DRorigL+8,$DRorigT+35,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^2 •");  	
	openGlobalButton( "drag_right_rp",$DRorigL+8,$DRorigT+42,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^0 •");

EndSub


Sub SE_FinishLeft ($userName) # Shows Blank Result Board
    		
	IF ( $DragMode == "Drag" )
	THEN
		$NickName = GetCurrentPlayerVar("NickName");
                     
  $aes = GetCurrentPlayerVar("AccelerationEndSpeed"); # End speed
  $us = GetCurrentPlayerVar("UnitSpeed"); # Unit of the speed of the pl ayer's car	
	
	openGlobalButton( "drag_finish_backing",$RBorigL,$RBorigT,$RBWidth*10+2,$RBHeight*7+3,$RBSpacing,$RBtime,32,""); # Backing for results board
	openGlobalButton( "drag_left_nickname",$RBorigL+1,$RBorigT+1,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,32,$NickName);  	
	openGlobalButton( "drag_v",$RBorigL+17,$RBorigT+1,$RBWidth*2,$RBHeight,$RBSpacing,$RBtime,0,"^1(No Competitors)");
	openGlobalButton( "drag_time",$RBorigL+17,$RBorigT+6,$RBWidth*2,$RBHeight,$RBSpacing,$RBtime,16,"^7Time");
	openGlobalButton( "drag_finish_zeroto",$RBorigL+17,$RBorigT+10,$RBWidth*2,$RBHeight,$RBSpacing,$RBtime,0,"^70 - " . $aes . " " . $us);
	openGlobalButton( "drag_finish_speedtrap",$RBorigL+17,$RBorigT+14,$RBWidth*2,$RBHeight,$RBSpacing,$RBtime,16,"^7SpeedTrap");	
	openGlobalButton( "drag_finish_gs",$RBorigL+17,$RBorigT+18,$RBWidth*2,$RBHeight,$RBSpacing,$RBtime,0,"^7g's");	
	openGlobalButton( "drag_200mtime",$RBorigL+17,$RBorigT+22,$RBWidth*2,$RBHeight,$RBSpacing,$RBtime,16,"^7200m");	
	openGlobalButton( "drag_400mtime",$RBorigL+17,$RBorigT+26,$RBWidth*2,$RBHeight,$RBSpacing,$RBtime,0,"^7400m");	
 	ELSE       	
  ENDIF
	
EndSub


Sub SE_FinishRight ($userName) # Shows Name on Result Board
    		
	IF ( $DragMode == "Drag" )
	THEN
		$r_NickName = GetCurrentPlayerVar("NickName");	
  closeGlobalButton ("drag_v");
	openGlobalButton( "drag_v",$RBorigL+17,$RBorigT+1,$RBWidth*2,$RBHeight,$RBSpacing,$RBtime,0,"^1V");	
	openGlobalButton( "drag_right_nickname",$RBorigL+25,$RBorigT+1,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,32,$r_NickName);		
  ELSE       	
  ENDIF
	
EndSub


Sub SE_ResultsLeft ($userName) # Shows Result in Results Board (times, etc)             

	IF ( $DragMode == "Drag" )
    THEN

# Acceleration / G-force Information  
  $AccelerationStartSpeed = 1; # At which speed to start measuring time.
  $AccelerationEndSpeed = 100; # At which speed to stop measuring time.
  $AccelerationStartSpeedMph = 1; # At which speed to start measuring time. In Mph
  $AccelerationEndSpeedMph = 60; # At which speed to stop measuring time. In Mph
  $AccelerationPrivateMaxTime = 30; # To show acceleration message, driver must reach end speed within this number of seconds   

  $at = GetCurrentPlayerVar("AccelerationTime"); # Acceleration time achieved from start to end speed
      
  $gforce_accel = (100/$at);
  $gforce = round(($gforce_accel/35.30394),2);
     
# Split Information (Can't use Split, as that is overwritten on next split)
  $Split2 = NumToMSH(GetCurrentPlayerVar("SectorSplit2"));
  $Split3 = NumToMSH(GetCurrentPlayerVar("SectorSplit3"));  
  $SplitLast = NumToMSH(GetCurrentPlayerVar( "SectorSplitLast")) ; 
  
  $DragTime = NumToMSH((GetCurrentPlayerVar("SectorSplit2")) + (GetCurrentPlayerVar("SectorSplit3")) + (GetCurrentPlayerVar("SectorSplitLast"))); 
   
# Speed Information
  $Speed = ToPlayerUnit( GetCurrentPlayerVar( "InstantSpeed" ));
  $us = GetCurrentPlayerVar("UnitSpeed"); # Unit of the speed of the player's car 

	openGlobalButton( "drag_left_dragtime",$RBorigL+1,$RBorigT+6,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,16,"^0" . $DragTime);		
	openGlobalButton( "drag_left_finishto",$RBorigL+1,$RBorigT+10,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,0,"^0" . $at . " secs");
	openGlobalButton( "drag_left_finish_speed",$RBorigL+1,$RBorigT+14,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,16,"^0" . $Speed . " " . $us);	 	
	openGlobalButton( "drag_left_gforce",$RBorigL+1,$RBorigT+18,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,0,"^0" . $gforce );
	openGlobalButton( "drag_left_200mresult",$RBorigL+1,$RBorigT+22,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,16,"^0" . $Split2);
	openGlobalButton( "drag_left_400mresult",$RBorigL+1,$RBorigT+26,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,0,"^0" . $Split3);
  
ELSE

	openGlobalButton( "drag_left_dragtime",$RBorigL+1,$RBorigT+6,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,16,"-");		
	openGlobalButton( "drag_left_finishto",$RBorigL+1,$RBorigT+10,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,0,"^-");
	openGlobalButton( "drag_left_finish_speed",$RBorigL+1,$RBorigT+14,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,16,"^-");	 	
	openGlobalButton( "drag_left_gforce",$RBorigL+1,$RBorigT+18,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,0,"^-");
	openGlobalButton( "drag_left_200mresult",$RBorigL+1,$RBorigT+22,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,16,"^-");
	openGlobalButton( "drag_left_400mresult",$RBorigL+1,$RBorigT+26,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,0,"^-"); 

ENDIF  	
EndSub


Sub SE_ResultsRight ($userName) # Shows Result in Results Board (times, etc)             
   		
	IF ( $DragMode == "Drag" )
	THEN	
# Acceleration / G-force Information  
  $AccelerationStartSpeed = 1; # At which speed to start measuring time.
  $AccelerationEndSpeed = 100; # At which speed to stop measuring time.
  $AccelerationStartSpeedMph = 1; # At which speed to start measuring time. In Mph
  $AccelerationEndSpeedMph = 60; # At which speed to stop measuring time. In Mph
  $AccelerationPrivateMaxTime = 30; # To show acceleration message, driver must reach end speed within this number of seconds   
  $r_at = GetCurrentPlayerVar("AccelerationTime"); # Acceleration time achieved from start to end speed
      
  $r_gforce_accel = (100/$r_at);
  $r_gforce = round(($r_gforce_accel/35.30394),2);
     
# Split Information (Can't use Split, as that is overwritten on next split)
  $r_Split2 = NumToMSH(GetCurrentPlayerVar("SectorSplit2"));
  $r_Split3 = NumToMSH(GetCurrentPlayerVar("SectorSplit3"));  
  $r_SplitLast = NumToMSH(GetCurrentPlayerVar( "SectorSplitLast")) ; 
  
  $r_DragTime = NumToMSH((GetCurrentPlayerVar("SectorSplit2")) + (GetCurrentPlayerVar("SectorSplit3")) + (GetCurrentPlayerVar("SectorSplitLast"))); 
   
# Speed Information
  $r_Speed = ToPlayerUnit( GetCurrentPlayerVar( "InstantSpeed" ));
  $r_us = GetCurrentPlayerVar("UnitSpeed"); # Unit of the speed of the player's car  

	openGlobalButton( "drag_right_dragtime",$RBorigL+25,$RBorigT+6,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,16,"^0" . $r_DragTime);		
	openGlobalButton( "drag_right_finishto",$RBorigL+25,$RBorigT+10,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,0,"^0" . $r_at . " secs");
	openGlobalButton( "drag_right_finish_speed",$RBorigL+25,$RBorigT+14,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,16,"^0" . $r_Speed . " " . $r_us);	 	
	openGlobalButton( "drag_right_gforce",$RBorigL+25,$RBorigT+18,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,0,"^0" . $r_gforce );
	openGlobalButton( "drag_right_200mresult",$RBorigL+25,$RBorigT+22,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,16,"^0" . $r_Split2);
	openGlobalButton( "drag_right_400mresult",$RBorigL+25,$RBorigT+26,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,0,"^0" . $r_Split3);	
    ELSE
	openGlobalButton( "drag_right_dragtime",$RBorigL+25,$RBorigT+6,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,16,"-");		
	openGlobalButton( "drag_right_finishto",$RBorigL+25,$RBorigT+10,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,0,"-");
	openGlobalButton( "drag_right_finish_speed",$RBorigL+25,$RBorigT+14,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,16,"-");	 	
	openGlobalButton( "drag_right_gforce",$RBorigL+25,$RBorigT+18,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,0,"-");
	openGlobalButton( "drag_right_200mresult",$RBorigL+25,$RBorigT+22,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,16,"-");
	openGlobalButton( "drag_right_400mresult",$RBorigL+25,$RBorigT+26,$RBWidth*4,$RBHeight,$RBSpacing,$RBtime,0,"-");           	
  ENDIF	
EndSub


Sub SE_PenaltyLineLeft ($KeyFlags) # in case of penalty (jumping lights))
	IF ( $drag_penalty == "on" )
	THEN  	
  closeGlobalButton ("drag_left_st&drag_left_rp");
	openGlobalButton( "drag_left_st",$DRorigL,$DRorigT+35,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^3•"); # Start Light turns yellow  
	openGlobalButton( "drag_left_rp",$DRorigL,$DRorigT+42,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^1•"); # Penalty Light turns red	
	ELSE	
	ENDIF	
EndSub


Sub SE_PenaltyLineRight ($KeyFlags) # in case of penalty (jumping lights))
	IF ( $drag_penalty == "on" )
	THEN  	
  closeGlobalButton ("drag_right_st&drag_right_rp");
	openGlobalButton( "drag_right_st",$DRorigL,$DRorigT+35,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^3•"); # Start Light turns yellow  
	openGlobalButton( "drag_right_rp",$DRorigL,$DRorigT+42,$DRWidth+12,$DRHeight+11,$DRspacing,$DRtime,0,"^1•"); # Penalty Light turns red	
	ELSE	
	ENDIF	
EndSub




Lang "EN"
drag_notadmin = "You are not an Admin!";
EndLang




######################################################################
#
#   Possible To Do items?
#
######################################################################
# Possibly use for showing differences between each drivers time, etc?
#	 Add new Event OnChangePos triggered when player change his position in race or qual
#	    			Event OnChangePos($userName,$lastPos,$currPos)
#            .....
#	    			EndEvent

#           UNameBehind,            // UserName of the player behind you in race
#           GapBehind,              // Gap between you and player behind in Race
#           UnameBefore,            // the username of the player before you in race
#           GapBefore,              // gap between you and the player before you in race
#
#######################################################################
#
#   Use SET and GET
#     to Set driver & car & times (each 200m + overall) and G and speedtrap
#     for comparison between a drivers times, etc, from one race to another
#     showing gains in Green and losses in Red?                                                                      











