﻿using System;
using System.Collections.Generic;
using System.Data.Entity;
using System.Linq;

namespace CruiseContextExample {
    class Program {
        static void Main() {
            // Save some data to the database.
            SaveUserToDatabase();

            // Read the data back out of the database.
            RetrieveUserFromDatabase();

            Console.ReadLine();
        }

        private static void SaveUserToDatabase() {
            // Create database connection.
            CruiseContext db = new CruiseContext();

            // Create a new user.
            User user = new User {
                UserName = "DarkTimes",
                PlayerName = "Alex",
                Cash = 1000,
                Cars = new List<Car>(), // empty car list
            };

            // Now let's add some cars.
            user.Cars.Add(new Car { CarName = "UF1" });
            user.Cars.Add(new Car { CarName = "XFG" });
            user.Cars.Add(new Car { CarName = "XRG" });

            // Add the user to the database.
            db.Users.Add(user);

            // Save the changes.
            db.SaveChanges();
        }

        private static void RetrieveUserFromDatabase() {
            // Createa new database connection (to prove it's saved).
            CruiseContext db = new CruiseContext();

            // Query the database for the user.
            User user = (from u in db.Users
                         where u.UserName == "DarkTimes"
                         select u).Single();

            // Write the user info to the console.
            Console.WriteLine("UserName: {0}", user.UserName);
            Console.WriteLine("PlayerName: {0}", user.PlayerName);
            Console.WriteLine("Cash: {0}", user.Cash);
            Console.WriteLine("Cars:");
            foreach (Car car in user.Cars) {
                Console.WriteLine(car.CarName);
            }
        }
    }

    public class CruiseContext : DbContext {
        public DbSet<User> Users { get; set; }
        public DbSet<Car> Cars { get; set; }
    }

    public class User {
        public int ID { get; set; }
        public string UserName { get; set; }
        public string PlayerName { get; set; }
        public int Cash { get; set; }
        public virtual List<Car> Cars { get; set; }
    }

    public class Car {
        public int ID { get; set; }
        public int UserID { get; set; }
        public string CarName { get; set; }
        public User User { get; set; }
    }
}
