/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response.relay;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.relay.InSimRelayResponse;

public class RelayErrorResponse
extends InSimRelayResponse {
    private RelayError error;

    public RelayErrorResponse() {
        super(PacketType.RELAY_ERROR);
    }

    @Override
    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        super.construct(buffer);
        this.error = RelayError.getById(buffer.get());
    }

    public RelayError getError() {
        return this.error;
    }

    @Override
    public String toString() {
        return "RelayErrorResponse[error=" + (Object)((Object)this.error) + "]";
    }

    static enum RelayError {
        INVALID_PACKET(1),
        INVALID_PACKET_TYPE(2),
        WRONG_HOSTNAME(3),
        WRONG_ADMIN_PASSWORD(4),
        WRONG_SPECTATOR_PASSWORD(5);

        private int id;

        private RelayError(int id) {
            this.id = id;
        }

        static RelayError getById(byte id) {
            int givenId = id & 0xFF;
            RelayError[] relayErrorArray = RelayError.values();
            int n = 0;
            int n2 = relayErrorArray.length;
            while (n < n2) {
                RelayError error = relayErrorArray[n];
                if (error.id == givenId) {
                    return error;
                }
                ++n;
            }
            throw new IllegalArgumentException("Given id is not a valid relay error id: " + id);
        }
    }
}

