/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.Track;
import net.sf.jinsim.response.InSimResponse;
import net.sf.jinsim.types.RaceLaps;

public class StateResponse
extends InSimResponse {
    public static final short ISS_GAME = 1;
    public static final short ISS_REPLAY = 2;
    public static final short ISS_PAUSED = 4;
    public static final short ISS_SHIFTU = 8;
    public static final short ISS_SHIFTU_HIGH = 16;
    public static final short ISS_SHIFTU_FOLLOW = 32;
    public static final short ISS_SHIFTU_NO_OPT = 64;
    public static final short ISS_SHOW_2D = 128;
    public static final short ISS_FRONT_END = 256;
    public static final short ISS_MULTI = 512;
    public static final short ISS_MPSPEEDUP = 1024;
    public static final short ISS_WINDOWED = 2048;
    public static final short ISS_SOUND_MUTE = 4096;
    public static final short ISS_VIEW_OVERRIDE = 8192;
    public static final byte ARCADE_VIEW = 0;
    public static final byte HELICOPTER_VIEW = 1;
    public static final byte TV_VIEW = 2;
    public static final byte DRIVER_VIEW = 3;
    public static final byte CUSTOM_VIEW = 4;
    private float replaySpeed;
    private short flags;
    private byte camera;
    private byte player;
    private byte numPlayers;
    private byte numConnections;
    private byte numFinished;
    private byte raceInProgress;
    private byte qualifyingLength;
    private RaceLaps numLaps;
    private String shortTrackName;
    private byte weatherType;
    private byte windType;

    StateResponse() {
        super(PacketType.STATE);
    }

    @Override
    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        super.construct(buffer);
        buffer.position(buffer.position() + 1);
        this.setReplaySpeed(buffer.getFloat());
        this.setFlags(buffer.getShort());
        this.setCamera(buffer.get());
        this.setPlayer(buffer.get());
        this.setNumPlayers(buffer.get());
        this.setNumConnections(buffer.get());
        this.setNumFinished(buffer.get());
        this.setRaceInProgress(buffer.get());
        this.setQualifyingLength(buffer.get());
        this.setNumLaps(new RaceLaps(buffer));
        this.setShortTrackName(this.getString(buffer, 6));
        this.setWeatherType(buffer.get());
        this.setWindType(buffer.get());
    }

    @Override
    public String toString() {
        String retval = super.toString();
        retval = String.valueOf(retval) + "Replay speed: " + this.getReplaySpeed() / 1.0f + "X normal\n";
        retval = String.valueOf(retval) + "Flags: \n" + this.getFlagsString();
        retval = String.valueOf(retval) + "Camera: " + this.getCameraString() + " View\n";
        retval = String.valueOf(retval) + "Player: " + this.getPlayer() + "\n";
        retval = String.valueOf(retval) + "Number of players: " + this.getNumPlayers() + "\n";
        retval = String.valueOf(retval) + "Number of connections: " + this.getNumConnections() + "\n";
        retval = String.valueOf(retval) + "Number of racers finished: " + this.getNumFinished() + "\n";
        retval = String.valueOf(retval) + "Race in progress: " + this.getRaceInProgressString() + "\n";
        retval = String.valueOf(retval) + "Qualifying length: " + this.getQualifyingLength() + " laps.\n";
        retval = String.valueOf(retval) + "Race length: " + this.getNumLaps() + "\n";
        retval = String.valueOf(retval) + "Track name: " + this.getShortTrackName() + "\n";
        retval = String.valueOf(retval) + "Weather type: " + this.getWeatherType() + "\n";
        retval = String.valueOf(retval) + "Wind type: " + this.getWindTypeString() + "\n";
        return retval;
    }

    public String getCameraString() {
        try {
            String[] cameras = new String[]{"Arcade", "Helicopter", "TV", "Driver", "Custom"};
            return cameras[this.getCamera()];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "Unknown (" + this.getCamera() + ")";
        }
    }

    public byte getCamera() {
        return this.camera;
    }

    public void setCamera(byte camera) {
        this.camera = camera;
    }

    public short getFlags() {
        return this.flags;
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public byte getNumConnections() {
        return this.numConnections;
    }

    public void setNumConnections(byte numConnections) {
        this.numConnections = numConnections;
    }

    public byte getNumFinished() {
        return this.numFinished;
    }

    public void setNumFinished(byte numFinished) {
        this.numFinished = numFinished;
    }

    public RaceLaps getNumLaps() {
        return this.numLaps;
    }

    public void setNumLaps(RaceLaps numLaps) {
        this.numLaps = numLaps;
    }

    public byte getNumPlayers() {
        return this.numPlayers;
    }

    public void setNumPlayers(byte numPlayers) {
        this.numPlayers = numPlayers;
    }

    public byte getPlayer() {
        return this.player;
    }

    public void setPlayer(byte player) {
        this.player = player;
    }

    public byte getQualifyingLength() {
        return this.qualifyingLength;
    }

    public void setQualifyingLength(byte qualifyingLength) {
        this.qualifyingLength = qualifyingLength;
    }

    public String getRaceInProgressString() {
        try {
            String[] raceStrings = new String[]{"No", "Racing", "Qualifying"};
            return raceStrings[this.getRaceInProgress()];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "Unknown";
        }
    }

    public byte getRaceInProgress() {
        return this.raceInProgress;
    }

    public void setRaceInProgress(byte raceInProgress) {
        this.raceInProgress = raceInProgress;
    }

    public float getReplaySpeed() {
        return this.replaySpeed;
    }

    public void setReplaySpeed(float replaySpeed) {
        this.replaySpeed = replaySpeed;
    }

    public String getShortTrackName() {
        return this.shortTrackName;
    }

    public Track getTrack() {
        return Track.getTrackByShortName(this.shortTrackName);
    }

    public void setShortTrackName(String shortTrackName) {
        this.shortTrackName = shortTrackName;
    }

    public byte getWeatherType() {
        return this.weatherType;
    }

    public void setWeatherType(byte weatherType) {
        this.weatherType = weatherType;
    }

    public String getWindTypeString() {
        try {
            String[] windTypes = new String[]{"None", "Weak", "Strong"};
            return windTypes[this.getWindType()];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "Unknown";
        }
    }

    public byte getWindType() {
        return this.windType;
    }

    public void setWindType(byte windType) {
        this.windType = windType;
    }

    public String getFlagsString() {
        String retval = "";
        short flags = this.getFlags();
        if ((flags & 1) != 0) {
            retval = String.valueOf(retval) + "In game (or multiplayer replay).\n";
        } else if ((flags & 2) != 0) {
            retval = String.valueOf(retval) + "In single player replay mode\n";
        } else if ((flags & 4) != 0) {
            retval = String.valueOf(retval) + "Paused.\n";
        } else if ((flags & 8) != 0) {
            retval = String.valueOf(retval) + "In Shift-U mode.\n";
        } else if ((flags & 0x10) != 0) {
            retval = String.valueOf(retval) + "In HIGH view.\n";
        } else if ((flags & 0x20) != 0) {
            retval = String.valueOf(retval) + "In follow mode.\n";
        } else if ((flags & 0x40) != 0) {
            retval = String.valueOf(retval) + "Buttons are hidden\n";
        } else if ((flags & 0x80) != 0) {
            retval = String.valueOf(retval) + "Show 2D display.\n";
        } else if ((flags & 0x100) != 0) {
            retval = String.valueOf(retval) + "In front end screen.\n";
        } else if ((flags & 0x200) != 0) {
            retval = String.valueOf(retval) + "In multiplayer mode\n";
        } else if ((flags & 0x400) != 0) {
            retval = String.valueOf(retval) + "Multiplayer speed up option\n";
        } else if ((flags & 0x800) != 0) {
            retval = String.valueOf(retval) + "Running in a window\n";
        } else if ((flags & 0x1000) != 0) {
            retval = String.valueOf(retval) + "Sound is off.\n";
        } else if ((flags & 0x2000) != 0) {
            retval = String.valueOf(retval) + "User view is overridden.\n";
        }
        return retval;
    }
}

