/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.PlayerResponse;
import net.sf.jinsim.types.InSimTime;

public class SplitTimeResponse
extends PlayerResponse {
    private InSimTime time;
    private InSimTime totalTime;
    private byte playerNumber;
    private byte split;
    private byte penalty;
    private byte numberOfStops;

    public SplitTimeResponse() {
        super(PacketType.SPLIT);
    }

    @Override
    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        super.construct(buffer);
        this.time = new InSimTime(buffer);
        this.totalTime = new InSimTime(buffer);
        this.split = buffer.get();
        this.penalty = buffer.get();
        this.numberOfStops = buffer.get();
        buffer.position(buffer.position() + 1);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ", time: " + this.getTime() + ", player: " + this.getPlayerNumber() + ", split: " + this.split + ", penalty: " + this.penalty + ", numberOfStops: " + this.numberOfStops;
    }

    public byte getPlayerNumber() {
        return this.playerNumber;
    }

    public void setPlayerNumber(byte playerNumber) {
        this.playerNumber = playerNumber;
    }

    public InSimTime getTime() {
        return this.time;
    }

    public void setTime(InSimTime t) {
        this.time = t;
    }

    public byte getNumberOfStops() {
        return this.numberOfStops;
    }

    public byte getPenalty() {
        return this.penalty;
    }

    public byte getSplit() {
        return this.split;
    }

    public InSimTime getTotalTime() {
        return this.totalTime;
    }
}

