/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.PlayerResponse;
import net.sf.jinsim.types.InSimTime;

public class ResultResponse
extends PlayerResponse {
    private String userName;
    private String nickname;
    private String plate;
    private String carName;
    private InSimTime totalTime;
    private InSimTime bestLapTime;
    private short lapsDone;
    private short playerFlags;
    private byte confirmationFlags;
    private byte numberPitStops;
    private byte resultPosition;
    private byte totalResults;

    ResultResponse() {
        super(PacketType.RESULT_CONFIRMED);
    }

    @Override
    public void construct(ByteBuffer buffer) {
        super.construct(buffer);
        this.userName = this.getString(buffer, 24);
        this.nickname = this.getString(buffer, 24);
        this.plate = this.getString(buffer, 8);
        this.carName = this.getString(buffer, 4);
        this.totalTime = new InSimTime(buffer);
        this.bestLapTime = new InSimTime(buffer);
        buffer.position(buffer.position() + 1);
        this.numberPitStops = buffer.get();
        this.confirmationFlags = buffer.get();
        buffer.position(buffer.position() + 1);
        this.lapsDone = buffer.getShort();
        this.playerFlags = buffer.getShort();
        this.resultPosition = buffer.get();
        this.totalResults = buffer.get();
        buffer.position(buffer.position() + 2);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ", User name: " + this.getUserName() + ", Nickname: " + this.getNickname() + ", Plate: " + this.getPlate() + ", Car name: " + this.getCarName() + ", Laps completed: " + this.getLapsDone() + ", Flags: " + this.getPlayerFlags() + ", Confirmation flags: " + this.getConfirmationFlags() + ", Pit stops: " + this.getNumberPitStops() + ", Total race time: " + this.getTotalTime() + ", Best lap time: " + this.getBestLapTime() + ", Result position: " + this.getResultPosition() + ", Total results: " + this.getTotalResults();
    }

    public InSimTime getBestLapTime() {
        return this.bestLapTime;
    }

    public String getCarName() {
        return this.carName;
    }

    public byte getConfirmationFlags() {
        return this.confirmationFlags;
    }

    public short getPlayerFlags() {
        return this.playerFlags;
    }

    public short getLapsDone() {
        return this.lapsDone;
    }

    public String getNickname() {
        return this.nickname;
    }

    public byte getNumberPitStops() {
        return this.numberPitStops;
    }

    public String getPlate() {
        return this.plate;
    }

    public byte getResultPosition() {
        return this.resultPosition;
    }

    public InSimTime getTotalTime() {
        return this.totalTime;
    }

    public byte getTotalResults() {
        return this.totalResults;
    }

    public String getUserName() {
        return this.userName;
    }
}

