/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.InSimResponse;

public class ReorderResponse
extends InSimResponse {
    private ArrayList<Byte> playerPositions = new ArrayList(32);
    private byte numberPlayers;

    ReorderResponse() {
        super(PacketType.REORDER);
    }

    @Override
    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        super.construct(buffer);
        this.numberPlayers = buffer.get();
        int i = 1;
        while (i < 32) {
            this.playerPositions.add(new Byte(buffer.get()));
            ++i;
        }
    }

    @Override
    public String toString() {
        String value = super.toString();
        value = String.valueOf(value) + "Number of players: " + this.getNumberPlayers();
        value = String.valueOf(value) + ", positions: ";
        for (Byte position : this.playerPositions) {
            value = String.valueOf(value) + position + ", ";
        }
        return value;
    }

    public byte getPlayerPositionAt(int n) {
        return this.playerPositions.get(n);
    }

    public ArrayList<Byte> getPlayerPositions() {
        return this.playerPositions;
    }

    public byte getNumberPlayers() {
        return this.numberPlayers;
    }

    public void setNumberPlayers(byte numPlayers) {
        this.numberPlayers = numPlayers;
    }
}

