/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.Track;
import net.sf.jinsim.Weather;
import net.sf.jinsim.Wind;
import net.sf.jinsim.response.InSimResponse;

public class RaceStartResponse
extends InSimResponse {
    private static int CAN_VOTE = 1;
    private static int CAN_SELECT = 2;
    private static int CAN_MIDRACE_JOIN = 32;
    private static int MUST_PIT = 64;
    private static int CAN_RESET = 128;
    private static int FORCE_COCKPIT_VIEW = 256;
    private static int CAN_CRUISE;
    private byte raceLaps;
    private byte qualifingMinutes;
    private byte numberOfPlayers;
    private Track track;
    private Weather weather;
    private Wind wind;
    private int raceFlags;
    private int numberOfNodes;
    private int finishLineNodeIndex;
    private int split1NodeIndex;
    private int split2NodeIndex;
    private int split3NodeIndex;

    public RaceStartResponse() {
        super(PacketType.RACE_START);
    }

    public int getFinishLineNodeIndex() {
        return this.finishLineNodeIndex;
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public byte getNumberOfPlayers() {
        return this.numberOfPlayers;
    }

    public byte getQualifingMinutes() {
        return this.qualifingMinutes;
    }

    public int getRaceFlags() {
        return this.raceFlags;
    }

    public byte getRaceLaps() {
        return this.raceLaps;
    }

    public int getSplit1NodeIndex() {
        return this.split1NodeIndex;
    }

    public int getSplit2NodeIndex() {
        return this.split2NodeIndex;
    }

    public int getSplit3NodeIndex() {
        return this.split3NodeIndex;
    }

    public Track getTrack() {
        return this.track;
    }

    public Weather getWeather() {
        return this.weather;
    }

    public Wind getWind() {
        return this.wind;
    }

    @Override
    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        super.construct(buffer);
        buffer.position(buffer.position() + 1);
        this.raceLaps = buffer.get();
        this.qualifingMinutes = buffer.get();
        this.numberOfPlayers = buffer.get();
        buffer.position(buffer.position() + 1);
        String trackname = this.getString(buffer, 6);
        this.track = Track.getTrackByShortName(trackname);
        this.weather = Weather.getWeather(buffer.get());
        this.wind = Wind.getWind(buffer.get());
        this.raceFlags = buffer.getShort();
        this.numberOfNodes = buffer.getShort();
        this.finishLineNodeIndex = buffer.getShort();
        this.split1NodeIndex = buffer.getShort();
        this.split2NodeIndex = buffer.getShort();
        this.split3NodeIndex = buffer.getShort();
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ", raceLaps: " + this.raceLaps + ", qualifingMinutes: " + this.qualifingMinutes + ", numberOfPlayers: " + this.numberOfPlayers + ", track: " + (Object)((Object)this.track) + ", weather: " + (Object)((Object)this.weather) + ", wind: " + (Object)((Object)this.wind) + ", raceFlags: " + this.raceFlags + ", numberOfNodes: " + this.numberOfNodes + ", finishLineNodeIndex: " + this.finishLineNodeIndex + ", split1NodeIndex: " + this.split1NodeIndex + ", split2NodeIndex: " + this.split2NodeIndex + ", split3NodeIndex: " + this.split3NodeIndex;
    }

    public boolean canVote() {
        return (this.raceFlags & CAN_VOTE) > 0;
    }

    public boolean canSelect() {
        return (this.raceFlags & CAN_SELECT) > 0;
    }

    public boolean canMidraceJoin() {
        return (this.raceFlags & CAN_MIDRACE_JOIN) > 0;
    }

    public boolean mustPit() {
        return (this.raceFlags & MUST_PIT) > 0;
    }

    public boolean canReset() {
        return (this.raceFlags & CAN_RESET) > 0;
    }

    public boolean forceCockpitView() {
        return (this.raceFlags & FORCE_COCKPIT_VIEW) > 0;
    }

    public boolean canCruise() {
        return (this.raceFlags & CAN_CRUISE) > 0;
    }
}

