/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.PenaltyReason;
import net.sf.jinsim.response.PlayerResponse;

public class PenaltyResponse
extends PlayerResponse {
    private byte oldPenalty;
    private byte newPenalty;
    private PenaltyReason reason;

    public PenaltyReason getReason() {
        return this.reason;
    }

    public PenaltyResponse() {
        super(PacketType.PENALTY);
    }

    @Override
    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        super.construct(buffer);
        this.oldPenalty = buffer.get();
        this.newPenalty = buffer.get();
        this.reason = PenaltyReason.getPenaltyReason(buffer.get());
        buffer.position(buffer.position());
    }

    public byte getNewPenalty() {
        return this.newPenalty;
    }

    public void setNewPenalty(byte newPen) {
        this.newPenalty = newPen;
    }

    public byte getOldPenalty() {
        return this.oldPenalty;
    }

    public void setOldPenalty(byte oldPen) {
        this.oldPenalty = oldPen;
    }

    @Override
    public String toString() {
        String result = super.toString();
        result = String.valueOf(result) + "oldPenalty " + this.oldPenalty + "\n";
        result = String.valueOf(result) + "newPenalty " + this.newPenalty + "\n";
        return result;
    }
}

