/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.InSimResponse;
import net.sf.jinsim.types.InSimVector;

public class OutSimResponse
extends InSimResponse {
    private int time;
    private InSimVector angularVelocity;
    private float heading;
    private float pitch;
    private float roll;
    private InSimVector acceleration;
    private InSimVector velocity;
    private InSimVector position;
    private int id;

    public OutSimResponse() {
        super(PacketType.OUT_SIM);
    }

    @Override
    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        buffer.rewind();
        this.setTime(buffer.getInt());
        this.angularVelocity = new InSimVector(buffer);
        this.heading = buffer.getFloat();
        this.pitch = buffer.getFloat();
        this.roll = buffer.getFloat();
        this.acceleration = new InSimVector(buffer);
        this.velocity = new InSimVector(buffer);
        this.position = new InSimVector(buffer);
        if (buffer.hasRemaining()) {
            this.setId(buffer.getInt());
        }
    }

    @Override
    public String toString() {
        return "OutSim [time=" + this.getTime() + ", angularVelocity= " + this.angularVelocity + ", heading= " + this.heading + ", pitch=" + this.pitch + ", roll=" + this.roll + ", acceleration=" + this.acceleration + ", velocity=" + this.velocity + ", position=" + this.position + ", id=" + this.id;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public InSimVector getAngularVelocity() {
        return this.angularVelocity;
    }

    public float getHeading() {
        return this.heading;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getRoll() {
        return this.roll;
    }

    public InSimVector getAcceleration() {
        return this.acceleration;
    }

    public InSimVector getVelocity() {
        return this.velocity;
    }

    public InSimVector getPosition() {
        return this.position;
    }
}

