/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.InSimResponse;

public class OutGaugeResponse
extends InSimResponse {
    private static final float ATMOSPHERIC_PRESSURE = 14.7f;
    private static final float METERS_PER_SECOND_TO_MPH_CONSTANT = 2.2360249f;
    public static final int OG_SHIFTLIGHT = 1;
    public static final int OG_FULLBEAM = 2;
    public static final int OG_HANDBRAKE = 4;
    public static final int OG_PITSPEED = 8;
    public static final int OG_TC = 16;
    public static final int OG_HEADLIGHTS = 32;
    public static final int OG_SIGNAL_L = 64;
    public static final int OG_SIGNAL_R = 128;
    public static final int OG_REDLINE = 256;
    public static final int OG_OILWARN = 512;
    public static final int OG_1 = 1024;
    public static final int OG_2 = 2048;
    public static final int OG_3 = 4096;
    public static final int OG_4 = 8192;
    public static final int OG_KM = 16384;
    public static final int OG_BAR = 32768;
    private int time;
    private String car;
    private short flags;
    private byte gear;
    private float speed;
    private float rpm;
    private float turbo;
    private float waterTemperatur;
    private float fuel;
    private float oilPressure;
    private float throttle;
    private float brake;
    private float clutch;
    private String display1;
    private String display2;
    private int id;

    public OutGaugeResponse() {
        super(PacketType.OUT_GAUGE);
    }

    @Override
    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        buffer.rewind();
        this.setTime(buffer.getInt());
        this.setCar(this.getString(buffer, 4));
        this.setFlags(buffer.getShort());
        this.setGear(buffer.get());
        buffer.position(buffer.position() + 1);
        this.setSpeed(buffer.getFloat());
        this.setRpm(buffer.getFloat());
        this.setTurbo(buffer.getFloat());
        this.setWaterTemperatur(buffer.getFloat());
        this.setFuel(buffer.getFloat());
        this.setOilPressure(buffer.getFloat());
        buffer.position(buffer.position() + 12);
        this.setThrottle(buffer.getFloat());
        this.setBrake(buffer.getFloat());
        this.setClutch(buffer.getFloat());
        this.setDisplay1(this.getString(buffer, 16));
        this.setDisplay2(this.getString(buffer, 16));
        if (buffer.hasRemaining()) {
            this.setId(buffer.getInt());
        }
    }

    @Override
    public String toString() {
        return "OutGaugeResponse[time=" + this.time + " car=" + this.getCar() + " flags=" + this.getFlags() + " gear=" + this.getGear() + " speed=" + this.getSpeed() + " rpm=" + this.getRpm() + " turbo=" + this.getTurbo() + " waterTemperature=" + this.getWaterTemperatur() + " fuel=" + this.getFuel() + " oilPressure=" + this.getOilPressure() + " throttle=" + this.getThrottle() + " brake=" + this.getBrake() + " clutch=" + this.getClutch() + " display1=" + this.getDisplay1() + " display2=" + this.getDisplay2() + " id=" + this.getId() + "]";
    }

    public float getBrake() {
        return this.brake;
    }

    public void setBrake(float brake) {
        this.brake = brake;
    }

    public String getCar() {
        return this.car;
    }

    public void setCar(String car) {
        this.car = car;
    }

    public float getClutch() {
        return this.clutch;
    }

    public void setClutch(float clutch) {
        this.clutch = clutch;
    }

    public String getDisplay1() {
        return this.display1;
    }

    public void setDisplay1(String display1) {
        this.display1 = display1;
    }

    public String getDisplay2() {
        return this.display2;
    }

    public void setDisplay2(String display2) {
        this.display2 = display2;
    }

    public short getFlags() {
        return this.flags;
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public float getFuel() {
        return this.fuel;
    }

    public void setFuel(float fuel) {
        this.fuel = fuel;
    }

    public byte getGear() {
        return this.gear;
    }

    public void setGear(byte gear) {
        this.gear = gear;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public float getOilPressure() {
        return this.oilPressure;
    }

    public void setOilPressure(float oilPressure) {
        this.oilPressure = oilPressure;
    }

    public float getRpm() {
        return this.rpm;
    }

    public void setRpm(float rpm) {
        this.rpm = rpm;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getSpeedInMilesPerHour() {
        return this.speed * 2.2360249f;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public float getThrottle() {
        return this.throttle;
    }

    public void setThrottle(float throttle) {
        this.throttle = throttle;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public float getTurbo() {
        return this.turbo;
    }

    public float getTurboInPoundsPressure() {
        return this.turbo * 14.7f;
    }

    public void setTurbo(float turbo) {
        this.turbo = turbo;
    }

    public float getWaterTemperatur() {
        return this.waterTemperatur;
    }

    public void setWaterTemperatur(float waterTemp) {
        this.waterTemperatur = waterTemp;
    }
}

