/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.InSimResponse;
import net.sf.jinsim.types.NodeLap;

public class NodeLapInfoResponse
extends InSimResponse {
    private byte numberPlayers;
    private ArrayList<NodeLap> nodeLaps = new ArrayList();

    NodeLapInfoResponse() {
        super(PacketType.NODE_LAP);
    }

    @Override
    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        super.construct(buffer);
        this.numberPlayers = buffer.get();
        int i = 0;
        while (i < this.numberPlayers) {
            this.nodeLaps.add(new NodeLap(buffer));
            ++i;
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NodeLapInfoResponse[numberPlayers=");
        builder.append(this.getNumberPlayers());
        for (NodeLap nodeLap : this.nodeLaps) {
            builder.append(", ");
            builder.append(nodeLap);
        }
        builder.append("]");
        return builder.toString();
    }

    public NodeLap getNodeLapAt(int i) {
        return this.nodeLaps.get(i);
    }

    public ArrayList<NodeLap> getNodeLaps() {
        return this.nodeLaps;
    }

    public byte getNumberPlayers() {
        return this.numberPlayers;
    }
}

