/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.ByteBuffer;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.InSimResponse;

public class MultiplayerBeginResponse
extends InSimResponse {
    public static final String TYPE = "ISM";
    private byte host;
    private String name;

    MultiplayerBeginResponse() {
        super(PacketType.START_MULTIPLAYER);
    }

    @Override
    public void construct(ByteBuffer buffer) {
        super.construct(buffer);
        buffer.position(buffer.position() + 1);
        this.setHost(buffer.get());
        buffer.position(buffer.position() + 3);
        this.setName(this.getString(buffer, 32));
    }

    @Override
    public String toString() {
        String retval = super.toString();
        retval = String.valueOf(retval) + "Type: " + (this.getHost() == 0 ? "guest" : "host") + "\n";
        retval = String.valueOf(retval) + "Server: " + (this.getName().equals("") ? "Empty (not in mp mode)" : this.getName()) + "\n";
        return retval;
    }

    public byte getHost() {
        return this.host;
    }

    public void setHost(byte host) {
        this.host = host;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

