/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jinsim.response;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import net.sf.jinsim.PacketType;
import net.sf.jinsim.response.InSimResponse;
import net.sf.jinsim.types.CompCar;

public class MultiCarInfoResponse
extends InSimResponse {
    private byte numberCompCarPackages;
    private ArrayList<CompCar> carInfoList = new ArrayList();

    MultiCarInfoResponse() {
        super(PacketType.MULIT_CAR_INFO);
    }

    @Override
    public void construct(ByteBuffer buffer) throws BufferUnderflowException {
        super.construct(buffer);
        this.numberCompCarPackages = buffer.get();
        int i = 0;
        while (i < this.numberCompCarPackages) {
            this.carInfoList.add(new CompCar(buffer));
            ++i;
        }
    }

    @Override
    public String toString() {
        String value = super.toString();
        value = String.valueOf(value) + "numberCompCarPackages: " + this.numberCompCarPackages;
        for (CompCar compCar : this.carInfoList) {
            value = String.valueOf(value) + "Car: " + compCar + ", ";
        }
        return value;
    }

    public void addCarInfo(CompCar info) {
        this.carInfoList.add(info);
    }

    public CompCar getCarInfoAt(int n) {
        return this.carInfoList.get(n);
    }

    public ArrayList<CompCar> getCarInfoList() {
        return this.carInfoList;
    }
}

